/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.rule.enums;

public enum DbTypeEnum {
    MYSQL("jdbc:mysql", "mysql", "select 1"),
    PG_SQL("jdbc:postgresql", "pgsql", "select version()"),
    ORACLE("jdbc:oracle", "oracle", "select 1 from dual"),
    DM("jdbc:dm", "oracle", "select 1 from dual"),
    MS_SQL("jdbc:jtds:sqlserver", "mssql", "select 1");

    private final String urlWords;
    private final String xmlDatabaseId;
    private final String validateQuery;

    private DbTypeEnum(String urlWords, String xmlDatabaseId, String validateQuery) {
        this.urlWords = urlWords;
        this.xmlDatabaseId = xmlDatabaseId;
        this.validateQuery = validateQuery;
    }

    public static String getTypeByUrl(String url) {
        if (url == null) {
            return MYSQL.name();
        }
        for (DbTypeEnum value : DbTypeEnum.values()) {
            if (!url.contains(value.getUrlWords())) continue;
            return value.name();
        }
        return MYSQL.name();
    }

    public String getUrlWords() {
        return this.urlWords;
    }

    public String getXmlDatabaseId() {
        return this.xmlDatabaseId;
    }

    public String getValidateQuery() {
        return this.validateQuery;
    }
}

