/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.rule.format;

import cn.stylefeng.roses.kernel.rule.base.SimpleFieldFormatProcess;
import cn.stylefeng.roses.kernel.rule.enums.FieldTypeEnum;
import cn.stylefeng.roses.kernel.rule.util.ClassTypeUtil;
import cn.stylefeng.roses.kernel.rule.util.MixFieldTypeUtil;
import cn.stylefeng.roses.kernel.rule.util.ObjectConvertUtil;
import java.util.ArrayList;
import java.util.Collection;

public abstract class BaseSimpleFieldFormatProcess
implements SimpleFieldFormatProcess {
    @Override
    public boolean canFormat(Object originValue) {
        return MixFieldTypeUtil.whetherAssignClass(originValue, Long.class);
    }

    @Override
    public Object formatProcess(Object originValue) {
        FieldTypeEnum classFieldType = ClassTypeUtil.getClassFieldType(originValue.getClass());
        if (FieldTypeEnum.BASIC.equals((Object)classFieldType)) {
            return this.simpleItemFormat(originValue);
        }
        if (FieldTypeEnum.BASE_COLLECTION.equals((Object)classFieldType)) {
            Collection originValueList = (Collection)originValue;
            ArrayList<Object> parsedList = new ArrayList<Object>();
            for (Object itemObject : originValueList) {
                parsedList.add(this.simpleItemFormat(itemObject));
            }
            return parsedList;
        }
        if (FieldTypeEnum.BASE_ARRAY.equals((Object)classFieldType)) {
            Object[] originValueArray = ObjectConvertUtil.objToArray(originValue);
            ArrayList<Object> parsedList = new ArrayList<Object>();
            for (Object itemObject : originValueArray) {
                parsedList.add(this.simpleItemFormat(itemObject));
            }
            return parsedList;
        }
        return originValue;
    }

    public abstract Class<?> getItemClass();

    public abstract Object simpleItemFormat(Object var1);
}

