/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.rule.util;

import cn.hutool.core.net.NetUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.extra.servlet.ServletUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.useragent.UserAgent;
import cn.hutool.http.useragent.UserAgentUtil;
import cn.stylefeng.roses.kernel.rule.exception.base.ServiceException;
import cn.stylefeng.roses.kernel.rule.exception.enums.http.ServletExceptionEnum;
import com.alibaba.fastjson.JSONPath;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class HttpServletUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpServletUtil.class);
    private static final String LOCAL_IP = "127.0.0.1";
    private static final String AGENT_SOURCE_IP = "Agent-Source-Ip";
    private static final String LOCAL_REMOTE_HOST = "0:0:0:0:0:0:0:1";
    private static final String USER_AGENT_HTTP_HEADER = "User-Agent";

    public static HttpServletRequest getRequest() {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            throw new ServiceException(ServletExceptionEnum.HTTP_CONTEXT_ERROR);
        }
        return requestAttributes.getRequest();
    }

    public static HttpServletResponse getResponse() {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            throw new ServiceException(ServletExceptionEnum.HTTP_CONTEXT_ERROR);
        }
        return requestAttributes.getResponse();
    }

    public static String getRequestClientIp(HttpServletRequest request) {
        if (ObjectUtil.isEmpty((Object)request)) {
            return LOCAL_IP;
        }
        String remoteHost = ServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[]{AGENT_SOURCE_IP});
        return LOCAL_REMOTE_HOST.equals(remoteHost) ? LOCAL_IP : remoteHost;
    }

    public static String calcClientIpAddress(HttpServletRequest request, String ipGeoApi, String ipGeoAppCode) {
        String resultJson = "-";
        String requestApiHeader = "Authorization";
        String ip = HttpServletUtil.getRequestClientIp(request);
        if (ObjectUtil.isEmpty((Object)ip) || NetUtil.isInnerIP((String)ip)) {
            return resultJson;
        }
        if (ObjectUtil.hasEmpty((Object[])new Object[]{ipGeoApi, ipGeoAppCode})) {
            return resultJson;
        }
        try {
            if (ObjectUtil.isAllNotEmpty((Object[])new Object[]{ipGeoApi, ipGeoAppCode})) {
                String jsonPath = "$['data']['country','region','city','isp']";
                String appCodeSymbol = "APPCODE";
                HttpRequest http = HttpUtil.createGet((String)String.format(ipGeoApi, ip));
                http.header(requestApiHeader, appCodeSymbol + " " + ipGeoAppCode);
                resultJson = http.timeout(3000).execute().body();
                resultJson = String.join((CharSequence)"", (List)JSONPath.read((String)resultJson, (String)jsonPath));
            }
        }
        catch (Exception e) {
            log.error("\u6839\u636eip\u5b9a\u4f4d\u5f02\u5e38\uff0c\u5177\u4f53\u4fe1\u606f\u4e3a\uff1a{}", (Object)e.getMessage());
        }
        return resultJson;
    }

    public static UserAgent getUserAgent(HttpServletRequest request) {
        String userAgentStr = ServletUtil.getHeaderIgnoreCase((HttpServletRequest)request, (String)USER_AGENT_HTTP_HEADER);
        if (ObjectUtil.isNotEmpty((Object)userAgentStr)) {
            return UserAgentUtil.parse((String)userAgentStr);
        }
        return null;
    }

    public static Boolean getNormalRequestFlag(HttpServletRequest request) {
        return request.getHeader("Accept") == null || request.getHeader("Accept").toLowerCase().contains("text/html");
    }

    public static Boolean getJsonRequestFlag(HttpServletRequest request) {
        return request.getHeader("Accept") == null || request.getHeader("Accept").toLowerCase().contains("application/json");
    }
}

