/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.rule.util;

import cn.hutool.core.io.IoUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class MvnDeployUtil {
    private final List<File> directories = new ArrayList<File>();
    private String mvnExePath;
    private String targetToDeployPath;
    private String mvnSettingXmlPath;
    private String repositoryId;
    private String repositoryUrl;

    public static void main(String[] args) {
        MvnDeployUtil mvnDeployUtil = new MvnDeployUtil();
        mvnDeployUtil.setTargetToDeployPath("D:\\tmp\\devops-plugins");
        mvnDeployUtil.setMvnExePath("D:\\apache-maven-3.5.4\\bin\\mvn.cmd");
        mvnDeployUtil.setMvnSettingXmlPath("D:\\apache-maven-3.5.4\\conf\\settings.xml");
        mvnDeployUtil.setRepositoryId("company-hosted");
        mvnDeployUtil.setRepositoryUrl("http://192.168.31.3:8081/repository/company-hosted/");
        mvnDeployUtil.beginDeploy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean packagingIsPomFlag(File pom) {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(pom)));
            while ((line = reader.readLine()) != null) {
                if (!line.trim().contains("<packaging>pom</packaging>")) continue;
                boolean bl = true;
                IoUtil.close((Closeable)reader);
                return bl;
            }
            IoUtil.close((Closeable)reader);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            IoUtil.close(reader);
        }
        return false;
    }

    private void getAllDirs(String fileDir) {
        this.directories.add(new File(fileDir));
        File file = new File(fileDir);
        File[] files = file.listFiles();
        if (files == null) {
            return;
        }
        for (File item : files) {
            if (!item.isDirectory()) continue;
            this.directories.add(new File(item.getAbsolutePath()));
            this.getAllDirs(item.getAbsolutePath());
        }
    }

    private DirectoryType getDirectoryType(File directoryPath) {
        boolean pom = false;
        boolean jar = false;
        File[] files = directoryPath.listFiles();
        if (files == null) {
            return DirectoryType.NONE;
        }
        for (File file : files) {
            if (file.getName().endsWith(".pom")) {
                pom = true;
                continue;
            }
            if (!file.getName().endsWith(".jar")) continue;
            jar = true;
        }
        if (pom && !jar) {
            return DirectoryType.POM;
        }
        if (jar && pom) {
            return DirectoryType.JAR_AND_POM;
        }
        return DirectoryType.NONE;
    }

    private void doOnlyPom(File directory) {
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        File pom = null;
        for (File file : files) {
            String name = file.getName();
            if (!name.endsWith(".pom")) continue;
            pom = file;
        }
        String command = this.buildCommand(FileType.POM, null, pom);
        this.executeCommand(command);
    }

    private void doJarAndPom(File directory) {
        File[] files = directory.listFiles();
        File pom = null;
        File jar = null;
        if (files != null) {
            for (File file : files) {
                String name = file.getName();
                if (name.endsWith(".pom")) {
                    pom = file;
                    continue;
                }
                if (!name.endsWith(".jar")) continue;
                jar = file;
            }
            if (jar != null) {
                String command = this.buildCommand(FileType.JAR, jar, pom);
                this.executeCommand(command);
            }
        }
    }

    public void beginDeploy() {
        this.getAllDirs(this.targetToDeployPath);
        for (File directory : this.directories) {
            DirectoryType directoryType = this.getDirectoryType(directory);
            if (directoryType.equals((Object)DirectoryType.NONE)) continue;
            if (directoryType.equals((Object)DirectoryType.JAR_AND_POM)) {
                this.doJarAndPom(directory);
                continue;
            }
            if (!directoryType.equals((Object)DirectoryType.POM)) continue;
            this.doOnlyPom(directory);
        }
    }

    private void executeCommand(String command) {
        try {
            System.out.println("\u5f00\u59cb\u6267\u884cmvn\u547d\u4ee4\uff1a" + command);
            Process exec = Runtime.getRuntime().exec(command);
            System.out.println(IoUtil.read((InputStream)exec.getInputStream(), (boolean)true));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String buildCommand(FileType fileType, File deployJar, File deployJarPom) {
        if (fileType.equals((Object)FileType.POM) && !MvnDeployUtil.packagingIsPomFlag(deployJarPom)) {
            return "";
        }
        String command = this.mvnExePath + " -s " + this.mvnSettingXmlPath + " install:install-file -Durl=" + this.repositoryUrl + " -DrepositoryId=" + this.repositoryId + " -DgeneratePom=false ";
        String packing = fileType.equals((Object)FileType.JAR) ? "-Dpackaging=jar " : " ";
        String pomFile = deployJarPom.getAbsolutePath();
        String file = fileType.equals((Object)FileType.POM) ? deployJarPom.getAbsolutePath() : deployJar.getAbsolutePath();
        command = command + packing;
        command = command + " -Dfile=" + file + " ";
        command = command + " -DpomFile=" + pomFile + " ";
        return command;
    }

    public List<File> getDirectories() {
        return this.directories;
    }

    public String getMvnExePath() {
        return this.mvnExePath;
    }

    public String getTargetToDeployPath() {
        return this.targetToDeployPath;
    }

    public String getMvnSettingXmlPath() {
        return this.mvnSettingXmlPath;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public void setMvnExePath(String mvnExePath) {
        this.mvnExePath = mvnExePath;
    }

    public void setTargetToDeployPath(String targetToDeployPath) {
        this.targetToDeployPath = targetToDeployPath;
    }

    public void setMvnSettingXmlPath(String mvnSettingXmlPath) {
        this.mvnSettingXmlPath = mvnSettingXmlPath;
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    public void setRepositoryUrl(String repositoryUrl) {
        this.repositoryUrl = repositoryUrl;
    }

    private static enum FileType {
        JAR,
        POM;

    }

    private static enum DirectoryType {
        NONE,
        POM,
        JAR_AND_POM;

    }
}

