/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.cache.memory.starter;

import cn.hutool.cache.CacheUtil;
import cn.hutool.cache.impl.TimedCache;
import cn.stylefeng.roses.kernel.cache.api.constants.CacheConstants;
import cn.stylefeng.roses.kernel.cache.memory.operator.DefaultMemoryCacheOperator;
import cn.stylefeng.roses.kernel.cache.memory.operator.DefaultStringMemoryCacheOperator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class GunsMemoryCacheAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(name={"defaultStringCacheOperator"})
    public DefaultStringMemoryCacheOperator defaultStringCacheOperator() {
        TimedCache stringTimedCache = CacheUtil.newTimedCache((long)CacheConstants.DEFAULT_CACHE_TIMEOUT);
        return new DefaultStringMemoryCacheOperator(stringTimedCache);
    }

    @Bean
    @ConditionalOnMissingBean(name={"defaultMemoryCacheOperator"})
    public DefaultMemoryCacheOperator defaultMemoryCacheOperator() {
        TimedCache objectTimedCache = CacheUtil.newTimedCache((long)CacheConstants.DEFAULT_CACHE_TIMEOUT);
        return new DefaultMemoryCacheOperator(objectTimedCache);
    }
}

