/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes.info;

import co.elastic.clients.elasticsearch.nodes.info.NodeInfoJvmMemory;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class NodeJvmInfo
implements JsonpSerializable {
    private final List<String> gcCollectors;
    private final NodeInfoJvmMemory mem;
    private final List<String> memoryPools;
    private final int pid;
    private final long startTimeInMillis;
    private final String version;
    private final String vmName;
    private final String vmVendor;
    private final String vmVersion;
    private final boolean usingBundledJdk;
    @Nullable
    private final Boolean usingCompressedOrdinaryObjectPointers;
    private final List<String> inputArguments;
    public static final JsonpDeserializer<NodeJvmInfo> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeJvmInfo::setupNodeJvmInfoDeserializer);

    private NodeJvmInfo(Builder builder) {
        this.gcCollectors = ApiTypeHelper.unmodifiableRequired(builder.gcCollectors, (Object)this, "gcCollectors");
        this.mem = ApiTypeHelper.requireNonNull(builder.mem, this, "mem");
        this.memoryPools = ApiTypeHelper.unmodifiableRequired(builder.memoryPools, (Object)this, "memoryPools");
        this.pid = ApiTypeHelper.requireNonNull(builder.pid, (Object)this, "pid", 0);
        this.startTimeInMillis = ApiTypeHelper.requireNonNull(builder.startTimeInMillis, (Object)this, "startTimeInMillis", 0L);
        this.version = ApiTypeHelper.requireNonNull(builder.version, this, "version");
        this.vmName = ApiTypeHelper.requireNonNull(builder.vmName, this, "vmName");
        this.vmVendor = ApiTypeHelper.requireNonNull(builder.vmVendor, this, "vmVendor");
        this.vmVersion = ApiTypeHelper.requireNonNull(builder.vmVersion, this, "vmVersion");
        this.usingBundledJdk = ApiTypeHelper.requireNonNull(builder.usingBundledJdk, (Object)this, "usingBundledJdk", false);
        this.usingCompressedOrdinaryObjectPointers = builder.usingCompressedOrdinaryObjectPointers;
        this.inputArguments = ApiTypeHelper.unmodifiableRequired(builder.inputArguments, (Object)this, "inputArguments");
    }

    public static NodeJvmInfo of(Function<Builder, ObjectBuilder<NodeJvmInfo>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> gcCollectors() {
        return this.gcCollectors;
    }

    public final NodeInfoJvmMemory mem() {
        return this.mem;
    }

    public final List<String> memoryPools() {
        return this.memoryPools;
    }

    public final int pid() {
        return this.pid;
    }

    public final long startTimeInMillis() {
        return this.startTimeInMillis;
    }

    public final String version() {
        return this.version;
    }

    public final String vmName() {
        return this.vmName;
    }

    public final String vmVendor() {
        return this.vmVendor;
    }

    public final String vmVersion() {
        return this.vmVersion;
    }

    public final boolean usingBundledJdk() {
        return this.usingBundledJdk;
    }

    @Nullable
    public final Boolean usingCompressedOrdinaryObjectPointers() {
        return this.usingCompressedOrdinaryObjectPointers;
    }

    public final List<String> inputArguments() {
        return this.inputArguments;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.gcCollectors)) {
            generator.writeKey("gc_collectors");
            generator.writeStartArray();
            for (String item0 : this.gcCollectors) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("mem");
        this.mem.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.memoryPools)) {
            generator.writeKey("memory_pools");
            generator.writeStartArray();
            for (String item0 : this.memoryPools) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("pid");
        generator.write(this.pid);
        generator.writeKey("start_time_in_millis");
        generator.write(this.startTimeInMillis);
        generator.writeKey("version");
        generator.write(this.version);
        generator.writeKey("vm_name");
        generator.write(this.vmName);
        generator.writeKey("vm_vendor");
        generator.write(this.vmVendor);
        generator.writeKey("vm_version");
        generator.write(this.vmVersion);
        generator.writeKey("using_bundled_jdk");
        generator.write(this.usingBundledJdk);
        if (this.usingCompressedOrdinaryObjectPointers != null) {
            generator.writeKey("using_compressed_ordinary_object_pointers");
            generator.write(this.usingCompressedOrdinaryObjectPointers.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.inputArguments)) {
            generator.writeKey("input_arguments");
            generator.writeStartArray();
            for (String item0 : this.inputArguments) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupNodeJvmInfoDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::gcCollectors, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "gc_collectors");
        op.add(Builder::mem, NodeInfoJvmMemory._DESERIALIZER, "mem");
        op.add(Builder::memoryPools, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "memory_pools");
        op.add(Builder::pid, JsonpDeserializer.integerDeserializer(), "pid");
        op.add(Builder::startTimeInMillis, JsonpDeserializer.longDeserializer(), "start_time_in_millis");
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version");
        op.add(Builder::vmName, JsonpDeserializer.stringDeserializer(), "vm_name");
        op.add(Builder::vmVendor, JsonpDeserializer.stringDeserializer(), "vm_vendor");
        op.add(Builder::vmVersion, JsonpDeserializer.stringDeserializer(), "vm_version");
        op.add(Builder::usingBundledJdk, JsonpDeserializer.booleanDeserializer(), "using_bundled_jdk");
        op.add(Builder::usingCompressedOrdinaryObjectPointers, JsonpDeserializer.booleanDeserializer(), "using_compressed_ordinary_object_pointers");
        op.add(Builder::inputArguments, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "input_arguments");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<NodeJvmInfo> {
        private List<String> gcCollectors;
        private NodeInfoJvmMemory mem;
        private List<String> memoryPools;
        private Integer pid;
        private Long startTimeInMillis;
        private String version;
        private String vmName;
        private String vmVendor;
        private String vmVersion;
        private Boolean usingBundledJdk;
        @Nullable
        private Boolean usingCompressedOrdinaryObjectPointers;
        private List<String> inputArguments;

        public final Builder gcCollectors(List<String> list) {
            this.gcCollectors = Builder._listAddAll(this.gcCollectors, list);
            return this;
        }

        public final Builder gcCollectors(String value, String ... values) {
            this.gcCollectors = Builder._listAdd(this.gcCollectors, value, values);
            return this;
        }

        public final Builder mem(NodeInfoJvmMemory value) {
            this.mem = value;
            return this;
        }

        public final Builder mem(Function<NodeInfoJvmMemory.Builder, ObjectBuilder<NodeInfoJvmMemory>> fn) {
            return this.mem(fn.apply(new NodeInfoJvmMemory.Builder()).build());
        }

        public final Builder memoryPools(List<String> list) {
            this.memoryPools = Builder._listAddAll(this.memoryPools, list);
            return this;
        }

        public final Builder memoryPools(String value, String ... values) {
            this.memoryPools = Builder._listAdd(this.memoryPools, value, values);
            return this;
        }

        public final Builder pid(int value) {
            this.pid = value;
            return this;
        }

        public final Builder startTimeInMillis(long value) {
            this.startTimeInMillis = value;
            return this;
        }

        public final Builder version(String value) {
            this.version = value;
            return this;
        }

        public final Builder vmName(String value) {
            this.vmName = value;
            return this;
        }

        public final Builder vmVendor(String value) {
            this.vmVendor = value;
            return this;
        }

        public final Builder vmVersion(String value) {
            this.vmVersion = value;
            return this;
        }

        public final Builder usingBundledJdk(boolean value) {
            this.usingBundledJdk = value;
            return this;
        }

        public final Builder usingCompressedOrdinaryObjectPointers(@Nullable Boolean value) {
            this.usingCompressedOrdinaryObjectPointers = value;
            return this;
        }

        public final Builder inputArguments(List<String> list) {
            this.inputArguments = Builder._listAddAll(this.inputArguments, list);
            return this;
        }

        public final Builder inputArguments(String value, String ... values) {
            this.inputArguments = Builder._listAdd(this.inputArguments, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NodeJvmInfo build() {
            this._checkSingleUse();
            return new NodeJvmInfo(this);
        }
    }
}

