/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.GetTokenResponse;
import co.elastic.clients.elasticsearch.security.get_token.AccessTokenGrantType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GetTokenRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final AccessTokenGrantType grantType;
    @Nullable
    private final String kerberosTicket;
    @Nullable
    private final String password;
    @Nullable
    private final String refreshToken;
    @Nullable
    private final String scope;
    @Nullable
    private final String username;
    public static final JsonpDeserializer<GetTokenRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetTokenRequest::setupGetTokenRequestDeserializer);
    public static final Endpoint<GetTokenRequest, GetTokenResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetTokenRequest, GetTokenResponse>("es/security.get_token", request -> "POST", request -> "/_security/oauth2/token", request -> Collections.emptyMap(), request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, GetTokenResponse._DESERIALIZER);

    private GetTokenRequest(Builder builder) {
        this.grantType = builder.grantType;
        this.kerberosTicket = builder.kerberosTicket;
        this.password = builder.password;
        this.refreshToken = builder.refreshToken;
        this.scope = builder.scope;
        this.username = builder.username;
    }

    public static GetTokenRequest of(Function<Builder, ObjectBuilder<GetTokenRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final AccessTokenGrantType grantType() {
        return this.grantType;
    }

    @Nullable
    public final String kerberosTicket() {
        return this.kerberosTicket;
    }

    @Nullable
    public final String password() {
        return this.password;
    }

    @Nullable
    public final String refreshToken() {
        return this.refreshToken;
    }

    @Nullable
    public final String scope() {
        return this.scope;
    }

    @Nullable
    public final String username() {
        return this.username;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.grantType != null) {
            generator.writeKey("grant_type");
            this.grantType.serialize(generator, mapper);
        }
        if (this.kerberosTicket != null) {
            generator.writeKey("kerberos_ticket");
            generator.write(this.kerberosTicket);
        }
        if (this.password != null) {
            generator.writeKey("password");
            generator.write(this.password);
        }
        if (this.refreshToken != null) {
            generator.writeKey("refresh_token");
            generator.write(this.refreshToken);
        }
        if (this.scope != null) {
            generator.writeKey("scope");
            generator.write(this.scope);
        }
        if (this.username != null) {
            generator.writeKey("username");
            generator.write(this.username);
        }
    }

    protected static void setupGetTokenRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::grantType, AccessTokenGrantType._DESERIALIZER, "grant_type");
        op.add(Builder::kerberosTicket, JsonpDeserializer.stringDeserializer(), "kerberos_ticket");
        op.add(Builder::password, JsonpDeserializer.stringDeserializer(), "password");
        op.add(Builder::refreshToken, JsonpDeserializer.stringDeserializer(), "refresh_token");
        op.add(Builder::scope, JsonpDeserializer.stringDeserializer(), "scope");
        op.add(Builder::username, JsonpDeserializer.stringDeserializer(), "username");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GetTokenRequest> {
        @Nullable
        private AccessTokenGrantType grantType;
        @Nullable
        private String kerberosTicket;
        @Nullable
        private String password;
        @Nullable
        private String refreshToken;
        @Nullable
        private String scope;
        @Nullable
        private String username;

        public final Builder grantType(@Nullable AccessTokenGrantType value) {
            this.grantType = value;
            return this;
        }

        public final Builder kerberosTicket(@Nullable String value) {
            this.kerberosTicket = value;
            return this;
        }

        public final Builder password(@Nullable String value) {
            this.password = value;
            return this;
        }

        public final Builder refreshToken(@Nullable String value) {
            this.refreshToken = value;
            return this;
        }

        public final Builder scope(@Nullable String value) {
            this.scope = value;
            return this;
        }

        public final Builder username(@Nullable String value) {
            this.username = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetTokenRequest build() {
            this._checkSingleUse();
            return new GetTokenRequest(this);
        }
    }
}

