/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.util;

import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpDeserializerBase;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpMappingException;
import co.elastic.clients.json.JsonpUtils;
import jakarta.json.stream.JsonParser;
import java.util.EnumSet;
import java.util.function.Function;

public class Pair<K, V> {
    private final K name;
    private final V value;

    public Pair(K name, V value) {
        this.name = name;
        this.value = value;
    }

    public K key() {
        return this.name;
    }

    public V value() {
        return this.value;
    }

    public static <K, V> Pair<K, V> of(K name, V value) {
        return new Pair<K, V>(name, value);
    }

    public static <K, V> JsonpDeserializer<Pair<K, V>> deserializer(final Function<String, K> keyDeserializer, final JsonpDeserializer<V> valueDeserializer) {
        return new JsonpDeserializerBase<Pair<K, V>>(EnumSet.of(JsonParser.Event.START_OBJECT)){

            @Override
            public Pair<K, V> deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
                JsonpUtils.expectNextEvent(parser, JsonParser.Event.KEY_NAME);
                String name = parser.getString();
                try {
                    Object key = keyDeserializer.apply(parser.getString());
                    Object value = valueDeserializer.deserialize(parser, mapper);
                    JsonpUtils.expectNextEvent(parser, JsonParser.Event.END_OBJECT);
                    return new Pair(key, value);
                }
                catch (Exception e) {
                    throw JsonpMappingException.from(e, null, name, parser);
                }
            }
        };
    }
}

