/*
 * Decompiled with CFR 0.152.
 */
package com.a3test.component.idworker;

import com.a3test.component.idworker.IdWorker;
import com.a3test.component.idworker.IdWorkerConfigBean;
import org.springframework.stereotype.Component;

@Component
public class Snowflake
implements IdWorker {
    private long epoch;
    private long projectId;
    private long nodeId;
    private final int projectIdBits = 9;
    private final int nodeIdBits = 3;
    private final int sequenceBits = 10;
    private final long maxNodeId = 7L;
    private final long maxProjectId = 511L;
    private final long sequenceMask = 1023L;
    private final int nodeIdShift = 10;
    private final int projectIdShift = 13;
    private final int timestampLeftShift = 22;
    private long sequence = 0L;
    private long lastTimestamp = -1L;

    public Snowflake(IdWorkerConfigBean idWorkerProperties) {
        if ((long)idWorkerProperties.getProjectid().intValue() > 511L || idWorkerProperties.getProjectid() < 0) {
            throw new IllegalArgumentException(String.format("projectId can't be greater than %d or less than 0.", 511L));
        }
        if ((long)idWorkerProperties.getNodeid().intValue() > 7L || idWorkerProperties.getNodeid() < 0) {
            throw new IllegalArgumentException(String.format("nodeId can't be greater than %d or less than 0.", 7L));
        }
        this.epoch = idWorkerProperties.getEpoch();
        this.nodeId = idWorkerProperties.getNodeid().intValue();
        this.projectId = idWorkerProperties.getProjectid().intValue();
    }

    @Override
    public synchronized String nextId() {
        long timestamp = System.currentTimeMillis();
        if (timestamp < this.lastTimestamp) {
            throw new RuntimeException(String.format("Clock moved backwards. Refusing to generate id for %d milliseconds.", this.lastTimestamp - timestamp));
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0x3FFL;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return String.valueOf(timestamp - this.epoch << 22 | this.projectId << 13 | this.nodeId << 10 | this.sequence);
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = System.currentTimeMillis();
        while (timestamp <= lastTimestamp) {
            timestamp = System.currentTimeMillis();
        }
        return timestamp;
    }
}

