/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.common.rpc.client.openapi;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ServiceLoaderUtil;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.client.common.annotation.Header;
import com.aizuda.snailjob.client.common.annotation.Mapping;
import com.aizuda.snailjob.client.common.annotation.Param;
import com.aizuda.snailjob.client.common.config.SnailJobProperties;
import com.aizuda.snailjob.client.common.exception.SnailJobClientException;
import com.aizuda.snailjob.client.common.rpc.client.openapi.DefaultHttpClient;
import com.aizuda.snailjob.client.common.rpc.client.openapi.Request;
import com.aizuda.snailjob.client.common.rpc.client.openapi.SnailHttpClient;
import com.aizuda.snailjob.common.core.context.SnailSpringContext;
import com.aizuda.snailjob.common.core.enums.ExecutorTypeEnum;
import com.aizuda.snailjob.common.core.enums.HeadersEnum;
import com.aizuda.snailjob.common.core.model.Result;
import com.aizuda.snailjob.common.core.util.ClassUtils;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.core.util.SnailJobVersion;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

public class HttpClientInvokeHandler<R extends Result<Object>>
implements InvocationHandler {
    private final long timeout;
    private final TimeUnit unit;

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        SnailHttpClient snailHttpClient = HttpClientInvokeHandler.loadSnailJobHttpClient();
        Mapping mapping = method.getAnnotation(Mapping.class);
        Parameter[] parameters = method.getParameters();
        Request request = new Request();
        request.setParams(this.getParams(args, parameters));
        request.setMethod(mapping.method().name());
        request.setPath(mapping.path());
        request.setHeaders(this.getHeaderInfo(method, args));
        request.setTimeout(this.unit.toMillis(this.timeout));
        request.setBody(JsonUtil.toJsonString((Object)args[0]));
        request.setReturnType(ClassUtils.getReturnType((Method)method));
        return snailHttpClient.execute(request);
    }

    private String getParams(Object[] args, Parameter[] parameters) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            if (!parameter.isAnnotationPresent(Param.class)) continue;
            Param param = parameter.getAnnotation(Param.class);
            sb.append(param.value()).append("=").append(args[i]);
        }
        String data = sb.toString();
        if (StrUtil.isNotBlank((CharSequence)data)) {
            return "?" + data;
        }
        return "";
    }

    private Map<String, String> getHeaderInfo(Method method, Object[] args) {
        HashMap<String, String> headersMap = new HashMap<String, String>();
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            if (!parameter.isAnnotationPresent(Header.class)) continue;
            Header header = parameter.getAnnotation(Header.class);
            Object o = args[i];
            if (!Objects.nonNull(o)) continue;
            headersMap.put(header.name().getKey(), JsonUtil.toJsonString((Object)o));
        }
        SnailJobProperties snailJobProperties = (SnailJobProperties)SnailSpringContext.getBean(SnailJobProperties.class);
        SnailJobProperties.ServerConfig serverConfig = snailJobProperties.getServer();
        headersMap.put(HeadersEnum.GROUP_NAME.getKey(), snailJobProperties.getGroup());
        headersMap.put(HeadersEnum.HOST.getKey(), serverConfig.getHost());
        headersMap.put(HeadersEnum.NAMESPACE.getKey(), Optional.ofNullable(snailJobProperties.getNamespace()).orElse("764d604ec6fc45f68cd92514c40e9e1a"));
        headersMap.put(HeadersEnum.TOKEN.getKey(), Optional.ofNullable(snailJobProperties.getToken()).orElse("SJ_Wyz3dmsdbDOkDujOTSSoBjGQP1BMsVnj"));
        headersMap.put(HeadersEnum.SYSTEM_VERSION.getKey(), Optional.ofNullable(SnailJobVersion.getVersion()).orElse("local"));
        headersMap.put(HeadersEnum.EXECUTOR_TYPE.getKey(), String.valueOf(ExecutorTypeEnum.JAVA.getType()));
        return headersMap;
    }

    public static SnailHttpClient loadSnailJobHttpClient() {
        SnailJobProperties properties = (SnailJobProperties)SnailSpringContext.getBean(SnailJobProperties.class);
        Assert.notNull((Object)properties, () -> new SnailJobClientException("snail job properties is null"));
        SnailJobProperties.SnailOpenApiConfig openApiConfig = properties.getOpenapi();
        openApiConfig.setHost(Optional.ofNullable(openApiConfig.getHost()).orElse(properties.getServer().getHost()));
        return ServiceLoaderUtil.loadList(SnailHttpClient.class).stream().findAny().orElse(new DefaultHttpClient(openApiConfig));
    }

    @Generated
    public HttpClientInvokeHandler(long timeout, TimeUnit unit) {
        this.timeout = timeout;
        this.unit = unit;
    }
}

