/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.common.alarm;

import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.server.common.alarm.AbstractAlarm;
import com.aizuda.snailjob.server.common.dto.RetryAlarmInfo;
import com.aizuda.snailjob.server.common.triple.ImmutableTriple;
import com.aizuda.snailjob.template.datasource.persistence.po.RetrySceneConfig;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.context.ApplicationEvent;

public abstract class AbstractRetryAlarm<E extends ApplicationEvent>
extends AbstractAlarm<E, RetryAlarmInfo> {
    @Override
    protected Map<Long, List<RetryAlarmInfo>> convertAlarmDTO(List<RetryAlarmInfo> retryAlarmInfoList, Set<Integer> notifyScene) {
        HashMap<Long, List<RetryAlarmInfo>> retryAlarmInfoMap = new HashMap<Long, List<RetryAlarmInfo>>();
        HashSet<String> groupNames = new HashSet<String>();
        HashSet<String> sceneNames = new HashSet<String>();
        HashSet<String> namespaceIds = new HashSet<String>();
        for (RetryAlarmInfo retryAlarmInfo : retryAlarmInfoList) {
            groupNames.add(retryAlarmInfo.getGroupName());
            sceneNames.add(retryAlarmInfo.getSceneName());
            namespaceIds.add(retryAlarmInfo.getNamespaceId());
            notifyScene.add(retryAlarmInfo.getNotifyScene());
        }
        Map retrySceneConfigMap = this.accessTemplate.getSceneConfigAccess().getSceneConfigByGroupNameAndSceneNameList(groupNames, sceneNames, namespaceIds).stream().collect(Collectors.toMap(i -> ImmutableTriple.of(i.getGroupName(), i.getSceneName(), i.getNamespaceId()), Function.identity()));
        for (RetryAlarmInfo retryAlarmInfo : retryAlarmInfoList) {
            RetrySceneConfig retrySceneConfig = (RetrySceneConfig)retrySceneConfigMap.get(ImmutableTriple.of(retryAlarmInfo.getGroupName(), retryAlarmInfo.getSceneName(), retryAlarmInfo.getNamespaceId()));
            if (Objects.isNull(retrySceneConfig)) continue;
            HashSet retryNotifyIds = StrUtil.isBlank((CharSequence)retrySceneConfig.getNotifyIds()) ? new HashSet() : new HashSet(JsonUtil.parseList((String)retrySceneConfig.getNotifyIds(), Long.class));
            for (Long retryNotifyId : retryNotifyIds) {
                List<RetryAlarmInfo> retryAlarmInfos = retryAlarmInfoMap.getOrDefault(retryNotifyId, Lists.newArrayList());
                retryAlarmInfos.add(retryAlarmInfo);
                retryAlarmInfoMap.put(retryNotifyId, retryAlarmInfos);
            }
        }
        return retryAlarmInfoMap;
    }
}

