/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.common.lock.persistence;

import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.lock.persistence.LockStorage;
import com.aizuda.snailjob.template.datasource.enums.DbTypeEnum;
import com.aizuda.snailjob.template.datasource.utils.DbUtils;
import com.google.common.collect.Lists;
import java.util.List;

public final class LockStorageFactory {
    private static final List<LockStorage> LOCK_STORAGES = Lists.newArrayList();

    public static void registerLockStorage(LockStorage lockStorage) {
        LOCK_STORAGES.add(lockStorage);
    }

    public static LockStorage getLockStorage() {
        DbTypeEnum db = DbUtils.getDbType();
        return LOCK_STORAGES.stream().filter(lockProvider -> lockProvider.supports(db.getDb())).findFirst().orElseThrow(() -> new SnailJobServerException("Suitable lock handler not found"));
    }
}

