/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.common.rpc.client.grpc;

import com.aizuda.snailjob.common.core.context.SnailSpringContext;
import com.aizuda.snailjob.common.core.enums.HeadersEnum;
import com.aizuda.snailjob.common.core.grpc.auto.GrpcResult;
import com.aizuda.snailjob.common.core.grpc.auto.Metadata;
import com.aizuda.snailjob.common.core.grpc.auto.SnailJobGrpcRequest;
import com.aizuda.snailjob.common.core.util.NetUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.config.SystemProperties;
import com.aizuda.snailjob.server.common.register.ServerRegister;
import com.aizuda.snailjob.server.common.triple.Pair;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.protobuf.Message;
import io.grpc.CallOptions;
import io.grpc.ClientCall;
import io.grpc.DecompressorRegistry;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.ClientCalls;
import java.net.ConnectException;
import java.nio.channels.ClosedChannelException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcChannel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GrpcChannel.class);
    private static final ThreadPoolExecutor grpcExecutor = GrpcChannel.createGrpcExecutor();
    private static ConcurrentHashMap<Pair<String, String>, ManagedChannel> CHANNEL_MAP = new ConcurrentHashMap(16);

    private GrpcChannel() {
    }

    public static void removeChannel(ManagedChannel channel) {
        CHANNEL_MAP.forEach((key, value) -> {
            if (value.equals(channel)) {
                CHANNEL_MAP.remove(key);
            }
        });
    }

    public static synchronized ListenableFuture<GrpcResult> send(String url, String body, Map<String, String> headers, long reqId, ManagedChannel channel) {
        headers.put(HeadersEnum.HOST_ID.getKey(), ServerRegister.CURRENT_CID);
        headers.put(HeadersEnum.HOST_IP.getKey(), NetUtil.getLocalIpStr());
        headers.put(HeadersEnum.GROUP_NAME.getKey(), "DEFAULT_SERVER");
        headers.put(HeadersEnum.HOST_PORT.getKey(), GrpcChannel.getServerPort());
        headers.put(HeadersEnum.NAMESPACE.getKey(), "764d604ec6fc45f68cd92514c40e9e1a");
        headers.put(HeadersEnum.TOKEN.getKey(), GrpcChannel.getServerToken());
        Metadata metadata = Metadata.newBuilder().setUri(url).putAllHeaders(headers).build();
        SnailJobGrpcRequest snailJobRequest = SnailJobGrpcRequest.newBuilder().setMetadata(metadata).setReqId(reqId).setBody(body).build();
        MethodDescriptor methodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName(MethodDescriptor.generateFullMethodName((String)"UnaryRequest", (String)"unaryRequest")).setRequestMarshaller(ProtoUtils.marshaller((Message)SnailJobGrpcRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)GrpcResult.getDefaultInstance())).build();
        return ClientCalls.futureUnaryCall((ClientCall)channel.newCall(methodDescriptor, CallOptions.DEFAULT), (Object)snailJobRequest);
    }

    private static String getServerToken() {
        SystemProperties properties = (SystemProperties)SnailSpringContext.getBean(SystemProperties.class);
        return properties.getServerToken();
    }

    private static String getServerPort() {
        SystemProperties properties = (SystemProperties)SnailSpringContext.getBean(SystemProperties.class);
        return String.valueOf(properties.getServerPort());
    }

    public static ManagedChannel connect(String ip, Integer port) {
        try {
            SystemProperties.RpcClientProperties clientRpc = ((SystemProperties)SnailSpringContext.getBean(SystemProperties.class)).getClientRpc();
            return ManagedChannelBuilder.forAddress((String)ip, (int)port).usePlaintext().executor((Executor)grpcExecutor).decompressorRegistry(DecompressorRegistry.getDefaultInstance()).maxInboundMessageSize(clientRpc.getMaxInboundMessageSize()).keepAliveTime(clientRpc.getKeepAliveTime().toMillis(), TimeUnit.MILLISECONDS).keepAliveTimeout(clientRpc.getKeepAliveTimeout().toMillis(), TimeUnit.MILLISECONDS).idleTimeout(clientRpc.getIdleTimeout().toMillis(), TimeUnit.MILLISECONDS).keepAliveWithoutCalls(false).build();
        }
        catch (Exception e) {
            GrpcChannel.exceptionHandler(e);
            return null;
        }
    }

    private static ThreadPoolExecutor createGrpcExecutor() {
        SystemProperties.RpcClientProperties clientRpc = ((SystemProperties)SnailSpringContext.getBean(SystemProperties.class)).getClientRpc();
        SystemProperties.ThreadPoolConfig clientTp = clientRpc.getClientTp();
        ThreadPoolExecutor grpcExecutor = new ThreadPoolExecutor(clientTp.getCorePoolSize(), clientTp.getMaximumPoolSize(), clientTp.getKeepAliveTime(), TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(clientTp.getQueueCapacity()), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("snail-job-grpc-client-executor-%d").build());
        grpcExecutor.allowCoreThreadTimeOut(true);
        return grpcExecutor;
    }

    private static void exceptionHandler(Throwable cause) {
        if (cause instanceof ConnectException) {
            SnailJobLog.LOCAL.error("connect error:{}", new Object[]{cause.getMessage()});
        } else if (cause instanceof ClosedChannelException) {
            SnailJobLog.LOCAL.error("connect error:{}", new Object[]{"client has destroy"});
        } else {
            SnailJobLog.LOCAL.error("connect error:", new Object[]{cause});
        }
    }
}

