/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.executor.workflow;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import com.aizuda.snailjob.common.core.enums.JobArgsTypeEnum;
import com.aizuda.snailjob.common.core.enums.JobOperationReasonEnum;
import com.aizuda.snailjob.common.core.enums.WorkflowNodeTypeEnum;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.job.task.dto.WorkflowNodeTaskExecuteDTO;
import com.aizuda.snailjob.server.job.task.support.WorkflowExecutor;
import com.aizuda.snailjob.server.job.task.support.WorkflowTaskConverter;
import com.aizuda.snailjob.server.job.task.support.executor.workflow.WorkflowExecutorContext;
import com.aizuda.snailjob.server.job.task.support.executor.workflow.WorkflowExecutorFactory;
import com.aizuda.snailjob.server.job.task.support.generator.batch.JobTaskBatchGenerator;
import com.aizuda.snailjob.server.job.task.support.generator.batch.JobTaskBatchGeneratorContext;
import com.aizuda.snailjob.server.job.task.support.handler.DistributedLockHandler;
import com.aizuda.snailjob.server.job.task.support.handler.WorkflowBatchHandler;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobTaskBatchMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobTaskMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTask;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTaskBatch;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public abstract class AbstractWorkflowExecutor
implements WorkflowExecutor,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(AbstractWorkflowExecutor.class);
    private static final String KEY = "workflow_execute_{0}_{1}";
    @Autowired
    private DistributedLockHandler distributedLockHandler;
    @Autowired
    private JobTaskBatchMapper jobTaskBatchMapper;
    @Autowired
    private JobTaskBatchGenerator jobTaskBatchGenerator;
    @Autowired
    protected WorkflowBatchHandler workflowBatchHandler;
    @Autowired
    private JobTaskMapper jobTaskMapper;
    @Autowired
    private TransactionTemplate transactionTemplate;

    @Override
    public void execute(final WorkflowExecutorContext context) {
        this.distributedLockHandler.lockWithDisposableAndRetry(() -> {
            long total = 0L;
            if (WorkflowNodeTypeEnum.DECISION.getType() == context.getNodeType().intValue()) {
                List jobTaskBatches = this.jobTaskBatchMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{JobTaskBatch::getOperationReason}).eq(JobTaskBatch::getWorkflowTaskBatchId, (Object)context.getWorkflowTaskBatchId())).eq(JobTaskBatch::getWorkflowNodeId, (Object)context.getWorkflowNodeId()));
                if (CollUtil.isNotEmpty((Collection)jobTaskBatches)) {
                    total = jobTaskBatches.size();
                    JobTaskBatch jobTaskBatch = (JobTaskBatch)jobTaskBatches.get(0);
                    if (JobOperationReasonEnum.WORKFLOW_SUCCESSOR_SKIP_EXECUTION.contains(jobTaskBatch.getOperationReason())) {
                        context.setEvaluationResult(Boolean.FALSE);
                    } else {
                        context.setEvaluationResult(Boolean.TRUE);
                    }
                }
            } else {
                total = this.jobTaskBatchMapper.selectCount((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(JobTaskBatch::getWorkflowTaskBatchId, (Object)context.getWorkflowTaskBatchId())).eq(JobTaskBatch::getWorkflowNodeId, (Object)context.getWorkflowNodeId()));
            }
            if (total > 0L) {
                log.warn("\u4efb\u52a1\u8282\u70b9[{}]\u5df2\u88ab\u6267\u884c\uff0c\u8bf7\u52ff\u91cd\u590d\u6267\u884c", (Object)context.getWorkflowNodeId());
                return;
            }
            this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus status) {
                    if (!AbstractWorkflowExecutor.this.preValidate(context)) {
                        return;
                    }
                    AbstractWorkflowExecutor.this.beforeExecute(context);
                    AbstractWorkflowExecutor.this.doExecute(context);
                    AbstractWorkflowExecutor.this.afterExecute(context);
                }
            });
        }, MessageFormat.format(KEY, context.getWorkflowTaskBatchId(), context.getWorkflowNodeId()), Duration.ofSeconds(10L), Duration.ofSeconds(3L), 16);
    }

    protected boolean preValidate(WorkflowExecutorContext context) {
        return this.doPreValidate(context);
    }

    protected abstract boolean doPreValidate(WorkflowExecutorContext var1);

    protected abstract void afterExecute(WorkflowExecutorContext var1);

    protected abstract void beforeExecute(WorkflowExecutorContext var1);

    protected abstract void doExecute(WorkflowExecutorContext var1);

    protected JobTaskBatch generateJobTaskBatch(WorkflowExecutorContext context) {
        JobTaskBatchGeneratorContext generatorContext = WorkflowTaskConverter.INSTANCE.toJobTaskBatchGeneratorContext(context);
        return this.jobTaskBatchGenerator.generateJobTaskBatch(generatorContext);
    }

    protected void workflowTaskExecutor(WorkflowExecutorContext context) {
        WorkflowNodeTaskExecuteDTO taskExecuteDTO = new WorkflowNodeTaskExecuteDTO();
        taskExecuteDTO.setWorkflowTaskBatchId(context.getWorkflowTaskBatchId());
        taskExecuteDTO.setTaskExecutorScene(context.getTaskExecutorScene());
        taskExecuteDTO.setParentId(context.getWorkflowNodeId());
        taskExecuteDTO.setTaskBatchId(context.getTaskBatchId());
        this.workflowBatchHandler.openNextNode(taskExecuteDTO);
    }

    protected JobTask generateJobTask(WorkflowExecutorContext context, JobTaskBatch jobTaskBatch) {
        JobTask jobTask = new JobTask();
        jobTask.setGroupName(context.getGroupName());
        jobTask.setNamespaceId(context.getNamespaceId());
        jobTask.setJobId(context.getJobId());
        jobTask.setClientInfo("");
        jobTask.setTaskBatchId(jobTaskBatch.getId());
        jobTask.setArgsType(JobArgsTypeEnum.TEXT.getArgsType());
        jobTask.setArgsStr(Optional.ofNullable(context.getTaskResult()).orElse(""));
        jobTask.setTaskStatus(context.getJobTaskStatus());
        jobTask.setResultMessage(String.valueOf(context.getEvaluationResult()));
        Assert.isTrue((1 == this.jobTaskMapper.insert((Object)jobTask) ? 1 : 0) != 0, () -> new SnailJobServerException("\u65b0\u589e\u4efb\u52a1\u5b9e\u4f8b\u5931\u8d25"));
        return jobTask;
    }

    public void afterPropertiesSet() {
        WorkflowExecutorFactory.registerJobExecutor(this.getWorkflowNodeType(), this);
    }
}

