/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.timer;

import akka.actor.ActorRef;
import com.aizuda.snailjob.common.core.constant.SystemConstants;
import com.aizuda.snailjob.server.common.TimerTask;
import com.aizuda.snailjob.server.common.akka.ActorGenerator;
import com.aizuda.snailjob.server.job.task.dto.WorkflowNodeTaskExecuteDTO;
import com.aizuda.snailjob.server.job.task.dto.WorkflowTimerTaskDTO;
import io.netty.util.Timeout;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowTimerTask
implements TimerTask<String> {
    private static final Logger log = LoggerFactory.getLogger(WorkflowTimerTask.class);
    public static final String IDEMPOTENT_KEY_PREFIX = "workflow_{0}";
    private WorkflowTimerTaskDTO workflowTimerTaskDTO;

    public void run(Timeout timeout) throws Exception {
        log.debug("\u5f00\u59cb\u6267\u884c\u4efb\u52a1\u8c03\u5ea6. \u5f53\u524d\u65f6\u95f4:[{}] taskId:[{}]", (Object)LocalDateTime.now(), (Object)this.workflowTimerTaskDTO.getWorkflowTaskBatchId());
        try {
            WorkflowNodeTaskExecuteDTO taskExecuteDTO = new WorkflowNodeTaskExecuteDTO();
            taskExecuteDTO.setWorkflowTaskBatchId(this.workflowTimerTaskDTO.getWorkflowTaskBatchId());
            taskExecuteDTO.setTaskExecutorScene(this.workflowTimerTaskDTO.getTaskExecutorScene());
            taskExecuteDTO.setParentId(SystemConstants.ROOT);
            ActorRef actorRef = ActorGenerator.workflowTaskExecutorActor();
            actorRef.tell((Object)taskExecuteDTO, actorRef);
        }
        catch (Exception e) {
            log.error("\u4efb\u52a1\u8c03\u5ea6\u6267\u884c\u5931\u8d25", (Throwable)e);
        }
    }

    public String idempotentKey() {
        return MessageFormat.format(IDEMPOTENT_KEY_PREFIX, this.workflowTimerTaskDTO.getWorkflowTaskBatchId());
    }

    public WorkflowTimerTask(WorkflowTimerTaskDTO workflowTimerTaskDTO) {
        this.workflowTimerTaskDTO = workflowTimerTaskDTO;
    }
}

