/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.openapi.api;

import com.aizuda.snailjob.model.request.StatusUpdateApiRequest;
import com.aizuda.snailjob.model.request.WorkflowTriggerApiRequest;
import com.aizuda.snailjob.model.request.base.StatusUpdateRequest;
import com.aizuda.snailjob.model.request.base.WorkflowTriggerRequest;
import com.aizuda.snailjob.server.openapi.service.WorkflowApiService;
import com.aizuda.snailjob.server.service.service.WorkflowService;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.Size;
import java.util.Set;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class WorkflowApi {
    private final WorkflowApiService apiService;
    @Qualifier(value="workflowApiCommonService")
    private final WorkflowService workflowService;

    @DeleteMapping(value={"/api/workflow/delete"})
    public boolean deleteWorkflowByIds(@RequestBody @NotEmpty(message="ids cannot be null") @Size(max=100, message="Maximum {max} deletions") @NotEmpty(message="ids cannot be null") @Size(max=100, message="Maximum {max} deletions") Set<Long> ids) {
        return this.workflowService.deleteWorkflowByIds(ids);
    }

    @PostMapping(value={"/api/workflow/trigger"})
    public boolean triggerWorkFlow(@RequestBody @Validated WorkflowTriggerApiRequest jobTriggerApiDTO) {
        return this.workflowService.triggerWorkFlow((WorkflowTriggerRequest)jobTriggerApiDTO);
    }

    @PutMapping(value={"/api/workflow/update/status"})
    public boolean updateWorkFlowStatus(@RequestBody @Validated StatusUpdateApiRequest requestDTO) {
        return this.workflowService.updateWorkFlowStatus((StatusUpdateRequest)requestDTO);
    }

    @Generated
    public WorkflowApi(WorkflowApiService apiService, @Qualifier(value="workflowApiCommonService") WorkflowService workflowService) {
        this.apiService = apiService;
        this.workflowService = workflowService;
    }
}

