/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.openapi.interceptor;

import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.enums.HeadersEnum;
import com.aizuda.snailjob.server.common.cache.CacheToken;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;

@Configuration
public class OpenApiAuthenticationInterceptor
implements HandlerInterceptor {
    public static final String NAMESPACE_ID = HeadersEnum.NAMESPACE.getKey();
    public static final String TOKEN = HeadersEnum.TOKEN.getKey();
    public static final String GROUP_NAME = HeadersEnum.GROUP_NAME.getKey();

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String namespaceId = request.getHeader(NAMESPACE_ID);
        String groupName = request.getHeader(GROUP_NAME);
        String token = request.getHeader(TOKEN);
        request.setAttribute(NAMESPACE_ID, (Object)namespaceId);
        request.setAttribute(GROUP_NAME, (Object)groupName);
        if (StrUtil.isBlank((CharSequence)token) || !CacheToken.get((String)groupName, (String)namespaceId).equals(token)) {
            throw new SnailJobServerException("Token authentication failed. [namespace:{} groupName:{} token:{}]", new Object[]{namespaceId, groupName, token});
        }
        return true;
    }

    @Generated
    public OpenApiAuthenticationInterceptor() {
    }
}

