/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.block;

import com.aizuda.snailjob.common.core.enums.JobOperationReasonEnum;
import com.aizuda.snailjob.common.core.enums.RetryBlockStrategyEnum;
import com.aizuda.snailjob.common.core.enums.RetryOperationReasonEnum;
import com.aizuda.snailjob.common.core.enums.RetryTaskStatusEnum;
import com.aizuda.snailjob.server.retry.task.dto.RetryTaskGeneratorDTO;
import com.aizuda.snailjob.server.retry.task.dto.TaskStopJobDTO;
import com.aizuda.snailjob.server.retry.task.support.RetryTaskConverter;
import com.aizuda.snailjob.server.retry.task.support.block.AbstracJobBlockStrategy;
import com.aizuda.snailjob.server.retry.task.support.block.BlockStrategyContext;
import com.aizuda.snailjob.server.retry.task.support.generator.task.RetryTaskGeneratorHandler;
import com.aizuda.snailjob.server.retry.task.support.handler.RetryTaskStopHandler;
import java.util.Objects;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class OverlayRetryBlockStrategy
extends AbstracJobBlockStrategy {
    private final RetryTaskGeneratorHandler retryTaskGeneratorHandler;
    private final RetryTaskStopHandler retryTaskStopHandler;

    @Override
    public void doBlock(BlockStrategyContext context) {
        RetryTaskGeneratorDTO generatorDTO = RetryTaskConverter.INSTANCE.toRetryTaskGeneratorDTO(context);
        generatorDTO.setTaskStatus(RetryTaskStatusEnum.CANCEL.getStatus());
        generatorDTO.setOperationReason(RetryOperationReasonEnum.RETRY_TASK_DISCARD.getReason());
        this.retryTaskGeneratorHandler.generateRetryTask(generatorDTO);
        TaskStopJobDTO stopJobDTO = RetryTaskConverter.INSTANCE.toTaskStopJobDTO(context);
        if (Objects.isNull(context.getOperationReason()) || context.getOperationReason().intValue() == JobOperationReasonEnum.NONE.getReason()) {
            stopJobDTO.setOperationReason(RetryOperationReasonEnum.RETRY_TASK_OVERLAY.getReason());
        }
        stopJobDTO.setNeedUpdateTaskStatus(true);
        this.retryTaskStopHandler.stop(stopJobDTO);
    }

    @Override
    protected RetryBlockStrategyEnum blockStrategyEnum() {
        return RetryBlockStrategyEnum.OVERLAY;
    }

    @Generated
    public OverlayRetryBlockStrategy(RetryTaskGeneratorHandler retryTaskGeneratorHandler, RetryTaskStopHandler retryTaskStopHandler) {
        this.retryTaskGeneratorHandler = retryTaskGeneratorHandler;
        this.retryTaskStopHandler = retryTaskStopHandler;
    }
}

