/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.service.convert;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.model.request.base.JobRequest;
import com.aizuda.snailjob.model.response.base.JobResponse;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.common.util.TriggerIntervalUtils;
import com.aizuda.snailjob.template.datasource.persistence.po.Job;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.mapstruct.factory.Mappers;

@Mapper
public interface JobConverter {
    public static final JobConverter INSTANCE = (JobConverter)Mappers.getMapper(JobConverter.class);

    @Mappings(value={@Mapping(target="notifyIds", expression="java(JobConverter.toNotifyIdsStr(jobRequest.getNotifyIds()))"), @Mapping(target="triggerInterval", expression="java(JobConverter.toTriggerInterval(jobRequest))")})
    public Job convert(JobRequest var1);

    @Mappings(value={@Mapping(target="nextTriggerAt", expression="java(com.aizuda.snailjob.server.common.util.DateUtils.toLocalDateTime(job.getNextTriggerAt()))"), @Mapping(target="notifyIds", expression="java(JobConverter.toNotifyIds(job.getNotifyIds()))")})
    public void fillCommonFields(Job var1, @MappingTarget JobResponse var2);

    public static LocalDateTime toLocalDateTime(Long nextTriggerAt) {
        if (Objects.isNull(nextTriggerAt) || nextTriggerAt == 0L) {
            return null;
        }
        return DateUtils.toLocalDateTime((Long)nextTriggerAt);
    }

    public static Set<Long> toNotifyIds(String notifyIds) {
        if (StrUtil.isBlank((CharSequence)notifyIds)) {
            return new HashSet<Long>();
        }
        return new HashSet<Long>(JsonUtil.parseList((String)notifyIds, Long.class));
    }

    public static String toNotifyIdsStr(Set<Long> notifyIds) {
        if (CollUtil.isEmpty(notifyIds)) {
            return "";
        }
        return JsonUtil.toJsonString(notifyIds);
    }

    public static String toTriggerInterval(JobRequest jobRequestVO) {
        String triggerInterval = jobRequestVO.getTriggerInterval();
        if (StrUtil.isBlank((CharSequence)triggerInterval) || Objects.isNull(jobRequestVO.getTriggerType())) {
            return "";
        }
        return TriggerIntervalUtils.getPointInTimeStr((String)triggerInterval, (Integer)jobRequestVO.getTriggerType());
    }
}

