/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.HashUtil;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.model.request.base.JobRequest;
import com.aizuda.snailjob.model.request.base.JobTriggerRequest;
import com.aizuda.snailjob.model.request.base.StatusUpdateRequest;
import com.aizuda.snailjob.model.response.base.JobResponse;
import com.aizuda.snailjob.server.common.config.SystemProperties;
import com.aizuda.snailjob.server.common.enums.JobTaskExecutorSceneEnum;
import com.aizuda.snailjob.server.common.enums.SyetemTaskTypeEnum;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.common.util.TriggerIntervalUtils;
import com.aizuda.snailjob.server.job.task.dto.JobTaskPrepareDTO;
import com.aizuda.snailjob.server.job.task.support.JobTaskConverter;
import com.aizuda.snailjob.server.job.task.support.prepare.job.TerminalJobPrepareHandler;
import com.aizuda.snailjob.server.service.convert.JobConverter;
import com.aizuda.snailjob.server.service.dto.CalculateNextTriggerAtDTO;
import com.aizuda.snailjob.server.service.kit.JobKit;
import com.aizuda.snailjob.server.service.kit.TriggerIntervalKit;
import com.aizuda.snailjob.server.service.service.JobService;
import com.aizuda.snailjob.template.datasource.access.AccessTemplate;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobSummaryMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.WorkflowNodeMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.GroupConfig;
import com.aizuda.snailjob.template.datasource.persistence.po.Job;
import com.aizuda.snailjob.template.datasource.persistence.po.JobSummary;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractJobService
implements JobService {
    @Autowired
    protected SystemProperties systemProperties;
    @Autowired
    protected JobMapper jobMapper;
    @Autowired
    protected JobSummaryMapper jobSummaryMapper;
    @Autowired
    protected AccessTemplate accessTemplate;
    @Autowired
    protected TerminalJobPrepareHandler terminalJobPrepareHandler;
    @Autowired
    protected WorkflowNodeMapper workflowNodeMapper;

    @Override
    public Boolean trigger(JobTriggerRequest jobTrigger) {
        Job job = (Job)this.jobMapper.selectById((Serializable)jobTrigger.getJobId());
        Assert.notNull((Object)job, () -> new SnailJobServerException("job can not be null."));
        long count = this.accessTemplate.getGroupConfigAccess().count((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(GroupConfig::getGroupName, (Object)job.getGroupName())).eq(GroupConfig::getNamespaceId, (Object)job.getNamespaceId())).eq(GroupConfig::getGroupStatus, (Object)StatusEnum.YES.getStatus()));
        Assert.isTrue((count > 0L ? 1 : 0) != 0, () -> new SnailJobServerException("Group [{}] is closed, manual execution is not supported.", new Object[]{job.getGroupName()}));
        JobTaskPrepareDTO jobTaskPrepare = JobTaskConverter.INSTANCE.toJobTaskPrepare(job);
        jobTaskPrepare.setNextTriggerAt(DateUtils.toNowMilli());
        jobTaskPrepare.setTaskExecutorScene(JobTaskExecutorSceneEnum.MANUAL_JOB.getType());
        if (StrUtil.isNotBlank((CharSequence)jobTrigger.getTmpArgsStr())) {
            jobTaskPrepare.setTmpArgsStr(jobTrigger.getTmpArgsStr());
        }
        this.terminalJobPrepareHandler.handle(jobTaskPrepare);
        return true;
    }

    @Override
    public boolean deleteJobByIds(Set<Long> ids) {
        String namespaceId = this.getNamespaceId();
        Assert.isTrue((ids.size() == this.jobMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{Job::getId}).eq(Job::getNamespaceId, (Object)namespaceId)).eq(Job::getJobStatus, (Object)StatusEnum.NO.getStatus())).in(Job::getId, ids)).size() ? 1 : 0) != 0, () -> new SnailJobServerException("Failed to delete the scheduled task. Ensure the task is closed, and confirm whether the job exists."));
        Assert.isTrue((boolean)this.workflowNodeMapper.selectJobUsedInNonLatestWorkflow(ids).isEmpty(), () -> new SnailJobServerException("Failed to delete scheduled task, please check if the task is used in the workflow"));
        List jobSummaries = this.jobSummaryMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{JobSummary::getId}).in(JobSummary::getBusinessId, ids)).eq(JobSummary::getNamespaceId, (Object)namespaceId)).eq(JobSummary::getSystemTaskType, (Object)SyetemTaskTypeEnum.JOB.getType()));
        if (CollUtil.isNotEmpty((Collection)jobSummaries)) {
            this.jobSummaryMapper.deleteByIds((Collection)StreamUtils.toSet((Collection)jobSummaries, JobSummary::getId));
        }
        Assert.isTrue((ids.size() == this.jobMapper.delete((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Job::getNamespaceId, (Object)namespaceId)).eq(Job::getJobStatus, (Object)StatusEnum.NO.getStatus())).in(Job::getId, ids)) ? 1 : 0) != 0, () -> new SnailJobServerException("Failed to delete scheduled task"));
        return true;
    }

    @Override
    public boolean updateJob(JobRequest jobRequest) {
        Assert.notNull((Object)jobRequest.getId(), () -> new SnailJobServerException("ID cannot be empty"));
        if (Objects.nonNull(jobRequest.getJobStatus())) {
            Assert.notNull((Object)StatusEnum.of((Integer)jobRequest.getJobStatus()), () -> new SnailJobServerException("Invalid status parameter"));
        }
        Job job = (Job)this.jobMapper.selectById((Serializable)jobRequest.getId());
        Assert.notNull((Object)job, () -> new SnailJobServerException("Job is null, update failed"));
        this.updateJobPreValidator(jobRequest);
        Job updateJob = JobConverter.INSTANCE.convert(jobRequest);
        Integer triggerType = Optional.ofNullable(jobRequest.getTriggerType()).orElse(job.getTriggerType());
        String triggerInterval = jobRequest.getTriggerInterval();
        if (StrUtil.isBlank((CharSequence)triggerInterval)) {
            triggerInterval = job.getTriggerInterval();
        }
        String pointInTimeStr = TriggerIntervalUtils.getPointInTimeStr((String)triggerInterval, (Integer)triggerType);
        updateJob.setTriggerInterval(pointInTimeStr);
        updateJob.setResident(JobKit.isResident(triggerType, triggerInterval));
        this.checkTriggerInterval(jobRequest);
        CalculateNextTriggerAtDTO nextTriggerAtDTO = CalculateNextTriggerAtDTO.builder().triggerInterval(updateJob.getTriggerInterval()).triggerType(triggerType).newResident(updateJob.getResident()).oldResident(job.getResident()).id(job.getId()).build();
        updateJob.setNextTriggerAt(JobKit.calculateNextTriggerAt(nextTriggerAtDTO));
        updateJob.setGroupName(null);
        updateJob.setNamespaceId(null);
        updateJob.setOwnerId(Optional.ofNullable(jobRequest.getOwnerId()).orElse(0L));
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(Job::getId, (Object)jobRequest.getId());
        return 1 == this.jobMapper.update((Object)updateJob, (Wrapper)updateWrapper);
    }

    @Override
    public Long addJob(JobRequest request) {
        this.addJobPreValidator(request);
        Job job = JobConverter.INSTANCE.convert(request);
        job.setResident(JobKit.isResident(request.getTriggerType(), request.getTriggerInterval()));
        this.checkTriggerInterval(request);
        job.setBucketIndex(Integer.valueOf(HashUtil.bkdrHash((String)(request.getGroupName() + request.getJobName())) % this.systemProperties.getBucketTotal()));
        job.setNextTriggerAt(JobKit.calculateNextTriggerAt(job.getTriggerType(), job.getTriggerInterval(), DateUtils.toNowMilli()));
        job.setId(null);
        job.setNamespaceId(this.getNamespaceId());
        this.addJobPopulate(job, request);
        Assert.isTrue((1 == this.jobMapper.insert((Object)job) ? 1 : 0) != 0, () -> new SnailJobServerException("Adding new task failed"));
        return job.getId();
    }

    @Override
    public Boolean updateJobStatus(StatusUpdateRequest requestDTO) {
        Assert.notNull((Object)StatusEnum.of((Integer)requestDTO.getStatus()), () -> new SnailJobServerException("Status cannot be empty"));
        Job job = (Job)this.jobMapper.selectById((Serializable)requestDTO.getId());
        Assert.notNull((Object)job, () -> new SnailJobServerException("update job status failed"));
        if (Objects.equals(requestDTO.getStatus(), job.getJobStatus())) {
            return true;
        }
        Job update = new Job();
        if (StatusEnum.YES.getStatus().equals(job.getJobStatus())) {
            update.setNextTriggerAt(JobKit.calculateNextTriggerAt(job.getTriggerType(), job.getTriggerInterval(), DateUtils.toNowMilli()));
        }
        update.setJobStatus(requestDTO.getStatus());
        update.setId(requestDTO.getId());
        return 1 == this.jobMapper.updateById((Object)update);
    }

    @Override
    public <T extends JobResponse> T getJobById(Long id, Class<T> clazz) {
        Job job = (Job)this.jobMapper.selectById((Serializable)id);
        try {
            JobResponse instance = (JobResponse)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            JobConverter.INSTANCE.fillCommonFields(job, instance);
            this.getJobByIdAfter(instance, job);
            return (T)instance;
        }
        catch (Exception e) {
            throw new SnailJobServerException("Failed to get job by id [{}]", new Object[]{id, e});
        }
    }

    protected abstract void getJobByIdAfter(JobResponse var1, Job var2);

    protected abstract void updateJobPreValidator(JobRequest var1);

    protected abstract String getNamespaceId();

    protected abstract void addJobPopulate(Job var1, JobRequest var2);

    protected void checkTriggerInterval(JobRequest jobRequestVO) {
        TriggerIntervalKit.checkTriggerInterval(jobRequestVO.getTriggerInterval(), jobRequestVO.getTriggerType());
    }

    protected abstract void addJobPreValidator(JobRequest var1);
}

