/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.controller;

import com.aizuda.snailjob.common.core.annotation.OriginalControllerReturnValue;
import com.aizuda.snailjob.server.web.annotation.LoginRequired;
import com.aizuda.snailjob.server.web.model.base.PageResult;
import com.aizuda.snailjob.server.web.model.request.ExportJobVO;
import com.aizuda.snailjob.server.web.model.request.JobQueryVO;
import com.aizuda.snailjob.server.web.model.request.JobRequestVO;
import com.aizuda.snailjob.server.web.model.request.JobStatusUpdateRequestVO;
import com.aizuda.snailjob.server.web.model.response.JobResponseVO;
import com.aizuda.snailjob.server.web.service.JobService;
import com.aizuda.snailjob.server.web.util.ExportUtils;
import com.aizuda.snailjob.server.web.util.ImportUtils;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/job"})
public class JobController {
    @Autowired
    private JobService jobService;

    @GetMapping(value={"/page/list"})
    @LoginRequired
    public PageResult<List<JobResponseVO>> getJobPage(JobQueryVO jobQueryVO) {
        return this.jobService.getJobPage(jobQueryVO);
    }

    @GetMapping(value={"/list"})
    @LoginRequired
    public List<JobResponseVO> getJobList(@RequestParam(value="groupName") String groupName) {
        return this.jobService.getJobList(groupName);
    }

    @GetMapping(value={"{id}"})
    @LoginRequired
    public JobResponseVO getJobDetail(@PathVariable(value="id") Long id) {
        return this.jobService.getJobDetail(id);
    }

    @PostMapping
    @LoginRequired
    public Boolean saveJob(@RequestBody @Validated JobRequestVO jobRequestVO) {
        return this.jobService.saveJob(jobRequestVO);
    }

    @PutMapping
    @LoginRequired
    public Boolean updateJob(@RequestBody @Validated JobRequestVO jobRequestVO) {
        return this.jobService.updateJob(jobRequestVO);
    }

    @PutMapping(value={"/status"})
    @LoginRequired
    public Boolean updateJobStatus(@RequestBody @Validated JobStatusUpdateRequestVO jobRequestVO) {
        return this.jobService.updateJobStatus(jobRequestVO);
    }

    @DeleteMapping(value={"{id}"})
    @LoginRequired
    public Boolean deleteJobById(@PathVariable(value="id") Long id) {
        return this.jobService.deleteJobById(id);
    }

    @GetMapping(value={"/cron"})
    @LoginRequired
    public List<String> getTimeByCron(@RequestParam(value="cron") String cron) {
        return this.jobService.getTimeByCron(cron);
    }

    @GetMapping(value={"/job-name/list"})
    @LoginRequired
    public List<JobResponseVO> getJobNameList(@RequestParam(value="keywords", required=false) String keywords, @RequestParam(value="jobId", required=false) Long jobId, @RequestParam(value="groupName", required=false) String groupName) {
        return this.jobService.getJobNameList(keywords, jobId, groupName);
    }

    @PostMapping(value={"/trigger/{jobId}"})
    @LoginRequired
    public Boolean trigger(@PathVariable(value="jobId") Long jobId) {
        return this.jobService.trigger(jobId);
    }

    @PostMapping(value={"/import"}, consumes={"multipart/form-data"})
    @LoginRequired
    public void importScene(@RequestPart(value="file") MultipartFile file) throws IOException {
        this.jobService.importJobs(ImportUtils.parseList(file, JobRequestVO.class));
    }

    @PostMapping(value={"/export"})
    @LoginRequired
    @OriginalControllerReturnValue
    public ResponseEntity<String> exportGroup(@RequestBody ExportJobVO exportJobVO) {
        return ExportUtils.doExport(this.jobService.exportJobs(exportJobVO));
    }
}

