/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.controller;

import com.aizuda.snailjob.common.core.annotation.OriginalControllerReturnValue;
import com.aizuda.snailjob.model.request.base.JobRequest;
import com.aizuda.snailjob.model.request.base.JobTriggerRequest;
import com.aizuda.snailjob.model.request.base.StatusUpdateRequest;
import com.aizuda.snailjob.server.service.service.JobService;
import com.aizuda.snailjob.server.web.annotation.LoginRequired;
import com.aizuda.snailjob.server.web.model.base.PageResult;
import com.aizuda.snailjob.server.web.model.request.ExportJobVO;
import com.aizuda.snailjob.server.web.model.request.JobQueryVO;
import com.aizuda.snailjob.server.web.model.request.JobRequestWebVO;
import com.aizuda.snailjob.server.web.model.request.JobTriggerVO;
import com.aizuda.snailjob.server.web.model.request.StatusUpdateRequestWebVO;
import com.aizuda.snailjob.server.web.model.response.JobResponseWebVO;
import com.aizuda.snailjob.server.web.service.JobWebService;
import com.aizuda.snailjob.server.web.util.ExportUtils;
import com.aizuda.snailjob.server.web.util.ImportUtils;
import jakarta.validation.constraints.NotEmpty;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/job"})
public class JobController {
    @Qualifier(value="jobWebCommonService")
    private final JobService jobService;
    private final JobWebService jobWebService;

    @GetMapping(value={"/page/list"})
    @LoginRequired
    public PageResult<List<JobResponseWebVO>> getJobPage(JobQueryVO jobQueryVO) {
        return this.jobWebService.getJobPage(jobQueryVO);
    }

    @GetMapping(value={"/list"})
    @LoginRequired
    public List<JobResponseWebVO> getJobList(@RequestParam(value="groupName") String groupName) {
        return this.jobWebService.getJobList(groupName);
    }

    @GetMapping(value={"{id}"})
    @LoginRequired
    public JobResponseWebVO getJobDetail(@PathVariable(value="id") Long id) {
        return (JobResponseWebVO)this.jobService.getJobById(id, JobResponseWebVO.class);
    }

    @PostMapping
    @LoginRequired
    public Long saveJob(@RequestBody @Validated JobRequestWebVO jobRequestWebVO) {
        return this.jobService.addJob((JobRequest)jobRequestWebVO);
    }

    @PutMapping
    @LoginRequired
    public Boolean updateJob(@RequestBody @Validated JobRequestWebVO jobRequestWebVO) {
        return this.jobService.updateJob((JobRequest)jobRequestWebVO);
    }

    @PutMapping(value={"/status"})
    @LoginRequired
    public Boolean updateJobStatus(@RequestBody @Validated StatusUpdateRequestWebVO jobRequestVO) {
        return this.jobService.updateJobStatus((StatusUpdateRequest)jobRequestVO);
    }

    @DeleteMapping(value={"/ids"})
    @LoginRequired
    public Boolean deleteJobById(@RequestBody @NotEmpty(message="ids cannot be null") @NotEmpty(message="ids cannot be null") Set<Long> ids) {
        return this.jobService.deleteJobByIds(ids);
    }

    @GetMapping(value={"/cron"})
    @LoginRequired
    public List<String> getTimeByCron(@RequestParam(value="cron") String cron) {
        return this.jobWebService.getTimeByCron(cron);
    }

    @GetMapping(value={"/job-name/list"})
    @LoginRequired
    public List<JobResponseWebVO> getJobNameList(@RequestParam(value="keywords", required=false) String keywords, @RequestParam(value="jobId", required=false) Long jobId, @RequestParam(value="groupName", required=false) String groupName) {
        return this.jobWebService.getJobNameList(keywords, jobId, groupName);
    }

    @PostMapping(value={"/trigger"})
    @LoginRequired
    public Boolean trigger(@RequestBody @Validated JobTriggerVO jobTrigger) {
        JobTriggerRequest triggerDTO = new JobTriggerRequest();
        triggerDTO.setJobId(jobTrigger.getJobId());
        triggerDTO.setTmpArgsStr(jobTrigger.getTmpArgsStr());
        return this.jobService.trigger(triggerDTO);
    }

    @PostMapping(value={"/import"}, consumes={"multipart/form-data"})
    @LoginRequired
    public void importScene(@RequestPart(value="file") MultipartFile file) throws IOException {
        this.jobWebService.importJobs(ImportUtils.parseList(file, JobRequestWebVO.class));
    }

    @PostMapping(value={"/export"})
    @LoginRequired
    @OriginalControllerReturnValue
    public ResponseEntity<String> exportGroup(@RequestBody ExportJobVO exportJobVO) {
        return ExportUtils.doExport(this.jobWebService.exportJobs(exportJobVO));
    }

    @Generated
    public JobController(@Qualifier(value="jobWebCommonService") JobService jobService, JobWebService jobWebService) {
        this.jobService = jobService;
        this.jobWebService = jobWebService;
    }
}

