/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.dto.PartitionTask;
import com.aizuda.snailjob.server.common.enums.IdGeneratorModeEnum;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.handler.ConfigVersionSyncHandler;
import com.aizuda.snailjob.server.common.util.PartitionTaskUtils;
import com.aizuda.snailjob.server.web.model.base.PageResult;
import com.aizuda.snailjob.server.web.model.request.ExportGroupVO;
import com.aizuda.snailjob.server.web.model.request.GroupConfigQueryVO;
import com.aizuda.snailjob.server.web.model.request.GroupConfigRequestVO;
import com.aizuda.snailjob.server.web.model.request.UserSessionVO;
import com.aizuda.snailjob.server.web.model.response.GroupConfigResponseVO;
import com.aizuda.snailjob.server.web.service.GroupConfigService;
import com.aizuda.snailjob.server.web.service.convert.GroupConfigConverter;
import com.aizuda.snailjob.server.web.service.convert.GroupConfigResponseVOConverter;
import com.aizuda.snailjob.server.web.util.UserSessionUtils;
import com.aizuda.snailjob.template.datasource.access.AccessTemplate;
import com.aizuda.snailjob.template.datasource.access.ConfigAccess;
import com.aizuda.snailjob.template.datasource.enums.DbTypeEnum;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.NamespaceMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.ServerNodeMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.SystemUserPermissionMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.WorkflowMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.GroupConfig;
import com.aizuda.snailjob.template.datasource.persistence.po.Job;
import com.aizuda.snailjob.template.datasource.persistence.po.Namespace;
import com.aizuda.snailjob.template.datasource.persistence.po.RetrySceneConfig;
import com.aizuda.snailjob.template.datasource.persistence.po.ServerNode;
import com.aizuda.snailjob.template.datasource.persistence.po.SystemUserPermission;
import com.aizuda.snailjob.template.datasource.persistence.po.Workflow;
import com.aizuda.snailjob.template.datasource.utils.DbUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;

@Service
@Validated
public class GroupConfigServiceImpl
implements GroupConfigService {
    private final ServerNodeMapper serverNodeMapper;
    private final AccessTemplate accessTemplate;
    private final ConfigVersionSyncHandler configVersionSyncHandler;
    private final JdbcTemplate jdbcTemplate;
    private final NamespaceMapper namespaceMapper;
    private final JobMapper jobMapper;
    private final WorkflowMapper workflowMapper;
    private final SystemUserPermissionMapper systemUserPermissionMapper;

    @Override
    @Transactional
    public Boolean addGroup(GroupConfigRequestVO groupConfigRequestVO) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        ConfigAccess groupConfigAccess = this.accessTemplate.getGroupConfigAccess();
        Assert.isTrue((groupConfigAccess.count((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(GroupConfig::getNamespaceId, (Object)namespaceId)).eq(GroupConfig::getGroupName, (Object)groupConfigRequestVO.getGroupName())) == 0L ? 1 : 0) != 0, () -> new SnailJobServerException("GroupName already exists {}", new Object[]{groupConfigRequestVO.getGroupName()}));
        return this.doSaveGroupConfig(namespaceId, groupConfigRequestVO);
    }

    @Override
    @Transactional
    public Boolean updateGroup(GroupConfigRequestVO groupConfigRequestVO) {
        String groupName = groupConfigRequestVO.getGroupName();
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        ConfigAccess groupConfigAccess = this.accessTemplate.getGroupConfigAccess();
        long count = groupConfigAccess.count((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(GroupConfig::getNamespaceId, (Object)namespaceId)).eq(GroupConfig::getGroupName, (Object)groupName));
        if (count <= 0L) {
            return false;
        }
        GroupConfig groupConfig = GroupConfigConverter.INSTANCE.toGroupConfig(groupConfigRequestVO);
        groupConfig.setDescription(Optional.ofNullable(groupConfigRequestVO.getDescription()).orElse(""));
        groupConfig.setVersion(Integer.valueOf(1));
        groupConfig.setToken(null);
        groupConfig.setGroupName(null);
        Assert.isTrue((1 == groupConfigAccess.update((Object)groupConfig, (LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(GroupConfig::getNamespaceId, (Object)namespaceId)).eq(GroupConfig::getGroupName, (Object)groupName)) ? 1 : 0) != 0, () -> new SnailJobServerException("exception occurred while adding group. groupConfigVO[{}]", new Object[]{groupConfigRequestVO}));
        boolean add = this.configVersionSyncHandler.addSyncTask(groupName, namespaceId, Integer.valueOf(0));
        if (!add) {
            this.configVersionSyncHandler.syncVersion(groupName, namespaceId);
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean updateGroupStatus(String groupName, Integer status) {
        GroupConfig groupConfig = new GroupConfig();
        groupConfig.setGroupStatus(status);
        ConfigAccess groupConfigAccess = this.accessTemplate.getGroupConfigAccess();
        return groupConfigAccess.update((Object)groupConfig, (LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(GroupConfig::getNamespaceId, (Object)UserSessionUtils.currentUserSession().getNamespaceId())).eq(GroupConfig::getGroupName, (Object)groupName)) == 1;
    }

    @Override
    public PageResult<List<GroupConfigResponseVO>> getGroupConfigForPage(GroupConfigQueryVO queryVO) {
        UserSessionVO userSessionVO = UserSessionUtils.currentUserSession();
        String namespaceId = userSessionVO.getNamespaceId();
        List<String> groupNames = UserSessionUtils.getGroupNames(queryVO.getGroupName());
        ConfigAccess groupConfigAccess = this.accessTemplate.getGroupConfigAccess();
        PageDTO groupConfigPageDTO = groupConfigAccess.listPage(new PageDTO((long)queryVO.getPage(), (long)queryVO.getSize()), (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(GroupConfig::getNamespaceId, (Object)namespaceId)).eq(Objects.nonNull(queryVO.getGroupStatus()), GroupConfig::getGroupStatus, (Object)queryVO.getGroupStatus())).in(CollUtil.isNotEmpty(groupNames), GroupConfig::getGroupName, groupNames)).likeRight(StrUtil.isNotBlank((CharSequence)queryVO.getGroupName()), GroupConfig::getGroupName, (Object)StrUtil.trim((CharSequence)queryVO.getGroupName()))).orderByDesc(GroupConfig::getId));
        List records = groupConfigPageDTO.getRecords();
        if (CollUtil.isEmpty((Collection)records)) {
            return new PageResult<List<GroupConfigResponseVO>>(groupConfigPageDTO.getCurrent(), groupConfigPageDTO.getSize(), groupConfigPageDTO.getTotal());
        }
        PageResult<List<GroupConfigResponseVO>> pageResult = new PageResult<List<GroupConfigResponseVO>>(groupConfigPageDTO.getCurrent(), groupConfigPageDTO.getSize(), groupConfigPageDTO.getTotal());
        List<GroupConfigResponseVO> responseVOList = GroupConfigResponseVOConverter.INSTANCE.convertList(records);
        for (GroupConfigResponseVO groupConfigResponseVO : responseVOList) {
            Optional.ofNullable(IdGeneratorModeEnum.modeOf((int)groupConfigResponseVO.getIdGeneratorMode())).ifPresent(idGeneratorMode -> groupConfigResponseVO.setIdGeneratorModeName(idGeneratorMode.getDesc()));
        }
        pageResult.setData(responseVOList);
        return pageResult;
    }

    private boolean doSaveGroupConfig(String namespaceId, GroupConfigRequestVO groupConfigRequestVO) {
        GroupConfig groupConfig = GroupConfigConverter.INSTANCE.toGroupConfig(groupConfigRequestVO);
        groupConfig.setCreateDt(LocalDateTime.now());
        groupConfig.setVersion(Integer.valueOf(1));
        groupConfig.setNamespaceId(namespaceId);
        groupConfig.setGroupName(groupConfigRequestVO.getGroupName());
        groupConfig.setToken(groupConfigRequestVO.getToken());
        groupConfig.setDescription(Optional.ofNullable(groupConfigRequestVO.getDescription()).orElse(""));
        ConfigAccess groupConfigAccess = this.accessTemplate.getGroupConfigAccess();
        Assert.isTrue((1 == groupConfigAccess.insert((Object)groupConfig) ? 1 : 0) != 0, () -> new SnailJobServerException("Group addition exception groupConfigVO[{}]", new Object[]{groupConfigRequestVO}));
        return Boolean.TRUE;
    }

    @Override
    public GroupConfigResponseVO getGroupConfigByGroupName(String groupName) {
        ConfigAccess groupConfigAccess = this.accessTemplate.getGroupConfigAccess();
        GroupConfig groupConfig = (GroupConfig)groupConfigAccess.one((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(GroupConfig::getNamespaceId, (Object)UserSessionUtils.currentUserSession().getNamespaceId())).eq(GroupConfig::getGroupName, (Object)groupName));
        GroupConfigResponseVO groupConfigResponseVO = GroupConfigResponseVOConverter.INSTANCE.convert(groupConfig);
        Optional.ofNullable(IdGeneratorModeEnum.modeOf((int)groupConfig.getIdGeneratorMode())).ifPresent(idGeneratorMode -> groupConfigResponseVO.setIdGeneratorModeName(idGeneratorMode.getDesc()));
        return groupConfigResponseVO;
    }

    @Override
    public List<GroupConfigResponseVO> getAllGroupConfigList(List<String> namespaceIds) {
        ConfigAccess groupConfigAccess = this.accessTemplate.getGroupConfigAccess();
        List groupConfigs = groupConfigAccess.list((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{GroupConfig::getGroupName, GroupConfig::getNamespaceId}).in(CollUtil.isNotEmpty(namespaceIds), GroupConfig::getNamespaceId, namespaceIds));
        if (CollUtil.isEmpty((Collection)groupConfigs)) {
            return Collections.emptyList();
        }
        List namespaces = this.namespaceMapper.selectList((Wrapper)new LambdaQueryWrapper().in(Namespace::getUniqueId, (Collection)StreamUtils.toSet((Collection)groupConfigs, GroupConfig::getNamespaceId)));
        Map namespaceMap = StreamUtils.toMap((Collection)namespaces, Namespace::getUniqueId, Namespace::getName);
        List<GroupConfigResponseVO> groupConfigResponses = GroupConfigResponseVOConverter.INSTANCE.convertList(groupConfigs);
        for (GroupConfigResponseVO groupConfigResponseVO : groupConfigResponses) {
            groupConfigResponseVO.setNamespaceName((String)namespaceMap.get(groupConfigResponseVO.getNamespaceId()));
        }
        return groupConfigResponses;
    }

    @Override
    public List<String> getAllGroupNameList() {
        UserSessionVO userSessionVO = UserSessionUtils.currentUserSession();
        if (userSessionVO.isUser()) {
            return userSessionVO.getGroupNames();
        }
        ConfigAccess groupConfigAccess = this.accessTemplate.getGroupConfigAccess();
        List groupConfigs = groupConfigAccess.list(((LambdaQueryWrapper)new LambdaQueryWrapper().eq(GroupConfig::getNamespaceId, (Object)userSessionVO.getNamespaceId())).select(new SFunction[]{GroupConfig::getGroupName}));
        return StreamUtils.toList((Collection)groupConfigs, GroupConfig::getGroupName);
    }

    @Override
    public List<String> getOnlinePods(String groupName) {
        List serverNodes = this.serverNodeMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ServerNode::getNamespaceId, (Object)UserSessionUtils.currentUserSession().getNamespaceId())).eq(ServerNode::getGroupName, (Object)groupName));
        return StreamUtils.toList((Collection)serverNodes, serverNode -> serverNode.getHostIp() + ":" + serverNode.getHostPort());
    }

    @Override
    public List<Integer> getTablePartitionList() {
        List<Integer> list;
        block10: {
            DataSource dataSource = this.jdbcTemplate.getDataSource();
            Connection connection = dataSource.getConnection();
            try {
                String catalog = connection.getCatalog();
                String schema = connection.getSchema();
                String tableNamePattern = "sj_retry_task_%";
                DbTypeEnum dbType = DbUtils.getDbType();
                if (DbTypeEnum.ORACLE.getDb().equals(dbType.getDb()) || DbTypeEnum.DM.getDb().equals(dbType.getDb())) {
                    tableNamePattern = tableNamePattern.toUpperCase();
                }
                DatabaseMetaData metaData = connection.getMetaData();
                ResultSet tableRs = metaData.getTables(catalog, schema, tableNamePattern, new String[]{"TABLE"});
                ArrayList<String> tableList = new ArrayList<String>();
                while (tableRs.next()) {
                    String tableName = tableRs.getString("TABLE_NAME");
                    tableList.add(tableName);
                }
                list = tableList.stream().map(ReUtil::getFirstNumber).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                if (connection == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ignored) {
                    SnailJobLog.LOCAL.error("getTablePartitionList method error", new Object[]{ignored});
                    return Collections.emptyList();
                }
            }
            connection.close();
        }
        return list;
    }

    @Override
    @Transactional
    public void importGroup(List<GroupConfigRequestVO> requestList) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        Set groupSet = StreamUtils.toSet(requestList, GroupConfigRequestVO::getGroupName);
        ConfigAccess groupConfigAccess = this.accessTemplate.getGroupConfigAccess();
        List configs = groupConfigAccess.list((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{GroupConfig::getGroupName}).eq(GroupConfig::getNamespaceId, (Object)namespaceId)).in(GroupConfig::getGroupName, (Collection)groupSet));
        Assert.isTrue((boolean)CollUtil.isEmpty((Collection)configs), () -> new SnailJobServerException("Import failed. Reason: Group {} already exists", new Object[]{StreamUtils.toSet((Collection)configs, GroupConfig::getGroupName)}));
        for (GroupConfigRequestVO groupConfigRequestVO : requestList) {
            this.doSaveGroupConfig(namespaceId, groupConfigRequestVO);
        }
    }

    @Override
    public String exportGroup(ExportGroupVO exportGroupVO) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        ArrayList allRequestList = Lists.newArrayList();
        PartitionTaskUtils.process(startId -> {
            List groupConfigs = this.accessTemplate.getGroupConfigAccess().listPage(new PageDTO(0L, 100L, Boolean.FALSE.booleanValue()), (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ge(GroupConfig::getId, (Object)startId)).eq(GroupConfig::getNamespaceId, (Object)namespaceId)).eq(Objects.nonNull(exportGroupVO.getGroupStatus()), GroupConfig::getGroupStatus, (Object)exportGroupVO.getGroupStatus())).in(CollUtil.isNotEmpty(exportGroupVO.getGroupIds()), GroupConfig::getId, exportGroupVO.getGroupIds())).likeRight(StrUtil.isNotBlank((CharSequence)exportGroupVO.getGroupName()), GroupConfig::getGroupName, (Object)StrUtil.trim((CharSequence)exportGroupVO.getGroupName()))).orderByAsc(GroupConfig::getId)).getRecords();
            return groupConfigs.stream().map(GroupConfigPartitionTask::new).toList();
        }, partitionTasks -> {
            List configPartitionTasks = partitionTasks;
            List configs = StreamUtils.toList((Collection)configPartitionTasks, GroupConfigPartitionTask::getConfig);
            allRequestList.addAll(GroupConfigConverter.INSTANCE.toGroupConfigRequestVOs(configs));
        }, (long)0L);
        return JsonUtil.toJsonString((Object)allRequestList);
    }

    @Override
    public boolean deleteByGroupName(String groupName) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        Assert.isTrue((boolean)CollUtil.isEmpty((Collection)this.jobMapper.selectList((IPage)new PageDTO(1L, 1L), (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Job::getNamespaceId, (Object)namespaceId)).eq(Job::getGroupName, (Object)groupName)).orderByAsc(Job::getId))), () -> new SnailJobServerException("There are undeleted scheduled tasks. Please delete the current group's scheduled tasks before retrying deletion"));
        Assert.isTrue((boolean)CollUtil.isEmpty((Collection)this.workflowMapper.selectList((IPage)new PageDTO(1L, 1L), (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Workflow::getNamespaceId, (Object)namespaceId)).eq(Workflow::getGroupName, (Object)groupName)).orderByAsc(Workflow::getId))), () -> new SnailJobServerException("There are undeleted workflow tasks. Please delete the current group's workflow tasks before retrying deletion"));
        Assert.isTrue((boolean)CollUtil.isEmpty((Collection)this.accessTemplate.getSceneConfigAccess().listPage(new PageDTO(1L, 1L), (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetrySceneConfig::getNamespaceId, (Object)namespaceId)).eq(RetrySceneConfig::getGroupName, (Object)groupName)).orderByAsc(RetrySceneConfig::getId)).getRecords()), () -> new SnailJobServerException("There are undeleted retry scenes. Please delete the current group's retry scenes before retrying deletion"));
        Assert.isTrue((boolean)CollUtil.isEmpty((Collection)this.systemUserPermissionMapper.selectList((IPage)new PageDTO(1L, 1L), (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SystemUserPermission::getNamespaceId, (Object)namespaceId)).eq(SystemUserPermission::getGroupName, (Object)groupName)).orderByAsc(SystemUserPermission::getId))), () -> new SnailJobServerException("There are allocated group permissions. Please delete the allocated group permissions before retrying deletion"));
        Assert.isTrue((boolean)CollUtil.isEmpty((Collection)this.serverNodeMapper.selectList((IPage)new PageDTO(1L, 1L), (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ServerNode::getNamespaceId, (Object)namespaceId)).eq(ServerNode::getGroupName, (Object)groupName)).orderByAsc(ServerNode::getId))), () -> new SnailJobServerException("There are live client nodes."));
        Assert.isTrue((1 == this.accessTemplate.getGroupConfigAccess().delete((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(GroupConfig::getNamespaceId, (Object)namespaceId)).eq(GroupConfig::getGroupStatus, (Object)StatusEnum.NO.getStatus())).eq(GroupConfig::getGroupName, (Object)groupName)) ? 1 : 0) != 0, () -> new SnailJobServerException("Failed to delete group, please check if the status is closed"));
        return Boolean.TRUE;
    }

    @Generated
    public GroupConfigServiceImpl(ServerNodeMapper serverNodeMapper, AccessTemplate accessTemplate, ConfigVersionSyncHandler configVersionSyncHandler, JdbcTemplate jdbcTemplate, NamespaceMapper namespaceMapper, JobMapper jobMapper, WorkflowMapper workflowMapper, SystemUserPermissionMapper systemUserPermissionMapper) {
        this.serverNodeMapper = serverNodeMapper;
        this.accessTemplate = accessTemplate;
        this.configVersionSyncHandler = configVersionSyncHandler;
        this.jdbcTemplate = jdbcTemplate;
        this.namespaceMapper = namespaceMapper;
        this.jobMapper = jobMapper;
        this.workflowMapper = workflowMapper;
        this.systemUserPermissionMapper = systemUserPermissionMapper;
    }

    private static class GroupConfigPartitionTask
    extends PartitionTask {
        private final GroupConfig config;

        public GroupConfigPartitionTask(@NotNull GroupConfig config) {
            this.config = config;
            this.setId(config.getId());
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GroupConfigPartitionTask)) {
                return false;
            }
            GroupConfigPartitionTask other = (GroupConfigPartitionTask)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            GroupConfig this$config = this.getConfig();
            GroupConfig other$config = other.getConfig();
            return !(this$config == null ? other$config != null : !this$config.equals(other$config));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof GroupConfigPartitionTask;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            GroupConfig $config = this.getConfig();
            result = result * 59 + ($config == null ? 43 : $config.hashCode());
            return result;
        }

        @Generated
        public GroupConfig getConfig() {
            return this.config;
        }
    }
}

