/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjUtil;
import com.aizuda.snailjob.common.core.enums.JobOperationReasonEnum;
import com.aizuda.snailjob.common.core.enums.JobTaskBatchStatusEnum;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.job.task.support.handler.WorkflowBatchHandler;
import com.aizuda.snailjob.server.service.service.impl.AbstractWorkflowBatchService;
import com.aizuda.snailjob.server.web.model.base.PageResult;
import com.aizuda.snailjob.server.web.model.request.UserSessionVO;
import com.aizuda.snailjob.server.web.model.request.WorkflowBatchQueryVO;
import com.aizuda.snailjob.server.web.model.response.WorkflowBatchResponseVO;
import com.aizuda.snailjob.server.web.service.WorkflowWebBatchService;
import com.aizuda.snailjob.server.web.service.convert.WorkflowWebConverter;
import com.aizuda.snailjob.server.web.service.handler.JobHandler;
import com.aizuda.snailjob.server.web.util.UserSessionUtils;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobTaskBatchMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.WorkflowTaskBatchMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTaskBatch;
import com.aizuda.snailjob.template.datasource.persistence.po.WorkflowTaskBatch;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="WorkflowWebBatchCommonService")
public class WorkflowWebBatchServiceImpl
extends AbstractWorkflowBatchService
implements WorkflowWebBatchService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowWebBatchServiceImpl.class);
    private final WorkflowTaskBatchMapper workflowTaskBatchMapper;
    private final JobTaskBatchMapper jobTaskBatchMapper;
    private final WorkflowBatchHandler workflowBatchHandler;
    private final JobHandler jobHandler;

    private static boolean isNoOperation(JobTaskBatch i) {
        return JobOperationReasonEnum.WORKFLOW_SUCCESSOR_SKIP_EXECUTION.contains(i.getOperationReason()) || i.getTaskBatchStatus().intValue() == JobTaskBatchStatusEnum.STOP.getStatus();
    }

    @Override
    public PageResult<List<WorkflowBatchResponseVO>> listPage(WorkflowBatchQueryVO queryVO) {
        PageDTO pageDTO = new PageDTO((long)queryVO.getPage(), (long)queryVO.getSize());
        UserSessionVO userSessionVO = UserSessionUtils.currentUserSession();
        List<String> groupNames = UserSessionUtils.getGroupNames(queryVO.getGroupName());
        if (userSessionVO.isUser() && CollUtil.isEmpty(groupNames)) {
            return new PageResult<List<WorkflowBatchResponseVO>>(pageDTO, Collections.emptyList());
        }
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"batch.namespace_id", (Object)userSessionVO.getNamespaceId())).eq(queryVO.getWorkflowId() != null, (Object)"batch.workflow_id", (Object)queryVO.getWorkflowId())).in(CollUtil.isNotEmpty(groupNames), (Object)"batch.group_name", groupNames)).eq(queryVO.getTaskBatchStatus() != null, (Object)"batch.task_batch_status", (Object)queryVO.getTaskBatchStatus())).between(ObjUtil.isNotNull((Object)queryVO.getDatetimeRange()), (Object)"batch.create_dt", (Object)queryVO.getStartDt(), (Object)queryVO.getEndDt())).eq((Object)"batch.deleted", (Object)0)).orderByDesc((Object)"batch.id");
        List batchResponseDOList = this.workflowTaskBatchMapper.selectWorkflowBatchPageList(pageDTO, (Wrapper)wrapper);
        List<WorkflowBatchResponseVO> batchResponseVOList = WorkflowWebConverter.INSTANCE.convertListToWorkflowBatchList(batchResponseDOList);
        return new PageResult<List<WorkflowBatchResponseVO>>(pageDTO, batchResponseVOList);
    }

    @Override
    public Boolean stop(Long id) {
        WorkflowTaskBatch workflowTaskBatch = (WorkflowTaskBatch)this.workflowTaskBatchMapper.selectById((Serializable)id);
        Assert.notNull((Object)workflowTaskBatch, () -> new SnailJobServerException("workflow batch can not be null."));
        Assert.isTrue((boolean)JobTaskBatchStatusEnum.NOT_COMPLETE.contains(workflowTaskBatch.getTaskBatchStatus()), () -> new SnailJobServerException("workflow batch status completed."));
        this.workflowBatchHandler.stop(id, Integer.valueOf(JobOperationReasonEnum.MANNER_STOP.getReason()));
        return Boolean.TRUE;
    }

    @Override
    @Transactional
    public Boolean deleteByIds(Set<Long> ids) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        Assert.isTrue((ids.size() == this.workflowTaskBatchMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(WorkflowTaskBatch::getNamespaceId, (Object)namespaceId)).in(WorkflowTaskBatch::getId, ids)) ? 1 : 0) != 0, () -> new SnailJobServerException("Failed to delete workflow task, please check if the task status is closed"));
        List jobTaskBatches = this.jobTaskBatchMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(JobTaskBatch::getNamespaceId, (Object)namespaceId)).in(JobTaskBatch::getWorkflowTaskBatchId, ids));
        if (CollUtil.isEmpty((Collection)jobTaskBatches)) {
            return Boolean.TRUE;
        }
        Set jobTaskBatchIds = StreamUtils.toSet((Collection)jobTaskBatches, JobTaskBatch::getId);
        this.jobHandler.deleteJobTaskBatchByIds(jobTaskBatchIds, namespaceId);
        return Boolean.TRUE;
    }

    @Generated
    public WorkflowWebBatchServiceImpl(WorkflowTaskBatchMapper workflowTaskBatchMapper, JobTaskBatchMapper jobTaskBatchMapper, WorkflowBatchHandler workflowBatchHandler, JobHandler jobHandler) {
        this.workflowTaskBatchMapper = workflowTaskBatchMapper;
        this.jobTaskBatchMapper = jobTaskBatchMapper;
        this.workflowBatchHandler = workflowBatchHandler;
        this.jobHandler = jobHandler;
    }
}

