/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.utils;

import java.lang.reflect.Method;
import org.springframework.beans.PropertyValues;
import org.springframework.boot.bind.PropertySourcesPropertyValues;
import org.springframework.boot.bind.RelaxedDataBinder;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySources;

public class BinderUtils {
    private static boolean existBinder = false;
    private static boolean existRelaxedDataBinder = false;
    private static Method Binder_get_Method;
    private static Method Binder_bind_Method;
    private static Method Bindable_of_Method;
    private static Method BindResult_orElse_Method;

    public static <T> T bind(ConfigurableEnvironment environment, String prefix, Class<T> type) {
        if (existRelaxedDataBinder) {
            return BinderUtils.relaxedDataBinderBind(environment, prefix, type);
        }
        if (existBinder) {
            return BinderUtils.binderBind(environment, prefix, type);
        }
        throw new IllegalStateException("Can not find class org.springframework.boot.context.properties.bind.Binder or org.springframework.boot.bind.RelaxedDataBinder");
    }

    private static <T> T binderBind(ConfigurableEnvironment environment, String prefix, Class<T> type) {
        try {
            if (Binder_get_Method == null) {
                Class<?> binderClass = Class.forName("org.springframework.boot.context.properties.bind.Binder");
                Class<?> bindableClass = Class.forName("org.springframework.boot.context.properties.bind.Bindable");
                Binder_get_Method = binderClass.getMethod("get", Environment.class);
                Binder_bind_Method = binderClass.getMethod("bind", String.class, bindableClass);
            }
            if (Bindable_of_Method == null) {
                Bindable_of_Method = Class.forName("org.springframework.boot.context.properties.bind.Bindable").getMethod("of", Class.class);
            }
            if (BindResult_orElse_Method == null) {
                BindResult_orElse_Method = Class.forName("org.springframework.boot.context.properties.bind.BindResult").getMethod("orElse", Object.class);
            }
            Object binder = Binder_get_Method.invoke(null, environment);
            Object bindable = Bindable_of_Method.invoke(null, type);
            Object bindResult = Binder_bind_Method.invoke(binder, prefix, bindable);
            return (T)BindResult_orElse_Method.invoke(bindResult, type.newInstance());
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static <T> T relaxedDataBinderBind(ConfigurableEnvironment environment, String prefix, Class<T> type) {
        T instance;
        try {
            instance = type.newInstance();
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
        new RelaxedDataBinder(instance, prefix).bind((PropertyValues)new PropertySourcesPropertyValues((PropertySources)environment.getPropertySources()));
        return instance;
    }

    static {
        try {
            Class.forName("org.springframework.boot.context.properties.bind.Binder");
            existBinder = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            Class.forName("org.springframework.boot.bind.RelaxedDataBinder");
            existRelaxedDataBinder = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

