/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.autoconfigure.dashscope;

import com.alibaba.cloud.ai.autoconfigure.dashscope.DashScopeParentProperties;
import com.alibaba.cloud.ai.autoconfigure.dashscope.ResolvedConnectionProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public final class DashScopeConnectionUtils {
    private DashScopeConnectionUtils() {
    }

    @NotNull
    public static ResolvedConnectionProperties resolveConnectionProperties(DashScopeParentProperties commonProperties, DashScopeParentProperties modelProperties, String modelType) {
        String baseUrl = StringUtils.hasText((String)modelProperties.getBaseUrl()) ? modelProperties.getBaseUrl() : commonProperties.getBaseUrl();
        String apiKey = StringUtils.hasText((String)modelProperties.getApiKey()) ? modelProperties.getApiKey() : commonProperties.getApiKey();
        String workspaceId = StringUtils.hasText((String)modelProperties.getWorkspaceId()) ? modelProperties.getWorkspaceId() : commonProperties.getWorkspaceId();
        HashMap<String, List<String>> connectionHeaders = new HashMap<String, List<String>>();
        if (StringUtils.hasText((String)workspaceId)) {
            connectionHeaders.put("DashScope-Workspace", List.of(workspaceId));
        }
        if (Objects.isNull(apiKey) && Objects.nonNull(System.getenv("AI_DASHSCOPE_API_KEY"))) {
            apiKey = System.getenv("AI_DASHSCOPE_API_KEY");
        }
        Assert.hasText((String)baseUrl, (String)("DashScope base URL must be set.  Use the connection property: spring.ai.dashscope.base-url or spring.ai.dashscope." + modelType + ".base-url property."));
        Assert.hasText((String)apiKey, (String)("DashScope API key must be set. Use the connection property: spring.ai.dashscope.api-key or spring.ai.dashscope." + modelType + ".api-key property."));
        return new ResolvedConnectionProperties(baseUrl, apiKey, workspaceId, (MultiValueMap<String, String>)CollectionUtils.toMultiValueMap(connectionHeaders));
    }
}

