/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.sentinel.gateway;

import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class GatewayEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    private static final String SENTINEL_FILTER_ENABLED = "spring.cloud.sentinel.filter.enabled";
    private static final String PROPERTY_SOURCE_NAME = "defaultProperties";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication springApplication) {
        this.addDefaultPropertySource(environment);
    }

    private void addDefaultPropertySource(ConfigurableEnvironment environment) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.configureDefaultProperties(map);
        this.addOrReplace(environment.getPropertySources(), map);
    }

    private void configureDefaultProperties(Map<String, Object> source) {
        source.put(SENTINEL_FILTER_ENABLED, "false");
    }

    private void addOrReplace(MutablePropertySources propertySources, Map<String, Object> map) {
        PropertySource source;
        MapPropertySource target = null;
        if (propertySources.contains(PROPERTY_SOURCE_NAME) && (source = propertySources.get(PROPERTY_SOURCE_NAME)) instanceof MapPropertySource) {
            MapPropertySource mapPropertySource;
            target = mapPropertySource = (MapPropertySource)source;
            for (String key : map.keySet()) {
                if (target.containsProperty(key)) continue;
                ((Map)target.getSource()).put(key, map.get(key));
            }
        }
        if (target == null) {
            target = new MapPropertySource(PROPERTY_SOURCE_NAME, map);
        }
        if (!propertySources.contains(PROPERTY_SOURCE_NAME)) {
            propertySources.addLast((PropertySource)target);
        }
    }
}

