/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cola.catchlog;

import com.alibaba.cola.catchlog.ResponseHandler;
import com.alibaba.cola.exception.BaseException;
import com.alibaba.cola.exception.BizException;
import com.alibaba.cola.exception.SysException;
import com.alibaba.fastjson.JSON;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class CatchLogAspect {
    private static final Logger log = LoggerFactory.getLogger(CatchLogAspect.class);

    @Pointcut(value="@within(CatchAndLog) && execution(public * *(..))")
    public void pointcut() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="pointcut()")
    public Object around(ProceedingJoinPoint joinPoint) {
        long startTime = System.currentTimeMillis();
        this.logRequest(joinPoint);
        Object response = null;
        try {
            response = joinPoint.proceed();
        }
        catch (Throwable e) {
            response = this.handleException(joinPoint, e);
        }
        finally {
            this.logResponse(startTime, response);
        }
        return response;
    }

    private Object handleException(ProceedingJoinPoint joinPoint, Throwable e) {
        MethodSignature ms = (MethodSignature)joinPoint.getSignature();
        Class returnType = ms.getReturnType();
        if (e instanceof BizException) {
            log.warn("BIZ EXCEPTION : " + e.getMessage());
            if (log.isDebugEnabled()) {
                log.error(e.getMessage(), e);
            }
            return ResponseHandler.handle(returnType, (BaseException)e);
        }
        if (e instanceof SysException) {
            log.error("SYS EXCEPTION :");
            log.error(e.getMessage(), e);
            return ResponseHandler.handle(returnType, (BaseException)e);
        }
        log.error("UNKNOWN EXCEPTION :");
        log.error(e.getMessage(), e);
        return ResponseHandler.handle(returnType, "UNKNOWN_ERROR", e.getMessage());
    }

    private void logResponse(long startTime, Object response) {
        try {
            long endTime = System.currentTimeMillis();
            log.debug("RESPONSE : " + JSON.toJSONString((Object)response));
            log.debug("COST : " + (endTime - startTime) + "ms");
        }
        catch (Exception e) {
            log.error("logResponse error : " + e);
        }
    }

    private void logRequest(ProceedingJoinPoint joinPoint) {
        try {
            Object[] args;
            log.debug("START PROCESSING: " + joinPoint.getSignature().toShortString());
            for (Object arg : args = joinPoint.getArgs()) {
                log.debug("REQUEST : " + JSON.toJSONString((Object)arg));
            }
        }
        catch (Exception e) {
            log.error("logReqeust error : " + e);
        }
    }
}

