/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.property;

import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.property.PropertyListener;
import com.alibaba.csp.sentinel.property.SentinelProperty;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class DynamicSentinelProperty<T>
implements SentinelProperty<T> {
    protected Set<PropertyListener<T>> listeners = Collections.synchronizedSet(new HashSet());
    private T value = null;

    public DynamicSentinelProperty() {
    }

    public DynamicSentinelProperty(T value) {
        this.value = value;
    }

    @Override
    public void addListener(PropertyListener<T> listener) {
        this.listeners.add(listener);
        listener.configLoad(this.value);
    }

    @Override
    public void removeListener(PropertyListener<T> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void updateValue(T newValue) {
        if (this.isEqual(this.value, newValue)) {
            return;
        }
        RecordLog.info("[DynamicSentinelProperty] Config will be updated to: " + newValue, new Object[0]);
        this.value = newValue;
        for (PropertyListener<T> listener : this.listeners) {
            listener.configUpdate(newValue);
        }
    }

    private boolean isEqual(T oldValue, T newValue) {
        if (oldValue == null && newValue == null) {
            return true;
        }
        if (oldValue == null) {
            return false;
        }
        return oldValue.equals(newValue);
    }

    public void close() {
        this.listeners.clear();
    }
}

