/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.statistic.base;

import com.alibaba.csp.sentinel.slots.statistic.base.WindowWrap;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.csp.sentinel.util.TimeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantLock;

public abstract class LeapArray<T> {
    protected int windowLengthInMs;
    protected int sampleCount;
    protected int intervalInMs;
    protected final AtomicReferenceArray<WindowWrap<T>> array;
    private final ReentrantLock updateLock = new ReentrantLock();

    public LeapArray(int windowLengthInMs, int intervalInSec) {
        AssertUtil.isTrue(windowLengthInMs > 0, "bucket length is invalid: " + windowLengthInMs);
        int intervalInMs = intervalInSec * 1000;
        AssertUtil.isTrue(intervalInMs > windowLengthInMs, "total time span of the window should be greater than bucket length");
        AssertUtil.isTrue(intervalInMs % windowLengthInMs == 0, "time span needs to be evenly divided");
        this.windowLengthInMs = windowLengthInMs;
        this.intervalInMs = intervalInMs;
        this.sampleCount = intervalInMs / windowLengthInMs;
        this.array = new AtomicReferenceArray(this.sampleCount);
    }

    public WindowWrap<T> currentWindow() {
        return this.currentWindow(TimeUtil.currentTimeMillis());
    }

    public abstract T newEmptyBucket();

    protected abstract WindowWrap<T> resetWindowTo(WindowWrap<T> var1, long var2);

    protected int calculateTimeIdx(long timeMillis) {
        long timeId = timeMillis / (long)this.windowLengthInMs;
        return (int)(timeId % (long)this.array.length());
    }

    protected long calculateWindowStart(long timeMillis) {
        return timeMillis - timeMillis % (long)this.windowLengthInMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WindowWrap<T> currentWindow(long timeMillis) {
        if (timeMillis < 0L) {
            return null;
        }
        int idx = this.calculateTimeIdx(timeMillis);
        long windowStart = this.calculateWindowStart(timeMillis);
        while (true) {
            WindowWrap<T> old;
            if ((old = this.array.get(idx)) == null) {
                WindowWrap<T> window = new WindowWrap<T>(this.windowLengthInMs, windowStart, this.newEmptyBucket());
                if (this.array.compareAndSet(idx, null, window)) {
                    return window;
                }
                Thread.yield();
                continue;
            }
            if (windowStart == old.windowStart()) {
                return old;
            }
            if (windowStart > old.windowStart()) {
                if (this.updateLock.tryLock()) {
                    try {
                        WindowWrap<T> windowWrap = this.resetWindowTo(old, windowStart);
                        return windowWrap;
                    }
                    finally {
                        this.updateLock.unlock();
                    }
                }
                Thread.yield();
                continue;
            }
            if (windowStart < old.windowStart()) break;
        }
        return new WindowWrap<T>(this.windowLengthInMs, windowStart, this.newEmptyBucket());
    }

    public WindowWrap<T> getPreviousWindow(long timeMillis) {
        if (timeMillis < 0L) {
            return null;
        }
        long timeId = (timeMillis - (long)this.windowLengthInMs) / (long)this.windowLengthInMs;
        int idx = (int)(timeId % (long)this.array.length());
        timeMillis -= (long)this.windowLengthInMs;
        WindowWrap<T> wrap = this.array.get(idx);
        if (wrap == null || this.isWindowDeprecated(wrap)) {
            return null;
        }
        if (wrap.windowStart() + (long)this.windowLengthInMs < timeMillis) {
            return null;
        }
        return wrap;
    }

    public WindowWrap<T> getPreviousWindow() {
        return this.getPreviousWindow(TimeUtil.currentTimeMillis());
    }

    public T getWindowValue(long time) {
        if (time < 0L) {
            return null;
        }
        int idx = this.calculateTimeIdx(time);
        WindowWrap<T> old = this.array.get(idx);
        if (old == null || this.isWindowDeprecated(old)) {
            return null;
        }
        return old.value();
    }

    protected boolean isWindowDeprecated(WindowWrap<T> windowWrap) {
        return TimeUtil.currentTimeMillis() - windowWrap.windowStart() >= (long)this.intervalInMs;
    }

    public List<WindowWrap<T>> list() {
        int size = this.array.length();
        ArrayList<WindowWrap<T>> result = new ArrayList<WindowWrap<T>>(size);
        for (int i = 0; i < size; ++i) {
            WindowWrap<T> windowWrap = this.array.get(i);
            if (windowWrap == null || this.isWindowDeprecated(windowWrap)) continue;
            result.add(windowWrap);
        }
        return result;
    }

    public List<T> values() {
        int size = this.array.length();
        ArrayList<T> result = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            WindowWrap<T> windowWrap = this.array.get(i);
            if (windowWrap == null || this.isWindowDeprecated(windowWrap)) continue;
            result.add(windowWrap.value());
        }
        return result;
    }

    WindowWrap<T> getValidHead(long timeMillis) {
        int idx = this.calculateTimeIdx(timeMillis + (long)this.windowLengthInMs);
        WindowWrap<T> wrap = this.array.get(idx);
        if (wrap == null || this.isWindowDeprecated(wrap)) {
            return null;
        }
        return wrap;
    }

    public WindowWrap<T> getValidHead() {
        return this.getValidHead(TimeUtil.currentTimeMillis());
    }

    public int getSampleCount() {
        return this.sampleCount;
    }

    public int getIntervalInSecond() {
        return this.intervalInMs / 1000;
    }
}

