/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.log;

import com.alibaba.csp.sentinel.log.ConsoleHandler;
import com.alibaba.csp.sentinel.log.CspFormatter;
import com.alibaba.csp.sentinel.log.DateFileLogHandler;
import com.alibaba.csp.sentinel.log.LogConfigLoader;
import com.alibaba.csp.sentinel.log.LoggerUtils;
import com.alibaba.csp.sentinel.util.ConfigUtil;
import com.alibaba.csp.sentinel.util.PidUtil;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogBase {
    public static final String LOG_DIR = "csp.sentinel.log.dir";
    public static final String LOG_NAME_USE_PID = "csp.sentinel.log.use.pid";
    public static final String LOG_OUTPUT_TYPE = "csp.sentinel.log.output.type";
    public static final String LOG_CHARSET = "csp.sentinel.log.charset";
    public static final String LOG_OUTPUT_TYPE_FILE = "file";
    public static final String LOG_OUTPUT_TYPE_CONSOLE = "console";
    public static final String LOG_CHARSET_UTF8 = "utf-8";
    private static final String DIR_NAME = "logs" + File.separator + "csp";
    private static final String USER_HOME = "user.home";
    private static boolean logNameUsePid;
    private static String logOutputType;
    private static String logBaseDir;
    private static String logCharSet;

    private static void initialize() {
        logNameUsePid = false;
        logOutputType = LOG_OUTPUT_TYPE_FILE;
        logBaseDir = ConfigUtil.addSeparator(System.getProperty(USER_HOME)) + DIR_NAME + File.separator;
        logCharSet = LOG_CHARSET_UTF8;
    }

    private static void loadProperties() {
        Properties properties = LogConfigLoader.getProperties();
        String string = logOutputType = properties.get(LOG_OUTPUT_TYPE) == null ? logOutputType : properties.getProperty(LOG_OUTPUT_TYPE);
        if (!LOG_OUTPUT_TYPE_FILE.equalsIgnoreCase(logOutputType) && !LOG_OUTPUT_TYPE_CONSOLE.equalsIgnoreCase(logOutputType)) {
            logOutputType = LOG_OUTPUT_TYPE_FILE;
        }
        System.out.println("INFO: log output type is: " + logOutputType);
        logCharSet = properties.getProperty(LOG_CHARSET) == null ? logCharSet : properties.getProperty(LOG_CHARSET);
        System.out.println("INFO: log charset is: " + logCharSet);
        logBaseDir = properties.getProperty(LOG_DIR) == null ? logBaseDir : properties.getProperty(LOG_DIR);
        ConfigUtil.addSeparator(logBaseDir);
        File dir = new File(logBaseDir);
        if (!dir.exists() && !dir.mkdirs()) {
            System.err.println("ERROR: create log base dir error: " + logBaseDir);
        }
        System.out.println("INFO: log base dir is: " + logBaseDir);
        String usePid = properties.getProperty(LOG_NAME_USE_PID);
        logNameUsePid = "true".equalsIgnoreCase(usePid);
        System.out.println("INFO: log name use pid is: " + logNameUsePid);
    }

    public static boolean isLogNameUsePid() {
        return logNameUsePid;
    }

    public static String getLogBaseDir() {
        return logBaseDir;
    }

    public static String getLogOutputType() {
        return logOutputType;
    }

    public static String getLogCharset() {
        return logCharSet;
    }

    protected static void log(Logger logger, Handler handler, Level level, String detail, Object ... params) {
        if (detail == null) {
            return;
        }
        LoggerUtils.disableOtherHandlers(logger, handler);
        if (params.length == 0) {
            logger.log(level, detail);
        } else {
            logger.log(level, detail, params);
        }
    }

    protected static void log(Logger logger, Handler handler, Level level, String detail, Throwable throwable) {
        if (detail == null) {
            return;
        }
        LoggerUtils.disableOtherHandlers(logger, handler);
        logger.log(level, detail, throwable);
    }

    protected static Handler makeLogger(String logName, Logger heliumRecordLog) {
        CspFormatter formatter = new CspFormatter();
        Handler handler = null;
        switch (logOutputType) {
            case "file": {
                String fileName = LogBase.getLogBaseDir() + logName;
                if (LogBase.isLogNameUsePid()) {
                    fileName = fileName + ".pid" + PidUtil.getPid();
                }
                try {
                    handler = new DateFileLogHandler(fileName + ".%d", 0xC800000, 4, true);
                    handler.setFormatter(formatter);
                    handler.setEncoding(logCharSet);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
            case "console": {
                try {
                    handler = new ConsoleHandler();
                    handler.setFormatter(formatter);
                    handler.setEncoding(logCharSet);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
        if (handler != null) {
            LoggerUtils.disableOtherHandlers(heliumRecordLog, handler);
        }
        heliumRecordLog.setLevel(Level.ALL);
        return handler;
    }

    static {
        try {
            LogBase.initialize();
            LogBase.loadProperties();
        }
        catch (Throwable t) {
            System.err.println("[LogBase] FATAL ERROR when initializing log class");
            t.printStackTrace();
        }
    }
}

