/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.gateway.sc;

import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.adapter.gateway.common.api.matcher.AbstractApiMatcher;
import com.alibaba.csp.sentinel.adapter.gateway.common.param.GatewayParamParser;
import com.alibaba.csp.sentinel.adapter.gateway.common.param.RequestItemParser;
import com.alibaba.csp.sentinel.adapter.gateway.sc.ServerWebExchangeItemParser;
import com.alibaba.csp.sentinel.adapter.gateway.sc.api.GatewayApiMatcherManager;
import com.alibaba.csp.sentinel.adapter.gateway.sc.callback.GatewayCallbackManager;
import com.alibaba.csp.sentinel.adapter.reactor.ContextConfig;
import com.alibaba.csp.sentinel.adapter.reactor.EntryConfig;
import com.alibaba.csp.sentinel.adapter.reactor.SentinelReactorTransformer;
import com.alibaba.csp.sentinel.util.AssertUtil;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.core.Ordered;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class SentinelGatewayFilter
implements GatewayFilter,
GlobalFilter,
Ordered {
    private final int order;
    private final GatewayParamParser<ServerWebExchange> paramParser;

    public SentinelGatewayFilter() {
        this(Integer.MIN_VALUE);
    }

    public SentinelGatewayFilter(int order) {
        this(order, new ServerWebExchangeItemParser());
    }

    public SentinelGatewayFilter(RequestItemParser<ServerWebExchange> serverWebExchangeItemParser) {
        this(Integer.MIN_VALUE, serverWebExchangeItemParser);
    }

    public SentinelGatewayFilter(int order, RequestItemParser<ServerWebExchange> requestItemParser) {
        AssertUtil.notNull(requestItemParser, (String)"requestItemParser cannot be null");
        this.order = order;
        this.paramParser = new GatewayParamParser(requestItemParser);
    }

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        Route route = (Route)exchange.getAttribute(ServerWebExchangeUtils.GATEWAY_ROUTE_ATTR);
        Mono asyncResult = chain.filter(exchange);
        if (route != null) {
            String routeId = route.getId();
            Object[] params = this.paramParser.parseParameterFor(routeId, (Object)exchange, r -> r.getResourceMode() == 0);
            String origin = Optional.ofNullable(GatewayCallbackManager.getRequestOriginParser()).map(f -> (String)f.apply(exchange)).orElse("");
            asyncResult = asyncResult.transform((Function)new SentinelReactorTransformer(new EntryConfig(routeId, 3, EntryType.IN, 1, params, new ContextConfig(this.contextName(routeId), origin))));
        }
        Set<String> matchingApis = this.pickMatchingApiDefinitions(exchange);
        for (String apiName : matchingApis) {
            Object[] params = this.paramParser.parseParameterFor(apiName, (Object)exchange, r -> r.getResourceMode() == 1);
            asyncResult = asyncResult.transform((Function)new SentinelReactorTransformer(new EntryConfig(apiName, 3, EntryType.IN, 1, params)));
        }
        return asyncResult;
    }

    private String contextName(String route) {
        return "sentinel_gateway_context$$route$$" + route;
    }

    Set<String> pickMatchingApiDefinitions(ServerWebExchange exchange) {
        return GatewayApiMatcherManager.getApiMatcherMap().values().stream().filter(m -> m.test(exchange)).map(AbstractApiMatcher::getApiName).collect(Collectors.toSet());
    }

    public int getOrder() {
        return this.order;
    }
}

