/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.sentinel.gateway.sc;

import com.alibaba.csp.ahas.sentinel.AhasSentinelMetadataAutoConfiguration;
import com.alibaba.csp.ahas.sentinel.gateway.sc.SentinelGatewayProperties;
import com.alibaba.csp.sentinel.adapter.gateway.sc.SentinelGatewayFilter;
import com.alibaba.csp.sentinel.adapter.gateway.sc.callback.GatewayCallbackManager;
import com.alibaba.csp.sentinel.adapter.gateway.sc.callback.RedirectBlockRequestHandler;
import com.alibaba.csp.sentinel.adapter.gateway.sc.exception.SentinelGatewayBlockExceptionHandler;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.MediaType;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.reactive.result.view.ViewResolver;

@Configuration
@ConditionalOnProperty(name={"spring.cloud.ahas.sentinel.enabled"}, matchIfMissing=true)
@AutoConfigureAfter(value={AhasSentinelMetadataAutoConfiguration.class})
@EnableConfigurationProperties(value={SentinelGatewayProperties.class})
public class SentinelGatewayAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(SentinelGatewayAutoConfiguration.class);
    private final SentinelGatewayProperties gatewayProperties;
    private final List<ViewResolver> viewResolvers;
    private final ServerCodecConfigurer serverCodecConfigurer;

    public SentinelGatewayAutoConfiguration(ObjectProvider<List<ViewResolver>> viewResolversProvider, ServerCodecConfigurer serverCodecConfigurer, SentinelGatewayProperties gatewayProperties) {
        this.viewResolvers = (List)viewResolversProvider.getIfAvailable(Collections::emptyList);
        this.serverCodecConfigurer = serverCodecConfigurer;
        this.gatewayProperties = gatewayProperties;
        this.doInit();
    }

    @Bean
    @Order(value=-2147483648)
    public SentinelGatewayBlockExceptionHandler sentinelGatewayBlockExceptionHandler() {
        return new SentinelGatewayBlockExceptionHandler(this.viewResolvers, this.serverCodecConfigurer);
    }

    @Bean
    public GlobalFilter sentinelGatewayFilter() {
        return new SentinelGatewayFilter();
    }

    private void doInit() {
        this.initAppType();
        this.initFallback();
    }

    private void initAppType() {
        System.setProperty("csp.sentinel.app.type", String.valueOf(1));
    }

    private void initFallback() {
        if (this.gatewayProperties == null) {
            return;
        }
        SentinelGatewayProperties.FallbackProperties fallbackProperties = this.gatewayProperties.getFallback();
        if (fallbackProperties == null || StringUtil.isBlank((String)fallbackProperties.getMode())) {
            return;
        }
        if ("response".equals(fallbackProperties.getMode()) && StringUtil.isNotBlank((String)fallbackProperties.getResponseBody())) {
            GatewayCallbackManager.setBlockHandler((exchange, t) -> ServerResponse.status((int)fallbackProperties.getResponseStatus()).contentType(MediaType.APPLICATION_JSON_UTF8).body(BodyInserters.fromObject((Object)fallbackProperties.getResponseBody())));
            LOGGER.info("[Sentinel SpringCloudGateway] using AnonymousBlockRequestHandler, responseStatus: " + fallbackProperties.getResponseStatus() + ", responseBody: " + fallbackProperties.getResponseStatus());
        }
        String redirectUrl = fallbackProperties.getRedirect();
        if ("redirect".equals(fallbackProperties.getMode()) && StringUtil.isNotBlank((String)redirectUrl)) {
            GatewayCallbackManager.setBlockHandler(new RedirectBlockRequestHandler(redirectUrl));
            LOGGER.info("[Sentinel SpringCloudGateway] Using RedirectBlockRequestHandler, redirectUrl: {}", (Object)redirectUrl);
        }
    }
}

