/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.sentinel.gateway.sc.arms;

import com.alibaba.csp.ahas.ext.arms.shaded.org.apache.thrift.TBase;
import com.alibaba.csp.ahas.sentinel.AhasGlobalContext;
import com.alibaba.csp.sentinel.arms.ArmsDataSender;
import com.alibaba.csp.sentinel.arms.ArmsKeyGeneratorUtil;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.AppNameUtil;
import com.navercorp.pinpoint.thrift.dto.TAgentInfo;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArmsInitExecutor
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArmsInitExecutor.class);
    private final ArmsDataSender armsDataSender = ArmsDataSender.getInstance();
    private volatile boolean running = true;

    @Override
    public void run() {
        while (this.running) {
            try {
                if (AhasGlobalContext.getClientInfoService() != null && AhasGlobalContext.getClientInfoService().getUserId() != null) {
                    TAgentInfo agentInfo = new TAgentInfo();
                    agentInfo.setAppName(AppNameUtil.getAppName());
                    agentInfo.setAgentEnv("AHAS");
                    agentInfo.setLicenseKey(ArmsKeyGeneratorUtil.genArmsLicenseKey((String)AhasGlobalContext.getClientInfoService().getUserId()));
                    if (!this.armsDataSender.sendInitialData((TBase)agentInfo)) {
                        LOGGER.error("Failed to initialize data for ARMS sender");
                        RecordLog.warn((String)"[ArmsInitExecutor] Failed to initialize data for ARMS sender", (Object[])new Object[0]);
                    }
                    RecordLog.info((String)"[ArmsInitExecutor] ArmsDataSender sendInitialData task submitted", (Object[])new Object[0]);
                    this.running = false;
                }
                TimeUnit.SECONDS.sleep(3L);
            }
            catch (InterruptedException e) {
                this.running = false;
            }
        }
    }

    public void stop() {
        this.running = false;
    }
}

