/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.sentinel.gateway.sc.arms;

import com.alibaba.csp.ahas.ext.arms.shaded.org.apache.thrift.TBase;
import com.alibaba.csp.ahas.sentinel.AhasGlobalContext;
import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.JSON;
import com.alibaba.csp.sentinel.adapter.gateway.common.api.matcher.AbstractApiMatcher;
import com.alibaba.csp.sentinel.adapter.gateway.sc.api.GatewayApiMatcherManager;
import com.alibaba.csp.sentinel.arms.ArmsCallbackContext;
import com.alibaba.csp.sentinel.arms.ArmsDataSender;
import com.alibaba.csp.sentinel.arms.ArmsKeyGeneratorUtil;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.AppNameUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.navercorp.pinpoint.thrift.dto.TAgentInfo;
import com.navercorp.pinpoint.thrift.dto.TMetric;
import com.navercorp.pinpoint.thrift.dto.TMetricBatch;
import com.navercorp.pinpoint.thrift.dto.TMetricValue;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ArmsLogFilter
implements GlobalFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArmsLogFilter.class);
    private final ArmsDataSender armsDataSender = ArmsDataSender.getInstance();

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        if (ArmsCallbackContext.getAgentId() == null) {
            if (AhasGlobalContext.getClientInfoService() == null) {
                LOGGER.warn("clientInfoService has not been initialized.");
                return chain.filter(exchange);
            }
            TAgentInfo agentInfo = new TAgentInfo();
            agentInfo.setAppName(AppNameUtil.getAppName());
            agentInfo.setAgentEnv("AHAS");
            agentInfo.setLicenseKey(ArmsKeyGeneratorUtil.genArmsLicenseKey((String)AhasGlobalContext.getClientInfoService().getUserId()));
            if (!this.armsDataSender.sendInitialData((TBase)agentInfo)) {
                LOGGER.error("Failed to initialize data for ARMS sender");
                RecordLog.warn((String)"[ArmsLogFilter] Failed to initialize data for ARMS sender", (Object[])new Object[0]);
            }
            RecordLog.info((String)"[ArmsLogFilter] ArmsDataSender sendInitialData task submitted", (Object[])new Object[0]);
            return chain.filter(exchange);
        }
        TMetricBatch metricBatch = new TMetricBatch();
        metricBatch.setTimestamp(System.currentTimeMillis());
        metricBatch.setAgentEnv("AHAS");
        metricBatch.setAgentId(ArmsCallbackContext.getAgentId());
        metricBatch.setLicenseKey(ArmsKeyGeneratorUtil.genArmsLicenseKey((String)AhasGlobalContext.getClientInfoService().getUserId()));
        long start = System.currentTimeMillis();
        exchange.getResponse().beforeCommit(() -> {
            long rt = System.currentTimeMillis() - start;
            List<TMetric> metrics = this.buildCurrentAccess(exchange);
            metrics.add(new TMetric("rt", TMetricValue.longValue((long)rt)));
            metricBatch.setMetrics(metrics);
            this.armsDataSender.sendMetricData((TBase)metricBatch);
            return Mono.empty();
        });
        return chain.filter(exchange);
    }

    private String orElseEmpty(String str) {
        return str == null ? "" : str;
    }

    private List<TMetric> buildCurrentAccess(ServerWebExchange exchange) {
        String xForwardedFor;
        ArrayList<TMetric> metrics = new ArrayList<TMetric>();
        Route route = (Route)exchange.getAttribute(ServerWebExchangeUtils.GATEWAY_ROUTE_ATTR);
        Set<String> matchingApis = this.pickMatchingApiDefinitions(exchange);
        if (route != null) {
            matchingApis.add(route.getId());
            metrics.add(new TMetric("route", TMetricValue.stringValue((String)route.getId())));
        }
        metrics.add(new TMetric("matchingApis", TMetricValue.stringValue((String)JSON.toJSONString(matchingApis))));
        ServerHttpRequest request = exchange.getRequest();
        ServerHttpResponse response = exchange.getResponse();
        metrics.add(new TMetric("method", TMetricValue.stringValue((String)request.getMethodValue())));
        metrics.add(new TMetric("uri", TMetricValue.stringValue((String)request.getPath().value())));
        InetSocketAddress remoteAddress = exchange.getRequest().getRemoteAddress();
        String clientIp = xForwardedFor = request.getHeaders().getFirst("X-Forwarded-For");
        if (StringUtil.isEmpty((String)clientIp) && remoteAddress != null) {
            clientIp = remoteAddress.getAddress().getHostAddress();
        }
        metrics.add(new TMetric("clientIp", TMetricValue.stringValue((String)this.orElseEmpty(clientIp))));
        metrics.add(new TMetric("requestLength", TMetricValue.longValue((long)request.getHeaders().getContentLength())));
        metrics.add(new TMetric("httpReferer", TMetricValue.stringValue((String)this.orElseEmpty(request.getHeaders().getFirst("Referer")))));
        metrics.add(new TMetric("host", TMetricValue.stringValue((String)this.orElseEmpty(request.getHeaders().getFirst("Host")))));
        metrics.add(new TMetric("httpUserAgent", TMetricValue.stringValue((String)this.orElseEmpty(request.getHeaders().getFirst("User-Agent")))));
        metrics.add(new TMetric("xForwardFor", TMetricValue.stringValue((String)this.orElseEmpty(xForwardedFor))));
        HttpStatus status = response.getStatusCode();
        if (status != null) {
            Random random = new Random();
            int index = random.nextInt(10);
            metrics.add(new TMetric("statusCode", TMetricValue.intValue((int)status.value())));
        }
        metrics.add(new TMetric("responseLength", TMetricValue.longValue((long)response.getHeaders().getContentLength())));
        return metrics;
    }

    Set<String> pickMatchingApiDefinitions(ServerWebExchange exchange) {
        return GatewayApiMatcherManager.getApiMatcherMap().values().stream().filter(m -> m.test(exchange)).map(AbstractApiMatcher::getApiName).collect(Collectors.toSet());
    }
}

