/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.sentinel.gateway.sc.arms;

import com.alibaba.csp.ahas.ext.arms.shaded.org.apache.thrift.TBase;
import com.alibaba.csp.ahas.sentinel.AhasGlobalContext;
import com.alibaba.csp.ahas.sentinel.gateway.sc.arms.ArmsInitExecutor;
import com.alibaba.csp.sentinel.arms.ArmsCallbackContext;
import com.alibaba.csp.sentinel.arms.ArmsDataSender;
import com.alibaba.csp.sentinel.arms.ArmsKeyGeneratorUtil;
import com.alibaba.csp.sentinel.node.ClusterNode;
import com.alibaba.csp.sentinel.node.metric.MetricNode;
import com.alibaba.csp.sentinel.slotchain.ResourceWrapper;
import com.alibaba.csp.sentinel.slots.clusterbuilder.ClusterBuilderSlot;
import com.alibaba.csp.sentinel.util.TimeUtil;
import com.navercorp.pinpoint.thrift.dto.TMetric;
import com.navercorp.pinpoint.thrift.dto.TMetricValue;
import com.navercorp.pinpoint.thrift.dto.TSpanStatBatch;
import com.navercorp.pinpoint.thrift.dto.TSpanStatInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArmsMetricSenderExecutor
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArmsMetricSenderExecutor.class);
    private ArmsDataSender armsDataSender = ArmsDataSender.getInstance();
    private ArmsInitExecutor initExecutor;
    private volatile long lastFetchTime = -1L;

    public ArmsMetricSenderExecutor(ArmsInitExecutor runnable) {
        this.initExecutor = runnable;
    }

    @Override
    public void run() {
        try {
            TimeUnit.SECONDS.sleep(30L);
        }
        catch (InterruptedException e) {
            LOGGER.warn("arms metric sender thread interrupted.");
        }
        if (ArmsCallbackContext.getAgentId() == null) {
            this.initExecutor.stop();
            return;
        }
        while (true) {
            this.sendSpanStatData();
            try {
                TimeUnit.SECONDS.sleep(30L);
                continue;
            }
            catch (InterruptedException e) {
                LOGGER.warn("thread interrupted.", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private void sendSpanStatData() {
        try {
            TSpanStatBatch statBatch = new TSpanStatBatch();
            statBatch.setAgentEnv("AHAS");
            statBatch.setAgentId(ArmsCallbackContext.getAgentId());
            statBatch.setLicenseKey(ArmsKeyGeneratorUtil.genArmsLicenseKey((String)AhasGlobalContext.getClientInfoService().getUserId()));
            List<TSpanStatInfo> statInfoList = this.buildSpanStatInfos();
            if (statInfoList.size() == 0) {
                return;
            }
            statBatch.setSpanStatBatch(statInfoList);
            this.armsDataSender.sendSpanStatData((TBase)statBatch);
        }
        catch (Exception e) {
            LOGGER.error("send metric data to arms failed.", (Throwable)e);
        }
    }

    private List<TSpanStatInfo> buildSpanStatInfos() {
        ArrayList<TSpanStatInfo> statInfoList = new ArrayList<TSpanStatInfo>();
        long currentTime = TimeUtil.currentTimeMillis();
        currentTime -= currentTime % 1000L;
        long newLastFetchTime = this.lastFetchTime;
        for (Map.Entry entry : ClusterBuilderSlot.getClusterNodeMap().entrySet()) {
            String resource = ((ResourceWrapper)entry.getKey()).getName();
            List metricList = ((ClusterNode)entry.getValue()).rawMetricsInMin(null);
            for (MetricNode node : metricList) {
                if (!this.isNodeInTime(node, currentTime)) continue;
                newLastFetchTime = Math.max(newLastFetchTime, node.getTimestamp());
                if (!this.isResourceAccess(node)) continue;
                TSpanStatInfo statInfo = new TSpanStatInfo();
                statInfo.setPid(ArmsCallbackContext.getAgentId());
                statInfo.setRpc(resource);
                statInfo.setTimestamp(node.getTimestamp());
                statInfo.setMetrics(this.convertSentinelMetric2TMetric(node));
                statInfoList.add(statInfo);
            }
        }
        this.lastFetchTime = newLastFetchTime;
        return statInfoList;
    }

    private boolean isNodeInTime(MetricNode node, long currentTime) {
        return node.getTimestamp() > this.lastFetchTime && node.getTimestamp() < currentTime;
    }

    private boolean isResourceAccess(MetricNode node) {
        return node.getPassQps() != 0L || node.getBlockQps() != 0L || node.getSuccessQps() != 0L || node.getExceptionQps() != 0L || node.getRt() != 0L;
    }

    private List<TMetric> convertSentinelMetric2TMetric(MetricNode node) {
        ArrayList<TMetric> metrics = new ArrayList<TMetric>();
        TMetric pQpsMetric = new TMetric();
        pQpsMetric.setKey("passQps");
        pQpsMetric.setValue(TMetricValue.longValue((long)node.getPassQps()));
        TMetric bQpsMetric = new TMetric();
        bQpsMetric.setKey("blockQps");
        bQpsMetric.setValue(TMetricValue.longValue((long)node.getBlockQps()));
        TMetric sQpsMetric = new TMetric();
        sQpsMetric.setKey("successQps");
        sQpsMetric.setValue(TMetricValue.longValue((long)node.getSuccessQps()));
        TMetric eQpsMetric = new TMetric();
        eQpsMetric.setKey("exceptionQps");
        eQpsMetric.setValue(TMetricValue.longValue((long)node.getExceptionQps()));
        TMetric rtMetric = new TMetric();
        rtMetric.setKey("rt");
        rtMetric.setValue(TMetricValue.longValue((long)node.getRt()));
        metrics.add(pQpsMetric);
        metrics.add(bQpsMetric);
        metrics.add(sQpsMetric);
        metrics.add(eQpsMetric);
        metrics.add(rtMetric);
        return metrics;
    }
}

