/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.rerank;

import com.alibaba.dashscope.common.DashScopeResult;
import com.alibaba.dashscope.rerank.TextReRankOutput;
import com.alibaba.dashscope.rerank.TextReRankUsage;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextReRankResult {
    private static final Logger log = LoggerFactory.getLogger(TextReRankResult.class);
    @SerializedName(value="request_id")
    private String requestId;
    private TextReRankUsage usage;
    private TextReRankOutput output;

    private TextReRankResult() {
    }

    public static TextReRankResult fromDashScopeResult(DashScopeResult dashScopeResult) {
        TextReRankResult result = new TextReRankResult();
        result.setRequestId(dashScopeResult.getRequestId());
        if (dashScopeResult.getUsage() != null) {
            result.setUsage(JsonUtils.fromJsonObject((JsonElement)dashScopeResult.getUsage().getAsJsonObject(), TextReRankUsage.class));
        }
        if (dashScopeResult.getOutput() != null) {
            result.setOutput(JsonUtils.fromJsonObject((JsonElement)((JsonObject)dashScopeResult.getOutput()), TextReRankOutput.class));
        } else {
            log.error("Result no output: {}", (Object)dashScopeResult);
        }
        return result;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public TextReRankUsage getUsage() {
        return this.usage;
    }

    public TextReRankOutput getOutput() {
        return this.output;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setUsage(TextReRankUsage usage) {
        this.usage = usage;
    }

    public void setOutput(TextReRankOutput output) {
        this.output = output;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextReRankResult)) {
            return false;
        }
        TextReRankResult other = (TextReRankResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        TextReRankUsage this$usage = this.getUsage();
        TextReRankUsage other$usage = other.getUsage();
        if (this$usage == null ? other$usage != null : !((Object)this$usage).equals(other$usage)) {
            return false;
        }
        TextReRankOutput this$output = this.getOutput();
        TextReRankOutput other$output = other.getOutput();
        return !(this$output == null ? other$output != null : !((Object)this$output).equals(other$output));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TextReRankResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        TextReRankUsage $usage = this.getUsage();
        result = result * 59 + ($usage == null ? 43 : ((Object)$usage).hashCode());
        TextReRankOutput $output = this.getOutput();
        result = result * 59 + ($output == null ? 43 : ((Object)$output).hashCode());
        return result;
    }

    public String toString() {
        return "TextReRankResult(requestId=" + this.getRequestId() + ", usage=" + this.getUsage() + ", output=" + this.getOutput() + ")";
    }
}

