/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.utils;

import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversationMessage;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversationMessageAdapter;
import com.alibaba.dashscope.common.Message;
import com.alibaba.dashscope.common.MessageAdapter;
import com.alibaba.dashscope.common.MultiModalMessage;
import com.alibaba.dashscope.common.MultiModalMessageAdapter;
import com.alibaba.dashscope.threads.AnnotationBase;
import com.alibaba.dashscope.threads.AnnotationDeserializer;
import com.alibaba.dashscope.threads.ContentBase;
import com.alibaba.dashscope.threads.MessageContentDeserializer;
import com.alibaba.dashscope.threads.runs.StepDetailBase;
import com.alibaba.dashscope.threads.runs.StepDetailDeserializer;
import com.alibaba.dashscope.tools.ToolBase;
import com.alibaba.dashscope.tools.ToolCallBase;
import com.alibaba.dashscope.tools.ToolCallGsonDeserializer;
import com.alibaba.dashscope.tools.ToolGsonDeserializer;
import com.alibaba.dashscope.utils.AnnotationExclusionStrategy;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.MalformedJsonException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public class JsonUtils {
    public static final Gson gson = new GsonBuilder().registerTypeAdapter(Message.class, (Object)new MessageAdapter()).registerTypeAdapter(MultiModalConversationMessage.class, (Object)new MultiModalConversationMessageAdapter()).registerTypeAdapter(MultiModalMessage.class, (Object)new MultiModalMessageAdapter()).registerTypeAdapter(ToolBase.class, (Object)new ToolGsonDeserializer()).registerTypeAdapter(ContentBase.class, (Object)new MessageContentDeserializer()).registerTypeAdapter(AnnotationBase.class, (Object)new AnnotationDeserializer()).registerTypeAdapter(StepDetailBase.class, (Object)new StepDetailDeserializer()).registerTypeAdapter(ToolCallBase.class, (Object)new ToolCallGsonDeserializer()).addSerializationExclusionStrategy((ExclusionStrategy)new AnnotationExclusionStrategy()).setObjectToNumberStrategy((ToNumberStrategy)ToNumberPolicy.LONG_OR_DOUBLE).disableHtmlEscaping().create();

    public static String toJson(Object obj) {
        return gson.toJson(obj);
    }

    public static <T> T fromJson(String obj, Class<T> clazz) {
        return (T)gson.fromJson(obj, clazz);
    }

    public static <T> T fromJson(String str, Type typeOfT) {
        return (T)gson.fromJson(str, typeOfT);
    }

    public static <T> T fromJson(JsonElement json, Type typeOfT) {
        return (T)gson.fromJson(json, typeOfT);
    }

    public static <T> T fromJsonObject(JsonElement jsonElement, Class<T> clazz) {
        return (T)gson.fromJson(jsonElement, clazz);
    }

    public static JsonArray toJsonArray(Object obj) {
        return gson.toJsonTree(obj).getAsJsonArray();
    }

    public static JsonObject toJsonObject(Object obj) {
        return gson.toJsonTree(obj).getAsJsonObject();
    }

    public static JsonElement toJsonElement(Object obj) {
        return gson.toJsonTree(obj);
    }

    public static JsonObject parse(String jsonString) {
        return JsonUtils.parseString(jsonString).getAsJsonObject();
    }

    public static JsonElement parseString(String json) throws JsonSyntaxException {
        return JsonUtils.parseReader(new StringReader(json));
    }

    public static JsonElement parseReader(Reader reader) throws JsonIOException, JsonSyntaxException {
        try {
            JsonReader jsonReader = new JsonReader(reader);
            JsonElement element = JsonUtils.parseReader(jsonReader);
            if (!element.isJsonNull() && jsonReader.peek() != JsonToken.END_DOCUMENT) {
                throw new JsonSyntaxException("Did not consume the entire document.");
            }
            return element;
        }
        catch (MalformedJsonException e) {
            throw new JsonSyntaxException((Throwable)e);
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)e);
        }
        catch (NumberFormatException e) {
            throw new JsonSyntaxException((Throwable)e);
        }
    }

    public static JsonElement parseReader(JsonReader reader) throws JsonIOException, JsonSyntaxException {
        boolean lenient = reader.isLenient();
        reader.setLenient(true);
        try {
            JsonElement jsonElement = Streams.parse((JsonReader)reader);
            return jsonElement;
        }
        catch (StackOverflowError e) {
            throw new JsonParseException("Failed parsing JSON source: " + reader + " to Json", (Throwable)e);
        }
        catch (OutOfMemoryError e) {
            throw new JsonParseException("Failed parsing JSON source: " + reader + " to Json", (Throwable)e);
        }
        finally {
            reader.setLenient(lenient);
        }
    }

    public static JsonObject merge(JsonObject dest, JsonObject src) {
        for (Map.Entry srcEntry : src.entrySet()) {
            String key = (String)srcEntry.getKey();
            JsonElement value = (JsonElement)srcEntry.getValue();
            if (dest.has(key)) continue;
            dest.add(key, value);
        }
        return dest;
    }

    public static JsonObject parametersToJsonObject(Map<String, Object> parameters) {
        if (parameters != null) {
            JsonObject jsonObject = new JsonObject();
            for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                if (entry.getValue() instanceof String) {
                    jsonObject.addProperty(entry.getKey(), (String)entry.getValue());
                    continue;
                }
                if (entry.getValue() instanceof Integer) {
                    jsonObject.addProperty(entry.getKey(), (Number)((Integer)entry.getValue()));
                    continue;
                }
                if (entry.getValue() instanceof Double) {
                    jsonObject.addProperty(entry.getKey(), (Number)((Double)entry.getValue()));
                    continue;
                }
                if (entry.getValue() instanceof Boolean) {
                    jsonObject.addProperty(entry.getKey(), (Boolean)entry.getValue());
                    continue;
                }
                if (entry.getValue() instanceof Character) {
                    jsonObject.addProperty(entry.getKey(), (Character)entry.getValue());
                    continue;
                }
                if (entry.getValue() instanceof List) {
                    jsonObject.add(entry.getKey(), (JsonElement)JsonUtils.toJsonArray(entry.getValue()));
                    continue;
                }
                if (entry.getValue() instanceof Map) {
                    jsonObject.add(entry.getKey(), (JsonElement)JsonUtils.toJsonObject(entry.getValue()));
                    continue;
                }
                jsonObject.add(entry.getKey(), JsonUtils.toJsonElement(entry.getValue()));
            }
            return jsonObject;
        }
        return null;
    }
}

