/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.spas.sdk.client.identity;

import com.taobao.spas.sdk.client.identity.CredentialService;
import com.taobao.spas.sdk.client.identity.Credentials;
import com.taobao.spas.sdk.common.config.SpasConfigLoader;
import com.taobao.spas.sdk.common.log.SpasLogCode;
import com.taobao.spas.sdk.common.log.SpasLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;

public class CredentialWatcher {
    private static final long REFRESH_INTERVAL = 10000L;
    private CredentialService serviceInstance;
    private String appName;
    private String propertyPath;
    private TimerTask watcher;

    public CredentialWatcher(String appName, CredentialService serviceInstance) {
        this.appName = appName;
        this.serviceInstance = serviceInstance;
        this.loadCredential(true);
        this.watcher = new TimerTask(){
            private Timer timer = new Timer(true);
            private long modified = 0L;
            {
                this.timer.schedule((TimerTask)this, 10000L, 10000L);
            }

            public void run() {
                boolean reload = false;
                if (CredentialWatcher.this.propertyPath == null) {
                    reload = true;
                } else {
                    File file = new File(CredentialWatcher.this.propertyPath);
                    long lastModified = file.lastModified();
                    if (this.modified != lastModified) {
                        reload = true;
                        this.modified = lastModified;
                    }
                }
                if (reload) {
                    CredentialWatcher.this.loadCredential(false);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCredential(boolean init) {
        Credentials credential;
        FileInputStream propertiesIS;
        boolean logWarn;
        boolean bl = logWarn = init || !this.serviceInstance.getCredential().valid();
        if (this.propertyPath == null) {
            URL url = ClassLoader.getSystemResource("spas.properties");
            if (url != null) {
                this.propertyPath = url.getPath();
            }
            if (this.propertyPath == null || this.propertyPath.isEmpty()) {
                if (logWarn) {
                    SpasLogger.info(this.appName, "Unable to load credential file from classpath: spas.properties");
                }
                this.propertyPath = SpasConfigLoader.getProperty("spas.identity");
                if (this.propertyPath == null) {
                    if (logWarn) {
                        SpasLogger.info(this.appName, "Undefined credential file: -Dspas.identity");
                    }
                    if (this.appName == null) {
                        if (logWarn) {
                            SpasLogger.warn(SpasLogCode.SPAS0063, this.appName, "Missing property project.name");
                        }
                        return;
                    }
                    this.propertyPath = "/home/admin/.spas_key/" + this.appName;
                }
            }
        }
        try {
            propertiesIS = new FileInputStream(this.propertyPath);
        }
        catch (FileNotFoundException e) {
            if (logWarn) {
                SpasLogger.info(this.appName, "No credential file from path: " + this.propertyPath);
            }
            return;
        }
        Properties properties = new Properties();
        try {
            properties.load(propertiesIS);
        }
        catch (IOException e) {
            SpasLogger.error(SpasLogCode.SPAS0026, this.appName, "Unable to load credential file", e);
            return;
        }
        finally {
            try {
                ((InputStream)propertiesIS).close();
            }
            catch (IOException e) {
                SpasLogger.error(SpasLogCode.SPAS0027, this.appName, "Unable to close credential file", e);
            }
        }
        String accessKey = null;
        String secretKey = null;
        if (properties.containsKey("accessKey") && (accessKey = properties.getProperty("accessKey")) != null) {
            accessKey = accessKey.trim();
        }
        if (properties.containsKey("secretKey") && (secretKey = properties.getProperty("secretKey")) != null) {
            secretKey = secretKey.trim();
        }
        if (!(credential = new Credentials(accessKey, secretKey)).valid()) {
            SpasLogger.warn(SpasLogCode.SPAS0001, this.appName, "Credential file missing accessKey or secretKey");
        }
        this.serviceInstance.setCredential(credential);
    }
}

