/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.spas.sdk.common.log;

import com.taobao.spas.sdk.common.log.SpasLogCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpasLogger {
    private static Logger logger = LoggerFactory.getLogger(SpasLogger.class);

    public static void info(String s) {
        logger.info(s);
    }

    public static void info(String appName, String s) {
        logger.info(SpasLogger.formatAppName(appName), (Object)s);
    }

    public static void warn(String s) {
        logger.warn(s);
    }

    public static void warn(String appName, String s) {
        logger.warn(SpasLogger.formatAppName(appName), (Object)s);
    }

    public static void error(String s) {
        logger.error("", (Object)s);
    }

    public static void error(String appName, String s) {
        logger.error(SpasLogger.formatAppName(appName), (Object)"", (Object)s);
    }

    public static void error(String s, Throwable throwable) {
        logger.error("", (Object)s, (Object)throwable);
    }

    public static void error(String appName, String s, Throwable throwable) {
        logger.error(SpasLogger.formatAppName(appName), new Object[]{"", s, throwable});
    }

    public static void info(SpasLogCode code, String s) {
        logger.info(SpasLogger.formatLogMessage(code, s));
    }

    public static void info(SpasLogCode code, String appName, String s) {
        logger.info(SpasLogger.formatAppName(appName), (Object)SpasLogger.formatLogMessage(code, s));
    }

    public static void warn(SpasLogCode code, String s) {
        logger.warn(SpasLogger.formatLogMessage(code, s));
    }

    public static void warn(SpasLogCode code, String appName, String s) {
        logger.warn(SpasLogger.formatAppName(appName), (Object)SpasLogger.formatLogMessage(code, s));
    }

    public static void error(SpasLogCode code, String s) {
        logger.error("", (Object)SpasLogger.formatLogMessage(code, s));
    }

    public static void error(SpasLogCode code, String appName, String s) {
        logger.error(SpasLogger.formatAppName(appName), (Object)"", (Object)SpasLogger.formatLogMessage(code, s));
    }

    public static void error(SpasLogCode code, String s, Throwable throwable) {
        logger.error("", (Object)SpasLogger.formatLogMessage(code, s), (Object)throwable);
    }

    public static void error(SpasLogCode code, String appName, String s, Throwable throwable) {
        logger.error(SpasLogger.formatAppName(appName), new Object[]{"", SpasLogger.formatLogMessage(code, s), throwable});
    }

    private static String formatAppName(String appName) {
        return appName == null ? "" : appName;
    }

    private static String formatLogMessage(SpasLogCode code, String s) {
        return String.format("[SPAS-%04d] %s", code.getValue(), s);
    }
}

