/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.spas.sdk.common.sec;

import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.codec.binary.Base64;

public class RSAUtils {
    public static final int ENCRYPT_MODE = 1;
    public static final int DECRYPT_MODE = 2;
    private static final String ALGORITHM = "RSA";
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private Cipher cipher = null;
    private int opmode = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean init(int mode, String key) {
        block16: {
            if (this.opmode != 0) {
                return true;
            }
            if (mode != 1 && mode != 2) {
                return false;
            }
            if (key == null || key.isEmpty()) {
                return false;
            }
            try {
                this.cipher = Cipher.getInstance(ALGORITHM);
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            catch (NoSuchPaddingException e) {
                e.printStackTrace();
            }
            finally {
                if (this.cipher != null) break block16;
                return false;
            }
        }
        Key secKey = null;
        if (mode == 1) {
            secKey = RSAUtils.getEncKey(key);
        } else if (mode == 2) {
            secKey = RSAUtils.getDecKey(key);
        }
        if (secKey == null) {
            return false;
        }
        try {
            this.cipher.init(mode, secKey);
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
            return false;
        }
        this.opmode = mode;
        return true;
    }

    private static Key getEncKey(String encKey) {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(Base64.decodeBase64((byte[])encKey.getBytes(UTF8)));
        PublicKey publicKey = null;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
            publicKey = keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
        }
        return publicKey;
    }

    private static Key getDecKey(String decKey) {
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(Base64.decodeBase64((byte[])decKey.getBytes(UTF8)));
        PrivateKey privateKey = null;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
            privateKey = keyFactory.generatePrivate(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
        }
        return privateKey;
    }

    public synchronized String encrypt(String data) {
        if (this.opmode != 1) {
            return null;
        }
        if (data == null) {
            return null;
        }
        byte[] encData = null;
        try {
            encData = this.cipher.doFinal(data.getBytes(UTF8));
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        if (encData == null) {
            return null;
        }
        return new String(Base64.encodeBase64((byte[])encData), UTF8);
    }

    public synchronized String decrypt(String data) {
        if (this.opmode != 2) {
            return null;
        }
        if (data == null) {
            return null;
        }
        byte[] decData = null;
        try {
            decData = this.cipher.doFinal(Base64.decodeBase64((byte[])data.getBytes(UTF8)));
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        if (decData == null) {
            return null;
        }
        return new String(decData, UTF8);
    }
}

