/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.mysql.parser;

import com.alibaba.druid.sql.ast.SQLCommentHint;
import com.alibaba.druid.sql.ast.SQLDataTypeImpl;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLNCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAlterColumn;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDisableConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDisableKeys;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropColumnItem;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropForeignKey;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropIndex;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropPrimaryKey;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableEnableConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableEnableKeys;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCreateDatabaseStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLPrimaryKey;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSetStatement;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlPrimaryKey;
import com.alibaba.druid.sql.dialect.mysql.ast.MysqlForeignKey;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.MySqlCaseStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.MySqlCreateProcedureStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.MySqlCursorDeclareStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.MySqlDeclareStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.MySqlElseStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.MySqlIfStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.MySqlIterateStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.MySqlLeaveStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.MySqlLoopStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.MySqlParameter;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.MySqlRepeatStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.MySqlSelectIntoStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.MySqlWhileStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.CobarShowStatus;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableAddColumn;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableChangeColumn;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableCharacter;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableDiscardTablespace;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableImportTablespace;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableModifyColumn;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableOption;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterUserStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAnalyzeStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlBinlogStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlBlockStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlCommitStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlCreateIndexStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlCreateTableStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlCreateUserStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlDeleteStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlDescribeStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlExecuteStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlHelpStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlHintStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlInsertStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlKillStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlLoadDataInFileStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlLoadXmlStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlLockTableStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlOptimizeStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlPrepareStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlRenameTableStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlReplaceStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlResetStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlRollbackStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSetCharSetStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSetNamesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSetPasswordStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSetTransactionStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowAuthorsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowBinLogEventsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowBinaryLogsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCharacterSetStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCollationStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowColumnsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowContributorsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCreateDatabaseStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCreateEventStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCreateFunctionStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCreateProcedureStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCreateTableStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCreateTriggerStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCreateViewStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowDatabasesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowEngineStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowEnginesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowErrorsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowEventsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowFunctionCodeStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowFunctionStatusStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowGrantsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowIndexesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowKeysStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowMasterLogsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowMasterStatusStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowOpenTablesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowPluginsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowPrivilegesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowProcedureCodeStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowProcedureStatusStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowProcessListStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowProfileStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowProfilesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowRelayLogEventsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowSlaveHostsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowSlaveStatusStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowStatusStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowTableStatusStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowTablesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowTriggersStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowVariantsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowWarningsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlStartTransactionStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlUnlockTablesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlUpdateStatement;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlCreateTableParser;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlExprParser;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlSelectIntoParser;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlSelectParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLSelectParser;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.parser.Token;
import java.util.ArrayList;
import java.util.List;

public class MySqlStatementParser
extends SQLStatementParser {
    private static final String AUTO_INCREMENT = "AUTO_INCREMENT";
    private static final String COLLATE2 = "COLLATE";
    private static final String CHAIN = "CHAIN";
    private static final String ENGINES = "ENGINES";
    private static final String ENGINE = "ENGINE";
    private static final String BINLOG = "BINLOG";
    private static final String EVENTS = "EVENTS";
    private static final String CHARACTER = "CHARACTER";
    private static final String SESSION = "SESSION";
    private static final String GLOBAL = "GLOBAL";
    private static final String VARIABLES = "VARIABLES";
    private static final String ERRORS = "ERRORS";
    private static final String STATUS = "STATUS";
    private static final String IGNORE = "IGNORE";
    private static final String RESET = "RESET";
    private static final String DESCRIBE = "DESCRIBE";
    private static final String WRITE = "WRITE";
    private static final String READ = "READ";
    private static final String LOCAL = "LOCAL";
    private static final String TABLES = "TABLES";
    private static final String TEMPORARY = "TEMPORARY";
    private static final String SPATIAL = "SPATIAL";
    private static final String FULLTEXT = "FULLTEXT";
    private static final String DELAYED = "DELAYED";
    private static final String LOW_PRIORITY = "LOW_PRIORITY";

    public MySqlStatementParser(String sql) {
        super(new MySqlExprParser(sql));
    }

    public MySqlStatementParser(Lexer lexer) {
        super(new MySqlExprParser(lexer));
    }

    @Override
    public SQLCreateTableStatement parseCreateTable() {
        MySqlCreateTableParser parser = new MySqlCreateTableParser(this.exprParser);
        return parser.parseCrateTable();
    }

    @Override
    public SQLSelectStatement parseSelect() {
        MySqlSelectParser selectParser = new MySqlSelectParser(this.exprParser);
        return new SQLSelectStatement(selectParser.select(), "mysql");
    }

    @Override
    public SQLUpdateStatement parseUpdateStatement() {
        MySqlUpdateStatement stmt = this.createUpdateStatement();
        if (this.lexer.token() == Token.UPDATE) {
            this.lexer.nextToken();
            if (this.identifierEquals(LOW_PRIORITY)) {
                this.lexer.nextToken();
                stmt.setLowPriority(true);
            }
            if (this.identifierEquals(IGNORE)) {
                this.lexer.nextToken();
                stmt.setIgnore(true);
            }
            SQLTableSource tableSource = this.exprParser.createSelectParser().parseTableSource();
            stmt.setTableSource(tableSource);
        }
        this.parseUpdateSet(stmt);
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            stmt.setWhere(this.exprParser.expr());
        }
        stmt.setOrderBy(this.exprParser.parseOrderBy());
        stmt.setLimit(this.parseLimit());
        return stmt;
    }

    @Override
    protected MySqlUpdateStatement createUpdateStatement() {
        return new MySqlUpdateStatement();
    }

    @Override
    public MySqlDeleteStatement parseDeleteStatement() {
        MySqlDeleteStatement deleteStatement = new MySqlDeleteStatement();
        if (this.lexer.token() == Token.DELETE) {
            SQLTableSource tableSource;
            this.lexer.nextToken();
            if (this.lexer.token() == Token.COMMENT) {
                this.lexer.nextToken();
            }
            if (this.identifierEquals(LOW_PRIORITY)) {
                deleteStatement.setLowPriority(true);
                this.lexer.nextToken();
            }
            if (this.identifierEquals("QUICK")) {
                deleteStatement.setQuick(true);
                this.lexer.nextToken();
            }
            if (this.identifierEquals(IGNORE)) {
                deleteStatement.setIgnore(true);
                this.lexer.nextToken();
            }
            if (this.lexer.token() == Token.IDENTIFIER) {
                deleteStatement.setTableSource(this.createSQLSelectParser().parseTableSource());
                if (this.lexer.token() == Token.FROM) {
                    this.lexer.nextToken();
                    tableSource = this.createSQLSelectParser().parseTableSource();
                    deleteStatement.setFrom(tableSource);
                }
            } else if (this.lexer.token() == Token.FROM) {
                this.lexer.nextToken();
                deleteStatement.setTableSource(this.createSQLSelectParser().parseTableSource());
            } else {
                throw new ParserException("syntax error");
            }
            if (this.identifierEquals("USING")) {
                this.lexer.nextToken();
                tableSource = this.createSQLSelectParser().parseTableSource();
                deleteStatement.setUsing(tableSource);
            }
        }
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            SQLExpr where = this.exprParser.expr();
            deleteStatement.setWhere(where);
        }
        if (this.lexer.token() == Token.ORDER) {
            SQLOrderBy orderBy = this.exprParser.parseOrderBy();
            deleteStatement.setOrderBy(orderBy);
        }
        deleteStatement.setLimit(this.parseLimit());
        return deleteStatement;
    }

    @Override
    public SQLStatement parseCreate() {
        char markChar = this.lexer.current();
        int markBp = this.lexer.bp();
        this.accept(Token.CREATE);
        boolean replace = false;
        if (this.lexer.token() == Token.OR) {
            this.lexer.nextToken();
            this.accept(Token.REPLACE);
            replace = true;
        }
        List<SQLCommentHint> hints = this.exprParser.parseHints();
        if (this.lexer.token() == Token.TABLE || this.identifierEquals(TEMPORARY)) {
            if (replace) {
                this.lexer.reset(markBp, markChar, Token.CREATE);
            }
            MySqlCreateTableParser parser = new MySqlCreateTableParser(this.exprParser);
            MySqlCreateTableStatement stmt = parser.parseCrateTable(false);
            stmt.setHints(hints);
            return stmt;
        }
        if (this.lexer.token() == Token.DATABASE) {
            if (replace) {
                this.lexer.reset(markBp, markChar, Token.CREATE);
            }
            return this.parseCreateDatabase();
        }
        if (this.lexer.token() == Token.UNIQUE || this.lexer.token() == Token.INDEX || this.identifierEquals(FULLTEXT) || this.identifierEquals(SPATIAL)) {
            if (replace) {
                this.lexer.reset(markBp, markChar, Token.CREATE);
            }
            return this.parseCreateIndex(false);
        }
        if (this.lexer.token() == Token.USER) {
            if (replace) {
                this.lexer.reset(markBp, markChar, Token.CREATE);
            }
            return this.parseCreateUser();
        }
        if (this.lexer.token() == Token.VIEW) {
            if (replace) {
                this.lexer.reset(markBp, markChar, Token.CREATE);
            }
            return this.parseCreateView();
        }
        if (this.lexer.token() == Token.TRIGGER) {
            if (replace) {
                this.lexer.reset(markBp, markChar, Token.CREATE);
            }
            return this.parseCreateTrigger();
        }
        if (this.lexer.token() == Token.PROCEDURE) {
            if (replace) {
                this.lexer.reset(markBp, markChar, Token.CREATE);
            }
            return this.parseCreateProcedure();
        }
        throw new ParserException("TODO " + (Object)((Object)this.lexer.token()));
    }

    @Override
    public SQLStatement parseCreateIndex(boolean acceptCreate) {
        if (acceptCreate) {
            this.accept(Token.CREATE);
        }
        MySqlCreateIndexStatement stmt = new MySqlCreateIndexStatement();
        if (this.lexer.token() == Token.UNIQUE) {
            stmt.setType("UNIQUE");
            this.lexer.nextToken();
        } else if (this.identifierEquals(FULLTEXT)) {
            stmt.setType(FULLTEXT);
            this.lexer.nextToken();
        } else if (this.identifierEquals(SPATIAL)) {
            stmt.setType(SPATIAL);
            this.lexer.nextToken();
        }
        this.accept(Token.INDEX);
        stmt.setName(this.exprParser.name());
        this.parseCreateIndexUsing(stmt);
        this.accept(Token.ON);
        stmt.setTable(this.exprParser.name());
        this.accept(Token.LPAREN);
        while (true) {
            SQLSelectOrderByItem item = this.exprParser.parseSelectOrderByItem();
            item.setParent(stmt);
            stmt.getItems().add(item);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
        this.parseCreateIndexUsing(stmt);
        return stmt;
    }

    private void parseCreateIndexUsing(MySqlCreateIndexStatement stmt) {
        if (this.identifierEquals("USING")) {
            this.lexer.nextToken();
            if (this.identifierEquals("BTREE")) {
                stmt.setUsing("BTREE");
                this.lexer.nextToken();
            } else if (this.identifierEquals("HASH")) {
                stmt.setUsing("HASH");
                this.lexer.nextToken();
            } else {
                throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
            }
        }
    }

    public SQLStatement parseCreateUser() {
        if (this.lexer.token() == Token.CREATE) {
            this.lexer.nextToken();
        }
        this.accept(Token.USER);
        MySqlCreateUserStatement stmt = new MySqlCreateUserStatement();
        while (true) {
            MySqlCreateUserStatement.UserSpecification userSpec = new MySqlCreateUserStatement.UserSpecification();
            SQLExpr expr = this.exprParser.primary();
            userSpec.setUser(expr);
            if (this.lexer.token() == Token.IDENTIFIED) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.BY) {
                    this.lexer.nextToken();
                    if (this.identifierEquals("PASSWORD")) {
                        this.lexer.nextToken();
                        userSpec.setPasswordHash(true);
                    }
                    SQLCharExpr password = (SQLCharExpr)this.exprParser.expr();
                    userSpec.setPassword(password);
                } else if (this.lexer.token() == Token.WITH) {
                    this.lexer.nextToken();
                    userSpec.setAuthPlugin(this.exprParser.expr());
                }
            }
            stmt.getUsers().add(userSpec);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        return stmt;
    }

    public SQLStatement parseKill() {
        this.accept(Token.KILL);
        MySqlKillStatement stmt = new MySqlKillStatement();
        if (this.identifierEquals("CONNECTION")) {
            stmt.setType(MySqlKillStatement.Type.CONNECTION);
            this.lexer.nextToken();
        } else if (this.identifierEquals("QUERY")) {
            stmt.setType(MySqlKillStatement.Type.QUERY);
            this.lexer.nextToken();
        } else {
            throw new ParserException("not support kill type " + (Object)((Object)this.lexer.token()));
        }
        SQLExpr threadId = this.exprParser.expr();
        stmt.setThreadId(threadId);
        return stmt;
    }

    public SQLStatement parseBinlog() {
        this.acceptIdentifier("binlog");
        MySqlBinlogStatement stmt = new MySqlBinlogStatement();
        SQLExpr expr = this.exprParser.expr();
        stmt.setExpr(expr);
        return stmt;
    }

    public MySqlAnalyzeStatement parseAnalyze() {
        this.accept(Token.ANALYZE);
        this.accept(Token.TABLE);
        MySqlAnalyzeStatement stmt = new MySqlAnalyzeStatement();
        ArrayList<SQLName> names = new ArrayList<SQLName>();
        this.exprParser.names(names, stmt);
        for (SQLName name : names) {
            stmt.getTableSources().add(new SQLExprTableSource(name));
        }
        return stmt;
    }

    public MySqlOptimizeStatement parseOptimize() {
        this.accept(Token.OPTIMIZE);
        this.accept(Token.TABLE);
        MySqlOptimizeStatement stmt = new MySqlOptimizeStatement();
        ArrayList<SQLName> names = new ArrayList<SQLName>();
        this.exprParser.names(names, stmt);
        for (SQLName name : names) {
            stmt.getTableSources().add(new SQLExprTableSource(name));
        }
        return stmt;
    }

    public SQLStatement parseReset() {
        this.acceptIdentifier(RESET);
        MySqlResetStatement stmt = new MySqlResetStatement();
        while (this.lexer.token() == Token.IDENTIFIER) {
            if (this.identifierEquals("QUERY")) {
                this.lexer.nextToken();
                this.accept(Token.CACHE);
                stmt.getOptions().add("QUERY CACHE");
            } else {
                stmt.getOptions().add(this.lexer.stringVal());
                this.lexer.nextToken();
            }
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        return stmt;
    }

    @Override
    public boolean parseStatementListDialect(List<SQLStatement> statementList) {
        if (this.lexer.token() == Token.KILL) {
            SQLStatement stmt = this.parseKill();
            statementList.add(stmt);
            return true;
        }
        if (this.identifierEquals("PREPARE")) {
            MySqlPrepareStatement stmt = this.parsePrepare();
            statementList.add(stmt);
            return true;
        }
        if (this.identifierEquals("EXECUTE")) {
            MySqlExecuteStatement stmt = this.parseExecute();
            statementList.add(stmt);
            return true;
        }
        if (this.identifierEquals("LOAD")) {
            SQLStatement stmt = this.parseLoad();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.token() == Token.REPLACE) {
            MySqlReplaceStatement stmt = this.parseReplicate();
            statementList.add(stmt);
            return true;
        }
        if (this.identifierEquals("START")) {
            MySqlStartTransactionStatement stmt = this.parseStart();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.token() == Token.SHOW) {
            SQLStatement stmt = this.parseShow();
            statementList.add(stmt);
            return true;
        }
        if (this.identifierEquals(BINLOG)) {
            SQLStatement stmt = this.parseBinlog();
            statementList.add(stmt);
            return true;
        }
        if (this.identifierEquals(RESET)) {
            SQLStatement stmt = this.parseReset();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.token() == Token.ANALYZE) {
            MySqlAnalyzeStatement stmt = this.parseAnalyze();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.token() == Token.OPTIMIZE) {
            MySqlOptimizeStatement stmt = this.parseOptimize();
            statementList.add(stmt);
            return true;
        }
        if (this.identifierEquals("HELP")) {
            this.lexer.nextToken();
            MySqlHelpStatement stmt = new MySqlHelpStatement();
            stmt.setContent(this.exprParser.primary());
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.token() == Token.DESC || this.identifierEquals(DESCRIBE)) {
            MySqlDescribeStatement stmt = this.parseDescribe();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.token() == Token.LOCK) {
            this.lexer.nextToken();
            this.acceptIdentifier(TABLES);
            MySqlLockTableStatement stmt = new MySqlLockTableStatement();
            stmt.setTableSource(this.exprParser.name());
            if (this.identifierEquals(READ)) {
                this.lexer.nextToken();
                if (this.identifierEquals(LOCAL)) {
                    this.lexer.nextToken();
                    stmt.setLockType(MySqlLockTableStatement.LockType.READ_LOCAL);
                } else {
                    stmt.setLockType(MySqlLockTableStatement.LockType.READ);
                }
            } else if (this.identifierEquals(WRITE)) {
                stmt.setLockType(MySqlLockTableStatement.LockType.WRITE);
            } else if (this.identifierEquals(LOW_PRIORITY)) {
                this.lexer.nextToken();
                this.acceptIdentifier(WRITE);
                stmt.setLockType(MySqlLockTableStatement.LockType.LOW_PRIORITY_WRITE);
            }
            if (this.lexer.token() == Token.HINT) {
                stmt.setHints(this.exprParser.parseHints());
            }
            statementList.add(stmt);
            return true;
        }
        if (this.identifierEquals("UNLOCK")) {
            this.lexer.nextToken();
            this.acceptIdentifier(TABLES);
            statementList.add(new MySqlUnlockTablesStatement());
            return true;
        }
        if (this.lexer.token() == Token.HINT) {
            statementList.add(this.parseHint());
            return true;
        }
        if (this.lexer.token() == Token.BEGIN) {
            statementList.add(this.parseBlock());
            return true;
        }
        return false;
    }

    @Override
    public MySqlBlockStatement parseBlock() {
        MySqlBlockStatement block = new MySqlBlockStatement();
        this.accept(Token.BEGIN);
        this.parseProcedureStatementList(block.getStatementList());
        this.accept(Token.END);
        return block;
    }

    public MySqlDescribeStatement parseDescribe() {
        if (this.lexer.token() != Token.DESC && !this.identifierEquals(DESCRIBE)) {
            throw new ParserException("expect DESC, actual " + (Object)((Object)this.lexer.token()));
        }
        this.lexer.nextToken();
        MySqlDescribeStatement stmt = new MySqlDescribeStatement();
        stmt.setObject(this.exprParser.name());
        if (this.lexer.token() == Token.IDENTIFIER) {
            stmt.setColName(this.exprParser.name());
        }
        return stmt;
    }

    @Override
    public SQLStatement parseShow() {
        this.accept(Token.SHOW);
        if (this.lexer.token() == Token.COMMENT) {
            this.lexer.nextToken();
        }
        boolean full = false;
        if (this.lexer.token() == Token.FULL) {
            this.lexer.nextToken();
            full = true;
        }
        if (this.identifierEquals("PROCESSLIST")) {
            this.lexer.nextToken();
            MySqlShowProcessListStatement stmt = new MySqlShowProcessListStatement();
            stmt.setFull(full);
            return stmt;
        }
        if (this.identifierEquals("COLUMNS") || this.identifierEquals("FIELDS")) {
            this.lexer.nextToken();
            MySqlShowColumnsStatement stmt = this.parseShowColumns();
            stmt.setFull(full);
            return stmt;
        }
        if (this.identifierEquals("COLUMNS")) {
            this.lexer.nextToken();
            MySqlShowColumnsStatement stmt = this.parseShowColumns();
            return stmt;
        }
        if (this.identifierEquals(TABLES)) {
            this.lexer.nextToken();
            MySqlShowTablesStatement stmt = this.parseShowTabless();
            stmt.setFull(full);
            return stmt;
        }
        if (this.identifierEquals("DATABASES")) {
            this.lexer.nextToken();
            MySqlShowDatabasesStatement stmt = this.parseShowDatabases();
            return stmt;
        }
        if (this.identifierEquals("WARNINGS")) {
            this.lexer.nextToken();
            MySqlShowWarningsStatement stmt = this.parseShowWarnings();
            return stmt;
        }
        if (this.identifierEquals("COUNT")) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            this.accept(Token.STAR);
            this.accept(Token.RPAREN);
            if (this.identifierEquals(ERRORS)) {
                this.lexer.nextToken();
                MySqlShowErrorsStatement stmt = new MySqlShowErrorsStatement();
                stmt.setCount(true);
                return stmt;
            }
            this.acceptIdentifier("WARNINGS");
            MySqlShowWarningsStatement stmt = new MySqlShowWarningsStatement();
            stmt.setCount(true);
            return stmt;
        }
        if (this.identifierEquals(ERRORS)) {
            this.lexer.nextToken();
            MySqlShowErrorsStatement stmt = new MySqlShowErrorsStatement();
            stmt.setLimit(this.parseLimit());
            return stmt;
        }
        if (this.identifierEquals(STATUS)) {
            this.lexer.nextToken();
            MySqlShowStatusStatement stmt = this.parseShowStatus();
            return stmt;
        }
        if (this.identifierEquals(VARIABLES)) {
            this.lexer.nextToken();
            MySqlShowVariantsStatement stmt = this.parseShowVariants();
            return stmt;
        }
        if (this.identifierEquals(GLOBAL)) {
            this.lexer.nextToken();
            if (this.identifierEquals(STATUS)) {
                this.lexer.nextToken();
                MySqlShowStatusStatement stmt = this.parseShowStatus();
                stmt.setGlobal(true);
                return stmt;
            }
            if (this.identifierEquals(VARIABLES)) {
                this.lexer.nextToken();
                MySqlShowVariantsStatement stmt = this.parseShowVariants();
                stmt.setGlobal(true);
                return stmt;
            }
        }
        if (this.identifierEquals(SESSION)) {
            this.lexer.nextToken();
            if (this.identifierEquals(STATUS)) {
                this.lexer.nextToken();
                MySqlShowStatusStatement stmt = this.parseShowStatus();
                stmt.setSession(true);
                return stmt;
            }
            if (this.identifierEquals(VARIABLES)) {
                this.lexer.nextToken();
                MySqlShowVariantsStatement stmt = this.parseShowVariants();
                stmt.setSession(true);
                return stmt;
            }
        }
        if (this.identifierEquals("COBAR_STATUS")) {
            this.lexer.nextToken();
            return new CobarShowStatus();
        }
        if (this.identifierEquals("AUTHORS")) {
            this.lexer.nextToken();
            return new MySqlShowAuthorsStatement();
        }
        if (this.lexer.token() == Token.BINARY) {
            this.lexer.nextToken();
            this.acceptIdentifier("LOGS");
            return new MySqlShowBinaryLogsStatement();
        }
        if (this.identifierEquals("MASTER")) {
            this.lexer.nextToken();
            if (this.identifierEquals("LOGS")) {
                this.lexer.nextToken();
                return new MySqlShowMasterLogsStatement();
            }
            this.acceptIdentifier(STATUS);
            return new MySqlShowMasterStatusStatement();
        }
        if (this.identifierEquals(CHARACTER)) {
            this.lexer.nextToken();
            this.accept(Token.SET);
            MySqlShowCharacterSetStatement stmt = new MySqlShowCharacterSetStatement();
            if (this.lexer.token() == Token.LIKE) {
                this.lexer.nextToken();
                stmt.setPattern(this.exprParser.expr());
            }
            if (this.lexer.token() == Token.WHERE) {
                this.lexer.nextToken();
                stmt.setWhere(this.exprParser.expr());
            }
            return stmt;
        }
        if (this.identifierEquals("COLLATION")) {
            this.lexer.nextToken();
            MySqlShowCollationStatement stmt = new MySqlShowCollationStatement();
            if (this.lexer.token() == Token.LIKE) {
                this.lexer.nextToken();
                stmt.setPattern(this.exprParser.expr());
            }
            if (this.lexer.token() == Token.WHERE) {
                this.lexer.nextToken();
                stmt.setWhere(this.exprParser.expr());
            }
            return stmt;
        }
        if (this.identifierEquals(BINLOG)) {
            this.lexer.nextToken();
            this.acceptIdentifier(EVENTS);
            MySqlShowBinLogEventsStatement stmt = new MySqlShowBinLogEventsStatement();
            if (this.lexer.token() == Token.IN) {
                this.lexer.nextToken();
                stmt.setIn(this.exprParser.expr());
            }
            if (this.lexer.token() == Token.FROM) {
                this.lexer.nextToken();
                stmt.setFrom(this.exprParser.expr());
            }
            stmt.setLimit(this.parseLimit());
            return stmt;
        }
        if (this.identifierEquals("CONTRIBUTORS")) {
            this.lexer.nextToken();
            return new MySqlShowContributorsStatement();
        }
        if (this.lexer.token() == Token.CREATE) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.DATABASE) {
                this.lexer.nextToken();
                MySqlShowCreateDatabaseStatement stmt = new MySqlShowCreateDatabaseStatement();
                stmt.setDatabase(this.exprParser.name());
                return stmt;
            }
            if (this.identifierEquals("EVENT")) {
                this.lexer.nextToken();
                MySqlShowCreateEventStatement stmt = new MySqlShowCreateEventStatement();
                stmt.setEventName(this.exprParser.name());
                return stmt;
            }
            if (this.lexer.token() == Token.FUNCTION) {
                this.lexer.nextToken();
                MySqlShowCreateFunctionStatement stmt = new MySqlShowCreateFunctionStatement();
                stmt.setName(this.exprParser.name());
                return stmt;
            }
            if (this.lexer.token() == Token.PROCEDURE) {
                this.lexer.nextToken();
                MySqlShowCreateProcedureStatement stmt = new MySqlShowCreateProcedureStatement();
                stmt.setName(this.exprParser.name());
                return stmt;
            }
            if (this.lexer.token() == Token.TABLE) {
                this.lexer.nextToken();
                MySqlShowCreateTableStatement stmt = new MySqlShowCreateTableStatement();
                stmt.setName(this.exprParser.name());
                return stmt;
            }
            if (this.lexer.token() == Token.VIEW) {
                this.lexer.nextToken();
                MySqlShowCreateViewStatement stmt = new MySqlShowCreateViewStatement();
                stmt.setName(this.exprParser.name());
                return stmt;
            }
            if (this.lexer.token() == Token.TRIGGER) {
                this.lexer.nextToken();
                MySqlShowCreateTriggerStatement stmt = new MySqlShowCreateTriggerStatement();
                stmt.setName(this.exprParser.name());
                return stmt;
            }
            throw new ParserException("TODO " + this.lexer.stringVal());
        }
        if (this.identifierEquals(ENGINE)) {
            this.lexer.nextToken();
            MySqlShowEngineStatement stmt = new MySqlShowEngineStatement();
            stmt.setName(this.exprParser.name());
            stmt.setOption(MySqlShowEngineStatement.Option.valueOf(this.lexer.stringVal().toUpperCase()));
            this.lexer.nextToken();
            return stmt;
        }
        if (this.identifierEquals("STORAGE")) {
            this.lexer.nextToken();
            this.acceptIdentifier(ENGINES);
            MySqlShowEnginesStatement stmt = new MySqlShowEnginesStatement();
            stmt.setStorage(true);
            return stmt;
        }
        if (this.identifierEquals(ENGINES)) {
            this.lexer.nextToken();
            MySqlShowEnginesStatement stmt = new MySqlShowEnginesStatement();
            return stmt;
        }
        if (this.identifierEquals(EVENTS)) {
            this.lexer.nextToken();
            MySqlShowEventsStatement stmt = new MySqlShowEventsStatement();
            if (this.lexer.token() == Token.FROM || this.lexer.token() == Token.IN) {
                this.lexer.nextToken();
                stmt.setSchema(this.exprParser.name());
            }
            if (this.lexer.token() == Token.LIKE) {
                this.lexer.nextToken();
                stmt.setLike(this.exprParser.expr());
            }
            if (this.lexer.token() == Token.WHERE) {
                this.lexer.nextToken();
                stmt.setWhere(this.exprParser.expr());
            }
            return stmt;
        }
        if (this.lexer.token() == Token.FUNCTION) {
            this.lexer.nextToken();
            if (this.identifierEquals("CODE")) {
                this.lexer.nextToken();
                MySqlShowFunctionCodeStatement stmt = new MySqlShowFunctionCodeStatement();
                stmt.setName(this.exprParser.name());
                return stmt;
            }
            this.acceptIdentifier(STATUS);
            MySqlShowFunctionStatusStatement stmt = new MySqlShowFunctionStatusStatement();
            if (this.lexer.token() == Token.LIKE) {
                this.lexer.nextToken();
                stmt.setLike(this.exprParser.expr());
            }
            if (this.lexer.token() == Token.WHERE) {
                this.lexer.nextToken();
                stmt.setWhere(this.exprParser.expr());
            }
            return stmt;
        }
        if (this.identifierEquals(ENGINE)) {
            this.lexer.nextToken();
            MySqlShowEngineStatement stmt = new MySqlShowEngineStatement();
            stmt.setName(this.exprParser.name());
            stmt.setOption(MySqlShowEngineStatement.Option.valueOf(this.lexer.stringVal().toUpperCase()));
            this.lexer.nextToken();
            return stmt;
        }
        if (this.identifierEquals("STORAGE")) {
            this.lexer.nextToken();
            this.acceptIdentifier(ENGINES);
            MySqlShowEnginesStatement stmt = new MySqlShowEnginesStatement();
            stmt.setStorage(true);
            return stmt;
        }
        if (this.identifierEquals(ENGINES)) {
            this.lexer.nextToken();
            MySqlShowEnginesStatement stmt = new MySqlShowEnginesStatement();
            return stmt;
        }
        if (this.identifierEquals("GRANTS")) {
            this.lexer.nextToken();
            MySqlShowGrantsStatement stmt = new MySqlShowGrantsStatement();
            if (this.lexer.token() == Token.FOR) {
                this.lexer.nextToken();
                stmt.setUser(this.exprParser.expr());
            }
            return stmt;
        }
        if (this.lexer.token() == Token.INDEX || this.identifierEquals("INDEXES")) {
            this.lexer.nextToken();
            MySqlShowIndexesStatement stmt = new MySqlShowIndexesStatement();
            if (this.lexer.token() == Token.FROM || this.lexer.token() == Token.IN) {
                this.lexer.nextToken();
                SQLName table = this.exprParser.name();
                stmt.setTable(table);
                if (this.lexer.token() == Token.FROM || this.lexer.token() == Token.IN) {
                    this.lexer.nextToken();
                    SQLName database = this.exprParser.name();
                    stmt.setDatabase(database);
                }
            }
            if (this.lexer.token() == Token.HINT) {
                stmt.setHints(this.exprParser.parseHints());
            }
            return stmt;
        }
        if (this.identifierEquals("KEYS")) {
            this.lexer.nextToken();
            MySqlShowKeysStatement stmt = new MySqlShowKeysStatement();
            if (this.lexer.token() == Token.FROM || this.lexer.token() == Token.IN) {
                this.lexer.nextToken();
                SQLName table = this.exprParser.name();
                stmt.setTable(table);
                if (this.lexer.token() == Token.FROM || this.lexer.token() == Token.IN) {
                    this.lexer.nextToken();
                    SQLName database = this.exprParser.name();
                    stmt.setDatabase(database);
                }
            }
            return stmt;
        }
        if (this.lexer.token() == Token.OPEN || this.identifierEquals("OPEN")) {
            this.lexer.nextToken();
            this.acceptIdentifier(TABLES);
            MySqlShowOpenTablesStatement stmt = new MySqlShowOpenTablesStatement();
            if (this.lexer.token() == Token.FROM || this.lexer.token() == Token.IN) {
                this.lexer.nextToken();
                stmt.setDatabase(this.exprParser.name());
            }
            if (this.lexer.token() == Token.LIKE) {
                this.lexer.nextToken();
                stmt.setLike(this.exprParser.expr());
            }
            if (this.lexer.token() == Token.WHERE) {
                this.lexer.nextToken();
                stmt.setWhere(this.exprParser.expr());
            }
            return stmt;
        }
        if (this.identifierEquals("PLUGINS")) {
            this.lexer.nextToken();
            MySqlShowPluginsStatement stmt = new MySqlShowPluginsStatement();
            return stmt;
        }
        if (this.identifierEquals("PRIVILEGES")) {
            this.lexer.nextToken();
            MySqlShowPrivilegesStatement stmt = new MySqlShowPrivilegesStatement();
            return stmt;
        }
        if (this.lexer.token() == Token.PROCEDURE) {
            this.lexer.nextToken();
            if (this.identifierEquals("CODE")) {
                this.lexer.nextToken();
                MySqlShowProcedureCodeStatement stmt = new MySqlShowProcedureCodeStatement();
                stmt.setName(this.exprParser.name());
                return stmt;
            }
            this.acceptIdentifier(STATUS);
            MySqlShowProcedureStatusStatement stmt = new MySqlShowProcedureStatusStatement();
            if (this.lexer.token() == Token.LIKE) {
                this.lexer.nextToken();
                stmt.setLike(this.exprParser.expr());
            }
            if (this.lexer.token() == Token.WHERE) {
                this.lexer.nextToken();
                stmt.setWhere(this.exprParser.expr());
            }
            return stmt;
        }
        if (this.identifierEquals("PROCESSLIST")) {
            this.lexer.nextToken();
            MySqlShowProcessListStatement stmt = new MySqlShowProcessListStatement();
            return stmt;
        }
        if (this.identifierEquals("PROFILES")) {
            this.lexer.nextToken();
            MySqlShowProfilesStatement stmt = new MySqlShowProfilesStatement();
            return stmt;
        }
        if (this.identifierEquals("PROFILE")) {
            this.lexer.nextToken();
            MySqlShowProfileStatement stmt = new MySqlShowProfileStatement();
            while (true) {
                if (this.lexer.token() == Token.ALL) {
                    stmt.getTypes().add(MySqlShowProfileStatement.Type.ALL);
                    this.lexer.nextToken();
                } else if (this.identifierEquals("BLOCK")) {
                    this.lexer.nextToken();
                    this.acceptIdentifier("IO");
                    stmt.getTypes().add(MySqlShowProfileStatement.Type.BLOCK_IO);
                } else if (this.identifierEquals("CONTEXT")) {
                    this.lexer.nextToken();
                    this.acceptIdentifier("SWITCHES");
                    stmt.getTypes().add(MySqlShowProfileStatement.Type.CONTEXT_SWITCHES);
                } else if (this.identifierEquals("CPU")) {
                    this.lexer.nextToken();
                    stmt.getTypes().add(MySqlShowProfileStatement.Type.CPU);
                } else if (this.identifierEquals("IPC")) {
                    this.lexer.nextToken();
                    stmt.getTypes().add(MySqlShowProfileStatement.Type.IPC);
                } else if (this.identifierEquals("MEMORY")) {
                    this.lexer.nextToken();
                    stmt.getTypes().add(MySqlShowProfileStatement.Type.MEMORY);
                } else if (this.identifierEquals("PAGE")) {
                    this.lexer.nextToken();
                    this.acceptIdentifier("FAULTS");
                    stmt.getTypes().add(MySqlShowProfileStatement.Type.PAGE_FAULTS);
                } else if (this.identifierEquals("SOURCE")) {
                    this.lexer.nextToken();
                    stmt.getTypes().add(MySqlShowProfileStatement.Type.SOURCE);
                } else {
                    if (!this.identifierEquals("SWAPS")) break;
                    this.lexer.nextToken();
                    stmt.getTypes().add(MySqlShowProfileStatement.Type.SWAPS);
                }
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            if (this.lexer.token() == Token.FOR) {
                this.lexer.nextToken();
                this.acceptIdentifier("QUERY");
                stmt.setForQuery(this.exprParser.primary());
            }
            stmt.setLimit(this.parseLimit());
            return stmt;
        }
        if (this.identifierEquals("RELAYLOG")) {
            this.lexer.nextToken();
            this.acceptIdentifier(EVENTS);
            MySqlShowRelayLogEventsStatement stmt = new MySqlShowRelayLogEventsStatement();
            if (this.lexer.token() == Token.IN) {
                this.lexer.nextToken();
                stmt.setLogName(this.exprParser.primary());
            }
            if (this.lexer.token() == Token.FROM) {
                this.lexer.nextToken();
                stmt.setFrom(this.exprParser.primary());
            }
            stmt.setLimit(this.parseLimit());
            return stmt;
        }
        if (this.identifierEquals("RELAYLOG")) {
            this.lexer.nextToken();
            this.acceptIdentifier(EVENTS);
            MySqlShowRelayLogEventsStatement stmt = new MySqlShowRelayLogEventsStatement();
            if (this.lexer.token() == Token.IN) {
                this.lexer.nextToken();
                stmt.setLogName(this.exprParser.primary());
            }
            if (this.lexer.token() == Token.FROM) {
                this.lexer.nextToken();
                stmt.setFrom(this.exprParser.primary());
            }
            stmt.setLimit(this.parseLimit());
            return stmt;
        }
        if (this.identifierEquals("SLAVE")) {
            this.lexer.nextToken();
            if (this.identifierEquals(STATUS)) {
                this.lexer.nextToken();
                return new MySqlShowSlaveStatusStatement();
            }
            this.acceptIdentifier("HOSTS");
            MySqlShowSlaveHostsStatement stmt = new MySqlShowSlaveHostsStatement();
            return stmt;
        }
        if (this.lexer.token() == Token.TABLE) {
            this.lexer.nextToken();
            this.acceptIdentifier(STATUS);
            MySqlShowTableStatusStatement stmt = new MySqlShowTableStatusStatement();
            if (this.lexer.token() == Token.FROM || this.lexer.token() == Token.IN) {
                this.lexer.nextToken();
                stmt.setDatabase(this.exprParser.name());
            }
            if (this.lexer.token() == Token.LIKE) {
                this.lexer.nextToken();
                stmt.setLike(this.exprParser.expr());
            }
            if (this.lexer.token() == Token.WHERE) {
                this.lexer.nextToken();
                stmt.setWhere(this.exprParser.expr());
            }
            return stmt;
        }
        if (this.identifierEquals("TRIGGERS")) {
            this.lexer.nextToken();
            MySqlShowTriggersStatement stmt = new MySqlShowTriggersStatement();
            if (this.lexer.token() == Token.FROM) {
                this.lexer.nextToken();
                SQLName database = this.exprParser.name();
                stmt.setDatabase(database);
            }
            if (this.lexer.token() == Token.LIKE) {
                this.lexer.nextToken();
                SQLExpr like = this.exprParser.expr();
                stmt.setLike(like);
            }
            if (this.lexer.token() == Token.WHERE) {
                this.lexer.nextToken();
                SQLExpr where = this.exprParser.expr();
                stmt.setWhere(where);
            }
            return stmt;
        }
        throw new ParserException("TODO " + this.lexer.stringVal());
    }

    private MySqlShowStatusStatement parseShowStatus() {
        MySqlShowStatusStatement stmt = new MySqlShowStatusStatement();
        if (this.lexer.token() == Token.LIKE) {
            this.lexer.nextToken();
            SQLExpr like = this.exprParser.expr();
            stmt.setLike(like);
        }
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            SQLExpr where = this.exprParser.expr();
            stmt.setWhere(where);
        }
        return stmt;
    }

    private MySqlShowVariantsStatement parseShowVariants() {
        MySqlShowVariantsStatement stmt = new MySqlShowVariantsStatement();
        if (this.lexer.token() == Token.LIKE) {
            this.lexer.nextToken();
            SQLExpr like = this.exprParser.expr();
            stmt.setLike(like);
        }
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            SQLExpr where = this.exprParser.expr();
            stmt.setWhere(where);
        }
        return stmt;
    }

    private MySqlShowWarningsStatement parseShowWarnings() {
        MySqlShowWarningsStatement stmt = new MySqlShowWarningsStatement();
        stmt.setLimit(this.parseLimit());
        return stmt;
    }

    private MySqlShowDatabasesStatement parseShowDatabases() {
        MySqlShowDatabasesStatement stmt = new MySqlShowDatabasesStatement();
        if (this.lexer.token() == Token.LIKE) {
            this.lexer.nextToken();
            SQLExpr like = this.exprParser.expr();
            stmt.setLike(like);
        }
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            SQLExpr where = this.exprParser.expr();
            stmt.setWhere(where);
        }
        return stmt;
    }

    private MySqlShowTablesStatement parseShowTabless() {
        MySqlShowTablesStatement stmt = new MySqlShowTablesStatement();
        if (this.lexer.token() == Token.FROM) {
            this.lexer.nextToken();
            SQLName database = this.exprParser.name();
            stmt.setDatabase(database);
        }
        if (this.lexer.token() == Token.LIKE) {
            this.lexer.nextToken();
            SQLExpr like = this.exprParser.expr();
            stmt.setLike(like);
        }
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            SQLExpr where = this.exprParser.expr();
            stmt.setWhere(where);
        }
        return stmt;
    }

    private MySqlShowColumnsStatement parseShowColumns() {
        MySqlShowColumnsStatement stmt = new MySqlShowColumnsStatement();
        if (this.lexer.token() == Token.FROM) {
            this.lexer.nextToken();
            SQLName table = this.exprParser.name();
            stmt.setTable(table);
            if (this.lexer.token() == Token.FROM || this.lexer.token() == Token.IN) {
                this.lexer.nextToken();
                SQLName database = this.exprParser.name();
                stmt.setDatabase(database);
            }
        }
        if (this.lexer.token() == Token.LIKE) {
            this.lexer.nextToken();
            SQLExpr like = this.exprParser.expr();
            stmt.setLike(like);
        }
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            SQLExpr where = this.exprParser.expr();
            stmt.setWhere(where);
        }
        return stmt;
    }

    public MySqlStartTransactionStatement parseStart() {
        this.acceptIdentifier("START");
        this.acceptIdentifier("TRANSACTION");
        MySqlStartTransactionStatement stmt = new MySqlStartTransactionStatement();
        if (this.lexer.token() == Token.WITH) {
            this.lexer.nextToken();
            this.acceptIdentifier("CONSISTENT");
            this.acceptIdentifier("SNAPSHOT");
            stmt.setConsistentSnapshot(true);
        }
        if (this.lexer.token() == Token.BEGIN) {
            this.lexer.nextToken();
            stmt.setBegin(true);
            if (this.identifierEquals("WORK")) {
                this.lexer.nextToken();
                stmt.setWork(true);
            }
        }
        if (this.lexer.token() == Token.HINT) {
            stmt.setHints(this.exprParser.parseHints());
        }
        return stmt;
    }

    @Override
    public MySqlRollbackStatement parseRollback() {
        this.acceptIdentifier("ROLLBACK");
        MySqlRollbackStatement stmt = new MySqlRollbackStatement();
        if (this.identifierEquals("WORK")) {
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.AND) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.NOT) {
                this.lexer.nextToken();
                this.acceptIdentifier(CHAIN);
                stmt.setChain(Boolean.FALSE);
            } else {
                this.acceptIdentifier(CHAIN);
                stmt.setChain(Boolean.TRUE);
            }
        }
        if (this.lexer.token() == Token.TO) {
            this.lexer.nextToken();
            if (this.identifierEquals("SAVEPOINT")) {
                this.lexer.nextToken();
            }
            stmt.setTo(this.exprParser.name());
        }
        return stmt;
    }

    @Override
    public MySqlCommitStatement parseCommit() {
        this.acceptIdentifier("COMMIT");
        MySqlCommitStatement stmt = new MySqlCommitStatement();
        if (this.identifierEquals("WORK")) {
            this.lexer.nextToken();
            stmt.setWork(true);
        }
        if (this.lexer.token() == Token.AND) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.NOT) {
                this.lexer.nextToken();
                this.acceptIdentifier(CHAIN);
                stmt.setChain(Boolean.FALSE);
            } else {
                this.acceptIdentifier(CHAIN);
                stmt.setChain(Boolean.TRUE);
            }
        }
        return stmt;
    }

    public MySqlReplaceStatement parseReplicate() {
        SQLQueryExpr queryExpr;
        MySqlReplaceStatement stmt = new MySqlReplaceStatement();
        this.accept(Token.REPLACE);
        if (this.lexer.token() == Token.COMMENT) {
            this.lexer.nextToken();
        }
        if (this.identifierEquals(LOW_PRIORITY)) {
            stmt.setLowPriority(true);
            this.lexer.nextToken();
        }
        if (this.identifierEquals(DELAYED)) {
            stmt.setDelayed(true);
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.INTO) {
            this.lexer.nextToken();
        }
        SQLName tableName = this.exprParser.name();
        stmt.setTableName(tableName);
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.SELECT) {
                queryExpr = (SQLQueryExpr)this.exprParser.expr();
                stmt.setQuery(queryExpr);
            } else {
                this.exprParser.exprList(stmt.getColumns(), stmt);
            }
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.VALUES || this.identifierEquals("VALUE")) {
            this.lexer.nextToken();
            this.parseValueClause(stmt.getValuesList(), 0);
        } else if (this.lexer.token() == Token.SELECT) {
            queryExpr = (SQLQueryExpr)this.exprParser.expr();
            stmt.setQuery(queryExpr);
        } else if (this.lexer.token() == Token.SET) {
            this.lexer.nextToken();
            SQLInsertStatement.ValuesClause values = new SQLInsertStatement.ValuesClause();
            stmt.getValuesList().add(values);
            while (true) {
                stmt.getColumns().add(this.exprParser.name());
                if (this.lexer.token() == Token.COLONEQ) {
                    this.lexer.nextToken();
                } else {
                    this.accept(Token.EQ);
                }
                values.getValues().add(this.exprParser.expr());
                if (this.lexer.token() == Token.COMMA) {
                    this.lexer.nextToken();
                    continue;
                }
                break;
            }
        } else if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            queryExpr = (SQLQueryExpr)this.exprParser.expr();
            stmt.setQuery(queryExpr);
            this.accept(Token.RPAREN);
        }
        return stmt;
    }

    protected SQLStatement parseLoad() {
        this.acceptIdentifier("LOAD");
        if (this.identifierEquals("DATA")) {
            MySqlLoadDataInFileStatement stmt = this.parseLoadDataInFile();
            return stmt;
        }
        if (this.identifierEquals("XML")) {
            MySqlLoadXmlStatement stmt = this.parseLoadXml();
            return stmt;
        }
        throw new ParserException("TODO");
    }

    protected MySqlLoadXmlStatement parseLoadXml() {
        this.acceptIdentifier("XML");
        MySqlLoadXmlStatement stmt = new MySqlLoadXmlStatement();
        if (this.identifierEquals(LOW_PRIORITY)) {
            stmt.setLowPriority(true);
            this.lexer.nextToken();
        }
        if (this.identifierEquals("CONCURRENT")) {
            stmt.setConcurrent(true);
            this.lexer.nextToken();
        }
        if (this.identifierEquals(LOCAL)) {
            stmt.setLocal(true);
            this.lexer.nextToken();
        }
        this.acceptIdentifier("INFILE");
        SQLLiteralExpr fileName = (SQLLiteralExpr)this.exprParser.expr();
        stmt.setFileName(fileName);
        if (this.lexer.token() == Token.REPLACE) {
            stmt.setReplicate(true);
            this.lexer.nextToken();
        }
        if (this.identifierEquals(IGNORE)) {
            stmt.setIgnore(true);
            this.lexer.nextToken();
        }
        this.accept(Token.INTO);
        this.accept(Token.TABLE);
        SQLName tableName = this.exprParser.name();
        stmt.setTableName(tableName);
        if (this.identifierEquals(CHARACTER)) {
            this.lexer.nextToken();
            this.accept(Token.SET);
            if (this.lexer.token() != Token.LITERAL_CHARS) {
                throw new ParserException("syntax error, illegal charset");
            }
            String charset = this.lexer.stringVal();
            this.lexer.nextToken();
            stmt.setCharset(charset);
        }
        if (this.identifierEquals("ROWS")) {
            this.lexer.nextToken();
            this.accept(Token.IDENTIFIED);
            this.accept(Token.BY);
            SQLExpr rowsIdentifiedBy = this.exprParser.expr();
            stmt.setRowsIdentifiedBy(rowsIdentifiedBy);
        }
        if (this.identifierEquals(IGNORE)) {
            throw new ParserException("TODO");
        }
        if (this.lexer.token() == Token.SET) {
            throw new ParserException("TODO");
        }
        return stmt;
    }

    protected MySqlLoadDataInFileStatement parseLoadDataInFile() {
        this.acceptIdentifier("DATA");
        MySqlLoadDataInFileStatement stmt = new MySqlLoadDataInFileStatement();
        if (this.identifierEquals(LOW_PRIORITY)) {
            stmt.setLowPriority(true);
            this.lexer.nextToken();
        }
        if (this.identifierEquals("CONCURRENT")) {
            stmt.setConcurrent(true);
            this.lexer.nextToken();
        }
        if (this.identifierEquals(LOCAL)) {
            stmt.setLocal(true);
            this.lexer.nextToken();
        }
        this.acceptIdentifier("INFILE");
        SQLLiteralExpr fileName = (SQLLiteralExpr)this.exprParser.expr();
        stmt.setFileName(fileName);
        if (this.lexer.token() == Token.REPLACE) {
            stmt.setReplicate(true);
            this.lexer.nextToken();
        }
        if (this.identifierEquals(IGNORE)) {
            stmt.setIgnore(true);
            this.lexer.nextToken();
        }
        this.accept(Token.INTO);
        this.accept(Token.TABLE);
        SQLName tableName = this.exprParser.name();
        stmt.setTableName(tableName);
        if (this.identifierEquals(CHARACTER)) {
            this.lexer.nextToken();
            this.accept(Token.SET);
            if (this.lexer.token() != Token.LITERAL_CHARS) {
                throw new ParserException("syntax error, illegal charset");
            }
            String charset = this.lexer.stringVal();
            this.lexer.nextToken();
            stmt.setCharset(charset);
        }
        if (this.identifierEquals("FIELDS") || this.identifierEquals("COLUMNS")) {
            this.lexer.nextToken();
            if (this.identifierEquals("TERMINATED")) {
                this.lexer.nextToken();
                this.accept(Token.BY);
                stmt.setColumnsTerminatedBy(new SQLCharExpr(this.lexer.stringVal()));
                this.lexer.nextToken();
            }
            if (this.identifierEquals("OPTIONALLY")) {
                stmt.setColumnsEnclosedOptionally(true);
                this.lexer.nextToken();
            }
            if (this.identifierEquals("ENCLOSED")) {
                this.lexer.nextToken();
                this.accept(Token.BY);
                stmt.setColumnsEnclosedBy(new SQLCharExpr(this.lexer.stringVal()));
                this.lexer.nextToken();
            }
            if (this.identifierEquals("ESCAPED")) {
                this.lexer.nextToken();
                this.accept(Token.BY);
                stmt.setColumnsEscaped(new SQLCharExpr(this.lexer.stringVal()));
                this.lexer.nextToken();
            }
        }
        if (this.identifierEquals("LINES")) {
            this.lexer.nextToken();
            if (this.identifierEquals("STARTING")) {
                this.lexer.nextToken();
                this.accept(Token.BY);
                stmt.setLinesStartingBy(new SQLCharExpr(this.lexer.stringVal()));
                this.lexer.nextToken();
            }
            if (this.identifierEquals("TERMINATED")) {
                this.lexer.nextToken();
                this.accept(Token.BY);
                stmt.setLinesTerminatedBy(new SQLCharExpr(this.lexer.stringVal()));
                this.lexer.nextToken();
            }
        }
        if (this.identifierEquals(IGNORE)) {
            this.lexer.nextToken();
            stmt.setIgnoreLinesNumber(this.exprParser.expr());
            this.acceptIdentifier("LINES");
        }
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            this.exprParser.exprList(stmt.getColumns(), stmt);
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.SET) {
            this.lexer.nextToken();
            this.exprParser.exprList(stmt.getSetList(), stmt);
        }
        return stmt;
    }

    public MySqlPrepareStatement parsePrepare() {
        this.acceptIdentifier("PREPARE");
        SQLName name = this.exprParser.name();
        this.accept(Token.FROM);
        SQLExpr from = this.exprParser.expr();
        return new MySqlPrepareStatement(name, from);
    }

    public MySqlExecuteStatement parseExecute() {
        this.acceptIdentifier("EXECUTE");
        MySqlExecuteStatement stmt = new MySqlExecuteStatement();
        SQLName statementName = this.exprParser.name();
        stmt.setStatementName(statementName);
        if (this.identifierEquals("USING")) {
            this.lexer.nextToken();
            this.exprParser.exprList(stmt.getParameters(), stmt);
        }
        return stmt;
    }

    @Override
    public SQLInsertStatement parseInsert() {
        SQLSelect select;
        MySqlInsertStatement insertStatement = new MySqlInsertStatement();
        if (this.lexer.token() == Token.INSERT) {
            this.lexer.nextToken();
            if (this.identifierEquals(LOW_PRIORITY)) {
                insertStatement.setLowPriority(true);
                this.lexer.nextToken();
            }
            if (this.identifierEquals(DELAYED)) {
                insertStatement.setDelayed(true);
                this.lexer.nextToken();
            }
            if (this.identifierEquals("HIGH_PRIORITY")) {
                insertStatement.setHighPriority(true);
                this.lexer.nextToken();
            }
            if (this.identifierEquals(IGNORE)) {
                insertStatement.setIgnore(true);
                this.lexer.nextToken();
            }
            if (this.lexer.token() == Token.INTO) {
                this.lexer.nextToken();
            }
            SQLName tableName = this.exprParser.name();
            insertStatement.setTableName(tableName);
            if (this.lexer.token() == Token.IDENTIFIER && !this.identifierEquals("VALUE")) {
                insertStatement.setAlias(this.lexer.stringVal());
                this.lexer.nextToken();
            }
        }
        int columnSize = 0;
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.SELECT) {
                select = this.exprParser.createSelectParser().select();
                select.setParent(insertStatement);
                insertStatement.setQuery(select);
            } else {
                this.exprParser.exprList(insertStatement.getColumns(), insertStatement);
                columnSize = insertStatement.getColumns().size();
            }
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.VALUES || this.identifierEquals("VALUE")) {
            this.lexer.nextTokenLParen();
            this.parseValueClause(insertStatement.getValuesList(), columnSize);
        } else if (this.lexer.token() == Token.SET) {
            this.lexer.nextToken();
            SQLInsertStatement.ValuesClause values = new SQLInsertStatement.ValuesClause();
            insertStatement.getValuesList().add(values);
            while (true) {
                SQLName name = this.exprParser.name();
                insertStatement.getColumns().add(name);
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                } else {
                    this.accept(Token.COLONEQ);
                }
                values.getValues().add(this.exprParser.expr());
                if (this.lexer.token() == Token.COMMA) {
                    this.lexer.nextToken();
                    continue;
                }
                break;
            }
        } else if (this.lexer.token() == Token.SELECT) {
            select = this.exprParser.createSelectParser().select();
            select.setParent(insertStatement);
            insertStatement.setQuery(select);
        } else if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            select = this.exprParser.createSelectParser().select();
            select.setParent(insertStatement);
            insertStatement.setQuery(select);
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.ON) {
            this.lexer.nextToken();
            this.acceptIdentifier("DUPLICATE");
            this.accept(Token.KEY);
            this.accept(Token.UPDATE);
            this.exprParser.exprList(insertStatement.getDuplicateKeyUpdate(), insertStatement);
        }
        return insertStatement;
    }

    private void parseValueClause(List<SQLInsertStatement.ValuesClause> valueClauseList, int columnSize) {
        while (true) {
            if (this.lexer.token() != Token.LPAREN) {
                throw new ParserException("syntax error, expect ')'");
            }
            this.lexer.nextTokenValue();
            if (this.lexer.token() != Token.RPAREN) {
                ArrayList<SQLExpr> valueExprList = columnSize > 0 ? new ArrayList(columnSize) : new ArrayList<SQLExpr>();
                while (true) {
                    SQLExpr expr;
                    if (this.lexer.token() == Token.LITERAL_INT) {
                        expr = new SQLIntegerExpr(this.lexer.integerValue());
                        this.lexer.nextTokenComma();
                    } else if (this.lexer.token() == Token.LITERAL_CHARS) {
                        expr = new SQLCharExpr(this.lexer.stringVal());
                        this.lexer.nextTokenComma();
                    } else if (this.lexer.token() == Token.LITERAL_NCHARS) {
                        expr = new SQLNCharExpr(this.lexer.stringVal());
                        this.lexer.nextTokenComma();
                    } else {
                        expr = this.exprParser.expr();
                    }
                    if (this.lexer.token() == Token.COMMA) {
                        valueExprList.add(expr);
                        this.lexer.nextTokenValue();
                        continue;
                    }
                    if (this.lexer.token() == Token.RPAREN) {
                        valueExprList.add(expr);
                        break;
                    }
                    expr = this.exprParser.primaryRest(expr);
                    if (this.lexer.token() != Token.COMMA && this.lexer.token() != Token.RPAREN) {
                        expr = this.exprParser.exprRest(expr);
                    }
                    valueExprList.add(expr);
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                SQLInsertStatement.ValuesClause values = new SQLInsertStatement.ValuesClause(valueExprList);
                valueClauseList.add(values);
            } else {
                SQLInsertStatement.ValuesClause values = new SQLInsertStatement.ValuesClause(new ArrayList<SQLExpr>(0));
                valueClauseList.add(values);
            }
            if (this.lexer.token() != Token.RPAREN) {
                throw new ParserException("syntax error");
            }
            if (!this.parseCompleteValues && valueClauseList.size() >= this.parseValuesSize) {
                this.lexer.skipToEOF();
                break;
            }
            this.lexer.nextTokenComma();
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextTokenLParen();
        }
    }

    @Override
    public SQLSelectParser createSQLSelectParser() {
        return new MySqlSelectParser(this.exprParser);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public SQLStatement parseSet() {
        this.accept(Token.SET);
        if (this.identifierEquals("PASSWORD")) {
            this.lexer.nextToken();
            MySqlSetPasswordStatement stmt = new MySqlSetPasswordStatement();
            if (this.lexer.token() == Token.FOR) {
                this.lexer.nextToken();
                stmt.setUser(this.exprParser.name());
            }
            this.accept(Token.EQ);
            stmt.setPassword(this.exprParser.expr());
            return stmt;
        }
        Boolean global = null;
        if (this.identifierEquals(GLOBAL)) {
            global = Boolean.TRUE;
            this.lexer.nextToken();
        } else if (this.identifierEquals(SESSION)) {
            global = Boolean.FALSE;
            this.lexer.nextToken();
        }
        if (this.identifierEquals("TRANSACTION")) {
            MySqlSetTransactionStatement stmt = new MySqlSetTransactionStatement();
            stmt.setGlobal(global);
            this.lexer.nextToken();
            if (this.identifierEquals("ISOLATION")) {
                this.lexer.nextToken();
                this.acceptIdentifier("LEVEL");
                if (this.identifierEquals(READ)) {
                    this.lexer.nextToken();
                    if (this.identifierEquals("UNCOMMITTED")) {
                        stmt.setIsolationLevel("READ UNCOMMITTED");
                        this.lexer.nextToken();
                        return stmt;
                    } else if (this.identifierEquals(WRITE)) {
                        stmt.setIsolationLevel("READ WRITE");
                        this.lexer.nextToken();
                        return stmt;
                    } else if (this.identifierEquals("ONLY")) {
                        stmt.setIsolationLevel("READ ONLY");
                        this.lexer.nextToken();
                        return stmt;
                    } else {
                        if (!this.identifierEquals("COMMITTED")) throw new ParserException("UNKOWN TRANSACTION LEVEL : " + this.lexer.stringVal());
                        stmt.setIsolationLevel("READ COMMITTED");
                        this.lexer.nextToken();
                    }
                    return stmt;
                } else if (this.identifierEquals("SERIALIZABLE")) {
                    stmt.setIsolationLevel("SERIALIZABLE");
                    this.lexer.nextToken();
                    return stmt;
                } else {
                    if (!this.identifierEquals("REPEATABLE")) throw new ParserException("UNKOWN TRANSACTION LEVEL : " + this.lexer.stringVal());
                    this.lexer.nextToken();
                    if (!this.identifierEquals(READ)) throw new ParserException("UNKOWN TRANSACTION LEVEL : " + this.lexer.stringVal());
                    stmt.setIsolationLevel("REPEATABLE READ");
                    this.lexer.nextToken();
                }
                return stmt;
            } else {
                if (!this.identifierEquals(READ)) return stmt;
                this.lexer.nextToken();
                if (this.identifierEquals("ONLY")) {
                    stmt.setAccessModel("ONLY");
                    this.lexer.nextToken();
                    return stmt;
                } else {
                    if (!this.identifierEquals(WRITE)) throw new ParserException("UNKOWN ACCESS MODEL : " + this.lexer.stringVal());
                    stmt.setAccessModel(WRITE);
                    this.lexer.nextToken();
                }
            }
            return stmt;
        }
        if (this.identifierEquals("NAMES")) {
            this.lexer.nextToken();
            MySqlSetNamesStatement stmt = new MySqlSetNamesStatement();
            if (this.lexer.token() == Token.DEFAULT) {
                this.lexer.nextToken();
                stmt.setDefault(true);
                return stmt;
            } else {
                String charSet = this.lexer.stringVal();
                stmt.setCharSet(charSet);
                this.lexer.nextToken();
                if (!this.identifierEquals(COLLATE2)) return stmt;
                this.lexer.nextToken();
                String collate = this.lexer.stringVal();
                stmt.setCollate(collate);
                this.lexer.nextToken();
            }
            return stmt;
        }
        if (this.identifierEquals(CHARACTER)) {
            this.lexer.nextToken();
            this.accept(Token.SET);
            MySqlSetCharSetStatement stmt = new MySqlSetCharSetStatement();
            if (this.lexer.token() == Token.DEFAULT) {
                this.lexer.nextToken();
                stmt.setDefault(true);
                return stmt;
            } else {
                String charSet = this.lexer.stringVal();
                stmt.setCharSet(charSet);
                this.lexer.nextToken();
                if (!this.identifierEquals(COLLATE2)) return stmt;
                this.lexer.nextToken();
                String collate = this.lexer.stringVal();
                stmt.setCollate(collate);
                this.lexer.nextToken();
            }
            return stmt;
        }
        SQLSetStatement stmt = new SQLSetStatement(this.getDbType());
        this.parseAssignItems(stmt.getItems(), stmt);
        if (global != null && global.booleanValue()) {
            SQLVariantRefExpr varRef = (SQLVariantRefExpr)stmt.getItems().get(0).getTarget();
            varRef.setGlobal(true);
        }
        if (this.lexer.token() != Token.HINT) return stmt;
        stmt.setHints(this.exprParser.parseHints());
        return stmt;
    }

    public MySqlSelectQueryBlock.Limit parseLimit() {
        return ((MySqlExprParser)this.exprParser).parseLimit();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public SQLStatement parseAlter() {
        this.accept(Token.ALTER);
        if (this.lexer.token() == Token.USER) {
            return this.parseAlterUser();
        }
        boolean ignore = false;
        if (this.identifierEquals(IGNORE)) {
            ignore = true;
            this.lexer.nextToken();
        }
        if (this.lexer.token() != Token.TABLE) throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
        this.lexer.nextToken();
        MySqlAlterTableStatement stmt = new MySqlAlterTableStatement();
        stmt.setIgnore(ignore);
        stmt.setName(this.exprParser.name());
        while (true) {
            SQLObjectImpl item;
            SQLObjectImpl item2;
            if (this.lexer.token() == Token.DROP) {
                this.parseAlterDrop(stmt);
            } else if (this.identifierEquals("ADD")) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.COLUMN) {
                    this.lexer.nextToken();
                    this.parseAlterTableAddColumn(stmt);
                } else if (this.lexer.token() == Token.INDEX) {
                    item2 = this.parseAlterTableAddIndex();
                    item2.setParent(stmt);
                    stmt.getItems().add((SQLAlterTableItem)((Object)item2));
                } else if (this.lexer.token() == Token.UNIQUE) {
                    item2 = this.parseAlterTableAddIndex();
                    item2.setParent(stmt);
                    stmt.getItems().add((SQLAlterTableItem)((Object)item2));
                } else if (this.lexer.token() == Token.PRIMARY) {
                    SQLPrimaryKey primaryKey = this.exprParser.parsePrimaryKey();
                    item = new SQLAlterTableAddConstraint(primaryKey);
                    stmt.getItems().add((SQLAlterTableItem)((Object)item));
                } else if (this.lexer.token() == Token.KEY) {
                    item2 = this.parseAlterTableAddIndex();
                    item2.setParent(stmt);
                    stmt.getItems().add((SQLAlterTableItem)((Object)item2));
                } else if (this.lexer.token() == Token.CONSTRAINT) {
                    SQLAlterTableAddConstraint item3;
                    this.lexer.nextToken();
                    SQLName constraintName = this.exprParser.name();
                    if (this.lexer.token() == Token.PRIMARY) {
                        MySqlPrimaryKey primaryKey = ((MySqlExprParser)this.exprParser).parsePrimaryKey();
                        primaryKey.setName(constraintName);
                        item3 = new SQLAlterTableAddConstraint(primaryKey);
                        item3.setParent(stmt);
                        stmt.getItems().add(item3);
                    } else {
                        if (this.lexer.token() != Token.FOREIGN) throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                        MysqlForeignKey fk = this.getExprParser().parseForeignKey();
                        fk.setName(constraintName);
                        fk.setHasConstraint(true);
                        item3 = new SQLAlterTableAddConstraint(fk);
                        item3.setParent(stmt);
                        stmt.getItems().add(item3);
                    }
                } else {
                    if (this.identifierEquals(FULLTEXT)) {
                        throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                    }
                    if (this.identifierEquals(SPATIAL)) {
                        throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                    }
                    this.parseAlterTableAddColumn(stmt);
                }
            } else if (this.lexer.token() == Token.ALTER) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.COLUMN) {
                    this.lexer.nextToken();
                }
                SQLAlterTableAlterColumn alterColumn = new SQLAlterTableAlterColumn();
                SQLColumnDefinition columnDef = this.exprParser.parseColumn();
                alterColumn.setColumn(columnDef);
                stmt.getItems().add(alterColumn);
            } else if (this.identifierEquals("CHANGE")) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.COLUMN) {
                    this.lexer.nextToken();
                }
                item2 = new MySqlAlterTableChangeColumn();
                ((MySqlAlterTableChangeColumn)item2).setColumnName(this.exprParser.name());
                ((MySqlAlterTableChangeColumn)item2).setNewColumnDefinition(this.exprParser.parseColumn());
                if (this.identifierEquals("AFTER")) {
                    this.lexer.nextToken();
                    ((MySqlAlterTableChangeColumn)item2).setAfterColumn(this.exprParser.name());
                } else if (this.identifierEquals("FIRST")) {
                    this.lexer.nextToken();
                    if (this.lexer.token() == Token.IDENTIFIER) {
                        ((MySqlAlterTableChangeColumn)item2).setFirstColumn(this.exprParser.name());
                    } else {
                        ((MySqlAlterTableChangeColumn)item2).setFirst(true);
                    }
                }
                stmt.getItems().add((SQLAlterTableItem)((Object)item2));
            } else if (this.identifierEquals("MODIFY")) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.COLUMN) {
                    this.lexer.nextToken();
                }
                item2 = new MySqlAlterTableModifyColumn();
                ((MySqlAlterTableModifyColumn)item2).setNewColumnDefinition(this.exprParser.parseColumn());
                if (this.identifierEquals("AFTER")) {
                    this.lexer.nextToken();
                    ((MySqlAlterTableModifyColumn)item2).setAfterColumn(this.exprParser.name());
                } else if (this.identifierEquals("FIRST")) {
                    this.lexer.nextToken();
                    if (this.lexer.token() == Token.IDENTIFIER) {
                        ((MySqlAlterTableModifyColumn)item2).setFirstColumn(this.exprParser.name());
                    } else {
                        ((MySqlAlterTableModifyColumn)item2).setFirst(true);
                    }
                }
                stmt.getItems().add((SQLAlterTableItem)((Object)item2));
            } else if (this.lexer.token() == Token.DISABLE) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.CONSTRAINT) {
                    this.lexer.nextToken();
                    item2 = new SQLAlterTableDisableConstraint();
                    ((SQLAlterTableDisableConstraint)item2).setConstraintName(this.exprParser.name());
                    stmt.getItems().add((SQLAlterTableItem)((Object)item2));
                } else {
                    this.acceptIdentifier("KEYS");
                    item2 = new SQLAlterTableDisableKeys();
                    stmt.getItems().add((SQLAlterTableItem)((Object)item2));
                }
            } else if (this.lexer.token() == Token.ENABLE) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.CONSTRAINT) {
                    this.lexer.nextToken();
                    item2 = new SQLAlterTableEnableConstraint();
                    ((SQLAlterTableEnableConstraint)item2).setConstraintName(this.exprParser.name());
                    stmt.getItems().add((SQLAlterTableItem)((Object)item2));
                } else {
                    this.acceptIdentifier("KEYS");
                    item2 = new SQLAlterTableEnableKeys();
                    stmt.getItems().add((SQLAlterTableItem)((Object)item2));
                }
            } else {
                if (this.identifierEquals("RENAME")) {
                    this.lexer.nextToken();
                    if (this.lexer.token() == Token.TO || this.lexer.token() == Token.AS) {
                        this.lexer.nextToken();
                    }
                    MySqlRenameTableStatement renameStmt = new MySqlRenameTableStatement();
                    item = new MySqlRenameTableStatement.Item();
                    ((MySqlRenameTableStatement.Item)item).setName(stmt.getTableSource().getExpr());
                    ((MySqlRenameTableStatement.Item)item).setTo(this.exprParser.name());
                    renameStmt.getItems().add((MySqlRenameTableStatement.Item)item);
                    return renameStmt;
                }
                if (this.lexer.token() == Token.ORDER) {
                    throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                }
                if (this.identifierEquals("CONVERT")) {
                    throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                }
                if (this.lexer.token() == Token.DEFAULT) {
                    throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                }
                if (this.identifierEquals("DISCARD")) {
                    this.lexer.nextToken();
                    this.accept(Token.TABLESPACE);
                    item2 = new MySqlAlterTableDiscardTablespace();
                    stmt.getItems().add((SQLAlterTableItem)((Object)item2));
                } else if (this.identifierEquals("IMPORT")) {
                    this.lexer.nextToken();
                    this.accept(Token.TABLESPACE);
                    item2 = new MySqlAlterTableImportTablespace();
                    stmt.getItems().add((SQLAlterTableItem)((Object)item2));
                } else {
                    if (this.identifierEquals("FORCE")) {
                        throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                    }
                    if (this.identifierEquals("TRUNCATE")) {
                        throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                    }
                    if (this.identifierEquals("COALESCE")) {
                        throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                    }
                    if (this.identifierEquals("REORGANIZE")) {
                        throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                    }
                    if (this.identifierEquals("EXCHANGE")) {
                        throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                    }
                    if (this.identifierEquals("ANALYZE")) {
                        throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                    }
                    if (this.identifierEquals("CHECK")) {
                        throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                    }
                    if (this.lexer.token() == Token.OPTIMIZE) {
                        throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                    }
                    if (this.identifierEquals("REBUILD")) {
                        throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                    }
                    if (this.identifierEquals("REPAIR")) {
                        throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                    }
                    if (this.identifierEquals("REMOVE")) {
                        throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                    }
                    if (this.identifierEquals("ALGORITHM")) {
                        this.lexer.nextToken();
                        this.accept(Token.EQ);
                        stmt.getItems().add(new MySqlAlterTableOption("ALGORITHM", this.lexer.stringVal()));
                        this.lexer.nextToken();
                    } else if (this.identifierEquals(ENGINE)) {
                        this.lexer.nextToken();
                        this.accept(Token.EQ);
                        stmt.getItems().add(new MySqlAlterTableOption(ENGINE, this.lexer.stringVal()));
                        this.lexer.nextToken();
                    } else if (this.identifierEquals(AUTO_INCREMENT)) {
                        this.lexer.nextToken();
                        this.accept(Token.EQ);
                        stmt.getItems().add(new MySqlAlterTableOption(AUTO_INCREMENT, this.lexer.integerValue()));
                        this.lexer.nextToken();
                    } else if (this.identifierEquals(COLLATE2)) {
                        this.lexer.nextToken();
                        this.accept(Token.EQ);
                        stmt.getItems().add(new MySqlAlterTableOption(COLLATE2, this.lexer.stringVal()));
                        this.lexer.nextToken();
                    } else if (this.identifierEquals("PACK_KEYS")) {
                        this.lexer.nextToken();
                        this.accept(Token.EQ);
                        if (this.identifierEquals("PACK")) {
                            this.lexer.nextToken();
                            this.accept(Token.ALL);
                            stmt.getItems().add(new MySqlAlterTableOption("PACK_KEYS", "PACK ALL"));
                        } else {
                            stmt.getItems().add(new MySqlAlterTableOption("PACK_KEYS", this.lexer.stringVal()));
                            this.lexer.nextToken();
                        }
                    } else if (this.identifierEquals(CHARACTER)) {
                        this.lexer.nextToken();
                        this.accept(Token.SET);
                        this.accept(Token.EQ);
                        item2 = new MySqlAlterTableCharacter();
                        ((MySqlAlterTableCharacter)item2).setCharacterSet(this.exprParser.primary());
                        if (this.lexer.token() == Token.COMMA) {
                            this.lexer.nextToken();
                            this.acceptIdentifier(COLLATE2);
                            this.accept(Token.EQ);
                            ((MySqlAlterTableCharacter)item2).setCollate(this.exprParser.primary());
                        }
                        stmt.getItems().add((SQLAlterTableItem)((Object)item2));
                    } else {
                        if (this.lexer.token() != Token.COMMENT) return stmt;
                        this.lexer.nextToken();
                        if (this.lexer.token() == Token.EQ) {
                            this.accept(Token.EQ);
                        }
                        stmt.getItems().add(new MySqlAlterTableOption("COMMENT", '\'' + this.lexer.stringVal() + '\''));
                        this.lexer.nextToken();
                    }
                }
            }
            if (this.lexer.token() != Token.COMMA) return stmt;
            this.lexer.nextToken();
        }
    }

    protected void parseAlterTableAddColumn(MySqlAlterTableStatement stmt) {
        boolean parenFlag = false;
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            parenFlag = true;
        }
        MySqlAlterTableAddColumn item = new MySqlAlterTableAddColumn();
        while (true) {
            SQLColumnDefinition columnDef = this.exprParser.parseColumn();
            item.getColumns().add(columnDef);
            if (this.identifierEquals("AFTER")) {
                this.lexer.nextToken();
                item.setAfterColumn(this.exprParser.name());
            } else if (this.identifierEquals("FIRST")) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.IDENTIFIER) {
                    item.setFirstColumn(this.exprParser.name());
                } else {
                    item.setFirst(true);
                }
            }
            if (!parenFlag || this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        stmt.getItems().add(item);
        if (parenFlag) {
            this.accept(Token.RPAREN);
        }
    }

    @Override
    public void parseAlterDrop(SQLAlterTableStatement stmt) {
        this.lexer.nextToken();
        if (this.lexer.token() == Token.INDEX) {
            this.lexer.nextToken();
            SQLName indexName = this.exprParser.name();
            SQLAlterTableDropIndex item = new SQLAlterTableDropIndex();
            item.setIndexName(indexName);
            stmt.getItems().add(item);
        } else if (this.lexer.token() == Token.FOREIGN) {
            this.lexer.nextToken();
            this.accept(Token.KEY);
            SQLName indexName = this.exprParser.name();
            SQLAlterTableDropForeignKey item = new SQLAlterTableDropForeignKey();
            item.setIndexName(indexName);
            stmt.getItems().add(item);
        } else if (this.lexer.token() == Token.PRIMARY) {
            this.lexer.nextToken();
            this.accept(Token.KEY);
            SQLAlterTableDropPrimaryKey item = new SQLAlterTableDropPrimaryKey();
            stmt.getItems().add(item);
        } else if (this.lexer.token() == Token.CONSTRAINT) {
            this.lexer.nextToken();
            SQLAlterTableDropConstraint item = new SQLAlterTableDropConstraint();
            item.setConstraintName(this.exprParser.name());
            stmt.getItems().add(item);
        } else if (this.lexer.token() == Token.COLUMN) {
            this.lexer.nextToken();
            SQLAlterTableDropColumnItem item = new SQLAlterTableDropColumnItem();
            SQLName name = this.exprParser.name();
            name.setParent(item);
            item.getColumns().add(name);
            while (this.lexer.token() == Token.COMMA) {
                this.lexer.mark();
                this.lexer.nextToken();
                if (this.identifierEquals("CHANGE")) {
                    this.lexer.reset();
                    break;
                }
                if (this.lexer.token() == Token.IDENTIFIER) {
                    name = this.exprParser.name();
                    name.setParent(item);
                    continue;
                }
                this.lexer.reset();
                break;
            }
            stmt.getItems().add(item);
        } else if (this.lexer.token() == Token.IDENTIFIER) {
            SQLAlterTableDropColumnItem item = new SQLAlterTableDropColumnItem();
            this.exprParser.names(item.getColumns());
            stmt.getItems().add(item);
        } else {
            super.parseAlterDrop(stmt);
        }
    }

    @Override
    public SQLStatement parseRename() {
        MySqlRenameTableStatement stmt = new MySqlRenameTableStatement();
        this.acceptIdentifier("RENAME");
        this.accept(Token.TABLE);
        while (true) {
            MySqlRenameTableStatement.Item item = new MySqlRenameTableStatement.Item();
            item.setName(this.exprParser.name());
            this.accept(Token.TO);
            item.setTo(this.exprParser.name());
            stmt.getItems().add(item);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        return stmt;
    }

    @Override
    public SQLStatement parseCreateDatabase() {
        if (this.lexer.token() == Token.CREATE) {
            this.lexer.nextToken();
        }
        this.accept(Token.DATABASE);
        SQLCreateDatabaseStatement stmt = new SQLCreateDatabaseStatement("mysql");
        stmt.setName(this.exprParser.name());
        if (this.lexer.token() == Token.DEFAULT) {
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.HINT) {
            stmt.setHints(this.exprParser.parseHints());
        }
        return stmt;
    }

    @Override
    protected void parseUpdateSet(SQLUpdateStatement update) {
        this.accept(Token.SET);
        while (true) {
            SQLUpdateSetItem item = this.exprParser.parseUpdateSetItem();
            update.addItem(item);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
    }

    public MySqlAlterUserStatement parseAlterUser() {
        this.accept(Token.USER);
        MySqlAlterUserStatement stmt = new MySqlAlterUserStatement();
        while (true) {
            SQLExpr user = this.exprParser.expr();
            this.acceptIdentifier("PASSWORD");
            this.acceptIdentifier("EXPIRE");
            stmt.getUsers().add(user);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        return stmt;
    }

    @Override
    public MySqlExprParser getExprParser() {
        return (MySqlExprParser)this.exprParser;
    }

    public MySqlHintStatement parseHint() {
        MySqlHintStatement stmt = new MySqlHintStatement();
        stmt.setHints(this.exprParser.parseHints());
        return stmt;
    }

    @Override
    public MySqlCreateProcedureStatement parseCreateProcedure() {
        MySqlCreateProcedureStatement stmt = new MySqlCreateProcedureStatement();
        this.accept(Token.CREATE);
        if (this.lexer.token() == Token.OR) {
            this.lexer.nextToken();
            this.accept(Token.REPLACE);
            stmt.setOrReplace(true);
        }
        this.accept(Token.PROCEDURE);
        stmt.setName(this.exprParser.name());
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            this.parserParameters(stmt.getParameters());
            this.accept(Token.RPAREN);
        }
        MySqlBlockStatement block = this.parseBlock();
        stmt.setBlock(block);
        return stmt;
    }

    private void parserParameters(List<MySqlParameter> parameters) {
        do {
            MySqlParameter parameter = new MySqlParameter();
            if (this.lexer.token() == Token.CURSOR) {
                this.lexer.nextToken();
                parameter.setName(this.exprParser.name());
                this.accept(Token.IS);
                SQLSelect select = this.createSQLSelectParser().select();
                SQLDataTypeImpl dataType = new SQLDataTypeImpl();
                dataType.setName("CURSOR");
                parameter.setDataType(dataType);
                parameter.setDefaultValue(new SQLQueryExpr(select));
            } else if (this.lexer.token() == Token.IN || this.lexer.token() == Token.OUT || this.lexer.token() == Token.INOUT) {
                if (this.lexer.token() == Token.IN) {
                    parameter.setParamType(MySqlParameter.ParameterType.IN);
                } else if (this.lexer.token() == Token.OUT) {
                    parameter.setParamType(MySqlParameter.ParameterType.OUT);
                } else if (this.lexer.token() == Token.INOUT) {
                    parameter.setParamType(MySqlParameter.ParameterType.INOUT);
                }
                this.lexer.nextToken();
                parameter.setName(this.exprParser.name());
                parameter.setDataType(this.exprParser.parseDataType());
            } else {
                parameter.setParamType(MySqlParameter.ParameterType.DEFAULT);
                parameter.setName(this.exprParser.name());
                parameter.setDataType(this.exprParser.parseDataType());
                if (this.lexer.token() == Token.COLONEQ) {
                    this.lexer.nextToken();
                    parameter.setDefaultValue(this.exprParser.expr());
                }
            }
            parameters.add(parameter);
            if (this.lexer.token() != Token.COMMA && this.lexer.token() != Token.SEMI) continue;
            this.lexer.nextToken();
        } while (this.lexer.token() != Token.BEGIN && this.lexer.token() != Token.RPAREN);
    }

    private void parseProcedureStatementList(List<SQLStatement> statementList) {
        this.parseProcedureStatementList(statementList, -1);
    }

    private void parseProcedureStatementList(List<SQLStatement> statementList, int max) {
        block35: {
            int bp;
            char ch;
            while (true) {
                if (max != -1 && statementList.size() >= max) {
                    return;
                }
                if (this.lexer.token() == Token.EOF) {
                    return;
                }
                if (this.lexer.token() == Token.END) {
                    return;
                }
                if (this.lexer.token() == Token.ELSE) {
                    return;
                }
                if (this.lexer.token() == Token.SEMI) {
                    this.lexer.nextToken();
                    continue;
                }
                if (this.lexer.token() == Token.WHEN) {
                    return;
                }
                if (this.lexer.token() == Token.UNTIL) {
                    return;
                }
                if (this.lexer.token() == Token.SELECT) {
                    statementList.add(this.parseSelectInto());
                    continue;
                }
                if (this.lexer.token() == Token.UPDATE) {
                    statementList.add(this.parseUpdateStatement());
                    continue;
                }
                if (this.lexer.token() == Token.CREATE) {
                    statementList.add(this.parseCreate());
                    continue;
                }
                if (this.lexer.token() == Token.INSERT) {
                    statementList.add(this.parseInsert());
                    continue;
                }
                if (this.lexer.token() == Token.DELETE) {
                    statementList.add(this.parseDeleteStatement());
                    continue;
                }
                if (this.lexer.token() == Token.LBRACE || this.identifierEquals("CALL")) {
                    statementList.add(this.parseCall());
                    continue;
                }
                if (this.lexer.token() == Token.BEGIN) {
                    statementList.add(this.parseBlock());
                    continue;
                }
                if (this.lexer.token() == Token.VARIANT) {
                    SQLBinaryOpExpr binaryOpExpr;
                    SQLExpr variant = this.exprParser.primary();
                    if (variant instanceof SQLBinaryOpExpr && (binaryOpExpr = (SQLBinaryOpExpr)variant).getOperator() == SQLBinaryOperator.Assignment) {
                        SQLSetStatement stmt = new SQLSetStatement(binaryOpExpr.getLeft(), binaryOpExpr.getRight(), this.getDbType());
                        statementList.add(stmt);
                        continue;
                    }
                    this.accept(Token.COLONEQ);
                    SQLExpr value = this.exprParser.expr();
                    SQLSetStatement stmt = new SQLSetStatement(variant, value, this.getDbType());
                    statementList.add(stmt);
                    continue;
                }
                if (this.lexer.token() == Token.LPAREN) {
                    char ch2 = this.lexer.current();
                    int bp2 = this.lexer.bp();
                    this.lexer.nextToken();
                    if (this.lexer.token() == Token.SELECT) {
                        this.lexer.reset(bp2, ch2, Token.LPAREN);
                        statementList.add(this.parseSelect());
                        continue;
                    }
                    throw new ParserException("TODO : " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                }
                if (this.lexer.token() == Token.SET) {
                    statementList.add(this.parseAssign());
                    continue;
                }
                if (this.lexer.token() == Token.WHILE) {
                    statementList.add(this.parseWhile());
                    continue;
                }
                if (this.lexer.token() == Token.LOOP) {
                    statementList.add(this.parseLoop());
                    continue;
                }
                if (this.lexer.token() == Token.IF) {
                    statementList.add(this.parseIf());
                    continue;
                }
                if (this.lexer.token() == Token.CASE) {
                    statementList.add(this.parseCase());
                    continue;
                }
                if (this.lexer.token() == Token.DECLARE) {
                    char markChar = this.lexer.current();
                    int markBp = this.lexer.bp();
                    this.lexer.nextToken();
                    this.lexer.nextToken();
                    if (this.lexer.token() == Token.CURSOR) {
                        this.lexer.reset(markBp, markChar, Token.DECLARE);
                        statementList.add(this.parseCursorDeclare());
                        continue;
                    }
                    this.lexer.reset(markBp, markChar, Token.DECLARE);
                    statementList.add(this.parseDeclare());
                    continue;
                }
                if (this.lexer.token() == Token.LEAVE) {
                    statementList.add(this.parseLeave());
                    continue;
                }
                if (this.lexer.token() == Token.ITERATE) {
                    statementList.add(this.parseIterate());
                    continue;
                }
                if (this.lexer.token() == Token.REPEAT) {
                    statementList.add(this.parseRepeat());
                    continue;
                }
                if (this.lexer.token() == Token.OPEN) {
                    statementList.add(this.parseOpen());
                    continue;
                }
                if (this.lexer.token() == Token.CLOSE) {
                    statementList.add(this.parseClose());
                    continue;
                }
                if (this.lexer.token() == Token.FETCH) {
                    statementList.add(this.parseFetch());
                    continue;
                }
                if (this.lexer.token() != Token.IDENTIFIER) break block35;
                String label = this.lexer.stringVal();
                ch = this.lexer.current();
                bp = this.lexer.bp();
                this.lexer.nextToken();
                if (this.lexer.token() != Token.VARIANT || !this.lexer.stringVal().equals(":")) break;
                this.lexer.nextToken();
                if (this.lexer.token() == Token.LOOP) {
                    statementList.add(this.parseLoop(label));
                    continue;
                }
                if (this.lexer.token() == Token.WHILE) {
                    statementList.add(this.parseWhile(label));
                    continue;
                }
                if (this.lexer.token() == Token.BEGIN) {
                    statementList.add(this.parseBlock(label));
                    continue;
                }
                if (this.lexer.token() != Token.REPEAT) continue;
                statementList.add(this.parseRepeat(label));
            }
            this.lexer.reset(bp, ch, Token.IDENTIFIER);
        }
        throw new ParserException("TODO : " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
    }

    public MySqlIfStatement parseIf() {
        this.accept(Token.IF);
        MySqlIfStatement stmt = new MySqlIfStatement();
        stmt.setCondition(this.exprParser.expr());
        this.accept(Token.THEN);
        this.parseProcedureStatementList(stmt.getStatements());
        while (this.lexer.token() == Token.ELSE) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.IF) {
                this.lexer.nextToken();
                MySqlIfStatement.MySqlElseIfStatement elseIf = new MySqlIfStatement.MySqlElseIfStatement();
                elseIf.setCondition(this.exprParser.expr());
                this.accept(Token.THEN);
                this.parseProcedureStatementList(elseIf.getStatements());
                stmt.getElseIfList().add(elseIf);
                continue;
            }
            MySqlElseStatement elseItem = new MySqlElseStatement();
            this.parseProcedureStatementList(elseItem.getStatements());
            stmt.setElseItem(elseItem);
            break;
        }
        this.accept(Token.END);
        this.accept(Token.IF);
        this.accept(Token.SEMI);
        return stmt;
    }

    public MySqlWhileStatement parseWhile() {
        this.accept(Token.WHILE);
        MySqlWhileStatement stmt = new MySqlWhileStatement();
        stmt.setCondition(this.exprParser.expr());
        this.accept(Token.DO);
        this.parseProcedureStatementList(stmt.getStatements());
        this.accept(Token.END);
        this.accept(Token.WHILE);
        this.accept(Token.SEMI);
        return stmt;
    }

    public MySqlWhileStatement parseWhile(String label) {
        this.accept(Token.WHILE);
        MySqlWhileStatement stmt = new MySqlWhileStatement();
        stmt.setLabelName(label);
        stmt.setCondition(this.exprParser.expr());
        this.accept(Token.DO);
        this.parseProcedureStatementList(stmt.getStatements());
        this.accept(Token.END);
        this.accept(Token.WHILE);
        this.acceptIdentifier(label);
        this.accept(Token.SEMI);
        return stmt;
    }

    public MySqlCaseStatement parseCase() {
        MySqlCaseStatement stmt = new MySqlCaseStatement();
        this.accept(Token.CASE);
        if (this.lexer.token() == Token.WHEN) {
            while (this.lexer.token() == Token.WHEN) {
                MySqlCaseStatement.MySqlWhenStatement when = new MySqlCaseStatement.MySqlWhenStatement();
                when.setCondition(this.exprParser.expr());
                this.accept(Token.THEN);
                this.parseProcedureStatementList(when.getStatements());
                stmt.addWhenStatement(when);
            }
            if (this.lexer.token() == Token.ELSE) {
                MySqlElseStatement elseStmt = new MySqlElseStatement();
                this.parseProcedureStatementList(elseStmt.getStatements());
                stmt.setElseItem(elseStmt);
            }
        } else {
            stmt.setCondition(this.exprParser.expr());
            while (this.lexer.token() == Token.WHEN) {
                this.accept(Token.WHEN);
                MySqlCaseStatement.MySqlWhenStatement when = new MySqlCaseStatement.MySqlWhenStatement();
                when.setCondition(this.exprParser.expr());
                this.accept(Token.THEN);
                this.parseProcedureStatementList(when.getStatements());
                stmt.addWhenStatement(when);
            }
            if (this.lexer.token() == Token.ELSE) {
                this.accept(Token.ELSE);
                MySqlElseStatement elseStmt = new MySqlElseStatement();
                this.parseProcedureStatementList(elseStmt.getStatements());
                stmt.setElseItem(elseStmt);
            }
        }
        this.accept(Token.END);
        this.accept(Token.CASE);
        this.accept(Token.SEMI);
        return stmt;
    }

    public MySqlDeclareStatement parseDeclare() {
        MySqlDeclareStatement stmt = new MySqlDeclareStatement();
        this.accept(Token.DECLARE);
        while (true) {
            SQLExpr var;
            if ((var = this.exprParser.primary()) instanceof SQLIdentifierExpr) {
                var = new SQLVariantRefExpr(((SQLIdentifierExpr)var).getName());
            }
            stmt.addVar(var);
            if (this.lexer.token() == Token.COMMA) {
                this.accept(Token.COMMA);
                continue;
            }
            if (this.lexer.token() != Token.EOF) break;
            this.setErrorEndPos(this.lexer.pos());
            this.printError(this.lexer.token());
        }
        stmt.setType(this.exprParser.parseDataType());
        return stmt;
    }

    public SQLSetStatement parseAssign() {
        this.accept(Token.SET);
        SQLSetStatement stmt = new SQLSetStatement(this.getDbType());
        this.parseAssignItems(stmt.getItems(), stmt);
        return stmt;
    }

    public MySqlSelectIntoStatement parseSelectInto() {
        MySqlSelectIntoParser parse = new MySqlSelectIntoParser(this.exprParser);
        return parse.parseSelectInto();
    }

    public MySqlLoopStatement parseLoop() {
        MySqlLoopStatement loopStmt = new MySqlLoopStatement();
        this.accept(Token.LOOP);
        this.parseProcedureStatementList(loopStmt.getStatements());
        this.accept(Token.END);
        this.accept(Token.LOOP);
        this.accept(Token.SEMI);
        return loopStmt;
    }

    public MySqlLoopStatement parseLoop(String label) {
        MySqlLoopStatement loopStmt = new MySqlLoopStatement();
        loopStmt.setLabelName(label);
        this.accept(Token.LOOP);
        this.parseProcedureStatementList(loopStmt.getStatements());
        this.accept(Token.END);
        this.accept(Token.LOOP);
        this.acceptIdentifier(label);
        this.accept(Token.SEMI);
        return loopStmt;
    }

    public MySqlBlockStatement parseBlock(String label) {
        MySqlBlockStatement block = new MySqlBlockStatement();
        block.setLabelName(label);
        this.accept(Token.BEGIN);
        this.parseProcedureStatementList(block.getStatementList());
        this.accept(Token.END);
        this.acceptIdentifier(label);
        return block;
    }

    public MySqlLeaveStatement parseLeave() {
        this.accept(Token.LEAVE);
        MySqlLeaveStatement leaveStmt = new MySqlLeaveStatement();
        leaveStmt.setLabelName(this.exprParser.name().getSimpleName());
        this.accept(Token.SEMI);
        return leaveStmt;
    }

    public MySqlIterateStatement parseIterate() {
        this.accept(Token.ITERATE);
        MySqlIterateStatement iterateStmt = new MySqlIterateStatement();
        iterateStmt.setLabelName(this.exprParser.name().getSimpleName());
        this.accept(Token.SEMI);
        return iterateStmt;
    }

    public MySqlRepeatStatement parseRepeat() {
        MySqlRepeatStatement repeatStmt = new MySqlRepeatStatement();
        this.accept(Token.REPEAT);
        this.parseProcedureStatementList(repeatStmt.getStatements());
        this.accept(Token.UNTIL);
        repeatStmt.setCondition(this.exprParser.expr());
        this.accept(Token.END);
        this.accept(Token.REPEAT);
        this.accept(Token.SEMI);
        return repeatStmt;
    }

    public MySqlRepeatStatement parseRepeat(String label) {
        MySqlRepeatStatement repeatStmt = new MySqlRepeatStatement();
        repeatStmt.setLabelName(label);
        this.accept(Token.REPEAT);
        this.parseProcedureStatementList(repeatStmt.getStatements());
        this.accept(Token.UNTIL);
        repeatStmt.setCondition(this.exprParser.expr());
        this.accept(Token.END);
        this.accept(Token.REPEAT);
        this.acceptIdentifier(label);
        this.accept(Token.SEMI);
        return repeatStmt;
    }

    public MySqlCursorDeclareStatement parseCursorDeclare() {
        MySqlCursorDeclareStatement stmt = new MySqlCursorDeclareStatement();
        this.accept(Token.DECLARE);
        stmt.setCursorName(this.exprParser.name().getSimpleName());
        this.accept(Token.CURSOR);
        this.accept(Token.FOR);
        stmt.setSelect(this.parseSelect());
        this.accept(Token.SEMI);
        return stmt;
    }
}

