/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.odps.visitor;

import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLHint;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLCaseExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableElement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsAddStatisticStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsAnalyzeTableStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsCreateTableStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsInsert;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsInsertStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsReadStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsRemoveStatisticStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsSelectQueryBlock;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsSetLabelStatement;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsShowPartitionsStmt;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsShowStatisticStmt;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsStatisticClause;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsUDTFSQLSelectItem;
import com.alibaba.druid.sql.dialect.odps.visitor.OdpsASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OdpsOutputVisitor
extends SQLASTOutputVisitor
implements OdpsASTVisitor {
    private Set<String> builtInFunctions = new HashSet<String>();

    public OdpsOutputVisitor(Appendable appender) {
        super(appender);
        this.builtInFunctions.add("IF");
        this.builtInFunctions.add("COALESCE");
        this.builtInFunctions.add("TO_DATE");
        this.builtInFunctions.add("SUBSTR");
        this.builtInFunctions.add("INSTR");
        this.builtInFunctions.add("LENGTH");
        this.builtInFunctions.add("SPLIT");
        this.builtInFunctions.add("TOLOWER");
        this.builtInFunctions.add("TOUPPER");
        this.builtInFunctions.add("EXPLODE");
        this.builtInFunctions.add("LEAST");
        this.builtInFunctions.add("GREATEST");
    }

    @Override
    public boolean visit(OdpsCreateTableStatement x) {
        int partitionSize;
        int size;
        if (x.isIfNotExiists()) {
            this.print("CREATE TABLE IF NOT EXISTS ");
        } else {
            this.print("CREATE TABLE ");
        }
        x.getName().accept(this);
        if (x.getLike() != null) {
            this.print(" LIKE ");
            x.getLike().accept(this);
        }
        if ((size = x.getTableElementList().size()) > 0) {
            this.print(" (");
            this.incrementIndent();
            this.println();
            for (int i = 0; i < size; ++i) {
                SQLTableElement element = x.getTableElementList().get(i);
                element.accept(this);
                if (i != size - 1) {
                    this.print(",");
                }
                if (this.isPrettyFormat() && element.hasAfterComment()) {
                    this.print(' ');
                    this.printComment(element.getAfterCommentsDirect(), "\n");
                }
                if (i == size - 1) continue;
                this.println();
            }
            this.decrementIndent();
            this.println();
            this.print(")");
        }
        if (x.getComment() != null) {
            this.println();
            this.print("COMMENT ");
            x.getComment().accept(this);
        }
        if ((partitionSize = x.getPartitionColumns().size()) > 0) {
            this.println();
            this.print("PARTITIONED BY (");
            this.incrementIndent();
            this.println();
            for (int i = 0; i < partitionSize; ++i) {
                SQLColumnDefinition column = x.getPartitionColumns().get(i);
                column.accept(this);
                if (i != partitionSize - 1) {
                    this.print(',');
                }
                if (this.isPrettyFormat() && column.hasAfterComment()) {
                    this.print(' ');
                    this.printComment(column.getAfterCommentsDirect(), "\n");
                }
                if (i == partitionSize - 1) continue;
                this.println();
            }
            this.decrementIndent();
            this.println();
            this.print(")");
        }
        if (x.getLifecycle() != null) {
            this.println();
            this.print("LIFECYCLE ");
            x.getLifecycle().accept(this);
        }
        if (x.getSelect() != null) {
            this.println();
            this.print("AS");
            this.println();
            x.getSelect().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(OdpsCreateTableStatement x) {
        super.endVisit(x);
    }

    public SQLStatement parseInsert() {
        OdpsInsertStatement stmt = new OdpsInsertStatement();
        return stmt;
    }

    @Override
    public void endVisit(OdpsInsertStatement x) {
    }

    @Override
    public boolean visit(OdpsInsertStatement x) {
        if (x.getFrom() != null) {
            this.print("FROM (");
            this.incrementIndent();
            this.println();
            x.getFrom().getSelect().accept(this);
            this.decrementIndent();
            this.println();
            this.print(") ");
            this.print(x.getFrom().getAlias());
            this.println();
        }
        for (int i = 0; i < x.getItems().size(); ++i) {
            OdpsInsert insert = x.getItems().get(i);
            if (i != 0) {
                this.println();
            }
            insert.accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(OdpsInsert x) {
    }

    @Override
    public boolean visit(OdpsInsert x) {
        if (x.hasBeforeComment()) {
            this.printComment(x.getBeforeCommentsDirect(), "\n");
            this.println();
        }
        if (x.isOverwrite()) {
            this.print("INSERT OVERWRITE TABLE ");
        } else {
            this.print("INSERT INTO TABLE ");
        }
        x.getTableSource().accept(this);
        int partitions = x.getPartitions().size();
        if (partitions > 0) {
            this.print(" PARTITION (");
            for (int i = 0; i < partitions; ++i) {
                if (i != 0) {
                    this.print(", ");
                }
                SQLAssignItem assign = x.getPartitions().get(i);
                assign.getTarget().accept(this);
                if (assign.getValue() == null) continue;
                this.print("=");
                assign.getValue().accept(this);
            }
            this.print(")");
        }
        this.println();
        x.getQuery().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLCaseExpr x) {
        this.incrementIndent();
        this.print("CASE ");
        if (x.getValueExpr() != null) {
            x.getValueExpr().accept(this);
            this.println();
        }
        int size = x.getItems().size();
        for (int i = 0; i < size; ++i) {
            this.println();
            x.getItems().get(i).accept(this);
        }
        if (x.getElseExpr() != null) {
            this.println();
            this.print("ELSE ");
            x.getElseExpr().accept(this);
        }
        this.decrementIndent();
        this.println();
        this.print("END");
        return false;
    }

    @Override
    public boolean visit(SQLSelectGroupByClause x) {
        int itemSize = x.getItems().size();
        if (itemSize > 0) {
            this.print("GROUP BY ");
            this.incrementIndent();
            for (int i = 0; i < itemSize; ++i) {
                if (i != 0) {
                    this.println(", ");
                }
                x.getItems().get(i).accept(this);
            }
            this.decrementIndent();
        }
        if (x.getHaving() != null) {
            this.println();
            this.print("HAVING ");
            x.getHaving().accept(this);
        }
        return false;
    }

    @Override
    protected void printSelectList(List<SQLSelectItem> selectList) {
        this.incrementIndent();
        int size = selectList.size();
        for (int i = 0; i < size; ++i) {
            SQLSelectItem selectItem = selectList.get(i);
            if (i != 0) {
                SQLSelectItem preSelectItem = selectList.get(i - 1);
                if (preSelectItem.hasAfterComment()) {
                    this.print(' ');
                    this.printComment(preSelectItem.getAfterCommentsDirect(), "\n");
                }
                this.println();
                this.print(", ");
            }
            selectItem.accept(this);
            if (i != selectList.size() - 1 || !selectItem.hasAfterComment()) continue;
            this.print(' ');
            this.printComment(selectItem.getAfterCommentsDirect(), "\n");
        }
        this.decrementIndent();
    }

    @Override
    public boolean visit(SQLSubqueryTableSource x) {
        this.print("(");
        this.incrementIndent();
        this.println();
        x.getSelect().accept(this);
        this.decrementIndent();
        this.println();
        this.print(")");
        if (x.getAlias() != null) {
            this.print(' ');
            this.print(x.getAlias());
        }
        return false;
    }

    @Override
    public boolean visit(SQLJoinTableSource x) {
        x.getLeft().accept(this);
        if (x.getJoinType() == SQLJoinTableSource.JoinType.COMMA) {
            this.print(",");
        } else {
            this.println();
            this.printJoinType(x.getJoinType());
        }
        this.print(" ");
        x.getRight().accept(this);
        if (x.getCondition() != null) {
            this.println();
            this.print("ON ");
            this.incrementIndent();
            x.getCondition().accept(this);
            this.decrementIndent();
        }
        if (x.getUsing().size() > 0) {
            this.print(" USING (");
            this.printAndAccept(x.getUsing(), ", ");
            this.print(")");
        }
        if (x.getAlias() != null) {
            this.print(" AS ");
            this.print(x.getAlias());
        }
        return false;
    }

    @Override
    public void endVisit(OdpsUDTFSQLSelectItem x) {
    }

    @Override
    public boolean visit(OdpsUDTFSQLSelectItem x) {
        x.getExpr().accept(this);
        this.println();
        this.print("AS (");
        int aliasSize = x.getAliasList().size();
        if (aliasSize > 5) {
            this.incrementIndent();
            this.println();
        }
        for (int i = 0; i < aliasSize; ++i) {
            if (i != 0) {
                if (aliasSize > 5) {
                    this.println(",");
                } else {
                    this.print(", ");
                }
            }
            this.print(x.getAliasList().get(i));
        }
        if (aliasSize > 5) {
            this.decrementIndent();
            this.println();
        }
        this.print(")");
        return false;
    }

    @Override
    public void endVisit(OdpsShowPartitionsStmt x) {
    }

    @Override
    public boolean visit(OdpsShowPartitionsStmt x) {
        this.print("SHOW PARTITIONS ");
        x.getTableSource().accept(this);
        return false;
    }

    @Override
    public void endVisit(OdpsShowStatisticStmt x) {
    }

    @Override
    public boolean visit(OdpsShowStatisticStmt x) {
        this.print("SHOW STATISTIC ");
        x.getTableSource().accept(this);
        return false;
    }

    @Override
    public void endVisit(OdpsSetLabelStatement x) {
    }

    @Override
    public boolean visit(OdpsSetLabelStatement x) {
        this.print("SET LABEL ");
        this.print(x.getLabel());
        this.print(" TO ");
        if (x.getUser() != null) {
            this.print("USER ");
            x.getUser().accept(this);
        } else if (x.getTable() != null) {
            this.print("TABLE ");
            x.getTable().accept(this);
            if (x.getColumns().size() > 0) {
                this.print("(");
                this.printAndAccept(x.getColumns(), ", ");
                this.print(")");
            }
        }
        return false;
    }

    @Override
    public void endVisit(OdpsSelectQueryBlock x) {
    }

    @Override
    public boolean visit(OdpsSelectQueryBlock x) {
        if (this.isPrettyFormat() && x.hasBeforeComment()) {
            this.printComment(x.getBeforeCommentsDirect(), "\n");
            this.println();
        }
        this.print("SELECT ");
        List<SQLHint> hints = x.getHintsDirect();
        if (hints != null) {
            this.printAndAccept(hints, " ");
            this.print(' ');
        }
        if (1 == x.getDistionOption()) {
            this.print("ALL ");
        } else if (2 == x.getDistionOption()) {
            this.print("DISTINCT ");
        } else if (3 == x.getDistionOption()) {
            this.print("UNIQUE ");
        }
        this.printSelectList(x.getSelectList());
        if (x.getFrom() != null) {
            this.println();
            this.print("FROM ");
            x.getFrom().accept(this);
        }
        if (x.getWhere() != null) {
            this.println();
            this.print("WHERE ");
            if (x.getWhere().hasBeforeComment() && this.isPrettyFormat()) {
                this.printlnComments(x.getWhere().getBeforeCommentsDirect());
            }
            x.getWhere().setParent(x);
            x.getWhere().accept(this);
            if (x.getWhere().hasAfterComment() && this.isPrettyFormat()) {
                this.print(' ');
                this.printComment(x.getWhere().getAfterCommentsDirect(), "\n");
            }
        }
        if (x.getGroupBy() != null) {
            this.println();
            x.getGroupBy().accept(this);
        }
        if (x.getOrderBy() != null) {
            this.println();
            x.getOrderBy().accept(this);
        }
        if (x.getDistributeBy() != null) {
            this.println();
            this.print("DISTRIBUTE BY ");
            x.getDistributeBy().accept(this);
            if (!x.getSortBy().isEmpty()) {
                this.print(" SORT BY ");
                this.printAndAccept(x.getSortBy(), ", ");
            }
        }
        if (x.getLimit() != null) {
            this.println();
            this.print("LIMIT ");
            x.getLimit().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLOrderBy x) {
        int itemSize = x.getItems().size();
        if (itemSize > 0) {
            this.print("ORDER BY ");
            this.incrementIndent();
            for (int i = 0; i < itemSize; ++i) {
                if (i != 0) {
                    this.println(", ");
                }
                x.getItems().get(i).accept(this);
            }
            this.decrementIndent();
        }
        return false;
    }

    @Override
    public void endVisit(OdpsAnalyzeTableStatement x) {
    }

    @Override
    public boolean visit(OdpsAnalyzeTableStatement x) {
        this.print("ANALYZE TABLE ");
        x.getTable().accept(this);
        if (x.getPartition().size() > 0) {
            this.print(" PARTITION (");
            this.printAndAccept(x.getPartition(), ", ");
            this.print(")");
        }
        this.print(" COMPUTE STATISTICS");
        return false;
    }

    @Override
    public void endVisit(OdpsAddStatisticStatement x) {
    }

    @Override
    public boolean visit(OdpsAddStatisticStatement x) {
        this.print("ADD STATISTIC ");
        x.getTable().accept(this);
        this.print(" ");
        x.getStatisticClause().accept(this);
        return false;
    }

    @Override
    public void endVisit(OdpsRemoveStatisticStatement x) {
    }

    @Override
    public boolean visit(OdpsRemoveStatisticStatement x) {
        this.print("REMOVE STATISTIC ");
        x.getTable().accept(this);
        this.print(" ");
        x.getStatisticClause().accept(this);
        return false;
    }

    @Override
    public void endVisit(OdpsStatisticClause.TableCount x) {
    }

    @Override
    public boolean visit(OdpsStatisticClause.TableCount x) {
        this.print("TABLE_COUNT");
        return false;
    }

    @Override
    public void endVisit(OdpsStatisticClause.ExpressionCondition x) {
    }

    @Override
    public boolean visit(OdpsStatisticClause.ExpressionCondition x) {
        this.print("EXPRESSION_CONDITION ");
        x.getExpr().accept(this);
        return false;
    }

    @Override
    public void endVisit(OdpsStatisticClause.NullValue x) {
    }

    @Override
    public boolean visit(OdpsStatisticClause.NullValue x) {
        this.print("NULL_VALUE ");
        x.getColumn().accept(this);
        return false;
    }

    @Override
    public void endVisit(OdpsStatisticClause.ColumnSum x) {
    }

    @Override
    public boolean visit(OdpsStatisticClause.ColumnSum x) {
        this.print("COLUMN_SUM ");
        x.getColumn().accept(this);
        return false;
    }

    @Override
    public void endVisit(OdpsStatisticClause.ColumnMax x) {
    }

    @Override
    public boolean visit(OdpsStatisticClause.ColumnMax x) {
        this.print("COLUMN_MAX ");
        x.getColumn().accept(this);
        return false;
    }

    @Override
    public void endVisit(OdpsStatisticClause.ColumnMin x) {
    }

    @Override
    public boolean visit(OdpsStatisticClause.ColumnMin x) {
        this.print("COLUMN_MIN ");
        x.getColumn().accept(this);
        return false;
    }

    @Override
    public void endVisit(OdpsReadStatement x) {
    }

    @Override
    public boolean visit(OdpsReadStatement x) {
        this.print("READ ");
        x.getTable().accept(this);
        if (x.getColumns().size() > 0) {
            this.print(" (");
            this.printAndAccept(x.getColumns(), ", ");
            this.print(")");
        }
        if (x.getPartition().size() > 0) {
            this.print(" PARTITION (");
            this.printAndAccept(x.getPartition(), ", ");
            this.print(")");
        }
        if (x.getRowCount() != null) {
            this.print(' ');
            x.getRowCount().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLMethodInvokeExpr x) {
        if (x.getOwner() != null) {
            x.getOwner().accept(this);
            this.print(":");
        }
        this.printFunctionName(x.getMethodName());
        this.print("(");
        this.printAndAccept(x.getParameters(), ", ");
        this.print(")");
        return false;
    }

    @Override
    protected void printJoinType(SQLJoinTableSource.JoinType joinType) {
        if (joinType.equals((Object)SQLJoinTableSource.JoinType.LEFT_OUTER_JOIN)) {
            this.print("LEFT OUTER JOIN");
        } else if (joinType.equals((Object)SQLJoinTableSource.JoinType.RIGHT_OUTER_JOIN)) {
            this.print("RIGHT OUTER JOIN");
        } else if (joinType.equals((Object)SQLJoinTableSource.JoinType.FULL_OUTER_JOIN)) {
            this.print("FULL OUTER JOIN");
        } else {
            this.print(SQLJoinTableSource.JoinType.toString(joinType));
        }
    }

    @Override
    public boolean visit(SQLDataType x) {
        this.print(x.getName().toUpperCase());
        if (x.getArguments().size() > 0) {
            this.print("(");
            this.printAndAccept(x.getArguments(), ", ");
            this.print(")");
        }
        return false;
    }

    @Override
    protected void printFunctionName(String name) {
        String upperName = name.toUpperCase();
        if (this.builtInFunctions.contains(upperName)) {
            this.print(upperName);
        } else {
            this.print(name);
        }
    }
}

