/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.mysql.visitor;

import com.alibaba.druid.sql.ast.SQLCommentHint;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLCharactorDataType;
import com.alibaba.druid.sql.ast.statement.SQLColumnConstraint;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlForceIndexHint;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlIgnoreIndexHint;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlKey;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlPrimaryKey;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlUnique;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlUseIndexHint;
import com.alibaba.druid.sql.dialect.mysql.ast.MysqlForeignKey;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlBinaryExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlBooleanExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlCharExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlExtractExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlIntervalExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlMatchAgainstExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlOutFileExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlUserName;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.CobarShowStatus;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableAddColumn;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableChangeColumn;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableCharacter;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableDiscardTablespace;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableImportTablespace;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableModifyColumn;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableOption;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterUserStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAnalyzeStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlBinlogStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlCommitStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlCreateIndexStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlCreateTableStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlCreateUserStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlDeleteStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlDescribeStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlExecuteStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlHelpStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlInsertStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlKillStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlLoadDataInFileStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlLoadXmlStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlLockTableStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlOptimizeStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlPartitionByHash;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlPartitionByKey;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlPartitionByList;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlPartitionByRange;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlPartitioningDef;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlPrepareStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlRenameTableStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlReplaceStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlResetStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlRollbackStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSQLColumnDefinition;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectGroupBy;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSetCharSetStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSetNamesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSetPasswordStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSetTransactionIsolationLevelStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowAuthorsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowBinLogEventsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowBinaryLogsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCharacterSetStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCollationStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowColumnsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowContributorsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCreateDatabaseStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCreateEventStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCreateFunctionStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCreateProcedureStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCreateTableStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCreateTriggerStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCreateViewStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowDatabasesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowEngineStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowEnginesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowErrorsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowEventsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowFunctionCodeStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowFunctionStatusStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowGrantsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowIndexesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowKeysStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowMasterLogsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowMasterStatusStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowOpenTablesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowPluginsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowPrivilegesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowProcedureCodeStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowProcedureStatusStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowProcessListStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowProfileStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowProfilesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowRelayLogEventsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowSlaveHostsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowSlaveStatusStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowStatusStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowTableStatusStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowTablesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowTriggersStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowVariantsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowWarningsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlStartTransactionStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlTableIndex;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlUnionQuery;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlUnlockTablesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlUpdateStatement;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import java.util.List;
import java.util.Map;

public class MySqlOutputVisitor
extends SQLASTOutputVisitor
implements MySqlASTVisitor {
    public MySqlOutputVisitor(Appendable appender) {
        super(appender);
    }

    @Override
    public boolean visit(MySqlBooleanExpr x) {
        this.print(x.getValue() ? "true" : "false");
        return false;
    }

    @Override
    public void endVisit(MySqlBooleanExpr x) {
    }

    @Override
    public boolean visit(SQLSelectQueryBlock select) {
        if (select instanceof MySqlSelectQueryBlock) {
            return this.visit((MySqlSelectQueryBlock)select);
        }
        return false;
    }

    @Override
    public boolean visit(MySqlSelectQueryBlock x) {
        if (x.getOrderBy() != null) {
            x.getOrderBy().setParent(x);
        }
        this.print("SELECT ");
        int size = x.getHintsSize();
        for (int i = 0; i < size; ++i) {
            SQLCommentHint hint = x.getHints().get(i);
            hint.accept(this);
            this.print(' ');
        }
        if (1 == x.getDistionOption()) {
            this.print("ALL ");
        } else if (2 == x.getDistionOption()) {
            this.print("DISTINCT ");
        } else if (4 == x.getDistionOption()) {
            this.print("DISTINCTROW ");
        }
        if (x.isHignPriority()) {
            this.print("HIGH_PRIORITY ");
        }
        if (x.isStraightJoin()) {
            this.print("STRAIGHT_JOIN ");
        }
        if (x.isSmallResult()) {
            this.print("SQL_SMALL_RESULT ");
        }
        if (x.isBigResult()) {
            this.print("SQL_BIG_RESULT ");
        }
        if (x.isBufferResult()) {
            this.print("SQL_BUFFER_RESULT ");
        }
        if (x.getCache() != null) {
            if (x.getCache().booleanValue()) {
                this.print("SQL_CACHE ");
            } else {
                this.print("SQL_NO_CACHE ");
            }
        }
        if (x.isCalcFoundRows()) {
            this.print("SQL_CALC_FOUND_ROWS ");
        }
        this.printSelectList(x.getSelectList());
        if (x.getInto() != null) {
            this.println();
            this.print("INTO ");
            x.getInto().accept(this);
        }
        if (x.getFrom() != null) {
            this.println();
            this.print("FROM ");
            x.getFrom().accept(this);
        }
        if (x.getWhere() != null) {
            this.println();
            this.print("WHERE ");
            x.getWhere().setParent(x);
            x.getWhere().accept(this);
        }
        if (x.getGroupBy() != null) {
            this.println();
            x.getGroupBy().accept(this);
        }
        if (x.getOrderBy() != null) {
            this.println();
            x.getOrderBy().accept(this);
        }
        if (x.getLimit() != null) {
            this.println();
            x.getLimit().accept(this);
        }
        if (x.getProcedureName() != null) {
            this.print(" PROCEDURE ");
            x.getProcedureName().accept(this);
            if (x.getProcedureArgumentList().size() > 0) {
                this.print("(");
                this.printAndAccept(x.getProcedureArgumentList(), ", ");
                this.print(")");
            }
        }
        if (x.isForUpdate()) {
            this.println();
            this.print("FOR UPDATE");
        }
        if (x.isLockInShareMode()) {
            this.println();
            this.print("LOCK IN SHARE MODE");
        }
        return false;
    }

    @Override
    public boolean visit(SQLColumnDefinition x) {
        MySqlSQLColumnDefinition mysqlColumn = null;
        if (x instanceof MySqlSQLColumnDefinition) {
            mysqlColumn = (MySqlSQLColumnDefinition)x;
        }
        x.getName().accept(this);
        this.print(' ');
        x.getDataType().accept(this);
        if (x.getDefaultExpr() != null) {
            if (x.getDefaultExpr() instanceof SQLNullExpr) {
                this.print(" NULL");
            } else {
                this.print(" DEFAULT ");
                x.getDefaultExpr().accept(this);
            }
        }
        if (mysqlColumn != null && mysqlColumn.getStorage() != null) {
            this.print(" STORAGE ");
            mysqlColumn.getStorage().accept(this);
        }
        if (mysqlColumn != null && mysqlColumn.getOnUpdate() != null) {
            this.print(" ON UPDATE ");
            mysqlColumn.getOnUpdate().accept(this);
        }
        if (mysqlColumn != null && mysqlColumn.isAutoIncrement()) {
            this.print(" AUTO_INCREMENT");
        }
        for (SQLColumnConstraint item : x.getConstaints()) {
            this.print(' ');
            item.accept(this);
        }
        if (x.getComment() != null) {
            this.print(" COMMENT ");
            x.getComment().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(MySqlSelectQueryBlock.Limit x) {
        this.print("LIMIT ");
        if (x.getOffset() != null) {
            x.getOffset().accept(this);
            this.print(", ");
        }
        x.getRowCount().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLDataType x) {
        SQLCharactorDataType charType;
        this.print(x.getName());
        if (x.getArguments().size() > 0) {
            this.print("(");
            this.printAndAccept(x.getArguments(), ", ");
            this.print(")");
        }
        if (Boolean.TRUE == x.getAttribute("unsigned")) {
            this.print(" unsigned");
        }
        if (x instanceof SQLCharactorDataType && (charType = (SQLCharactorDataType)x).getCharSetName() != null) {
            this.print(" CHARACTER SET ");
            this.print(charType.getCharSetName());
            if (charType.getCollate() != null) {
                this.print(" COLLATE ");
                this.print(charType.getCollate());
            }
        }
        return false;
    }

    @Override
    public boolean visit(SQLCharactorDataType x) {
        this.print(x.getName());
        if (x.getArguments().size() > 0) {
            this.print("(");
            this.printAndAccept(x.getArguments(), ", ");
            this.print(")");
        }
        if (x.getCharSetName() != null) {
            this.print(" CHARACTER SET ");
            this.print(x.getCharSetName());
            if (x.getCollate() != null) {
                this.print(" COLLATE ");
                this.print(x.getCollate());
            }
        }
        return false;
    }

    @Override
    public void endVisit(MySqlSelectQueryBlock.Limit x) {
    }

    @Override
    public void endVisit(MySqlTableIndex x) {
    }

    @Override
    public boolean visit(MySqlTableIndex x) {
        this.print("INDEX");
        if (x.getName() != null) {
            this.print(" ");
            x.getName().accept(this);
        }
        if (x.getIndexType() != null) {
            this.print(" USING ");
            this.print(x.getIndexType());
        }
        this.print("(");
        int size = x.getColumns().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.print(", ");
            }
            x.getColumns().get(i).accept(this);
        }
        this.print(")");
        return false;
    }

    @Override
    public boolean visit(MySqlCreateTableStatement x) {
        int size;
        this.print("CREATE ");
        for (SQLCommentHint hint : x.getHints()) {
            hint.accept(this);
            this.print(' ');
        }
        if (SQLCreateTableStatement.Type.GLOBAL_TEMPORARY.equals((Object)x.getType())) {
            this.print("TEMPORARY TABLE ");
        } else {
            this.print("TABLE ");
        }
        if (x.isIfNotExiists()) {
            this.print("IF NOT EXISTS ");
        }
        x.getName().accept(this);
        if (x.getLike() != null) {
            this.print(" LIKE ");
            x.getLike().accept(this);
        }
        if ((size = x.getTableElementList().size()) > 0) {
            this.print(" (");
            this.incrementIndent();
            this.println();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    this.print(", ");
                    this.println();
                }
                x.getTableElementList().get(i).accept(this);
            }
            this.decrementIndent();
            this.println();
            this.print(")");
        }
        for (Map.Entry<String, SQLObject> option : x.getTableOptions().entrySet()) {
            String key = option.getKey();
            this.print(' ');
            this.print(key);
            if ("TABLESPACE".equals(key)) {
                this.print(' ');
                option.getValue().accept(this);
                continue;
            }
            this.print(" = ");
            option.getValue().accept(this);
        }
        if (x.getPartitioning() != null) {
            this.print(' ');
            x.getPartitioning().accept(this);
        }
        if (x.getQuery() != null) {
            this.incrementIndent();
            this.println();
            x.getQuery().accept(this);
            this.decrementIndent();
        }
        return false;
    }

    @Override
    public void endVisit(MySqlKey x) {
    }

    @Override
    public void endVisit(MySqlPrimaryKey x) {
    }

    @Override
    public void endVisit(MysqlForeignKey x) {
    }

    @Override
    public boolean visit(MySqlKey x) {
        if (x.isHasConstaint()) {
            this.print("CONSTRAINT ");
            if (x.getName() != null) {
                x.getName().accept(this);
                this.print(' ');
            }
        }
        this.print("KEY");
        if (x.getIndexName() != null) {
            this.print(' ');
            x.getIndexName().accept(this);
        }
        if (x.getIndexType() != null) {
            this.print(" USING ");
            this.print(x.getIndexType());
        }
        this.print(" (");
        int size = x.getColumns().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.print(", ");
            }
            x.getColumns().get(i).accept(this);
        }
        this.print(")");
        return false;
    }

    @Override
    public boolean visit(MySqlPrimaryKey x) {
        if (x.getName() != null) {
            this.print("CONSTRAINT ");
            x.getName().accept(this);
            this.print(' ');
        }
        this.print("PRIMARY KEY");
        if (x.getIndexType() != null) {
            this.print(" USING ");
            this.print(x.getIndexType());
        }
        this.print(" (");
        int size = x.getColumns().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.print(", ");
            }
            x.getColumns().get(i).accept(this);
        }
        this.print(")");
        return false;
    }

    @Override
    public boolean visit(SQLCharExpr x) {
        this.print('\'');
        String text = x.getText();
        text = text.replaceAll("'", "''");
        text = text.replaceAll("\\\\", "\\\\");
        this.print(text);
        this.print('\'');
        return false;
    }

    @Override
    public boolean visit(SQLVariantRefExpr x) {
        int parametersSize = this.getParametersSize();
        int index = x.getIndex();
        if (index >= 0 && index < parametersSize) {
            Object param = this.getParameters().get(index);
            this.printParameter(param);
            return false;
        }
        String varName = x.getName();
        if (x.isGlobal()) {
            this.print("@@global.");
        } else if (!(varName.startsWith("@") || varName.equals("?") || varName.startsWith("#") || varName.startsWith("$") || varName.startsWith(":"))) {
            this.print("@@");
        }
        for (int i = 0; i < x.getName().length(); ++i) {
            char ch = x.getName().charAt(i);
            if (ch == '\'') {
                if (x.getName().startsWith("@@") && i == 2) {
                    this.print(ch);
                    continue;
                }
                if (x.getName().startsWith("@") && i == 1) {
                    this.print(ch);
                    continue;
                }
                if (i != 0 && i != x.getName().length() - 1) {
                    this.print("\\'");
                    continue;
                }
                this.print(ch);
                continue;
            }
            this.print(ch);
        }
        String collate = (String)x.getAttribute("COLLATE");
        if (collate != null) {
            this.print(" COLLATE ");
            this.print(collate);
        }
        return false;
    }

    @Override
    public boolean visit(SQLMethodInvokeExpr x) {
        if ("SUBSTRING".equalsIgnoreCase(x.getMethodName())) {
            SQLExpr forExpr;
            if (x.getOwner() != null) {
                x.getOwner().accept(this);
                this.print(".");
            }
            this.print(x.getMethodName());
            this.print("(");
            this.printAndAccept(x.getParameters(), ", ");
            SQLExpr from = (SQLExpr)x.getAttribute("FROM");
            if (from != null) {
                this.print(" FROM ");
                from.accept(this);
            }
            if ((forExpr = (SQLExpr)x.getAttribute("FOR")) != null) {
                this.print(" FOR ");
                forExpr.accept(this);
            }
            this.print(")");
            return false;
        }
        if ("TRIM".equalsIgnoreCase(x.getMethodName())) {
            if (x.getOwner() != null) {
                x.getOwner().accept(this);
                this.print(".");
            }
            this.print(x.getMethodName());
            this.print("(");
            String trimType = (String)x.getAttribute("TRIM_TYPE");
            if (trimType != null) {
                this.print(trimType);
                this.print(' ');
            }
            this.printAndAccept(x.getParameters(), ", ");
            SQLExpr from = (SQLExpr)x.getAttribute("FROM");
            if (from != null) {
                this.print(" FROM ");
                from.accept(this);
            }
            this.print(")");
            return false;
        }
        if ("CONVERT".equalsIgnoreCase(x.getMethodName())) {
            if (x.getOwner() != null) {
                x.getOwner().accept(this);
                this.print(".");
            }
            this.print(x.getMethodName());
            this.print("(");
            this.printAndAccept(x.getParameters(), ", ");
            String charset = (String)x.getAttribute("USING");
            if (charset != null) {
                this.print(" USING ");
                this.print(charset);
            }
            this.print(")");
            return false;
        }
        return super.visit(x);
    }

    @Override
    public void endVisit(MySqlIntervalExpr x) {
    }

    @Override
    public boolean visit(MySqlIntervalExpr x) {
        this.print("INTERVAL ");
        x.getValue().accept(this);
        this.print(' ');
        this.print(x.getUnit().name());
        return false;
    }

    @Override
    public boolean visit(MySqlExtractExpr x) {
        this.print("EXTRACT(");
        this.print(x.getUnit().name());
        this.print(" FROM ");
        x.getValue().accept(this);
        this.print(')');
        return false;
    }

    @Override
    public void endVisit(MySqlExtractExpr x) {
    }

    @Override
    public void endVisit(MySqlMatchAgainstExpr x) {
    }

    @Override
    public boolean visit(MySqlMatchAgainstExpr x) {
        this.print("MATCH (");
        this.printAndAccept(x.getColumns(), ", ");
        this.print(")");
        this.print(" AGAINST (");
        x.getAgainst().accept(this);
        if (x.getSearchModifier() != null) {
            this.print(' ');
            this.print(x.getSearchModifier().name);
        }
        this.print(')');
        return false;
    }

    @Override
    public void endVisit(MySqlBinaryExpr x) {
    }

    @Override
    public boolean visit(MySqlBinaryExpr x) {
        this.print("b'");
        this.print(x.getValue());
        this.print('\'');
        return false;
    }

    @Override
    public void endVisit(MySqlPrepareStatement x) {
    }

    @Override
    public boolean visit(MySqlPrepareStatement x) {
        this.print("PREPARE ");
        x.getName().accept(this);
        this.print(" FROM ");
        x.getFrom().accept(this);
        return false;
    }

    @Override
    public void endVisit(MySqlExecuteStatement x) {
    }

    @Override
    public boolean visit(MySqlExecuteStatement x) {
        this.print("EXECUTE ");
        x.getStatementName().accept(this);
        if (x.getParameters().size() > 0) {
            this.print(" USING ");
            this.printAndAccept(x.getParameters(), ", ");
        }
        return false;
    }

    @Override
    public void endVisit(MySqlDeleteStatement x) {
    }

    @Override
    public boolean visit(MySqlDeleteStatement x) {
        this.print("DELETE ");
        if (x.isLowPriority()) {
            this.print("LOW_PRIORITY ");
        }
        if (x.isQuick()) {
            this.print("QUICK ");
        }
        if (x.isIgnore()) {
            this.print("IGNORE ");
        }
        if (x.getFrom() == null) {
            this.print("FROM ");
            x.getTableSource().accept(this);
        } else {
            x.getTableSource().accept(this);
            this.println();
            this.print("FROM ");
            x.getFrom().accept(this);
        }
        if (x.getUsing() != null) {
            this.println();
            this.print("USING ");
            x.getUsing().accept(this);
        }
        if (x.getWhere() != null) {
            this.println();
            this.incrementIndent();
            this.print("WHERE ");
            x.getWhere().setParent(x);
            x.getWhere().accept(this);
            this.decrementIndent();
        }
        if (x.getOrderBy() != null) {
            this.println();
            x.getOrderBy().accept(this);
        }
        if (x.getLimit() != null) {
            this.println();
            x.getLimit().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlInsertStatement x) {
    }

    @Override
    public boolean visit(MySqlInsertStatement x) {
        int i;
        int size;
        this.print("INSERT ");
        if (x.isLowPriority()) {
            this.print("LOW_PRIORITY ");
        }
        if (x.isDelayed()) {
            this.print("DELAYED ");
        }
        if (x.isHighPriority()) {
            this.print("HIGH_PRIORITY ");
        }
        if (x.isIgnore()) {
            this.print("IGNORE ");
        }
        this.print("INTO ");
        x.getTableSource().accept(this);
        if (x.getColumns().size() > 0) {
            this.incrementIndent();
            this.print(" (");
            size = x.getColumns().size();
            for (i = 0; i < size; ++i) {
                if (i != 0) {
                    if (i % 5 == 0) {
                        this.println();
                    }
                    this.print(", ");
                }
                x.getColumns().get(i).accept(this);
            }
            this.print(")");
            this.decrementIndent();
        }
        if (x.getValuesList().size() != 0) {
            this.println();
            this.printValuesList(x);
        }
        if (x.getQuery() != null) {
            this.println();
            x.getQuery().accept(this);
        }
        if (x.getDuplicateKeyUpdate().size() != 0) {
            this.println();
            this.print("ON DUPLICATE KEY UPDATE ");
            size = x.getDuplicateKeyUpdate().size();
            for (i = 0; i < size; ++i) {
                if (i != 0) {
                    if (i % 5 == 0) {
                        this.println();
                    }
                    this.print(", ");
                }
                x.getDuplicateKeyUpdate().get(i).accept(this);
            }
        }
        return false;
    }

    protected void printValuesList(MySqlInsertStatement x) {
        this.print("VALUES ");
        if (x.getValuesList().size() > 1) {
            this.incrementIndent();
        }
        int size = x.getValuesList().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.print(",");
                this.println();
            }
            x.getValuesList().get(i).accept(this);
        }
        if (x.getValuesList().size() > 1) {
            this.decrementIndent();
        }
    }

    @Override
    public void endVisit(MySqlLoadDataInFileStatement x) {
    }

    @Override
    public boolean visit(MySqlLoadDataInFileStatement x) {
        this.print("LOAD DATA ");
        if (x.isLowPriority()) {
            this.print("LOW_PRIORITY ");
        }
        if (x.isConcurrent()) {
            this.print("CONCURRENT ");
        }
        if (x.isLocal()) {
            this.print("LOCAL ");
        }
        this.print("INFILE ");
        x.getFileName().accept(this);
        if (x.isReplicate()) {
            this.print(" REPLACE ");
        }
        if (x.isIgnore()) {
            this.print(" IGNORE ");
        }
        this.print(" INTO TABLE ");
        x.getTableName().accept(this);
        if (x.getColumnsTerminatedBy() != null || x.getColumnsEnclosedBy() != null || x.getColumnsEscaped() != null) {
            this.print(" COLUMNS");
            if (x.getColumnsTerminatedBy() != null) {
                this.print(" TERMINATED BY ");
                x.getColumnsTerminatedBy().accept(this);
            }
            if (x.getColumnsEnclosedBy() != null) {
                if (x.isColumnsEnclosedOptionally()) {
                    this.print(" OPTIONALLY");
                }
                this.print(" ENCLOSED BY ");
                x.getColumnsEnclosedBy().accept(this);
            }
            if (x.getColumnsEscaped() != null) {
                this.print(" ESCAPED BY ");
                x.getColumnsEscaped().accept(this);
            }
        }
        if (x.getLinesStartingBy() != null || x.getLinesTerminatedBy() != null) {
            this.print(" LINES");
            if (x.getLinesStartingBy() != null) {
                this.print(" STARTING BY ");
                x.getLinesStartingBy().accept(this);
            }
            if (x.getLinesTerminatedBy() != null) {
                this.print(" TERMINATED BY ");
                x.getLinesTerminatedBy().accept(this);
            }
        }
        if (x.getSetList().size() != 0) {
            this.print(" SET ");
            this.printAndAccept(x.getSetList(), ", ");
        }
        return false;
    }

    @Override
    public void endVisit(MySqlReplaceStatement x) {
    }

    @Override
    public boolean visit(MySqlReplaceStatement x) {
        this.print("REPLACE ");
        if (x.isLowPriority()) {
            this.print("LOW_PRIORITY ");
        }
        if (x.isDelayed()) {
            this.print("DELAYED ");
        }
        this.print("INTO ");
        x.getTableName().accept(this);
        if (x.getColumns().size() > 0) {
            this.print(" (");
            int size = x.getColumns().size();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    this.print(", ");
                }
                x.getColumns().get(i).accept(this);
            }
            this.print(")");
        }
        if (x.getValuesList().size() != 0) {
            this.println();
            this.print("VALUES ");
            int size = x.getValuesList().size();
            if (size == 0) {
                this.print("()");
            } else {
                for (int i = 0; i < size; ++i) {
                    if (i != 0) {
                        this.print(", ");
                    }
                    x.getValuesList().get(i).accept(this);
                }
            }
        }
        if (x.getQuery() != null) {
            x.getQuery().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlSelectGroupBy x) {
    }

    @Override
    public boolean visit(MySqlSelectGroupBy x) {
        super.visit(x);
        if (x.isRollUp()) {
            this.print(" WITH ROLLUP");
        }
        return false;
    }

    @Override
    public void endVisit(MySqlStartTransactionStatement x) {
    }

    @Override
    public boolean visit(MySqlStartTransactionStatement x) {
        this.print("START TRANSACTION");
        if (x.isConsistentSnapshot()) {
            this.print(" WITH CONSISTENT SNAPSHOT");
        }
        if (x.isBegin()) {
            this.print(" BEGIN");
        }
        if (x.isWork()) {
            this.print(" WORK");
        }
        return false;
    }

    @Override
    public void endVisit(MySqlCommitStatement x) {
    }

    @Override
    public boolean visit(MySqlCommitStatement x) {
        this.print("COMMIT");
        if (x.isWork()) {
            this.print(" WORK");
        }
        if (x.getChain() != null) {
            if (x.getChain().booleanValue()) {
                this.print(" AND CHAIN");
            } else {
                this.print(" AND NO CHAIN");
            }
        }
        if (x.getRelease() != null) {
            if (x.getRelease().booleanValue()) {
                this.print(" AND RELEASE");
            } else {
                this.print(" AND NO RELEASE");
            }
        }
        return false;
    }

    @Override
    public void endVisit(MySqlRollbackStatement x) {
    }

    @Override
    public boolean visit(MySqlRollbackStatement x) {
        this.print("ROLLBACK");
        if (x.getChain() != null) {
            if (x.getChain().booleanValue()) {
                this.print(" AND CHAIN");
            } else {
                this.print(" AND NO CHAIN");
            }
        }
        if (x.getRelease() != null) {
            if (x.getRelease().booleanValue()) {
                this.print(" AND RELEASE");
            } else {
                this.print(" AND NO RELEASE");
            }
        }
        if (x.getTo() != null) {
            this.print(" TO ");
            x.getTo().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowColumnsStatement x) {
    }

    @Override
    public boolean visit(MySqlShowColumnsStatement x) {
        if (x.isFull()) {
            this.print("SHOW FULL COLUMNS");
        } else {
            this.print("SHOW COLUMNS");
        }
        if (x.getTable() != null) {
            this.print(" FROM ");
            if (x.getDatabase() != null) {
                x.getDatabase().accept(this);
                this.print('.');
            }
            x.getTable().accept(this);
        }
        if (x.getLike() != null) {
            this.print(" LIKE ");
            x.getLike().accept(this);
        }
        if (x.getWhere() != null) {
            this.print(" WHERE ");
            x.getWhere().setParent(x);
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowTablesStatement x) {
    }

    @Override
    public boolean visit(MySqlShowTablesStatement x) {
        if (x.isFull()) {
            this.print("SHOW FULL TABLES");
        } else {
            this.print("SHOW TABLES");
        }
        if (x.getDatabase() != null) {
            this.print(" FROM ");
            x.getDatabase().accept(this);
        }
        if (x.getLike() != null) {
            this.print(" LIKE ");
            x.getLike().accept(this);
        }
        if (x.getWhere() != null) {
            this.print(" WHERE ");
            x.getWhere().setParent(x);
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowDatabasesStatement x) {
    }

    @Override
    public boolean visit(MySqlShowDatabasesStatement x) {
        this.print("SHOW DATABASES");
        if (x.getLike() != null) {
            this.print(" LIKE ");
            x.getLike().accept(this);
        }
        if (x.getWhere() != null) {
            this.print(" WHERE ");
            x.getWhere().setParent(x);
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowWarningsStatement x) {
    }

    @Override
    public boolean visit(MySqlShowWarningsStatement x) {
        if (x.isCount()) {
            this.print("SHOW COUNT(*) WARNINGS");
        } else {
            this.print("SHOW WARNINGS");
            if (x.getLimit() != null) {
                this.print(' ');
                x.getLimit().accept(this);
            }
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowStatusStatement x) {
    }

    @Override
    public boolean visit(MySqlShowStatusStatement x) {
        this.print("SHOW ");
        if (x.isGlobal()) {
            this.print("GLOBAL ");
        }
        if (x.isSession()) {
            this.print("SESSION ");
        }
        this.print("STATUS");
        if (x.getLike() != null) {
            this.print(" LIKE ");
            x.getLike().accept(this);
        }
        if (x.getWhere() != null) {
            this.print(" WHERE ");
            x.getWhere().setParent(x);
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlLoadXmlStatement x) {
    }

    @Override
    public boolean visit(MySqlLoadXmlStatement x) {
        this.print("LOAD XML ");
        if (x.isLowPriority()) {
            this.print("LOW_PRIORITY ");
        }
        if (x.isConcurrent()) {
            this.print("CONCURRENT ");
        }
        if (x.isLocal()) {
            this.print("LOCAL ");
        }
        this.print("INFILE ");
        x.getFileName().accept(this);
        if (x.isReplicate()) {
            this.print(" REPLACE ");
        }
        if (x.isIgnore()) {
            this.print(" IGNORE ");
        }
        this.print(" INTO TABLE ");
        x.getTableName().accept(this);
        if (x.getCharset() != null) {
            this.print(" CHARSET ");
            this.print(x.getCharset());
        }
        if (x.getRowsIdentifiedBy() != null) {
            this.print(" ROWS IDENTIFIED BY ");
            x.getRowsIdentifiedBy().accept(this);
        }
        if (x.getSetList().size() != 0) {
            this.print(" SET ");
            this.printAndAccept(x.getSetList(), ", ");
        }
        return false;
    }

    @Override
    public void endVisit(CobarShowStatus x) {
    }

    @Override
    public boolean visit(CobarShowStatus x) {
        this.print("SHOW COBAR_STATUS");
        return false;
    }

    @Override
    public void endVisit(MySqlKillStatement x) {
    }

    @Override
    public boolean visit(MySqlKillStatement x) {
        if (MySqlKillStatement.Type.CONNECTION.equals((Object)x.getType())) {
            this.print("KILL CONNECTION ");
        } else if (MySqlKillStatement.Type.QUERY.equals((Object)x.getType())) {
            this.print("KILL QUERY ");
        }
        x.getThreadId().accept(this);
        return false;
    }

    @Override
    public void endVisit(MySqlBinlogStatement x) {
    }

    @Override
    public boolean visit(MySqlBinlogStatement x) {
        this.print("BINLOG ");
        x.getExpr().accept(this);
        return false;
    }

    @Override
    public void endVisit(MySqlResetStatement x) {
    }

    @Override
    public boolean visit(MySqlResetStatement x) {
        this.print("RESET ");
        for (int i = 0; i < x.getOptions().size(); ++i) {
            if (i != 0) {
                this.print(", ");
            }
            this.print(x.getOptions().get(i));
        }
        return false;
    }

    @Override
    public void endVisit(MySqlCreateUserStatement x) {
    }

    @Override
    public boolean visit(MySqlCreateUserStatement x) {
        this.print("CREATE USER ");
        this.printAndAccept(x.getUsers(), ", ");
        return false;
    }

    @Override
    public void endVisit(MySqlCreateUserStatement.UserSpecification x) {
    }

    @Override
    public boolean visit(MySqlCreateUserStatement.UserSpecification x) {
        x.getUser().accept(this);
        if (x.getPassword() != null) {
            this.print(" IDENTIFIED BY ");
            if (x.isPasswordHash()) {
                this.print("PASSWORD ");
            }
            x.getPassword().accept(this);
        }
        if (x.getAuthPlugin() != null) {
            this.print(" IDENTIFIED WITH ");
            x.getAuthPlugin().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlPartitionByKey x) {
    }

    @Override
    public boolean visit(MySqlPartitionByKey x) {
        if (x.isLinear()) {
            this.print("PARTITION BY LINEAR KEY (");
        } else {
            this.print("PARTITION BY KEY (");
        }
        this.printAndAccept(x.getColumns(), ", ");
        this.print(")");
        if (x.getPartitionCount() != null) {
            this.print(" PARTITIONS ");
            x.getPartitionCount().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlPartitionByRange x) {
    }

    @Override
    public boolean visit(MySqlPartitionByRange x) {
        List<MySqlPartitioningDef> partitions;
        int partitionsSize;
        this.print("PARTITION BY RANGE");
        if (x.getExpr() != null) {
            this.print(" (");
            x.getExpr().accept(this);
            this.print(")");
        } else {
            this.print(" COLUMNS (");
            this.printAndAccept(x.getColumns(), ", ");
            this.print(")");
        }
        if (x.getPartitionCount() != null) {
            this.print(" PARTITIONS ");
            x.getPartitionCount().accept(this);
        }
        if ((partitionsSize = (partitions = x.getPartitions()).size()) > 0) {
            this.print("(");
            this.incrementIndent();
            for (int i = 0; i < partitionsSize; ++i) {
                this.println();
                partitions.get(i).accept(this);
                if (i == partitionsSize - 1) continue;
                this.print(", ");
            }
            this.decrementIndent();
            this.println();
            this.print(")");
        }
        return false;
    }

    @Override
    public void endVisit(MySqlPartitionByList x) {
    }

    @Override
    public boolean visit(MySqlPartitionByList x) {
        List<MySqlPartitioningDef> partitions;
        int partitionsSize;
        this.print("PARTITION BY LIST ");
        if (x.getExpr() != null) {
            this.print("(");
            x.getExpr().accept(this);
            this.print(") ");
        } else {
            this.print("COLUMNS (");
            this.printAndAccept(x.getColumns(), ", ");
            this.print(") ");
        }
        if (x.getPartitionCount() != null) {
            this.print(" PARTITIONS ");
            x.getPartitionCount().accept(this);
        }
        if ((partitionsSize = (partitions = x.getPartitions()).size()) > 0) {
            this.print("(");
            this.incrementIndent();
            for (int i = 0; i < partitionsSize; ++i) {
                this.println();
                partitions.get(i).accept(this);
                if (i == partitionsSize - 1) continue;
                this.print(", ");
            }
            this.decrementIndent();
            this.println();
            this.print(")");
        }
        return false;
    }

    @Override
    public void endVisit(MySqlPartitionByHash x) {
    }

    @Override
    public boolean visit(MySqlPartitionByHash x) {
        if (x.isLinear()) {
            this.print("PARTITION BY LINEAR HASH (");
        } else {
            this.print("PARTITION BY HASH (");
        }
        x.getExpr().accept(this);
        this.print(")");
        if (x.getPartitionCount() != null) {
            this.print(" PARTITIONS ");
            x.getPartitionCount().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlSelectQueryBlock x) {
    }

    @Override
    public boolean visit(MySqlOutFileExpr x) {
        this.print("OUTFILE ");
        x.getFile().accept(this);
        if (x.getCharset() != null) {
            this.print(" CHARACTER SET ");
            this.print(x.getCharset());
        }
        if (x.getColumnsTerminatedBy() != null || x.getColumnsEnclosedBy() != null || x.getColumnsEscaped() != null) {
            this.print(" COLUMNS");
            if (x.getColumnsTerminatedBy() != null) {
                this.print(" TERMINATED BY ");
                x.getColumnsTerminatedBy().accept(this);
            }
            if (x.getColumnsEnclosedBy() != null) {
                if (x.isColumnsEnclosedOptionally()) {
                    this.print(" OPTIONALLY");
                }
                this.print(" ENCLOSED BY ");
                x.getColumnsEnclosedBy().accept(this);
            }
            if (x.getColumnsEscaped() != null) {
                this.print(" ESCAPED BY ");
                x.getColumnsEscaped().accept(this);
            }
        }
        if (x.getLinesStartingBy() != null || x.getLinesTerminatedBy() != null) {
            this.print(" LINES");
            if (x.getLinesStartingBy() != null) {
                this.print(" STARTING BY ");
                x.getLinesStartingBy().accept(this);
            }
            if (x.getLinesTerminatedBy() != null) {
                this.print(" TERMINATED BY ");
                x.getLinesTerminatedBy().accept(this);
            }
        }
        return false;
    }

    @Override
    public void endVisit(MySqlOutFileExpr x) {
    }

    @Override
    public boolean visit(MySqlDescribeStatement x) {
        this.print("DESC ");
        x.getObject().accept(this);
        return false;
    }

    @Override
    public void endVisit(MySqlDescribeStatement x) {
    }

    @Override
    public boolean visit(MySqlUpdateStatement x) {
        this.print("UPDATE ");
        if (x.isLowPriority()) {
            this.print("LOW_PRIORITY ");
        }
        if (x.isIgnore()) {
            this.print("IGNORE ");
        }
        x.getTableSource().accept(this);
        this.println();
        this.print("SET ");
        int size = x.getItems().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.print(", ");
            }
            x.getItems().get(i).accept(this);
        }
        if (x.getWhere() != null) {
            this.println();
            this.incrementIndent();
            this.print("WHERE ");
            x.getWhere().setParent(x);
            x.getWhere().accept(this);
            this.decrementIndent();
        }
        if (x.getOrderBy() != null) {
            this.println();
            x.getOrderBy().accept(this);
        }
        if (x.getLimit() != null) {
            this.println();
            x.getLimit().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlUpdateStatement x) {
    }

    @Override
    public boolean visit(MySqlSetTransactionIsolationLevelStatement x) {
        return false;
    }

    @Override
    public void endVisit(MySqlSetTransactionIsolationLevelStatement x) {
        if (x.getGlobal() == null) {
            this.print("SET TRANSACTION ISOLATION LEVEL ");
        } else if (x.getGlobal().booleanValue()) {
            this.print("SET GLOBAL TRANSACTION ISOLATION LEVEL ");
        } else {
            this.print("SET SESSION TRANSACTION ISOLATION LEVEL ");
        }
        this.print(x.getLevel());
    }

    @Override
    public boolean visit(MySqlSetNamesStatement x) {
        this.print("SET NAMES ");
        if (x.isDefault()) {
            this.print("DEFAULT");
        } else {
            this.print(x.getCharSet());
            if (x.getCollate() != null) {
                this.print(" COLLATE ");
                this.print(x.getCollate());
            }
        }
        return false;
    }

    @Override
    public void endVisit(MySqlSetNamesStatement x) {
    }

    @Override
    public boolean visit(MySqlSetCharSetStatement x) {
        this.print("SET CHARACTER SET ");
        if (x.isDefault()) {
            this.print("DEFAULT");
        } else {
            this.print(x.getCharSet());
            if (x.getCollate() != null) {
                this.print(" COLLATE ");
                this.print(x.getCollate());
            }
        }
        return false;
    }

    @Override
    public void endVisit(MySqlSetCharSetStatement x) {
    }

    @Override
    public void endVisit(MySqlShowAuthorsStatement x) {
    }

    @Override
    public boolean visit(MySqlShowAuthorsStatement x) {
        this.print("SHOW AUTHORS");
        return false;
    }

    @Override
    public void endVisit(MySqlShowBinaryLogsStatement x) {
    }

    @Override
    public boolean visit(MySqlShowBinaryLogsStatement x) {
        this.print("SHOW BINARY LOGS");
        return false;
    }

    @Override
    public boolean visit(MySqlShowMasterLogsStatement x) {
        this.print("SHOW MASTER LOGS");
        return false;
    }

    @Override
    public void endVisit(MySqlShowMasterLogsStatement x) {
    }

    @Override
    public boolean visit(MySqlShowCollationStatement x) {
        this.print("SHOW COLLATION");
        if (x.getPattern() != null) {
            this.print(" LIKE ");
            x.getPattern().accept(this);
        }
        if (x.getWhere() != null) {
            this.print(" WHERE ");
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowCollationStatement x) {
    }

    @Override
    public boolean visit(MySqlShowBinLogEventsStatement x) {
        this.print("SHOW BINLOG EVENTS");
        if (x.getIn() != null) {
            this.print(" IN ");
            x.getIn().accept(this);
        }
        if (x.getFrom() != null) {
            this.print(" FROM ");
            x.getFrom().accept(this);
        }
        if (x.getLimit() != null) {
            this.print(" ");
            x.getLimit().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowBinLogEventsStatement x) {
    }

    @Override
    public boolean visit(MySqlShowCharacterSetStatement x) {
        this.print("SHOW CHARACTER SET");
        if (x.getPattern() != null) {
            this.print(" LIKE ");
            x.getPattern().accept(this);
        }
        if (x.getWhere() != null) {
            this.print(" WHERE ");
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowCharacterSetStatement x) {
    }

    @Override
    public boolean visit(MySqlShowContributorsStatement x) {
        this.print("SHOW CONTRIBUTORS");
        return false;
    }

    @Override
    public void endVisit(MySqlShowContributorsStatement x) {
    }

    @Override
    public boolean visit(MySqlShowCreateDatabaseStatement x) {
        this.print("SHOW CREATE DATABASE ");
        x.getDatabase().accept(this);
        return false;
    }

    @Override
    public void endVisit(MySqlShowCreateDatabaseStatement x) {
    }

    @Override
    public boolean visit(MySqlShowCreateEventStatement x) {
        this.print("SHOW CREATE EVENT ");
        x.getEventName().accept(this);
        return false;
    }

    @Override
    public void endVisit(MySqlShowCreateEventStatement x) {
    }

    @Override
    public boolean visit(MySqlShowCreateFunctionStatement x) {
        this.print("SHOW CREATE FUNCTION ");
        x.getName().accept(this);
        return false;
    }

    @Override
    public void endVisit(MySqlShowCreateFunctionStatement x) {
    }

    @Override
    public boolean visit(MySqlShowCreateProcedureStatement x) {
        this.print("SHOW CREATE PROCEDURE ");
        x.getName().accept(this);
        return false;
    }

    @Override
    public void endVisit(MySqlShowCreateProcedureStatement x) {
    }

    @Override
    public boolean visit(MySqlShowCreateTableStatement x) {
        this.print("SHOW CREATE TABLE ");
        x.getName().accept(this);
        return false;
    }

    @Override
    public void endVisit(MySqlShowCreateTableStatement x) {
    }

    @Override
    public boolean visit(MySqlShowCreateTriggerStatement x) {
        this.print("SHOW CREATE TRIGGER ");
        x.getName().accept(this);
        return false;
    }

    @Override
    public void endVisit(MySqlShowCreateTriggerStatement x) {
    }

    @Override
    public boolean visit(MySqlShowCreateViewStatement x) {
        this.print("SHOW CREATE VIEW ");
        x.getName().accept(this);
        return false;
    }

    @Override
    public void endVisit(MySqlShowCreateViewStatement x) {
    }

    @Override
    public boolean visit(MySqlShowEngineStatement x) {
        this.print("SHOW ENGINE ");
        x.getName().accept(this);
        this.print(' ');
        this.print(x.getOption().name());
        return false;
    }

    @Override
    public void endVisit(MySqlShowEngineStatement x) {
    }

    @Override
    public boolean visit(MySqlShowEventsStatement x) {
        this.print("SHOW EVENTS");
        if (x.getSchema() != null) {
            this.print(" FROM ");
            x.getSchema().accept(this);
        }
        if (x.getLike() != null) {
            this.print(" LIKE ");
            x.getLike().accept(this);
        }
        if (x.getWhere() != null) {
            this.print(" WHERE ");
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowEventsStatement x) {
    }

    @Override
    public boolean visit(MySqlShowFunctionCodeStatement x) {
        this.print("SHOW FUNCTION CODE ");
        x.getName().accept(this);
        return false;
    }

    @Override
    public void endVisit(MySqlShowFunctionCodeStatement x) {
    }

    @Override
    public boolean visit(MySqlShowFunctionStatusStatement x) {
        this.print("SHOW FUNCTION STATUS");
        if (x.getLike() != null) {
            this.print(" LIKE ");
            x.getLike().accept(this);
        }
        if (x.getWhere() != null) {
            this.print(" WHERE ");
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowFunctionStatusStatement x) {
    }

    @Override
    public boolean visit(MySqlShowEnginesStatement x) {
        if (x.isStorage()) {
            this.print("SHOW STORAGE ENGINES");
        } else {
            this.print("SHOW ENGINES");
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowEnginesStatement x) {
    }

    @Override
    public boolean visit(MySqlShowErrorsStatement x) {
        if (x.isCount()) {
            this.print("SHOW COUNT(*) ERRORS");
        } else {
            this.print("SHOW ERRORS");
            if (x.getLimit() != null) {
                this.print(' ');
                x.getLimit().accept(this);
            }
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowErrorsStatement x) {
    }

    @Override
    public boolean visit(MySqlShowGrantsStatement x) {
        this.print("SHOW GRANTS");
        if (x.getUser() != null) {
            this.print(" FOR ");
            x.getUser().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowGrantsStatement x) {
    }

    @Override
    public boolean visit(MySqlUserName x) {
        this.print(x.getUserName());
        if (x.getHost() != null) {
            this.print('@');
            this.print(x.getHost());
        }
        return false;
    }

    @Override
    public void endVisit(MySqlUserName x) {
    }

    @Override
    public boolean visit(MySqlShowIndexesStatement x) {
        this.print("SHOW INDEX");
        if (x.getTable() != null) {
            this.print(" FROM ");
            if (x.getDatabase() != null) {
                x.getDatabase().accept(this);
                this.print('.');
            }
            x.getTable().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowIndexesStatement x) {
    }

    @Override
    public boolean visit(MySqlShowKeysStatement x) {
        this.print("SHOW KEYS");
        if (x.getTable() != null) {
            this.print(" FROM ");
            if (x.getDatabase() != null) {
                x.getDatabase().accept(this);
                this.print('.');
            }
            x.getTable().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowKeysStatement x) {
    }

    @Override
    public boolean visit(MySqlShowMasterStatusStatement x) {
        this.print("SHOW MASTER STATUS");
        return false;
    }

    @Override
    public void endVisit(MySqlShowMasterStatusStatement x) {
    }

    @Override
    public boolean visit(MySqlShowOpenTablesStatement x) {
        this.print("SHOW OPEN TABLES");
        if (x.getDatabase() != null) {
            this.print(" FROM ");
            x.getDatabase().accept(this);
        }
        if (x.getLike() != null) {
            this.print(" LIKE ");
            x.getLike().accept(this);
        }
        if (x.getWhere() != null) {
            this.print(" WHERE ");
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowOpenTablesStatement x) {
    }

    @Override
    public boolean visit(MySqlShowPluginsStatement x) {
        this.print("SHOW PLUGINS");
        return false;
    }

    @Override
    public void endVisit(MySqlShowPluginsStatement x) {
    }

    @Override
    public boolean visit(MySqlShowPrivilegesStatement x) {
        this.print("SHOW PRIVILEGES");
        return false;
    }

    @Override
    public void endVisit(MySqlShowPrivilegesStatement x) {
    }

    @Override
    public boolean visit(MySqlShowProcedureCodeStatement x) {
        this.print("SHOW PROCEDURE CODE ");
        x.getName().accept(this);
        return false;
    }

    @Override
    public void endVisit(MySqlShowProcedureCodeStatement x) {
    }

    @Override
    public boolean visit(MySqlShowProcedureStatusStatement x) {
        this.print("SHOW PROCEDURE STATUS");
        if (x.getLike() != null) {
            this.print(" LIKE ");
            x.getLike().accept(this);
        }
        if (x.getWhere() != null) {
            this.print(" WHERE ");
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowProcedureStatusStatement x) {
    }

    @Override
    public boolean visit(MySqlShowProcessListStatement x) {
        if (x.isFull()) {
            this.print("SHOW FULL PROCESSLIST");
        } else {
            this.print("SHOW PROCESSLIST");
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowProcessListStatement x) {
    }

    @Override
    public boolean visit(MySqlShowProfileStatement x) {
        this.print("SHOW PROFILE");
        for (int i = 0; i < x.getTypes().size(); ++i) {
            if (i == 0) {
                this.print(' ');
            } else {
                this.print(", ");
            }
            this.print(x.getTypes().get((int)i).name);
        }
        if (x.getForQuery() != null) {
            this.print(" FOR QUERY ");
            x.getForQuery().accept(this);
        }
        if (x.getLimit() != null) {
            this.print(' ');
            x.getLimit().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowProfileStatement x) {
    }

    @Override
    public boolean visit(MySqlShowProfilesStatement x) {
        this.print("SHOW PROFILES");
        return false;
    }

    @Override
    public void endVisit(MySqlShowProfilesStatement x) {
    }

    @Override
    public boolean visit(MySqlShowRelayLogEventsStatement x) {
        this.print("SHOW RELAYLOG EVENTS");
        if (x.getLogName() != null) {
            this.print(" IN ");
            x.getLogName().accept(this);
        }
        if (x.getFrom() != null) {
            this.print(" FROM ");
            x.getFrom().accept(this);
        }
        if (x.getLimit() != null) {
            this.print(' ');
            x.getLimit().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowRelayLogEventsStatement x) {
    }

    @Override
    public boolean visit(MySqlShowSlaveHostsStatement x) {
        this.print("SHOW SLAVE HOSTS");
        return false;
    }

    @Override
    public void endVisit(MySqlShowSlaveHostsStatement x) {
    }

    @Override
    public boolean visit(MySqlShowSlaveStatusStatement x) {
        this.print("SHOW SLAVE STATUS");
        return false;
    }

    @Override
    public void endVisit(MySqlShowSlaveStatusStatement x) {
    }

    @Override
    public boolean visit(MySqlShowTableStatusStatement x) {
        this.print("SHOW TABLE STATUS");
        if (x.getDatabase() != null) {
            this.print(" FROM ");
            x.getDatabase().accept(this);
        }
        if (x.getLike() != null) {
            this.print(" LIKE ");
            x.getLike().accept(this);
        }
        if (x.getWhere() != null) {
            this.print(" WHERE ");
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowTableStatusStatement x) {
    }

    @Override
    public boolean visit(MySqlShowTriggersStatement x) {
        this.print("SHOW TRIGGERS");
        if (x.getDatabase() != null) {
            this.print(" FROM ");
            x.getDatabase().accept(this);
        }
        if (x.getLike() != null) {
            this.print(" LIKE ");
            x.getLike().accept(this);
        }
        if (x.getWhere() != null) {
            this.print(" WHERE ");
            x.getWhere().setParent(x);
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowTriggersStatement x) {
    }

    @Override
    public boolean visit(MySqlShowVariantsStatement x) {
        this.print("SHOW ");
        if (x.isGlobal()) {
            this.print("GLOBAL ");
        }
        if (x.isSession()) {
            this.print("SESSION ");
        }
        this.print("VARIABLES");
        if (x.getLike() != null) {
            this.print(" LIKE ");
            x.getLike().accept(this);
        }
        if (x.getWhere() != null) {
            this.print(" WHERE ");
            x.getWhere().setParent(x);
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowVariantsStatement x) {
    }

    @Override
    public boolean visit(MySqlAlterTableStatement x) {
        if (x.isIgnore()) {
            this.print("ALTER IGNORE TABLE ");
        } else {
            this.print("ALTER TABLE ");
        }
        x.getName().accept(this);
        this.incrementIndent();
        for (int i = 0; i < x.getItems().size(); ++i) {
            SQLAlterTableItem item = x.getItems().get(i);
            if (i != 0) {
                this.print(',');
            }
            this.println();
            item.accept(this);
        }
        this.decrementIndent();
        return false;
    }

    @Override
    public void endVisit(MySqlAlterTableStatement x) {
    }

    @Override
    public boolean visit(MySqlAlterTableAddColumn x) {
        this.print("ADD COLUMN ");
        this.printAndAccept(x.getColumns(), ", ");
        if (x.getFirstColumn() != null) {
            this.print(" FIRST ");
            x.getFirstColumn().accept(this);
        } else if (x.getAfterColumn() != null) {
            this.print(" AFTER ");
            x.getAfterColumn().accept(this);
        } else if (x.isFirst()) {
            this.print(" FIRST");
        }
        return false;
    }

    @Override
    public void endVisit(MySqlAlterTableAddColumn x) {
    }

    @Override
    public boolean visit(MySqlCreateIndexStatement x) {
        this.print("CREATE ");
        if (x.getType() != null) {
            this.print(x.getType());
            this.print(" ");
        }
        this.print("INDEX ");
        x.getName().accept(this);
        this.print(" ON ");
        x.getTable().accept(this);
        this.print(" (");
        this.printAndAccept(x.getItems(), ", ");
        this.print(")");
        if (x.getUsing() != null) {
            this.print(" USING ");
            this.print(x.getUsing());
        }
        return false;
    }

    @Override
    public void endVisit(MySqlCreateIndexStatement x) {
    }

    @Override
    public boolean visit(MySqlRenameTableStatement.Item x) {
        x.getName().accept(this);
        this.print(" TO ");
        x.getTo().accept(this);
        return false;
    }

    @Override
    public void endVisit(MySqlRenameTableStatement.Item x) {
    }

    @Override
    public boolean visit(MySqlRenameTableStatement x) {
        this.print("RENAME TABLE ");
        this.printAndAccept(x.getItems(), ", ");
        return false;
    }

    @Override
    public void endVisit(MySqlRenameTableStatement x) {
    }

    @Override
    public boolean visit(MySqlUnionQuery x) {
        MySqlSelectQueryBlock right;
        boolean needParen = false;
        if (x.getLeft() instanceof MySqlSelectQueryBlock && ((right = (MySqlSelectQueryBlock)x.getLeft()).getOrderBy() != null || right.getLimit() != null)) {
            needParen = true;
        }
        if (needParen) {
            this.print('(');
            x.getLeft().accept(this);
            this.print(')');
        } else {
            x.getLeft().accept(this);
        }
        this.println();
        this.print(x.getOperator().name);
        this.println();
        needParen = false;
        if (x.getOrderBy() != null || x.getLimit() != null) {
            needParen = true;
        } else if (x.getRight() instanceof MySqlSelectQueryBlock && ((right = (MySqlSelectQueryBlock)x.getRight()).getOrderBy() != null || right.getLimit() != null)) {
            needParen = true;
        }
        if (needParen) {
            this.print('(');
            x.getRight().accept(this);
            this.print(')');
        } else {
            x.getRight().accept(this);
        }
        if (x.getOrderBy() != null) {
            this.println();
            x.getOrderBy().accept(this);
        }
        if (x.getLimit() != null) {
            this.println();
            x.getLimit().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlUnionQuery x) {
    }

    @Override
    public boolean visit(MySqlUseIndexHint x) {
        this.print("USE INDEX ");
        if (x.getOption() != null) {
            this.print("FOR ");
            this.print(x.getOption().name);
            this.print(' ');
        }
        this.print('(');
        this.printAndAccept(x.getIndexList(), ", ");
        this.print(')');
        return false;
    }

    @Override
    public void endVisit(MySqlUseIndexHint x) {
    }

    @Override
    public boolean visit(MySqlIgnoreIndexHint x) {
        this.print("IGNORE INDEX ");
        if (x.getOption() != null) {
            this.print("FOR ");
            this.print(x.getOption().name);
            this.print(' ');
        }
        this.print('(');
        this.printAndAccept(x.getIndexList(), ", ");
        this.print(')');
        return false;
    }

    @Override
    public void endVisit(MySqlIgnoreIndexHint x) {
    }

    @Override
    public boolean visit(SQLExprTableSource x) {
        x.getExpr().accept(this);
        if (x.getAlias() != null) {
            this.print(' ');
            this.print(x.getAlias());
        }
        for (int i = 0; i < x.getHintsSize(); ++i) {
            this.print(' ');
            x.getHints().get(i).accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(MySqlLockTableStatement x) {
        this.print("LOCK TABLES ");
        x.getTableSource().accept(this);
        if (x.getLockType() != null) {
            this.print(' ');
            this.print(x.getLockType().name);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlLockTableStatement x) {
    }

    @Override
    public boolean visit(MySqlUnlockTablesStatement x) {
        this.print("UNLOCK TABLES");
        return false;
    }

    @Override
    public void endVisit(MySqlUnlockTablesStatement x) {
    }

    @Override
    public boolean visit(MySqlForceIndexHint x) {
        this.print("FORCE INDEX ");
        if (x.getOption() != null) {
            this.print("FOR ");
            this.print(x.getOption().name);
            this.print(' ');
        }
        this.print('(');
        this.printAndAccept(x.getIndexList(), ", ");
        this.print(')');
        return false;
    }

    @Override
    public void endVisit(MySqlForceIndexHint x) {
    }

    @Override
    public boolean visit(MySqlAlterTableChangeColumn x) {
        this.print("CHANGE COLUMN ");
        x.getColumnName().accept(this);
        this.print(' ');
        x.getNewColumnDefinition().accept(this);
        if (x.getFirstColumn() != null) {
            this.print(" FIRST ");
            x.getFirstColumn().accept(this);
        } else if (x.getAfterColumn() != null) {
            this.print(" AFTER ");
            x.getAfterColumn().accept(this);
        } else if (x.isFirst()) {
            this.print(" FIRST");
        }
        return false;
    }

    @Override
    public void endVisit(MySqlAlterTableChangeColumn x) {
    }

    @Override
    public boolean visit(MySqlAlterTableModifyColumn x) {
        this.print("MODIFY COLUMN ");
        x.getNewColumnDefinition().accept(this);
        if (x.getFirstColumn() != null) {
            this.print(" FIRST ");
            x.getFirstColumn().accept(this);
        } else if (x.getAfterColumn() != null) {
            this.print(" AFTER ");
            x.getAfterColumn().accept(this);
        } else if (x.isFirst()) {
            this.print(" FIRST");
        }
        return false;
    }

    @Override
    public void endVisit(MySqlAlterTableModifyColumn x) {
    }

    @Override
    public boolean visit(MySqlAlterTableCharacter x) {
        this.print("CHARACTER SET = ");
        x.getCharacterSet().accept(this);
        if (x.getCollate() != null) {
            this.print(", COLLATE = ");
            x.getCollate().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlAlterTableCharacter x) {
    }

    @Override
    public boolean visit(MySqlAlterTableOption x) {
        this.print(x.getName());
        this.print(" = ");
        this.print(x.getValue().toString());
        return false;
    }

    @Override
    public void endVisit(MySqlAlterTableOption x) {
    }

    @Override
    public void endVisit(MySqlCreateTableStatement x) {
    }

    @Override
    public boolean visit(MySqlHelpStatement x) {
        this.print("HELP ");
        x.getContent().accept(this);
        return false;
    }

    @Override
    public void endVisit(MySqlHelpStatement x) {
    }

    @Override
    public boolean visit(MySqlCharExpr x) {
        this.print(x.toString());
        return false;
    }

    @Override
    public void endVisit(MySqlCharExpr x) {
    }

    @Override
    public boolean visit(MySqlUnique x) {
        if (x.isHasConstaint()) {
            this.print("CONSTRAINT ");
            if (x.getName() != null) {
                x.getName().accept(this);
                this.print(' ');
            }
        }
        this.print("UNIQUE");
        if (x.getIndexName() != null) {
            this.print(' ');
            x.getIndexName().accept(this);
        }
        if (x.getIndexType() != null) {
            this.print(" USING ");
            this.print(x.getIndexType());
        }
        this.print(" (");
        this.printAndAccept(x.getColumns(), ", ");
        this.print(")");
        return false;
    }

    @Override
    public boolean visit(MysqlForeignKey x) {
        if (x.isHasConstaint()) {
            this.print("CONSTRAINT ");
            if (x.getName() != null) {
                x.getName().accept(this);
                this.print(' ');
            }
        }
        this.print("FOREIGN KEY");
        if (x.getIndexName() != null) {
            this.print(' ');
            x.getIndexName().accept(this);
        }
        this.print(" (");
        this.printAndAccept(x.getReferencingColumns(), ", ");
        this.print(")");
        this.print(" REFERENCES ");
        x.getReferencedTableName().accept(this);
        this.print(" (");
        this.printAndAccept(x.getReferencedColumns(), ", ");
        this.print(")");
        return false;
    }

    @Override
    public void endVisit(MySqlUnique x) {
    }

    @Override
    public boolean visit(MySqlAlterTableDiscardTablespace x) {
        this.print("DISCARD TABLESPACE");
        return false;
    }

    @Override
    public void endVisit(MySqlAlterTableDiscardTablespace x) {
    }

    @Override
    public boolean visit(MySqlAlterTableImportTablespace x) {
        this.print("IMPORT TABLESPACE");
        return false;
    }

    @Override
    public void endVisit(MySqlAlterTableImportTablespace x) {
    }

    @Override
    public boolean visit(SQLAssignItem x) {
        x.getTarget().accept(this);
        if (!"NAMES".equalsIgnoreCase(x.getTarget().toString())) {
            this.print(" = ");
        }
        x.getValue().accept(this);
        return false;
    }

    @Override
    public boolean visit(MySqlCreateTableStatement.TableSpaceOption x) {
        x.getName().accept(this);
        if (x.getStorage() != null) {
            this.print(' ');
            x.getStorage().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlCreateTableStatement.TableSpaceOption x) {
    }

    @Override
    public boolean visit(MySqlPartitioningDef x) {
        this.print("PARTITION ");
        x.getName().accept(this);
        if (x.getValues() != null) {
            this.print(' ');
            x.getValues().accept(this);
        }
        if (x.getDataDirectory() != null) {
            this.incrementIndent();
            this.println();
            this.print("DATA DIRECTORY ");
            x.getDataDirectory().accept(this);
            this.decrementIndent();
        }
        if (x.getIndexDirectory() != null) {
            this.incrementIndent();
            this.println();
            this.print("INDEX DIRECTORY ");
            x.getIndexDirectory().accept(this);
            this.decrementIndent();
        }
        return false;
    }

    @Override
    public void endVisit(MySqlPartitioningDef x) {
    }

    @Override
    public boolean visit(MySqlPartitioningDef.LessThanValues x) {
        this.print("VALUES LESS THAN (");
        this.printAndAccept(x.getItems(), ", ");
        this.print(')');
        return false;
    }

    @Override
    public void endVisit(MySqlPartitioningDef.LessThanValues x) {
    }

    @Override
    public boolean visit(MySqlPartitioningDef.InValues x) {
        this.print("VALUES IN (");
        this.printAndAccept(x.getItems(), ", ");
        this.print(')');
        return false;
    }

    @Override
    public void endVisit(MySqlPartitioningDef.InValues x) {
    }

    @Override
    protected void visitAggreateRest(SQLAggregateExpr aggregateExpr) {
        Object value = (SQLOrderBy)aggregateExpr.getAttribute("ORDER BY");
        if (value != null) {
            this.print(" ");
            value.accept(this);
        }
        if ((value = aggregateExpr.getAttribute("SEPARATOR")) != null) {
            this.print(" SEPARATOR ");
            ((SQLObject)value).accept(this);
        }
    }

    @Override
    public boolean visit(MySqlAnalyzeStatement x) {
        this.print("ANALYZE ");
        if (x.isNoWriteToBinlog()) {
            this.print("NO_WRITE_TO_BINLOG ");
        }
        if (x.isLocal()) {
            this.print("LOCAL ");
        }
        this.print("TABLE ");
        this.printAndAccept(x.getTableSources(), ", ");
        return false;
    }

    @Override
    public void endVisit(MySqlAnalyzeStatement x) {
    }

    @Override
    public boolean visit(MySqlOptimizeStatement x) {
        this.print("OPTIMIZE ");
        if (x.isNoWriteToBinlog()) {
            this.print("NO_WRITE_TO_BINLOG ");
        }
        if (x.isLocal()) {
            this.print("LOCAL ");
        }
        this.print("TABLE ");
        this.printAndAccept(x.getTableSources(), ", ");
        return false;
    }

    @Override
    public void endVisit(MySqlOptimizeStatement x) {
    }

    @Override
    public boolean visit(MySqlAlterUserStatement x) {
        this.print("ALTER USER");
        for (SQLExpr user : x.getUsers()) {
            this.print(' ');
            user.accept(this);
            this.print(" PASSWORD EXPIRE");
        }
        return false;
    }

    @Override
    public void endVisit(MySqlAlterUserStatement x) {
    }

    @Override
    public boolean visit(MySqlSetPasswordStatement x) {
        this.print("SET PASSWORD ");
        if (x.getUser() != null) {
            this.print("FOR ");
            x.getUser().accept(this);
            this.print(' ');
        }
        this.print("= ");
        if (x.getPassword() != null) {
            x.getPassword().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlSetPasswordStatement x) {
    }
}

