/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.wall.spi;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.druid.sql.ast.expr.SQLBetweenExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLCaseExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLExistsExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLInSubQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLNotExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumberExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumericLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLUnaryExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLCallStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTriggerStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropSequenceStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTriggerStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLInsertInto;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLRollbackStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSetStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTruncateStatement;
import com.alibaba.druid.sql.ast.statement.SQLUnionOperator;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.ast.statement.SQLUseStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlBooleanExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlOutFileExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlCommitStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlDeleteStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlDescribeStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlInsertStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlRenameTableStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlReplaceStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSetCharSetStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSetNamesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowGrantsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlUpdateStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCreateSequenceStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleMergeStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleMultiInsertStatement;
import com.alibaba.druid.sql.dialect.sqlserver.ast.stmt.SQLServerExecStatement;
import com.alibaba.druid.sql.dialect.sqlserver.ast.stmt.SQLServerInsertStatement;
import com.alibaba.druid.sql.visitor.ExportParameterVisitor;
import com.alibaba.druid.sql.visitor.SQLEvalVisitor;
import com.alibaba.druid.sql.visitor.SQLEvalVisitorUtils;
import com.alibaba.druid.sql.visitor.functions.Nil;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.alibaba.druid.util.JdbcUtils;
import com.alibaba.druid.util.ServletPathMatcher;
import com.alibaba.druid.util.StringUtils;
import com.alibaba.druid.wall.WallConfig;
import com.alibaba.druid.wall.WallContext;
import com.alibaba.druid.wall.WallProvider;
import com.alibaba.druid.wall.WallSqlTableStat;
import com.alibaba.druid.wall.WallVisitor;
import com.alibaba.druid.wall.violation.IllegalSQLObjectViolation;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public class WallVisitorUtils {
    private static final Log LOG = LogFactory.getLog(WallVisitorUtils.class);
    public static final String HAS_TRUE_LIKE = "hasTrueLike";
    private static ThreadLocal<WallConditionContext> wallConditionContextLocal = new ThreadLocal();
    private static ThreadLocal<WallTopStatementContext> wallTopStatementContextLocal = new ThreadLocal();

    public static void check(WallVisitor visitor, SQLInListExpr x) {
    }

    public static boolean check(WallVisitor visitor, SQLBinaryOpExpr x) {
        List<SQLExpr> groupList;
        if (x.getOperator() == SQLBinaryOperator.BooleanOr || x.getOperator() == SQLBinaryOperator.BooleanAnd) {
            List<SQLExpr> groupList2 = SQLUtils.split(x);
            for (SQLExpr item : groupList2) {
                item.accept(visitor);
            }
            return false;
        }
        if ((x.getOperator() == SQLBinaryOperator.Add || x.getOperator() == SQLBinaryOperator.Concat) && (groupList = SQLUtils.split(x)).size() >= 4) {
            int chrCount = 0;
            for (int i = 0; i < groupList.size(); ++i) {
                SQLMethodInvokeExpr methodExpr;
                String methodName;
                SQLExpr item = groupList.get(i);
                if (!(item instanceof SQLMethodInvokeExpr) || !"chr".equals(methodName = (methodExpr = (SQLMethodInvokeExpr)item).getMethodName().toLowerCase()) && !"char".equals(methodName) || !(methodExpr.getParameters().get(0) instanceof SQLLiteralExpr)) continue;
                ++chrCount;
            }
            if (chrCount >= 4) {
                WallVisitorUtils.addViolation(visitor, 2112, "evil concat", x);
            }
        }
        return true;
    }

    public static void check(WallVisitor visitor, SQLCreateTableStatement x) {
        WallSqlTableStat tableStat;
        String tableName = x.getName().getSimleName();
        WallContext context = WallContext.current();
        if (context != null && (tableStat = context.getTableStat(tableName)) != null) {
            tableStat.incrementCreateCount();
        }
    }

    public static void check(WallVisitor visitor, SQLAlterTableStatement x) {
        WallSqlTableStat tableStat;
        String tableName = x.getName().getSimleName();
        WallContext context = WallContext.current();
        if (context != null && (tableStat = context.getTableStat(tableName)) != null) {
            tableStat.incrementAlterCount();
        }
    }

    public static void check(WallVisitor visitor, SQLDropTableStatement x) {
        for (SQLExprTableSource item : x.getTableSources()) {
            WallSqlTableStat tableStat;
            if (!(item instanceof SQLExprTableSource)) continue;
            SQLExpr expr = item.getExpr();
            String tableName = ((SQLName)expr).getSimleName();
            WallContext context = WallContext.current();
            if (context == null || (tableStat = context.getTableStat(tableName)) == null) continue;
            tableStat.incrementDropCount();
        }
    }

    public static void check(WallVisitor visitor, SQLSelectItem x) {
        SQLSelectQueryBlock queryBlock;
        SQLTableSource from;
        SQLExpr expr = x.getExpr();
        if (expr instanceof SQLVariantRefExpr && !WallVisitorUtils.isTopSelectItem(expr) && "@".equals(((SQLVariantRefExpr)expr).getName())) {
            WallVisitorUtils.addViolation(visitor, 2111, "@ not allow", x);
        }
        if (visitor.getConfig().isSelectAllColumnAllow()) {
            return;
        }
        if (expr instanceof SQLAllColumnExpr && x.getParent() instanceof SQLSelectQueryBlock && (from = (queryBlock = (SQLSelectQueryBlock)x.getParent()).getFrom()) instanceof SQLExprTableSource) {
            WallVisitorUtils.addViolation(visitor, 1002, "'SELECT *' not allow", x);
        }
    }

    public static void check(WallVisitor visitor, SQLPropertyExpr x) {
        WallVisitorUtils.checkSchema(visitor, x.getOwner());
    }

    public static void checkInsert(WallVisitor visitor, SQLInsertInto x) {
        WallVisitorUtils.checkReadOnly(visitor, x.getTableSource());
        if (!visitor.getConfig().isInsertAllow()) {
            WallVisitorUtils.addViolation(visitor, 1004, "insert not allow", x);
        }
        WallVisitorUtils.checkInsertForMultiTenant(visitor, x);
    }

    public static void checkSelelct(WallVisitor visitor, SQLSelectQueryBlock x) {
        SQLExpr where;
        for (SQLSelectItem item : x.getSelectList()) {
            item.setParent(x);
        }
        if (x.getInto() != null) {
            WallVisitorUtils.checkReadOnly(visitor, x.getInto());
        }
        if (!visitor.getConfig().isSelectIntoAllow() && x.getInto() != null) {
            WallVisitorUtils.addViolation(visitor, 1003, "select into not allow", x);
            return;
        }
        if (x.getFrom() != null) {
            x.getFrom().setParent(x);
        }
        if ((where = x.getWhere()) != null) {
            where.setParent(x);
            WallVisitorUtils.checkCondition(visitor, x.getWhere());
            Object whereValue = WallVisitorUtils.getConditionValue(visitor, where, visitor.getConfig().isSelectWhereAlwayTrueCheck());
            if (Boolean.TRUE == whereValue && !WallVisitorUtils.isSimpleConstExpr(where)) {
                WallVisitorUtils.addViolation(visitor, 2100, "select alway true condition not allow", x);
            }
        }
        WallVisitorUtils.checkSelectForMultiTenant(visitor, x);
    }

    public static void checkHaving(WallVisitor visitor, SQLExpr x) {
        if (x == null) {
            return;
        }
        if (Boolean.TRUE == WallVisitorUtils.getConditionValue(visitor, x, visitor.getConfig().isSelectHavingAlwayTrueCheck()) && !WallVisitorUtils.isSimpleConstExpr(x)) {
            WallVisitorUtils.addViolation(visitor, 2100, "having alway true condition not allow", x);
        }
    }

    public static void checkDelete(WallVisitor visitor, SQLDeleteStatement x) {
        SQLExpr where;
        WallVisitorUtils.checkReadOnly(visitor, x.getTableSource());
        WallConfig config = visitor.getConfig();
        if (!config.isDeleteAllow()) {
            WallVisitorUtils.addViolation(visitor, 1004, "delete not allow", x);
            return;
        }
        boolean hasUsing = false;
        if (x instanceof MySqlDeleteStatement) {
            hasUsing = ((MySqlDeleteStatement)x).getUsing() != null;
        }
        boolean isJoinTableSource = x.getTableSource() instanceof SQLJoinTableSource;
        if (x.getWhere() == null && !hasUsing && !isJoinTableSource) {
            WallContext context = WallContext.current();
            if (context != null) {
                context.incrementDeleteNoneConditionWarnnings();
            }
            if (config.isDeleteWhereNoneCheck()) {
                WallVisitorUtils.addViolation(visitor, 2104, "delete none condition not allow", x);
                return;
            }
        }
        if ((where = x.getWhere()) != null) {
            WallVisitorUtils.checkCondition(visitor, where);
            if (Boolean.TRUE == WallVisitorUtils.getConditionValue(visitor, where, config.isDeleteWhereAlwayTrueCheck()) && !WallVisitorUtils.isSimpleConstExpr(where)) {
                WallVisitorUtils.addViolation(visitor, 2100, "delete alway true condition not allow", x);
            }
        }
    }

    private static boolean isSimpleConstExpr(SQLExpr sqlExpr) {
        List<SQLExpr> parts = WallVisitorUtils.getParts(sqlExpr);
        if (parts.isEmpty()) {
            return false;
        }
        for (SQLExpr part : parts) {
            SQLBinaryOpExpr binaryOpExpr;
            boolean isSimpleConstExpr = false;
            if (part == sqlExpr || part instanceof SQLLiteralExpr) {
                isSimpleConstExpr = true;
            } else if (part instanceof SQLBinaryOpExpr && ((binaryOpExpr = (SQLBinaryOpExpr)part).getOperator() == SQLBinaryOperator.Equality || binaryOpExpr.getOperator() == SQLBinaryOperator.NotEqual || binaryOpExpr.getOperator() == SQLBinaryOperator.GreaterThan) && binaryOpExpr.getLeft() instanceof SQLIntegerExpr && binaryOpExpr.getRight() instanceof SQLIntegerExpr) {
                isSimpleConstExpr = true;
            }
            if (isSimpleConstExpr) continue;
            return false;
        }
        return true;
    }

    private static void checkCondition(WallVisitor visitor, SQLExpr x) {
        if (x == null) {
            return;
        }
        if (visitor.getConfig().isMustParameterized()) {
            ExportParameterVisitor exportParameterVisitor = visitor.getProvider().createExportParameterVisitor();
            x.accept(exportParameterVisitor);
            if (exportParameterVisitor.getParameters().size() > 0) {
                WallVisitorUtils.addViolation(visitor, 2200, "sql must parameterized", x);
                return;
            }
        }
    }

    private static void checkJoinSelectForMultiTenant(WallVisitor visitor, SQLJoinTableSource join, SQLSelectQueryBlock x) {
        SQLExpr tableExpr;
        WallConfig.TenantCallBack tenantCallBack = visitor.getConfig().getTenantCallBack();
        String tenantTablePattern = visitor.getConfig().getTenantTablePattern();
        if (tenantCallBack == null && (tenantTablePattern == null || tenantTablePattern.length() == 0)) {
            return;
        }
        SQLTableSource right = join.getRight();
        if (right instanceof SQLExprTableSource && (tableExpr = ((SQLExprTableSource)right).getExpr()) instanceof SQLIdentifierExpr) {
            String tableName = ((SQLIdentifierExpr)tableExpr).getName();
            String alias = null;
            String tenantColumn = null;
            if (tenantCallBack != null) {
                tenantColumn = tenantCallBack.getTenantColumn(WallConfig.TenantCallBack.StatementType.SELECT, tableName);
            }
            if (StringUtils.isEmpty(tenantColumn) && ServletPathMatcher.getInstance().matches(tenantTablePattern, tableName)) {
                tenantColumn = visitor.getConfig().getTenantColumn();
            }
            if (!StringUtils.isEmpty(tenantColumn)) {
                alias = right.getAlias();
                if (alias == null) {
                    alias = tableName;
                }
                SQLExprImpl item = null;
                item = alias != null ? new SQLPropertyExpr(new SQLIdentifierExpr(alias), tenantColumn) : new SQLIdentifierExpr(tenantColumn);
                SQLSelectItem selectItem = new SQLSelectItem(item);
                x.getSelectList().add(selectItem);
                visitor.setSqlModified(true);
            }
        }
    }

    private static boolean isSelectStatmentForMultiTenant(SQLSelectQueryBlock queryBlock) {
        SQLObject parent = queryBlock.getParent();
        while (parent != null && parent instanceof SQLUnionQuery) {
            SQLObject x = parent;
            parent = x.getParent();
        }
        if (!(parent instanceof SQLSelect)) {
            return false;
        }
        return (parent = ((SQLSelect)parent).getParent()) instanceof SQLSelectStatement;
    }

    private static void checkSelectForMultiTenant(WallVisitor visitor, SQLSelectQueryBlock x) {
        WallConfig.TenantCallBack tenantCallBack = visitor.getConfig().getTenantCallBack();
        String tenantTablePattern = visitor.getConfig().getTenantTablePattern();
        if (tenantCallBack == null && (tenantTablePattern == null || tenantTablePattern.length() == 0)) {
            return;
        }
        if (x == null) {
            throw new IllegalStateException("x is null");
        }
        if (!WallVisitorUtils.isSelectStatmentForMultiTenant(x)) {
            return;
        }
        SQLTableSource tableSource = x.getFrom();
        String alias = null;
        String matchTableName = null;
        String tenantColumn = null;
        if (tableSource instanceof SQLExprTableSource) {
            SQLExpr tableExpr = ((SQLExprTableSource)tableSource).getExpr();
            if (tableExpr instanceof SQLIdentifierExpr) {
                String tableName = ((SQLIdentifierExpr)tableExpr).getName();
                if (tenantCallBack != null) {
                    tenantColumn = tenantCallBack.getTenantColumn(WallConfig.TenantCallBack.StatementType.SELECT, tableName);
                }
                if (StringUtils.isEmpty(tenantColumn) && ServletPathMatcher.getInstance().matches(tenantTablePattern, tableName)) {
                    tenantColumn = visitor.getConfig().getTenantColumn();
                }
                if (!StringUtils.isEmpty(tenantColumn)) {
                    matchTableName = tableName;
                    alias = tableSource.getAlias();
                }
            }
        } else if (tableSource instanceof SQLJoinTableSource) {
            SQLJoinTableSource join = (SQLJoinTableSource)tableSource;
            if (join.getLeft() instanceof SQLExprTableSource) {
                SQLExpr tableExpr = ((SQLExprTableSource)join.getLeft()).getExpr();
                if (tableExpr instanceof SQLIdentifierExpr) {
                    String tableName = ((SQLIdentifierExpr)tableExpr).getName();
                    if (tenantCallBack != null) {
                        tenantColumn = tenantCallBack.getTenantColumn(WallConfig.TenantCallBack.StatementType.SELECT, tableName);
                    }
                    if (StringUtils.isEmpty(tenantColumn) && ServletPathMatcher.getInstance().matches(tenantTablePattern, tableName)) {
                        tenantColumn = visitor.getConfig().getTenantColumn();
                    }
                    if (!StringUtils.isEmpty(tenantColumn)) {
                        matchTableName = tableName;
                        alias = join.getLeft().getAlias();
                        if (alias == null) {
                            alias = tableName;
                        }
                    }
                }
                WallVisitorUtils.checkJoinSelectForMultiTenant(visitor, join, x);
            } else {
                WallVisitorUtils.checkJoinSelectForMultiTenant(visitor, join, x);
            }
        }
        if (matchTableName == null) {
            return;
        }
        SQLExprImpl item = null;
        item = alias != null ? new SQLPropertyExpr(new SQLIdentifierExpr(alias), tenantColumn) : new SQLIdentifierExpr(tenantColumn);
        SQLSelectItem selectItem = new SQLSelectItem(item);
        x.getSelectList().add(selectItem);
        visitor.setSqlModified(true);
    }

    private static void checkUpdateForMultiTenant(WallVisitor visitor, SQLUpdateStatement x) {
        SQLExpr tableExpr;
        WallConfig.TenantCallBack tenantCallBack = visitor.getConfig().getTenantCallBack();
        String tenantTablePattern = visitor.getConfig().getTenantTablePattern();
        if (tenantCallBack == null && (tenantTablePattern == null || tenantTablePattern.length() == 0)) {
            return;
        }
        if (x == null) {
            throw new IllegalStateException("x is null");
        }
        SQLTableSource tableSource = x.getTableSource();
        String alias = null;
        String matchTableName = null;
        String tenantColumn = null;
        if (tableSource instanceof SQLExprTableSource && (tableExpr = ((SQLExprTableSource)tableSource).getExpr()) instanceof SQLIdentifierExpr) {
            String tableName = ((SQLIdentifierExpr)tableExpr).getName();
            if (tenantCallBack != null) {
                tenantColumn = tenantCallBack.getTenantColumn(WallConfig.TenantCallBack.StatementType.UPDATE, tableName);
            }
            if (StringUtils.isEmpty(tenantColumn) && ServletPathMatcher.getInstance().matches(tenantTablePattern, tableName)) {
                tenantColumn = visitor.getConfig().getTenantColumn();
            }
            if (!StringUtils.isEmpty(tenantColumn)) {
                matchTableName = tableName;
                alias = tableSource.getAlias();
            }
        }
        if (matchTableName == null) {
            return;
        }
        SQLExprImpl item = null;
        item = alias != null ? new SQLPropertyExpr(new SQLIdentifierExpr(alias), tenantColumn) : new SQLIdentifierExpr(tenantColumn);
        SQLExpr value = WallVisitorUtils.generateTenantValue(visitor, alias, WallConfig.TenantCallBack.StatementType.UPDATE, matchTableName);
        SQLUpdateSetItem updateSetItem = new SQLUpdateSetItem();
        updateSetItem.setColumn(item);
        updateSetItem.setValue(value);
        x.getItems().add(updateSetItem);
        visitor.setSqlModified(true);
    }

    private static void checkInsertForMultiTenant(WallVisitor visitor, SQLInsertInto x) {
        SQLSelect select;
        WallConfig.TenantCallBack tenantCallBack = visitor.getConfig().getTenantCallBack();
        String tenantTablePattern = visitor.getConfig().getTenantTablePattern();
        if (tenantCallBack == null && (tenantTablePattern == null || tenantTablePattern.length() == 0)) {
            return;
        }
        if (x == null) {
            throw new IllegalStateException("x is null");
        }
        SQLExprTableSource tableSource = x.getTableSource();
        String alias = null;
        String matchTableName = null;
        String tenantColumn = null;
        SQLExpr tableExpr = tableSource.getExpr();
        if (tableExpr instanceof SQLIdentifierExpr) {
            String tableName = ((SQLIdentifierExpr)tableExpr).getName();
            if (tenantCallBack != null) {
                tenantColumn = tenantCallBack.getTenantColumn(WallConfig.TenantCallBack.StatementType.INSERT, tableName);
            }
            if (StringUtils.isEmpty(tenantColumn) && ServletPathMatcher.getInstance().matches(tenantTablePattern, tableName)) {
                tenantColumn = visitor.getConfig().getTenantColumn();
            }
            if (!StringUtils.isEmpty(tenantColumn)) {
                matchTableName = tableName;
                alias = tableSource.getAlias();
            }
        }
        if (matchTableName == null) {
            return;
        }
        SQLExprImpl item = null;
        item = alias != null ? new SQLPropertyExpr(new SQLIdentifierExpr(alias), tenantColumn) : new SQLIdentifierExpr(tenantColumn);
        SQLExpr value = WallVisitorUtils.generateTenantValue(visitor, alias, WallConfig.TenantCallBack.StatementType.INSERT, matchTableName);
        x.getColumns().add(item);
        List<SQLInsertStatement.ValuesClause> valuesClauses = null;
        SQLInsertStatement.ValuesClause valuesClause = null;
        if (x instanceof MySqlInsertStatement) {
            valuesClauses = ((MySqlInsertStatement)x).getValuesList();
        } else if (x instanceof SQLServerInsertStatement) {
            valuesClauses = ((MySqlInsertStatement)x).getValuesList();
        } else {
            valuesClause = x.getValues();
        }
        if (valuesClauses != null && valuesClauses.size() > 0) {
            for (SQLInsertStatement.ValuesClause clause : valuesClauses) {
                clause.addValue(value);
            }
        }
        if (valuesClause != null) {
            valuesClause.addValue(value);
        }
        if ((select = x.getQuery()) != null) {
            List<SQLSelectQueryBlock> queryBlocks = WallVisitorUtils.splitSQLSelectQuery(select.getQuery());
            for (SQLSelectQueryBlock queryBlock : queryBlocks) {
                queryBlock.getSelectList().add(new SQLSelectItem(value));
            }
        }
        visitor.setSqlModified(true);
    }

    private static List<SQLSelectQueryBlock> splitSQLSelectQuery(SQLSelectQuery x) {
        ArrayList<SQLSelectQueryBlock> groupList = new ArrayList<SQLSelectQueryBlock>();
        Stack<SQLSelectQuery> stack = new Stack<SQLSelectQuery>();
        stack.push(x);
        do {
            SQLSelectQuery query;
            if ((query = (SQLSelectQuery)stack.pop()) instanceof SQLSelectQueryBlock) {
                groupList.add((SQLSelectQueryBlock)query);
                continue;
            }
            if (!(query instanceof SQLUnionQuery)) continue;
            SQLUnionQuery unionQuery = (SQLUnionQuery)query;
            stack.push(unionQuery.getLeft());
            stack.push(unionQuery.getRight());
        } while (!stack.empty());
        return groupList;
    }

    @Deprecated
    public static void checkConditionForMultiTenant(WallVisitor visitor, SQLExpr x, SQLObject parent) {
        SQLTableSource tableSource;
        String tenantTablePattern = visitor.getConfig().getTenantTablePattern();
        if (tenantTablePattern == null || tenantTablePattern.length() == 0) {
            return;
        }
        if (parent == null) {
            throw new IllegalStateException("parent is null");
        }
        String alias = null;
        WallConfig.TenantCallBack.StatementType statementType = null;
        if (parent instanceof SQLDeleteStatement) {
            tableSource = ((SQLDeleteStatement)parent).getTableSource();
            statementType = WallConfig.TenantCallBack.StatementType.DELETE;
        } else if (parent instanceof SQLUpdateStatement) {
            tableSource = ((SQLUpdateStatement)parent).getTableSource();
            statementType = WallConfig.TenantCallBack.StatementType.UPDATE;
        } else if (parent instanceof SQLSelectQueryBlock) {
            tableSource = ((SQLSelectQueryBlock)parent).getFrom();
            statementType = WallConfig.TenantCallBack.StatementType.SELECT;
        } else {
            throw new IllegalStateException("not support parent : " + parent.getClass());
        }
        String matchTableName = null;
        if (tableSource instanceof SQLExprTableSource) {
            SQLExpr tableExpr = ((SQLExprTableSource)tableSource).getExpr();
            if (tableExpr instanceof SQLIdentifierExpr) {
                String tableName = ((SQLIdentifierExpr)tableExpr).getName();
                if (ServletPathMatcher.getInstance().matches(tenantTablePattern, tableName)) {
                    matchTableName = tableName;
                    alias = tableSource.getAlias();
                }
            }
        } else if (tableSource instanceof SQLJoinTableSource) {
            SQLJoinTableSource join = (SQLJoinTableSource)tableSource;
            if (join.getLeft() instanceof SQLExprTableSource) {
                SQLExpr tableExpr = ((SQLExprTableSource)join.getLeft()).getExpr();
                if (tableExpr instanceof SQLIdentifierExpr) {
                    String tableName = ((SQLIdentifierExpr)tableExpr).getName();
                    if (ServletPathMatcher.getInstance().matches(tenantTablePattern, tableName)) {
                        matchTableName = tableName;
                        alias = join.getLeft().getAlias();
                    }
                }
                WallVisitorUtils.checkJoinConditionForMultiTenant(visitor, join, false, statementType);
            } else {
                WallVisitorUtils.checkJoinConditionForMultiTenant(visitor, join, true, statementType);
            }
        }
        if (matchTableName == null) {
            return;
        }
        SQLBinaryOpExpr tenantCondition = WallVisitorUtils.createTenantCondition(visitor, alias, statementType, matchTableName);
        SQLBinaryOpExpr condition = x == null ? tenantCondition : new SQLBinaryOpExpr((SQLExpr)tenantCondition, SQLBinaryOperator.BooleanAnd, x);
        if (parent instanceof SQLDeleteStatement) {
            SQLDeleteStatement deleteStmt = (SQLDeleteStatement)parent;
            deleteStmt.setWhere(condition);
            visitor.setSqlModified(true);
        } else if (parent instanceof SQLUpdateStatement) {
            SQLUpdateStatement updateStmt = (SQLUpdateStatement)parent;
            updateStmt.setWhere(condition);
            visitor.setSqlModified(true);
        } else if (parent instanceof SQLSelectQueryBlock) {
            SQLSelectQueryBlock queryBlock = (SQLSelectQueryBlock)parent;
            queryBlock.setWhere(condition);
            visitor.setSqlModified(true);
        }
    }

    @Deprecated
    public static void checkJoinConditionForMultiTenant(WallVisitor visitor, SQLJoinTableSource join, boolean checkLeft, WallConfig.TenantCallBack.StatementType statementType) {
        SQLExpr tableExpr;
        String tenantTablePattern = visitor.getConfig().getTenantTablePattern();
        if (tenantTablePattern == null || tenantTablePattern.length() == 0) {
            return;
        }
        SQLExpr condition = join.getCondition();
        SQLTableSource right = join.getRight();
        if (right instanceof SQLExprTableSource && (tableExpr = ((SQLExprTableSource)right).getExpr()) instanceof SQLIdentifierExpr) {
            String tableName = ((SQLIdentifierExpr)tableExpr).getName();
            if (ServletPathMatcher.getInstance().matches(tenantTablePattern, tableName)) {
                String alias = right.getAlias();
                if (alias == null) {
                    alias = tableName;
                }
                SQLBinaryOpExpr tenantCondition = WallVisitorUtils.createTenantCondition(visitor, alias, statementType, tableName);
                condition = condition == null ? tenantCondition : new SQLBinaryOpExpr((SQLExpr)tenantCondition, SQLBinaryOperator.BooleanAnd, condition);
            }
        }
        if (condition != join.getCondition()) {
            join.setCondition(condition);
            visitor.setSqlModified(true);
        }
    }

    @Deprecated
    private static SQLBinaryOpExpr createTenantCondition(WallVisitor visitor, String alias, WallConfig.TenantCallBack.StatementType statementType, String tableName) {
        SQLExprImpl left = alias != null ? new SQLPropertyExpr(new SQLIdentifierExpr(alias), visitor.getConfig().getTenantColumn()) : new SQLIdentifierExpr(visitor.getConfig().getTenantColumn());
        SQLExpr right = WallVisitorUtils.generateTenantValue(visitor, alias, statementType, tableName);
        SQLBinaryOpExpr tenantCondition = new SQLBinaryOpExpr((SQLExpr)left, SQLBinaryOperator.Equality, right);
        return tenantCondition;
    }

    private static SQLExpr generateTenantValue(WallVisitor visitor, String alias, WallConfig.TenantCallBack.StatementType statementType, String tableName) {
        SQLExprImpl value;
        Object tenantValue;
        WallConfig.TenantCallBack callBack = visitor.getConfig().getTenantCallBack();
        if (callBack != null) {
            WallProvider.setTenantValue(callBack.getTenantValue(statementType, tableName));
        }
        if ((tenantValue = WallProvider.getTenantValue()) instanceof Number) {
            value = new SQLNumberExpr((Number)tenantValue);
        } else if (tenantValue instanceof String) {
            value = new SQLCharExpr((String)tenantValue);
        } else {
            throw new IllegalStateException("tenant value not support type " + tenantValue);
        }
        return value;
    }

    public static void checkReadOnly(WallVisitor visitor, SQLTableSource tableSource) {
        if (tableSource instanceof SQLExprTableSource) {
            boolean readOnlyValid;
            String tableName = null;
            SQLExpr tableNameExpr = ((SQLExprTableSource)tableSource).getExpr();
            if (tableNameExpr instanceof SQLName) {
                tableName = ((SQLName)tableNameExpr).getSimleName();
            }
            if (!(readOnlyValid = visitor.getProvider().checkReadOnlyTable(tableName))) {
                WallVisitorUtils.addViolation(visitor, 4000, "table readonly : " + tableName, tableSource);
            }
        } else if (tableSource instanceof SQLJoinTableSource) {
            SQLJoinTableSource join = (SQLJoinTableSource)tableSource;
            WallVisitorUtils.checkReadOnly(visitor, join.getLeft());
            WallVisitorUtils.checkReadOnly(visitor, join.getRight());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void checkUpdate(WallVisitor visitor, SQLUpdateStatement x) {
        WallVisitorUtils.checkReadOnly(visitor, x.getTableSource());
        WallConfig config = visitor.getConfig();
        if (!config.isUpdateAllow()) {
            WallVisitorUtils.addViolation(visitor, 1006, "update not allow", x);
            return;
        }
        SQLExpr where = x.getWhere();
        if (where == null) {
            WallContext context = WallContext.current();
            if (context != null) {
                context.incrementUpdateNoneConditionWarnnings();
            }
            if (config.isUpdateWhereNoneCheck()) {
                if (!(x instanceof MySqlUpdateStatement)) {
                    WallVisitorUtils.addViolation(visitor, 2104, "update none condition not allow", x);
                    return;
                }
                MySqlUpdateStatement mysqlUpdate = (MySqlUpdateStatement)x;
                if (mysqlUpdate.getLimit() == null) {
                    WallVisitorUtils.addViolation(visitor, 2104, "update none condition not allow", x);
                    return;
                }
            }
        } else {
            where.setParent(x);
            WallVisitorUtils.checkCondition(visitor, where);
            if (Boolean.TRUE == WallVisitorUtils.getConditionValue(visitor, where, config.isUpdateWhereAlayTrueCheck()) && !WallVisitorUtils.isSimpleConstExpr(where)) {
                WallVisitorUtils.addViolation(visitor, 2100, "update alway true condition not allow", x);
            }
        }
        WallVisitorUtils.checkUpdateForMultiTenant(visitor, x);
    }

    public static Object getValue(WallVisitor visitor, SQLBinaryOpExpr x) {
        WallContext context;
        if (x.getLeft() instanceof SQLName && x.getRight() instanceof SQLName && x.getLeft().toString().equalsIgnoreCase(x.getRight().toString())) {
            if (x.getOperator() == SQLBinaryOperator.Equality) {
                return Boolean.TRUE;
            }
            if (x.getOperator() == SQLBinaryOperator.NotEqual) {
                return Boolean.FALSE;
            }
            switch (x.getOperator()) {
                case Equality: 
                case Like: {
                    return Boolean.TRUE;
                }
                case NotEqual: 
                case GreaterThan: 
                case GreaterThanOrEqual: 
                case LessThan: 
                case LessThanOrEqual: 
                case LessThanOrGreater: 
                case NotLike: {
                    return Boolean.FALSE;
                }
            }
        }
        if (x.getOperator() == SQLBinaryOperator.BooleanOr) {
            List<SQLExpr> groupList = SQLUtils.split(x);
            boolean allFalse = true;
            for (int i = groupList.size() - 1; i >= 0; --i) {
                SQLExpr item = groupList.get(i);
                Object result = WallVisitorUtils.getValue(visitor, item);
                Boolean booleanVal = SQLEvalVisitorUtils.castToBoolean(result);
                if (Boolean.TRUE == booleanVal) {
                    WallConditionContext wallContext = WallVisitorUtils.getWallConditionContext();
                    if (wallContext != null && !WallVisitorUtils.isFirst(item)) {
                        wallContext.setPartAlwayTrue(true);
                    }
                    return true;
                }
                if (Boolean.FALSE == booleanVal) continue;
                allFalse = false;
            }
            if (allFalse) {
                return false;
            }
            return null;
        }
        if (x.getOperator() == SQLBinaryOperator.BooleanAnd) {
            List<SQLExpr> groupList = SQLUtils.split(x);
            int dalConst = 0;
            Boolean allTrue = Boolean.TRUE;
            for (int i = groupList.size() - 1; i >= 0; --i) {
                WallConditionContext wallContext;
                SQLExpr item = groupList.get(i);
                Object result = WallVisitorUtils.getValue(visitor, item);
                Boolean booleanVal = SQLEvalVisitorUtils.castToBoolean(result);
                if (Boolean.TRUE == booleanVal) {
                    wallContext = WallVisitorUtils.getWallConditionContext();
                    if (wallContext != null && !WallVisitorUtils.isFirst(item)) {
                        wallContext.setPartAlwayTrue(true);
                    }
                    ++dalConst;
                } else if (Boolean.FALSE == booleanVal) {
                    wallContext = WallVisitorUtils.getWallConditionContext();
                    if (wallContext != null && !WallVisitorUtils.isFirst(item)) {
                        wallContext.setPartAlwayFalse(true);
                    }
                    allTrue = Boolean.FALSE;
                    ++dalConst;
                } else {
                    if (allTrue != Boolean.FALSE) {
                        allTrue = null;
                    }
                    dalConst = 0;
                }
                if (dalConst != 2 || visitor == null || visitor.getConfig().isConditionDoubleConstAllow()) continue;
                WallVisitorUtils.addViolation(visitor, 2107, "double const condition", x);
            }
            if (Boolean.TRUE == allTrue) {
                return true;
            }
            if (Boolean.FALSE == allTrue) {
                return false;
            }
            return null;
        }
        SQLExpr left = x.getLeft();
        SQLExpr right = x.getRight();
        Object leftResult = WallVisitorUtils.getValue(visitor, left);
        Object rightResult = WallVisitorUtils.getValue(visitor, right);
        if (x.getOperator() == SQLBinaryOperator.Like && leftResult instanceof String && leftResult.equals(rightResult)) {
            WallVisitorUtils.addViolation(visitor, 2108, "same const like", x);
        }
        if ((x.getOperator() == SQLBinaryOperator.Like || x.getOperator() == SQLBinaryOperator.NotLike) && (context = WallContext.current()) != null && (rightResult instanceof Number || leftResult instanceof Number)) {
            context.incrementLikeNumberWarnnings();
        }
        String dbType = null;
        WallContext wallContext = WallContext.current();
        if (wallContext != null) {
            dbType = wallContext.getDbType();
        }
        return WallVisitorUtils.eval(visitor, dbType, x, Collections.<Object>emptyList());
    }

    public static SQLExpr getFirst(SQLExpr x) {
        SQLBinaryOpExpr binary;
        if (x instanceof SQLBinaryOpExpr && ((binary = (SQLBinaryOpExpr)x).getOperator() == SQLBinaryOperator.BooleanAnd || binary.getOperator() == SQLBinaryOperator.BooleanOr)) {
            return WallVisitorUtils.getFirst(((SQLBinaryOpExpr)x).getLeft());
        }
        return x;
    }

    public static List<SQLExpr> getParts(SQLExpr x) {
        List<SQLExpr> tmp;
        List<SQLExpr> exprs = new ArrayList<SQLExpr>();
        exprs.add(x);
        while ((tmp = WallVisitorUtils.partExpr(exprs)).size() != exprs.size()) {
            exprs = tmp;
        }
        return exprs;
    }

    public static List<SQLExpr> partExpr(List<SQLExpr> exprs) {
        ArrayList<SQLExpr> partList = new ArrayList<SQLExpr>();
        for (SQLExpr x : exprs) {
            SQLBinaryOpExpr binary;
            if (x instanceof SQLBinaryOpExpr && ((binary = (SQLBinaryOpExpr)x).getOperator() == SQLBinaryOperator.BooleanAnd || binary.getOperator() == SQLBinaryOperator.BooleanOr)) {
                partList.add(((SQLBinaryOpExpr)x).getLeft());
                partList.add(((SQLBinaryOpExpr)x).getRight());
                continue;
            }
            partList.add(x);
        }
        return partList;
    }

    public static boolean isFirst(SQLObject x) {
        if (x == null) {
            return true;
        }
        SQLObject parent;
        while ((parent = x.getParent()) instanceof SQLExpr) {
            SQLBinaryOpExpr binaryExpr;
            if (parent instanceof SQLBinaryOpExpr && x == (binaryExpr = (SQLBinaryOpExpr)parent).getRight()) {
                return false;
            }
            x = parent;
        }
        return true;
    }

    private static boolean hasWhere(SQLSelectQuery selectQuery) {
        if (selectQuery instanceof SQLSelectQueryBlock) {
            return ((SQLSelectQueryBlock)selectQuery).getWhere() != null;
        }
        if (selectQuery instanceof SQLUnionQuery) {
            SQLUnionQuery union = (SQLUnionQuery)selectQuery;
            return WallVisitorUtils.hasWhere(union.getLeft()) || WallVisitorUtils.hasWhere(union.getRight());
        }
        return false;
    }

    public static boolean checkSqlExpr(SQLExpr x) {
        if (x == null) {
            return false;
        }
        SQLObject obj = x;
        SQLObject parent;
        while ((parent = obj.getParent()) != null) {
            if (parent instanceof SQLSelectGroupByClause) {
                return true;
            }
            if (parent instanceof SQLOrderBy) {
                return true;
            }
            if (parent instanceof MySqlSelectQueryBlock.Limit) {
                return true;
            }
            obj = parent;
        }
        return false;
    }

    public static boolean isWhereOrHaving(SQLObject x) {
        if (x == null) {
            return false;
        }
        SQLObject parent;
        while ((parent = x.getParent()) != null) {
            SQLSelectQueryBlock query;
            SQLUnionQuery union;
            SQLJoinTableSource joinTableSource;
            if (parent instanceof SQLJoinTableSource && (joinTableSource = (SQLJoinTableSource)parent).getCondition() == x) {
                return true;
            }
            if (parent instanceof SQLUnionQuery && (union = (SQLUnionQuery)parent).getRight() == x && WallVisitorUtils.hasWhere(union.getLeft())) {
                return true;
            }
            if (parent instanceof SQLSelectQueryBlock && (query = (SQLSelectQueryBlock)parent).getWhere() == x) {
                return true;
            }
            if (parent instanceof SQLDeleteStatement) {
                SQLDeleteStatement delete = (SQLDeleteStatement)parent;
                return delete.getWhere() == x;
            }
            if (parent instanceof SQLUpdateStatement) {
                SQLUpdateStatement update = (SQLUpdateStatement)parent;
                return update.getWhere() == x;
            }
            if (parent instanceof SQLSelectGroupByClause) {
                SQLSelectGroupByClause groupBy = (SQLSelectGroupByClause)parent;
                return x == groupBy.getHaving();
            }
            x = parent;
        }
        return false;
    }

    public static WallConditionContext getWallConditionContext() {
        return wallConditionContextLocal.get();
    }

    public static WallTopStatementContext getWallTopStatementContext() {
        return wallTopStatementContextLocal.get();
    }

    public static void clearWallTopStatementContext() {
        wallTopStatementContextLocal.set(null);
    }

    public static void initWallTopStatementContext() {
        wallTopStatementContextLocal.set(new WallTopStatementContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getConditionValue(WallVisitor visitor, SQLExpr x, boolean alwayTrueCheck) {
        WallConditionContext old = wallConditionContextLocal.get();
        try {
            wallConditionContextLocal.set(new WallConditionContext());
            Object value = WallVisitorUtils.getValue(visitor, x);
            WallConditionContext current = wallConditionContextLocal.get();
            WallContext context = WallContext.current();
            if (context != null && (current.hasPartAlwayTrue() || Boolean.TRUE == value) && !WallVisitorUtils.isFirst(x)) {
                context.incrementWarnnings();
            }
            if (current.hasPartAlwayTrue() && alwayTrueCheck && !visitor.getConfig().isConditionAndAlwayTrueAllow()) {
                WallVisitorUtils.addViolation(visitor, 2100, "part alway true condition not allow", x);
            }
            if (current.hasPartAlwayFalse() && !visitor.getConfig().isConditionAndAlwayFalseAllow()) {
                WallVisitorUtils.addViolation(visitor, 2113, "part alway false condition not allow", x);
            }
            if (current.hasConstArithmetic() && !visitor.getConfig().isConstArithmeticAllow()) {
                WallVisitorUtils.addViolation(visitor, 2101, "const arithmetic not allow", x);
            }
            if (current.hasXor() && !visitor.getConfig().isConditionOpXorAllow()) {
                WallVisitorUtils.addViolation(visitor, 2102, "xor not allow", x);
            }
            if (current.hasBitwise() && !visitor.getConfig().isConditionOpBitwseAllow()) {
                WallVisitorUtils.addViolation(visitor, 2103, "bitwise operator not allow", x);
            }
            Object object = value;
            return object;
        }
        finally {
            wallConditionContextLocal.set(old);
        }
    }

    public static Object getValueFromAttributes(WallVisitor visitor, SQLObject sqlObject) {
        if (sqlObject == null) {
            return null;
        }
        if (visitor != null && visitor.getConfig().isConditionLikeTrueAllow() && sqlObject.getAttributes().containsKey(HAS_TRUE_LIKE)) {
            return null;
        }
        return sqlObject.getAttribute("eval.value");
    }

    public static Object getValue(SQLExpr x) {
        return WallVisitorUtils.getValue(null, x);
    }

    public static Object getValue(WallVisitor visitor, SQLExpr x) {
        Object result;
        if (x != null && x.getAttributes().containsKey("eval.value")) {
            return WallVisitorUtils.getValueFromAttributes(visitor, x);
        }
        if (x instanceof SQLBinaryOpExpr) {
            return WallVisitorUtils.getValue(visitor, (SQLBinaryOpExpr)x);
        }
        if (x instanceof MySqlBooleanExpr) {
            return ((MySqlBooleanExpr)x).getValue();
        }
        if (x instanceof SQLNumericLiteralExpr) {
            return ((SQLNumericLiteralExpr)x).getNumber();
        }
        if (x instanceof SQLCharExpr) {
            return ((SQLCharExpr)x).getText();
        }
        if (x instanceof SQLNCharExpr) {
            return ((SQLNCharExpr)x).getText();
        }
        if (x instanceof SQLNotExpr && (result = WallVisitorUtils.getValue(visitor, ((SQLNotExpr)x).getExpr())) instanceof Boolean) {
            return (Boolean)result == false;
        }
        if (x instanceof SQLQueryExpr) {
            if (WallVisitorUtils.isSimpleCountTableSource(visitor, ((SQLQueryExpr)x).getSubQuery())) {
                return 1;
            }
            if (WallVisitorUtils.isSimpleCaseTableSource(visitor, ((SQLQueryExpr)x).getSubQuery())) {
                SQLSelectQueryBlock queryBlock = (SQLSelectQueryBlock)((SQLQueryExpr)x).getSubQuery().getQuery();
                SQLCaseExpr caseExpr = (SQLCaseExpr)queryBlock.getSelectList().get(0).getExpr();
                Object result2 = WallVisitorUtils.getValue(caseExpr);
                if (visitor != null && !visitor.getConfig().isCaseConditionConstAllow()) {
                    SQLExpr left;
                    boolean leftIsName = false;
                    if (x.getParent() instanceof SQLBinaryOpExpr && (left = ((SQLBinaryOpExpr)x.getParent()).getLeft()) instanceof SQLName) {
                        leftIsName = true;
                    }
                    if (!leftIsName && result2 != null) {
                        WallVisitorUtils.addViolation(visitor, 2109, "const case condition", caseExpr);
                    }
                }
                return result2;
            }
        }
        String dbType = null;
        if (visitor != null) {
            dbType = visitor.getDbType();
        }
        if (x instanceof SQLMethodInvokeExpr || x instanceof SQLBetweenExpr || x instanceof SQLInListExpr || x instanceof SQLUnaryExpr) {
            return WallVisitorUtils.eval(visitor, dbType, x, Collections.<Object>emptyList());
        }
        if (x instanceof SQLCaseExpr) {
            if (visitor != null && !visitor.getConfig().isCaseConditionConstAllow()) {
                SQLExpr left;
                SQLCaseExpr caseExpr = (SQLCaseExpr)x;
                boolean leftIsName = false;
                if (caseExpr.getParent() instanceof SQLBinaryOpExpr && (left = ((SQLBinaryOpExpr)caseExpr.getParent()).getLeft()) instanceof SQLName) {
                    leftIsName = true;
                }
                if (!leftIsName && caseExpr.getValueExpr() == null && caseExpr.getItems().size() > 0) {
                    SQLCaseExpr.Item item = caseExpr.getItems().get(0);
                    Object conditionVal = WallVisitorUtils.getValue(visitor, item.getConditionExpr());
                    Object itemVal = WallVisitorUtils.getValue(visitor, item.getValueExpr());
                    if (conditionVal instanceof Boolean && itemVal != null) {
                        WallVisitorUtils.addViolation(visitor, 2109, "const case condition", caseExpr);
                    }
                }
            }
            return WallVisitorUtils.eval(visitor, dbType, x, Collections.<Object>emptyList());
        }
        return null;
    }

    public static Object eval(WallVisitor wallVisitor, String dbType, SQLObject sqlObject, List<Object> parameters) {
        SQLEvalVisitor visitor = SQLEvalVisitorUtils.createEvalVisitor(dbType);
        visitor.setParameters(parameters);
        visitor.registerFunction("rand", Nil.instance);
        sqlObject.accept(visitor);
        if (sqlObject instanceof SQLNumericLiteralExpr) {
            return ((SQLNumericLiteralExpr)sqlObject).getNumber();
        }
        return WallVisitorUtils.getValueFromAttributes(wallVisitor, sqlObject);
    }

    public static boolean isSimpleCountTableSource(WallVisitor visitor, SQLTableSource tableSource) {
        if (!(tableSource instanceof SQLSubqueryTableSource)) {
            return false;
        }
        SQLSubqueryTableSource subQuery = (SQLSubqueryTableSource)tableSource;
        return WallVisitorUtils.isSimpleCountTableSource(visitor, subQuery.getSelect());
    }

    public static boolean isSimpleCountTableSource(WallVisitor visitor, SQLSelect select) {
        SQLSelectQuery query = select.getQuery();
        if (query instanceof SQLSelectQueryBlock) {
            SQLExpr selectItemExpr;
            SQLSelectQueryBlock queryBlock = (SQLSelectQueryBlock)query;
            boolean allawTrueWhere = false;
            if (queryBlock.getWhere() == null) {
                allawTrueWhere = true;
            } else {
                Object whereValue = WallVisitorUtils.getValue(visitor, queryBlock.getWhere());
                if (whereValue == Boolean.TRUE) {
                    allawTrueWhere = true;
                } else if (whereValue == Boolean.FALSE) {
                    return false;
                }
            }
            boolean simpleCount = false;
            if (queryBlock.getSelectList().size() == 1 && (selectItemExpr = queryBlock.getSelectList().get(0).getExpr()) instanceof SQLAggregateExpr && ((SQLAggregateExpr)selectItemExpr).getMethodName().equalsIgnoreCase("COUNT")) {
                simpleCount = true;
            }
            if (allawTrueWhere && simpleCount) {
                return true;
            }
        }
        return false;
    }

    public static boolean isSimpleCaseTableSource(WallVisitor visitor, SQLSelect select) {
        SQLSelectQuery query = select.getQuery();
        if (query instanceof SQLSelectQueryBlock) {
            SQLExpr selectItemExpr;
            SQLSelectQueryBlock queryBlock = (SQLSelectQueryBlock)query;
            boolean allawTrueWhere = false;
            if (queryBlock.getWhere() == null) {
                allawTrueWhere = true;
            } else {
                Object whereValue = WallVisitorUtils.getValue(visitor, queryBlock.getWhere());
                if (whereValue == Boolean.TRUE) {
                    allawTrueWhere = true;
                } else if (whereValue == Boolean.FALSE) {
                    return false;
                }
            }
            boolean simpleCase = false;
            if (queryBlock.getSelectList().size() == 1 && (selectItemExpr = queryBlock.getSelectList().get(0).getExpr()) instanceof SQLCaseExpr) {
                simpleCase = true;
            }
            if (allawTrueWhere && simpleCase) {
                return true;
            }
        }
        return false;
    }

    public static void checkFunctionInTableSource(WallVisitor visitor, SQLMethodInvokeExpr x) {
        WallTopStatementContext topStatementContext = wallTopStatementContextLocal.get();
        if (topStatementContext != null && (topStatementContext.fromSysSchema || topStatementContext.fromSysTable)) {
            return;
        }
        WallVisitorUtils.checkSchema(visitor, x.getOwner());
        String methodName = x.getMethodName().toLowerCase();
        if (!visitor.getProvider().checkDenyTable(methodName) && (WallVisitorUtils.isTopStatementWithTableSource(x) || WallVisitorUtils.isFirstSelectTableSource(x)) && topStatementContext != null) {
            topStatementContext.setFromSysSchema(Boolean.TRUE);
            WallVisitorUtils.clearViolation(visitor);
        }
    }

    public static void checkFunction(WallVisitor visitor, SQLMethodInvokeExpr x) {
        WallTopStatementContext topStatementContext = wallTopStatementContextLocal.get();
        if (topStatementContext != null && (topStatementContext.fromSysSchema || topStatementContext.fromSysTable)) {
            return;
        }
        WallVisitorUtils.checkSchema(visitor, x.getOwner());
        if (!visitor.getConfig().isFunctionCheck()) {
            return;
        }
        String methodName = x.getMethodName().toLowerCase();
        WallContext context = WallContext.current();
        if (context != null) {
            context.incrementFunctionInvoke(methodName);
        }
        if (!visitor.getProvider().checkDenyFunction(methodName)) {
            boolean isTopNoneFrom = WallVisitorUtils.isTopNoneFromSelect(visitor, x);
            if (isTopNoneFrom) {
                return;
            }
            boolean isShow = x.getParent() instanceof MySqlShowGrantsStatement;
            if (isShow) {
                return;
            }
            if (WallVisitorUtils.isWhereOrHaving(x) || WallVisitorUtils.checkSqlExpr(x)) {
                WallVisitorUtils.addViolation(visitor, 2001, "deny function : " + methodName, x);
            }
        }
    }

    public static SQLSelectQueryBlock getQueryBlock(SQLObject x) {
        if (x == null) {
            return null;
        }
        if (x instanceof SQLSelectQueryBlock) {
            return (SQLSelectQueryBlock)x;
        }
        SQLObject parent = x.getParent();
        if (parent instanceof SQLExpr) {
            return WallVisitorUtils.getQueryBlock(parent);
        }
        if (parent instanceof SQLSelectItem) {
            return WallVisitorUtils.getQueryBlock(parent);
        }
        if (parent instanceof SQLSelectQueryBlock) {
            return (SQLSelectQueryBlock)parent;
        }
        return null;
    }

    public static boolean isTopNoneFromSelect(WallVisitor visitor, SQLObject x) {
        while (x.getParent() instanceof SQLExpr || x.getParent() instanceof SQLCaseExpr.Item) {
            x = x.getParent();
        }
        if (!(x.getParent() instanceof SQLSelectItem)) {
            return false;
        }
        SQLSelectItem item = (SQLSelectItem)x.getParent();
        if (!(item.getParent() instanceof SQLSelectQueryBlock)) {
            return false;
        }
        SQLSelectQueryBlock queryBlock = (SQLSelectQueryBlock)item.getParent();
        if (!WallVisitorUtils.queryBlockFromIsNull(visitor, queryBlock)) {
            return false;
        }
        if (!(queryBlock.getParent() instanceof SQLSelect)) {
            return false;
        }
        SQLSelect select = (SQLSelect)queryBlock.getParent();
        if (!(select.getParent() instanceof SQLSelectStatement)) {
            return false;
        }
        SQLSelectStatement stmt = (SQLSelectStatement)select.getParent();
        return stmt.getParent() == null;
    }

    private static boolean checkSchema(WallVisitor visitor, SQLExpr x) {
        WallTopStatementContext topStatementContext = wallTopStatementContextLocal.get();
        if (topStatementContext != null && (topStatementContext.fromSysSchema || topStatementContext.fromSysTable)) {
            return true;
        }
        if (x instanceof SQLName) {
            String owner = ((SQLName)x).getSimleName();
            owner = WallVisitorUtils.form(owner);
            if (WallVisitorUtils.isInTableSource(x) && !visitor.getProvider().checkDenySchema(owner)) {
                if (!(WallVisitorUtils.isTopStatementWithTableSource(x) || WallVisitorUtils.isFirstSelectTableSource(x) || WallVisitorUtils.isFirstInSubQuery(x))) {
                    SQLSelectStatement selectStmt;
                    SQLSelectQuery query;
                    SQLObject parent;
                    for (parent = x.getParent(); parent != null && !(parent instanceof SQLStatement); parent = parent.getParent()) {
                    }
                    boolean sameToTopSelectSchema = false;
                    if (parent instanceof SQLSelectStatement && (query = (selectStmt = (SQLSelectStatement)parent).getSelect().getQuery()) instanceof SQLSelectQueryBlock) {
                        SQLExpr schemaExpr;
                        SQLExpr expr;
                        SQLSelectQueryBlock queryBlock = (SQLSelectQueryBlock)query;
                        SQLTableSource from = queryBlock.getFrom();
                        while (from instanceof SQLJoinTableSource) {
                            from = ((SQLJoinTableSource)from).getLeft();
                        }
                        if (from instanceof SQLExprTableSource && (expr = ((SQLExprTableSource)from).getExpr()) instanceof SQLPropertyExpr && (schemaExpr = ((SQLPropertyExpr)expr).getOwner()) instanceof SQLIdentifierExpr) {
                            String schema = ((SQLIdentifierExpr)schemaExpr).getName();
                            if ((schema = WallVisitorUtils.form(schema)).equalsIgnoreCase(owner)) {
                                sameToTopSelectSchema = true;
                            }
                        }
                    }
                    if (!sameToTopSelectSchema) {
                        WallVisitorUtils.addViolation(visitor, 2002, "deny schema : " + owner, x);
                    }
                } else if (topStatementContext != null) {
                    topStatementContext.setFromSysSchema(Boolean.TRUE);
                    WallVisitorUtils.clearViolation(visitor);
                }
                return true;
            }
            if (visitor.getConfig().isDenyObjects(owner)) {
                WallVisitorUtils.addViolation(visitor, 2005, "deny object : " + owner, x);
                return true;
            }
        }
        if (x instanceof SQLPropertyExpr) {
            return WallVisitorUtils.checkSchema(visitor, ((SQLPropertyExpr)x).getOwner());
        }
        return true;
    }

    private static boolean isInTableSource(SQLObject x) {
        while (x instanceof SQLExpr) {
            x = x.getParent();
        }
        return x instanceof SQLExprTableSource;
    }

    private static boolean isFirstInSubQuery(SQLObject x) {
        while (x instanceof SQLExpr) {
            x = x.getParent();
        }
        if (!(x instanceof SQLExprTableSource)) {
            return false;
        }
        SQLObjectImpl sqlSelect = null;
        SQLObject parent = x.getParent();
        while (parent != null) {
            if (parent instanceof SQLSelect) {
                sqlSelect = (SQLSelect)parent;
                break;
            }
            x = parent;
            parent = x.getParent();
        }
        if (sqlSelect == null) {
            return false;
        }
        parent = sqlSelect.getParent();
        if (!(parent instanceof SQLInSubQueryExpr) || !WallVisitorUtils.isFirst(parent)) {
            return false;
        }
        SQLInSubQueryExpr sqlInSubQueryExpr = (SQLInSubQueryExpr)parent;
        if (!(sqlInSubQueryExpr.getParent() instanceof SQLSelectQueryBlock)) {
            return false;
        }
        SQLSelectQueryBlock queryBlock = (SQLSelectQueryBlock)sqlInSubQueryExpr.getParent();
        if (!(queryBlock.getParent() instanceof SQLSelect)) {
            return false;
        }
        SQLSelect select = (SQLSelect)queryBlock.getParent();
        if (!(select.getParent() instanceof SQLSelectStatement)) {
            return false;
        }
        SQLSelectStatement stmt = (SQLSelectStatement)select.getParent();
        return stmt.getParent() == null;
    }

    private static boolean isFirstSelectTableSource(SQLObject x) {
        while (x instanceof SQLExpr) {
            x = x.getParent();
        }
        if (!(x instanceof SQLExprTableSource)) {
            return false;
        }
        SQLSelectQueryBlock queryBlock = null;
        SQLObject parent = x.getParent();
        while (parent != null) {
            if (parent instanceof SQLSelectQueryBlock) {
                queryBlock = (SQLSelectQueryBlock)parent;
                break;
            }
            x = parent;
            parent = x.getParent();
        }
        if (queryBlock == null) {
            return false;
        }
        boolean isWhereQueryExpr = false;
        boolean isSelectItem = false;
        do {
            x = parent;
            if ((parent = parent.getParent()) instanceof SQLUnionQuery) {
                SQLUnionQuery union = (SQLUnionQuery)parent;
                if (union.getRight() != x || !WallVisitorUtils.hasTableSource(union.getLeft())) continue;
                return false;
            }
            if (parent instanceof SQLQueryExpr || parent instanceof SQLInSubQueryExpr || parent instanceof SQLExistsExpr) {
                isWhereQueryExpr = WallVisitorUtils.isWhereOrHaving(parent);
                continue;
            }
            if (parent instanceof SQLSelectItem) {
                isSelectItem = true;
                continue;
            }
            if (!isWhereQueryExpr && !isSelectItem || !(parent instanceof SQLSelectQueryBlock) || !WallVisitorUtils.hasTableSource((SQLSelectQueryBlock)parent)) continue;
            return false;
        } while (parent != null);
        return true;
    }

    private static boolean hasTableSource(SQLSelectQuery x) {
        if (x instanceof SQLUnionQuery) {
            SQLUnionQuery union = (SQLUnionQuery)x;
            return WallVisitorUtils.hasTableSource(union.getLeft()) || WallVisitorUtils.hasTableSource(union.getRight());
        }
        if (x instanceof SQLSelectQueryBlock) {
            return WallVisitorUtils.hasTableSource(((SQLSelectQueryBlock)x).getFrom());
        }
        return false;
    }

    private static boolean hasTableSource(SQLTableSource x) {
        if (x == null) {
            return false;
        }
        if (x instanceof SQLExprTableSource) {
            SQLExpr fromExpr = ((SQLExprTableSource)x).getExpr();
            if (fromExpr instanceof SQLName) {
                String name = fromExpr.toString();
                if ((name = WallVisitorUtils.form(name)).equalsIgnoreCase("DUAL")) {
                    return false;
                }
            }
            return true;
        }
        if (x instanceof SQLJoinTableSource) {
            SQLJoinTableSource join = (SQLJoinTableSource)x;
            return WallVisitorUtils.hasTableSource(join.getLeft()) || WallVisitorUtils.hasTableSource(join.getRight());
        }
        if (x instanceof SQLSubqueryTableSource) {
            return WallVisitorUtils.hasTableSource(((SQLSubqueryTableSource)x).getSelect().getQuery());
        }
        return false;
    }

    private static boolean isTopStatementWithTableSource(SQLObject x) {
        while (x instanceof SQLExpr) {
            x = x.getParent();
        }
        return x instanceof SQLExprTableSource && (x = x.getParent()) instanceof SQLStatement && (x = x.getParent()) == null;
    }

    private static boolean isTopSelectItem(SQLObject x) {
        while (x.getParent() instanceof SQLExpr || x.getParent() instanceof SQLCaseExpr.Item) {
            x = x.getParent();
        }
        if (!(x.getParent() instanceof SQLSelectItem)) {
            return false;
        }
        SQLSelectItem item = (SQLSelectItem)x.getParent();
        return WallVisitorUtils.isTopSelectStatement(item.getParent());
    }

    private static boolean isTopSelectStatement(SQLObject x) {
        if (!(x instanceof SQLSelectQueryBlock)) {
            return false;
        }
        SQLSelectQueryBlock queryBlock = (SQLSelectQueryBlock)x;
        if (!(queryBlock.getParent() instanceof SQLSelect)) {
            return false;
        }
        SQLSelect select = (SQLSelect)queryBlock.getParent();
        if (!(select.getParent() instanceof SQLSelectStatement)) {
            return false;
        }
        SQLSelectStatement stmt = (SQLSelectStatement)select.getParent();
        return stmt.getParent() == null;
    }

    public static boolean isTopSelectOutFile(MySqlOutFileExpr x) {
        if (!(x.getParent() instanceof SQLExprTableSource)) {
            return false;
        }
        SQLExprTableSource tableSource = (SQLExprTableSource)x.getParent();
        return WallVisitorUtils.isTopSelectStatement(tableSource.getParent());
    }

    public static boolean check(WallVisitor visitor, SQLExprTableSource x) {
        boolean checkResult;
        WallTopStatementContext topStatementContext = wallTopStatementContextLocal.get();
        SQLExpr expr = x.getExpr();
        if (expr instanceof SQLPropertyExpr && !(checkResult = WallVisitorUtils.checkSchema(visitor, ((SQLPropertyExpr)expr).getOwner()))) {
            return false;
        }
        if (expr instanceof SQLName) {
            WallSqlTableStat tableStat;
            String tableName = ((SQLName)expr).getSimleName();
            WallContext context = WallContext.current();
            if (context != null && (tableStat = context.getTableStat(tableName)) != null) {
                SQLObject parent = x.getParent();
                while (parent instanceof SQLTableSource) {
                    parent = parent.getParent();
                }
                if (parent instanceof SQLSelectQueryBlock) {
                    SQLSelectQueryBlock queryBlock = (SQLSelectQueryBlock)parent;
                    if (x == queryBlock.getInto()) {
                        tableStat.incrementSelectIntoCount();
                    } else {
                        tableStat.incrementSelectCount();
                    }
                } else if (parent instanceof SQLTruncateStatement) {
                    tableStat.incrementTruncateCount();
                } else if (parent instanceof SQLInsertStatement) {
                    tableStat.incrementInsertCount();
                } else if (parent instanceof SQLDeleteStatement) {
                    tableStat.incrementDeleteCount();
                } else if (parent instanceof SQLUpdateStatement) {
                    tableStat.incrementUpdateCount();
                } else if (parent instanceof MySqlReplaceStatement) {
                    tableStat.incrementReplaceCount();
                }
            }
            if (topStatementContext != null && (topStatementContext.fromSysSchema || topStatementContext.fromSysTable)) {
                return true;
            }
            if (visitor.isDenyTable(tableName) && (topStatementContext == null || !topStatementContext.fromPermitTable())) {
                if (WallVisitorUtils.isTopStatementWithTableSource(x) || WallVisitorUtils.isFirstSelectTableSource(x)) {
                    if (topStatementContext != null) {
                        topStatementContext.setFromSysTable(Boolean.TRUE);
                        WallVisitorUtils.clearViolation(visitor);
                    }
                    return false;
                }
                boolean isTopNoneFrom = WallVisitorUtils.isTopNoneFromSelect(visitor, x);
                if (isTopNoneFrom) {
                    return false;
                }
                WallVisitorUtils.addViolation(visitor, 2004, "deny table : " + tableName, x);
                return false;
            }
            if (visitor.getConfig().getPermitTables().contains(tableName) && WallVisitorUtils.isFirstSelectTableSource(x)) {
                if (topStatementContext != null) {
                    topStatementContext.setFromPermitTable(Boolean.TRUE);
                }
                return false;
            }
        }
        return true;
    }

    private static void addViolation(WallVisitor visitor, int errorCode, String message, SQLObject x) {
        visitor.addViolation(new IllegalSQLObjectViolation(errorCode, message, visitor.toSQL(x)));
    }

    private static void clearViolation(WallVisitor visitor) {
        visitor.getViolations().clear();
    }

    public static void checkUnion(WallVisitor visitor, SQLUnionQuery x) {
        if (x.getOperator() == SQLUnionOperator.MINUS && !visitor.getConfig().isMinusAllow()) {
            WallVisitorUtils.addViolation(visitor, 1008, "minus not allow", x);
            return;
        }
        if (x.getOperator() == SQLUnionOperator.INTERSECT && !visitor.getConfig().isIntersectAllow()) {
            WallVisitorUtils.addViolation(visitor, 1008, "intersect not allow", x);
            return;
        }
        if (!WallVisitorUtils.queryBlockFromIsNull(visitor, x.getLeft()) && WallVisitorUtils.queryBlockFromIsNull(visitor, x.getRight())) {
            boolean isTopUpdateStatement = false;
            boolean isTopInsertStatement = false;
            SQLObject selectParent = x.getParent();
            while (selectParent instanceof SQLSelectQuery || selectParent instanceof SQLJoinTableSource || selectParent instanceof SQLSubqueryTableSource || selectParent instanceof SQLSelect) {
                selectParent = selectParent.getParent();
            }
            if (selectParent instanceof SQLUpdateStatement) {
                isTopUpdateStatement = true;
            }
            if (selectParent instanceof SQLInsertStatement) {
                isTopInsertStatement = true;
            }
            if (isTopUpdateStatement || isTopInsertStatement) {
                return;
            }
            WallContext context = WallContext.current();
            if (context != null) {
                context.incrementUnionWarnnings();
            }
            if ((x.getOperator() == SQLUnionOperator.UNION || x.getOperator() == SQLUnionOperator.UNION_ALL || x.getOperator() == SQLUnionOperator.DISTINCT) && visitor.getConfig().isSelectUnionCheck() || x.getOperator() == SQLUnionOperator.MINUS && visitor.getConfig().isSelectMinusCheck() || x.getOperator() == SQLUnionOperator.INTERSECT && visitor.getConfig().isSelectIntersectCheck() || x.getOperator() == SQLUnionOperator.EXCEPT && visitor.getConfig().isSelectExceptCheck()) {
                WallVisitorUtils.addViolation(visitor, 5000, x.getOperator().toString() + " query not contains 'from clause'", x);
            }
        }
    }

    public static boolean queryBlockFromIsNull(WallVisitor visitor, SQLSelectQuery query) {
        return WallVisitorUtils.queryBlockFromIsNull(visitor, query, true);
    }

    public static boolean queryBlockFromIsNull(WallVisitor visitor, SQLSelectQuery query, boolean checkSelectConst) {
        if (query instanceof SQLSelectQueryBlock) {
            Object whereValue;
            SQLExpr where;
            SQLSelectQuery subQuery;
            SQLExpr fromExpr;
            SQLSelectQueryBlock queryBlock = (SQLSelectQueryBlock)query;
            SQLTableSource from = queryBlock.getFrom();
            if (from == null) {
                return true;
            }
            if (from instanceof SQLExprTableSource && (fromExpr = ((SQLExprTableSource)from).getExpr()) instanceof SQLName) {
                String name = fromExpr.toString();
                if ((name = WallVisitorUtils.form(name)).equalsIgnoreCase("DUAL")) {
                    return true;
                }
            }
            if (queryBlock.getSelectList().size() == 1 && queryBlock.getSelectList().get(0).getExpr() instanceof SQLAllColumnExpr && from instanceof SQLSubqueryTableSource && WallVisitorUtils.queryBlockFromIsNull(visitor, subQuery = ((SQLSubqueryTableSource)from).getSelect().getQuery())) {
                return true;
            }
            if (checkSelectConst && (where = queryBlock.getWhere()) != null && Boolean.TRUE == (whereValue = WallVisitorUtils.getValue(visitor, where))) {
                boolean allIsConst = true;
                for (SQLSelectItem item : queryBlock.getSelectList()) {
                    if (WallVisitorUtils.getValue(visitor, item.getExpr()) != null) continue;
                    allIsConst = false;
                    break;
                }
                if (allIsConst) {
                    return true;
                }
            }
        }
        return false;
    }

    public static String form(String name) {
        if (name.startsWith("\"") && name.endsWith("\"")) {
            name = name.substring(1, name.length() - 1);
        }
        if (name.startsWith("'") && name.endsWith("'")) {
            name = name.substring(1, name.length() - 1);
        }
        if (name.startsWith("`") && name.endsWith("`")) {
            name = name.substring(1, name.length() - 1);
        }
        name = name.toLowerCase();
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadResource(Set<String> names, String resource) {
        block12: {
            try {
                boolean hasResource = false;
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader != null) {
                    Enumeration<URL> e = Thread.currentThread().getContextClassLoader().getResources(resource);
                    while (e.hasMoreElements()) {
                        URL url = e.nextElement();
                        InputStream in = null;
                        try {
                            in = url.openStream();
                            WallVisitorUtils.readFromInputStream(names, in);
                            hasResource = true;
                        }
                        finally {
                            JdbcUtils.close(in);
                        }
                    }
                }
                if (hasResource) break block12;
                if (!resource.startsWith("/")) {
                    resource = "/" + resource;
                }
                InputStream in = null;
                try {
                    in = WallVisitorUtils.class.getResourceAsStream(resource);
                    if (in != null) {
                        WallVisitorUtils.readFromInputStream(names, in);
                    }
                }
                finally {
                    JdbcUtils.close(in);
                }
            }
            catch (IOException e) {
                LOG.error("load oracle deny tables errror", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readFromInputStream(Set<String> names, InputStream in) throws IOException {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(in));
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() <= 0) continue;
                line = line.toLowerCase();
                names.add(line);
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.close(reader);
            throw throwable;
        }
        JdbcUtils.close(reader);
    }

    public static void preVisitCheck(WallVisitor visitor, SQLObject x) {
        int errorCode;
        String denyMessage;
        WallConfig config = visitor.getProvider().getConfig();
        if (!(x instanceof SQLStatement)) {
            return;
        }
        boolean allow = false;
        if (x instanceof SQLInsertStatement) {
            allow = config.isInsertAllow();
            denyMessage = "insert not allow";
            errorCode = 1004;
        } else if (x instanceof SQLSelectStatement) {
            allow = true;
            denyMessage = "select not allow";
            errorCode = 1002;
        } else if (x instanceof SQLDeleteStatement) {
            allow = config.isDeleteAllow();
            denyMessage = "delete not allow";
            errorCode = 1005;
        } else if (x instanceof SQLUpdateStatement) {
            allow = config.isUpdateAllow();
            denyMessage = "update not allow";
            errorCode = 1006;
        } else if (x instanceof OracleMultiInsertStatement) {
            allow = true;
            denyMessage = "multi-insert not allow";
            errorCode = 1004;
        } else if (x instanceof OracleMergeStatement) {
            allow = config.isMergeAllow();
            denyMessage = "merge not allow";
            errorCode = 1009;
        } else if (x instanceof SQLCallStatement || x instanceof SQLServerExecStatement) {
            allow = config.isCallAllow();
            denyMessage = "call not allow";
            errorCode = 1300;
        } else if (x instanceof SQLTruncateStatement) {
            allow = config.isTruncateAllow();
            denyMessage = "truncate not allow";
            errorCode = 1100;
        } else if (x instanceof SQLCreateTableStatement || x instanceof SQLCreateIndexStatement || x instanceof SQLCreateViewStatement || x instanceof SQLCreateTriggerStatement || x instanceof OracleCreateSequenceStatement) {
            allow = config.isCreateTableAllow();
            denyMessage = "create table not allow";
            errorCode = 1101;
        } else if (x instanceof SQLAlterTableStatement) {
            allow = config.isAlterTableAllow();
            denyMessage = "alter table not allow";
            errorCode = 1102;
        } else if (x instanceof SQLDropTableStatement || x instanceof SQLDropIndexStatement || x instanceof SQLDropViewStatement || x instanceof SQLDropTriggerStatement || x instanceof SQLDropSequenceStatement) {
            allow = config.isDropTableAllow();
            denyMessage = "drop table not allow";
            errorCode = 1103;
        } else if (x instanceof MySqlSetCharSetStatement || x instanceof MySqlSetNamesStatement || x instanceof SQLSetStatement) {
            allow = config.isSetAllow();
            denyMessage = "set not allow";
            errorCode = 1200;
        } else if (x instanceof MySqlReplaceStatement) {
            allow = config.isReplaceAllow();
            denyMessage = "replace not allow";
            errorCode = 1010;
        } else if (x instanceof MySqlDescribeStatement) {
            allow = config.isDescribeAllow();
            denyMessage = "describe not allow";
            errorCode = 1201;
        } else if (x instanceof MySqlShowStatement) {
            allow = config.isShowAllow();
            denyMessage = "show not allow";
            errorCode = 1202;
        } else if (x instanceof MySqlCommitStatement) {
            allow = config.isCommitAllow();
            denyMessage = "show not allow";
            errorCode = 1301;
        } else if (x instanceof SQLRollbackStatement) {
            allow = config.isRollbackAllow();
            denyMessage = "show not allow";
            errorCode = 1302;
        } else if (x instanceof SQLUseStatement) {
            allow = config.isUseAllow();
            denyMessage = "show not allow";
            errorCode = 1203;
        } else if (x instanceof MySqlRenameTableStatement) {
            allow = config.isRenameTableAllow();
            denyMessage = "rename table not allow";
            errorCode = 1105;
        } else {
            allow = config.isNoneBaseStatementAllow();
            errorCode = 1999;
            denyMessage = x.getClass() + " not allow";
        }
        if (!allow) {
            WallVisitorUtils.addViolation(visitor, errorCode, denyMessage, x);
        }
    }

    public static class WallConditionContext {
        private boolean partAlwayTrue = false;
        private boolean partAlwayFalse = false;
        private boolean constArithmetic = false;
        private boolean xor = false;
        private boolean bitwise = false;

        public boolean hasPartAlwayTrue() {
            return this.partAlwayTrue;
        }

        public void setPartAlwayTrue(boolean partAllowTrue) {
            this.partAlwayTrue = partAllowTrue;
        }

        public boolean hasPartAlwayFalse() {
            return this.partAlwayFalse;
        }

        public void setPartAlwayFalse(boolean partAlwayFalse) {
            this.partAlwayFalse = partAlwayFalse;
        }

        public boolean hasConstArithmetic() {
            return this.constArithmetic;
        }

        public void setConstArithmetic(boolean constArithmetic) {
            this.constArithmetic = constArithmetic;
        }

        public boolean hasXor() {
            return this.xor;
        }

        public void setXor(boolean xor) {
            this.xor = xor;
        }

        public boolean hasBitwise() {
            return this.bitwise;
        }

        public void setBitwise(boolean bitwise) {
            this.bitwise = bitwise;
        }
    }

    public static class WallTopStatementContext {
        private boolean fromSysTable = false;
        private boolean fromSysSchema = false;
        private boolean fromPermitTable = false;

        public boolean fromSysTable() {
            return this.fromSysTable;
        }

        public void setFromSysTable(boolean fromSysTable) {
            this.fromSysTable = fromSysTable;
        }

        public boolean fromSysSchema() {
            return this.fromSysSchema;
        }

        public void setFromSysSchema(boolean fromSysSchema) {
            this.fromSysSchema = fromSysSchema;
        }

        public boolean fromPermitTable() {
            return this.fromPermitTable;
        }

        public void setFromPermitTable(boolean fromPermitTable) {
            this.fromPermitTable = fromPermitTable;
        }
    }
}

