/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.remoting.zookeeper.zkclient;

import com.alibaba.dubbo.common.concurrent.ListenableFutureTask;
import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.dubbo.common.utils.Assert;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.I0Itec.zkclient.IZkChildListener;
import org.I0Itec.zkclient.IZkStateListener;
import org.I0Itec.zkclient.ZkClient;
import org.apache.zookeeper.Watcher;

public class ZkClientWrapper {
    Logger logger = LoggerFactory.getLogger(ZkClientWrapper.class);
    private long timeout;
    private ZkClient client;
    private volatile Watcher.Event.KeeperState state;
    private ListenableFutureTask<ZkClient> listenableFutureTask;
    private volatile boolean started = false;

    public ZkClientWrapper(final String serverAddr, long timeout) {
        this.timeout = timeout;
        this.listenableFutureTask = ListenableFutureTask.create((Callable)new Callable<ZkClient>(){

            @Override
            public ZkClient call() throws Exception {
                return new ZkClient(serverAddr, Integer.MAX_VALUE);
            }
        });
    }

    public void start() {
        if (!this.started) {
            Thread connectThread = new Thread((Runnable)this.listenableFutureTask);
            connectThread.setName("DubboZkclientConnector");
            connectThread.setDaemon(true);
            connectThread.start();
            try {
                this.client = (ZkClient)this.listenableFutureTask.get(this.timeout, TimeUnit.MILLISECONDS);
            }
            catch (Throwable t) {
                this.logger.error("Timeout! zookeeper server can not be connected in : " + this.timeout + "ms!", t);
            }
            this.started = true;
        } else {
            this.logger.warn("Zkclient has already been started!");
        }
    }

    public void addListener(final IZkStateListener listener) {
        this.listenableFutureTask.addListener(new Runnable(){

            @Override
            public void run() {
                try {
                    ZkClientWrapper.this.client = (ZkClient)ZkClientWrapper.this.listenableFutureTask.get();
                    ZkClientWrapper.this.client.subscribeStateChanges(listener);
                }
                catch (InterruptedException e) {
                    ZkClientWrapper.this.logger.warn(Thread.currentThread().getName() + " was interrupted unexpectedly, which may cause unpredictable exception!");
                }
                catch (ExecutionException e) {
                    ZkClientWrapper.this.logger.error("Got an exception when trying to create zkclient instance, can not connect to zookeeper server, please check!", (Throwable)e);
                }
            }
        });
    }

    public boolean isConnected() {
        return this.client != null && this.state == Watcher.Event.KeeperState.SyncConnected;
    }

    public void createPersistent(String path) {
        Assert.notNull((Object)this.client, (RuntimeException)new IllegalStateException("Zookeeper is not connected yet!"));
        this.client.createPersistent(path, true);
    }

    public void createEphemeral(String path) {
        Assert.notNull((Object)this.client, (RuntimeException)new IllegalStateException("Zookeeper is not connected yet!"));
        this.client.createEphemeral(path);
    }

    public void delete(String path) {
        Assert.notNull((Object)this.client, (RuntimeException)new IllegalStateException("Zookeeper is not connected yet!"));
        this.client.delete(path);
    }

    public List<String> getChildren(String path) {
        Assert.notNull((Object)this.client, (RuntimeException)new IllegalStateException("Zookeeper is not connected yet!"));
        return this.client.getChildren(path);
    }

    public boolean exists(String path) {
        Assert.notNull((Object)this.client, (RuntimeException)new IllegalStateException("Zookeeper is not connected yet!"));
        return this.client.exists(path);
    }

    public void close() {
        Assert.notNull((Object)this.client, (RuntimeException)new IllegalStateException("Zookeeper is not connected yet!"));
        this.client.close();
    }

    public List<String> subscribeChildChanges(String path, IZkChildListener listener) {
        Assert.notNull((Object)this.client, (RuntimeException)new IllegalStateException("Zookeeper is not connected yet!"));
        return this.client.subscribeChildChanges(path, listener);
    }

    public void unsubscribeChildChanges(String path, IZkChildListener listener) {
        Assert.notNull((Object)this.client, (RuntimeException)new IllegalStateException("Zookeeper is not connected yet!"));
        this.client.unsubscribeChildChanges(path, listener);
    }
}

