/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.util;

import com.alibaba.excel.exception.ExcelAnalysisException;
import com.alibaba.excel.exception.ExcelGenerateException;
import com.alibaba.excel.util.IoUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;

public class FileUtils {
    private static final String JAVA_IO_TMPDIR = "java.io.tmpdir";
    private static final String POIFILES = "poifiles";
    private static final String CACHE = "excache";
    private static final int WRITE_BUFF_SIZE = 8192;

    private FileUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileToByteArray(File file) throws IOException {
        FileInputStream in = FileUtils.openInputStream(file);
        try {
            long fileLength = file.length();
            byte[] byArray = fileLength > 0L ? IoUtils.toByteArray(in, (int)fileLength) : IoUtils.toByteArray(in);
            return byArray;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    public static FileInputStream openInputStream(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canRead()) {
                throw new IOException("File '" + file + "' cannot be read");
            }
        } else {
            throw new FileNotFoundException("File '" + file + "' does not exist");
        }
        return new FileInputStream(file);
    }

    public static void writeToFile(File file, InputStream inputStream) {
        FileOutputStream outputStream = null;
        try {
            int bytesRead;
            outputStream = new FileOutputStream(file);
            byte[] buffer = new byte[8192];
            while ((bytesRead = inputStream.read(buffer, 0, 8192)) != -1) {
                ((OutputStream)outputStream).write(buffer, 0, bytesRead);
            }
        }
        catch (Exception e) {
            throw new ExcelAnalysisException("Can not create temporary file!", e);
        }
        finally {
            if (outputStream != null) {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (IOException e) {
                    throw new ExcelAnalysisException("Can not close 'outputStream'!", e);
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    throw new ExcelAnalysisException("Can not close 'inputStream'", e);
                }
            }
        }
    }

    public static void createPoiFilesDirectory() {
        FileUtils.createTmpDirectory(POIFILES);
    }

    public static File createCacheTmpFile() {
        File directory = FileUtils.createTmpDirectory(CACHE);
        File cache = new File(directory.getPath(), UUID.randomUUID().toString());
        if (!cache.mkdir()) {
            throw new ExcelGenerateException("Can not create temp file!");
        }
        return cache;
    }

    public static void delete(File file) {
        if (file.isFile()) {
            file.delete();
            return;
        }
        if (file.isDirectory()) {
            File[] childFiles = file.listFiles();
            if (childFiles == null || childFiles.length == 0) {
                file.delete();
                return;
            }
            for (int i = 0; i < childFiles.length; ++i) {
                FileUtils.delete(childFiles[i]);
            }
            file.delete();
        }
    }

    public static File createTmpDirectory(String path) {
        String tmpDir = System.getProperty(JAVA_IO_TMPDIR);
        if (tmpDir == null) {
            throw new RuntimeException("Systems temporary directory not defined - set the -Djava.io.tmpdir jvm property!");
        }
        File directory = new File(tmpDir, path);
        if (!directory.exists()) {
            FileUtils.syncCreatePoiFilesDirectory(directory);
        }
        return directory;
    }

    public static File createTmpFile(String fileName) {
        String tmpDir = System.getProperty(JAVA_IO_TMPDIR);
        if (tmpDir == null) {
            throw new RuntimeException("Systems temporary directory not defined - set the -Djava.io.tmpdir jvm property!");
        }
        return new File(tmpDir, fileName);
    }

    private static synchronized void syncCreatePoiFilesDirectory(File directory) {
        if (!directory.exists()) {
            directory.mkdirs();
        }
    }
}

