/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.metadata.data;

import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.data.CellData;
import com.alibaba.excel.metadata.data.DataFormatData;
import java.math.BigDecimal;

public class ReadCellData<T>
extends CellData<T> {
    private DataFormatData dataFormatData;

    public ReadCellData(CellDataTypeEnum type) {
        if (type == null) {
            throw new IllegalArgumentException("Type can not be null");
        }
        this.setType(type);
    }

    public ReadCellData(T data) {
        this.setData(data);
    }

    public ReadCellData(String stringValue) {
        this(CellDataTypeEnum.STRING, stringValue);
    }

    public ReadCellData(CellDataTypeEnum type, String stringValue) {
        if (type != CellDataTypeEnum.STRING && type != CellDataTypeEnum.ERROR) {
            throw new IllegalArgumentException("Only support CellDataTypeEnum.STRING and  CellDataTypeEnum.ERROR");
        }
        if (stringValue == null) {
            throw new IllegalArgumentException("StringValue can not be null");
        }
        this.setType(type);
        this.setStringValue(stringValue);
    }

    public ReadCellData(BigDecimal numberValue) {
        if (numberValue == null) {
            throw new IllegalArgumentException("DoubleValue can not be null");
        }
        this.setType(CellDataTypeEnum.NUMBER);
        this.setNumberValue(numberValue);
    }

    public ReadCellData(Boolean booleanValue) {
        if (booleanValue == null) {
            throw new IllegalArgumentException("BooleanValue can not be null");
        }
        this.setType(CellDataTypeEnum.BOOLEAN);
        this.setBooleanValue(booleanValue);
    }

    public static ReadCellData<?> newEmptyInstance() {
        return ReadCellData.newEmptyInstance(null, null);
    }

    public static ReadCellData<?> newEmptyInstance(Integer rowIndex, Integer columnIndex) {
        ReadCellData<CellDataTypeEnum> cellData = new ReadCellData<CellDataTypeEnum>(CellDataTypeEnum.EMPTY);
        cellData.setRowIndex(rowIndex);
        cellData.setColumnIndex(columnIndex);
        return cellData;
    }

    public static ReadCellData<?> newInstance(Boolean booleanValue) {
        return ReadCellData.newInstance(booleanValue, null, null);
    }

    public static ReadCellData<?> newInstance(Boolean booleanValue, Integer rowIndex, Integer columnIndex) {
        ReadCellData cellData = new ReadCellData(booleanValue);
        cellData.setRowIndex(rowIndex);
        cellData.setColumnIndex(columnIndex);
        return cellData;
    }

    public static ReadCellData<?> newInstance(String stringValue, Integer rowIndex, Integer columnIndex) {
        ReadCellData cellData = new ReadCellData(stringValue);
        cellData.setRowIndex(rowIndex);
        cellData.setColumnIndex(columnIndex);
        return cellData;
    }

    public static ReadCellData<?> newInstance(BigDecimal numberValue, Integer rowIndex, Integer columnIndex) {
        ReadCellData cellData = new ReadCellData(numberValue);
        cellData.setRowIndex(rowIndex);
        cellData.setColumnIndex(columnIndex);
        return cellData;
    }

    public ReadCellData<Object> clone() {
        ReadCellData<Object> readCellData = new ReadCellData<Object>();
        readCellData.setType(this.getType());
        readCellData.setNumberValue(this.getNumberValue());
        readCellData.setStringValue(this.getStringValue());
        readCellData.setBooleanValue(this.getBooleanValue());
        readCellData.setData(this.getData());
        if (this.getDataFormatData() != null) {
            readCellData.setDataFormatData(this.getDataFormatData().clone());
        }
        if (this.getFormulaData() != null) {
            readCellData.setFormulaData(this.getFormulaData().clone());
        }
        return readCellData;
    }

    public DataFormatData getDataFormatData() {
        return this.dataFormatData;
    }

    public void setDataFormatData(DataFormatData dataFormatData) {
        this.dataFormatData = dataFormatData;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReadCellData)) {
            return false;
        }
        ReadCellData other = (ReadCellData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DataFormatData this$dataFormatData = this.getDataFormatData();
        DataFormatData other$dataFormatData = other.getDataFormatData();
        return !(this$dataFormatData == null ? other$dataFormatData != null : !((Object)this$dataFormatData).equals(other$dataFormatData));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ReadCellData;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        DataFormatData $dataFormatData = this.getDataFormatData();
        result = result * 59 + ($dataFormatData == null ? 43 : ((Object)$dataFormatData).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ReadCellData(super=" + super.toString() + ", dataFormatData=" + this.getDataFormatData() + ")";
    }

    public ReadCellData() {
    }
}

