/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.write.metadata.holder;

import com.alibaba.excel.constant.OrderConstant;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.converters.ConverterKeyBuild;
import com.alibaba.excel.converters.DefaultConverterLoader;
import com.alibaba.excel.enums.HeadKindEnum;
import com.alibaba.excel.event.NotRepeatExecutor;
import com.alibaba.excel.event.Order;
import com.alibaba.excel.metadata.AbstractHolder;
import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.alibaba.excel.metadata.property.LoopMergeProperty;
import com.alibaba.excel.metadata.property.OnceAbsoluteMergeProperty;
import com.alibaba.excel.metadata.property.RowHeightProperty;
import com.alibaba.excel.write.handler.CellWriteHandler;
import com.alibaba.excel.write.handler.DefaultWriteHandlerLoader;
import com.alibaba.excel.write.handler.RowWriteHandler;
import com.alibaba.excel.write.handler.SheetWriteHandler;
import com.alibaba.excel.write.handler.WorkbookWriteHandler;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.handler.context.CellWriteHandlerContext;
import com.alibaba.excel.write.merge.LoopMergeStrategy;
import com.alibaba.excel.write.merge.OnceAbsoluteMergeStrategy;
import com.alibaba.excel.write.metadata.WriteBasicParameter;
import com.alibaba.excel.write.metadata.holder.WriteHolder;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.property.ExcelWriteHeadProperty;
import com.alibaba.excel.write.style.AbstractVerticalCellStyleStrategy;
import com.alibaba.excel.write.style.column.AbstractHeadColumnWidthStyleStrategy;
import com.alibaba.excel.write.style.row.SimpleRowHeightStyleStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections4.CollectionUtils;

public abstract class AbstractWriteHolder
extends AbstractHolder
implements WriteHolder {
    private Boolean needHead;
    private Integer relativeHeadRowIndex;
    private ExcelWriteHeadProperty excelWriteHeadProperty;
    private Map<Class<? extends WriteHandler>, List<WriteHandler>> writeHandlerMap;
    private Map<Class<? extends WriteHandler>, List<WriteHandler>> ownWriteHandlerMap;
    private Boolean useDefaultStyle;
    private Boolean automaticMergeHead;
    private Collection<Integer> excludeColumnIndexes;
    private Collection<String> excludeColumnFieldNames;
    private Collection<Integer> includeColumnIndexes;
    private Collection<String> includeColumnFieldNames;

    public AbstractWriteHolder(WriteBasicParameter writeBasicParameter, AbstractWriteHolder parentAbstractWriteHolder) {
        super(writeBasicParameter, parentAbstractWriteHolder);
        if (writeBasicParameter.getUseScientificFormat() != null) {
            throw new UnsupportedOperationException("Currently does not support setting useScientificFormat.");
        }
        this.needHead = writeBasicParameter.getNeedHead() == null ? (parentAbstractWriteHolder == null ? Boolean.TRUE : parentAbstractWriteHolder.getNeedHead()) : writeBasicParameter.getNeedHead();
        this.relativeHeadRowIndex = writeBasicParameter.getRelativeHeadRowIndex() == null ? (parentAbstractWriteHolder == null ? Integer.valueOf(0) : parentAbstractWriteHolder.getRelativeHeadRowIndex()) : writeBasicParameter.getRelativeHeadRowIndex();
        this.useDefaultStyle = writeBasicParameter.getUseDefaultStyle() == null ? (parentAbstractWriteHolder == null ? Boolean.TRUE : parentAbstractWriteHolder.getUseDefaultStyle()) : writeBasicParameter.getUseDefaultStyle();
        this.automaticMergeHead = writeBasicParameter.getAutomaticMergeHead() == null ? (parentAbstractWriteHolder == null ? Boolean.TRUE : parentAbstractWriteHolder.getAutomaticMergeHead()) : writeBasicParameter.getAutomaticMergeHead();
        this.excludeColumnFieldNames = writeBasicParameter.getExcludeColumnFieldNames() == null && parentAbstractWriteHolder != null ? parentAbstractWriteHolder.getExcludeColumnFieldNames() : writeBasicParameter.getExcludeColumnFieldNames();
        this.excludeColumnIndexes = writeBasicParameter.getExcludeColumnIndexes() == null && parentAbstractWriteHolder != null ? parentAbstractWriteHolder.getExcludeColumnIndexes() : writeBasicParameter.getExcludeColumnIndexes();
        this.includeColumnFieldNames = writeBasicParameter.getIncludeColumnFieldNames() == null && parentAbstractWriteHolder != null ? parentAbstractWriteHolder.getIncludeColumnFieldNames() : writeBasicParameter.getIncludeColumnFieldNames();
        this.includeColumnIndexes = writeBasicParameter.getIncludeColumnIndexes() == null && parentAbstractWriteHolder != null ? parentAbstractWriteHolder.getIncludeColumnIndexes() : writeBasicParameter.getIncludeColumnIndexes();
        this.excelWriteHeadProperty = new ExcelWriteHeadProperty(this, this.getClazz(), this.getHead());
        ArrayList<WriteHandler> handlerList = new ArrayList<WriteHandler>();
        this.initAnnotationConfig(handlerList, writeBasicParameter);
        if (writeBasicParameter.getCustomWriteHandlerList() != null && !writeBasicParameter.getCustomWriteHandlerList().isEmpty()) {
            handlerList.addAll(writeBasicParameter.getCustomWriteHandlerList());
        }
        this.ownWriteHandlerMap = this.sortAndClearUpHandler(handlerList);
        Map<Class<? extends WriteHandler>, List<WriteHandler>> parentWriteHandlerMap = null;
        if (parentAbstractWriteHolder != null) {
            parentWriteHandlerMap = parentAbstractWriteHolder.getWriteHandlerMap();
        } else {
            handlerList.addAll(DefaultWriteHandlerLoader.loadDefaultHandler(this.useDefaultStyle));
        }
        this.writeHandlerMap = this.sortAndClearUpAllHandler(handlerList, parentWriteHandlerMap);
        if (parentAbstractWriteHolder == null) {
            this.setConverterMap(DefaultConverterLoader.loadDefaultWriteConverter());
        } else {
            this.setConverterMap(new HashMap(parentAbstractWriteHolder.getConverterMap()));
        }
        if (writeBasicParameter.getCustomConverterList() != null && !writeBasicParameter.getCustomConverterList().isEmpty()) {
            for (Converter<?> converter : writeBasicParameter.getCustomConverterList()) {
                this.getConverterMap().put(ConverterKeyBuild.buildKey(converter.supportJavaTypeKey()), converter);
            }
        }
    }

    protected void initAnnotationConfig(List<WriteHandler> handlerList, WriteBasicParameter writeBasicParameter) {
        if (!HeadKindEnum.CLASS.equals((Object)this.getExcelWriteHeadProperty().getHeadKind())) {
            return;
        }
        if (writeBasicParameter.getClazz() == null) {
            return;
        }
        Map<Integer, Head> headMap = this.getExcelWriteHeadProperty().getHeadMap();
        boolean hasColumnWidth = false;
        boolean hasStyle = false;
        for (Head head : headMap.values()) {
            if (head.getColumnWidthProperty() != null) {
                hasColumnWidth = true;
            }
            if (head.getHeadStyleProperty() != null || head.getHeadFontProperty() != null) {
                hasStyle = true;
            }
            this.dealLoopMerge(handlerList, head);
        }
        if (hasColumnWidth) {
            this.dealColumnWidth(handlerList);
        }
        this.dealStyle(handlerList);
        this.dealRowHigh(handlerList);
        this.dealOnceAbsoluteMerge(handlerList);
    }

    private void dealStyle(List<WriteHandler> handlerList) {
        AbstractVerticalCellStyleStrategy styleStrategy = new AbstractVerticalCellStyleStrategy(){

            @Override
            public int order() {
                return OrderConstant.ANNOTATION_DEFINE_STYLE;
            }

            @Override
            protected WriteCellStyle headCellStyle(CellWriteHandlerContext context) {
                ExcelContentProperty excelContentProperty = context.getExcelContentProperty();
                return WriteCellStyle.build(excelContentProperty.getContentStyleProperty(), excelContentProperty.getContentFontProperty());
            }

            @Override
            protected WriteCellStyle contentCellStyle(CellWriteHandlerContext context) {
                ExcelContentProperty excelContentProperty = context.getExcelContentProperty();
                return WriteCellStyle.build(excelContentProperty.getContentStyleProperty(), excelContentProperty.getContentFontProperty());
            }
        };
        handlerList.add(styleStrategy);
    }

    private void dealLoopMerge(List<WriteHandler> handlerList, Head head) {
        LoopMergeProperty loopMergeProperty = head.getLoopMergeProperty();
        if (loopMergeProperty == null) {
            return;
        }
        handlerList.add(new LoopMergeStrategy(loopMergeProperty, head.getColumnIndex()));
    }

    private void dealOnceAbsoluteMerge(List<WriteHandler> handlerList) {
        OnceAbsoluteMergeProperty onceAbsoluteMergeProperty = this.getExcelWriteHeadProperty().getOnceAbsoluteMergeProperty();
        if (onceAbsoluteMergeProperty == null) {
            return;
        }
        handlerList.add(new OnceAbsoluteMergeStrategy(onceAbsoluteMergeProperty));
    }

    private void dealRowHigh(List<WriteHandler> handlerList) {
        RowHeightProperty headRowHeightProperty = this.getExcelWriteHeadProperty().getHeadRowHeightProperty();
        RowHeightProperty contentRowHeightProperty = this.getExcelWriteHeadProperty().getContentRowHeightProperty();
        if (headRowHeightProperty == null && contentRowHeightProperty == null) {
            return;
        }
        Short headRowHeight = null;
        if (headRowHeightProperty != null) {
            headRowHeight = headRowHeightProperty.getHeight();
        }
        Short contentRowHeight = null;
        if (contentRowHeightProperty != null) {
            contentRowHeight = contentRowHeightProperty.getHeight();
        }
        handlerList.add(new SimpleRowHeightStyleStrategy(headRowHeight, contentRowHeight));
    }

    private void dealColumnWidth(List<WriteHandler> handlerList) {
        AbstractHeadColumnWidthStyleStrategy columnWidthStyleStrategy = new AbstractHeadColumnWidthStyleStrategy(){

            @Override
            protected Integer columnWidth(Head head, Integer columnIndex) {
                if (head == null) {
                    return null;
                }
                if (head.getColumnWidthProperty() != null) {
                    return head.getColumnWidthProperty().getWidth();
                }
                return null;
            }
        };
        handlerList.add(columnWidthStyleStrategy);
    }

    protected Map<Class<? extends WriteHandler>, List<WriteHandler>> sortAndClearUpAllHandler(List<WriteHandler> handlerList, Map<Class<? extends WriteHandler>, List<WriteHandler>> parentHandlerMap) {
        List<WriteHandler> parentWriteHandler;
        if (parentHandlerMap != null && !CollectionUtils.isEmpty(parentWriteHandler = parentHandlerMap.get(WriteHandler.class))) {
            handlerList.addAll(parentWriteHandler);
        }
        return this.sortAndClearUpHandler(handlerList);
    }

    protected Map<Class<? extends WriteHandler>, List<WriteHandler>> sortAndClearUpHandler(List<WriteHandler> handlerList) {
        TreeMap orderExcelWriteHandlerMap = new TreeMap();
        for (WriteHandler handler : handlerList) {
            int order = Integer.MIN_VALUE;
            if (handler instanceof Order) {
                order = handler.order();
            }
            if (orderExcelWriteHandlerMap.containsKey(order)) {
                ((List)orderExcelWriteHandlerMap.get(order)).add(handler);
                continue;
            }
            ArrayList<WriteHandler> tempHandlerList = new ArrayList<WriteHandler>();
            tempHandlerList.add(handler);
            orderExcelWriteHandlerMap.put(order, tempHandlerList);
        }
        HashSet<String> alreadyExistedHandlerSet = new HashSet<String>();
        ArrayList<WriteHandler> cleanUpHandlerList = new ArrayList<WriteHandler>();
        for (Map.Entry entry : orderExcelWriteHandlerMap.entrySet()) {
            for (WriteHandler handler : (List)entry.getValue()) {
                if (handler instanceof NotRepeatExecutor) {
                    String uniqueValue = ((NotRepeatExecutor)((Object)handler)).uniqueValue();
                    if (alreadyExistedHandlerSet.contains(uniqueValue)) continue;
                    alreadyExistedHandlerSet.add(uniqueValue);
                }
                cleanUpHandlerList.add(handler);
            }
        }
        HashMap<Class<? extends WriteHandler>, List<WriteHandler>> result = new HashMap<Class<? extends WriteHandler>, List<WriteHandler>>(16);
        result.put(WriteHandler.class, new ArrayList());
        result.put(WorkbookWriteHandler.class, new ArrayList());
        result.put(SheetWriteHandler.class, new ArrayList());
        result.put(RowWriteHandler.class, new ArrayList());
        result.put(CellWriteHandler.class, new ArrayList());
        for (WriteHandler writeHandler : cleanUpHandlerList) {
            if (writeHandler instanceof CellWriteHandler) {
                ((List)result.get(CellWriteHandler.class)).add(writeHandler);
            }
            if (writeHandler instanceof RowWriteHandler) {
                ((List)result.get(RowWriteHandler.class)).add(writeHandler);
            }
            if (writeHandler instanceof SheetWriteHandler) {
                ((List)result.get(SheetWriteHandler.class)).add(writeHandler);
            }
            if (writeHandler instanceof WorkbookWriteHandler) {
                ((List)result.get(WorkbookWriteHandler.class)).add(writeHandler);
            }
            ((List)result.get(WriteHandler.class)).add(writeHandler);
        }
        return result;
    }

    @Override
    public boolean ignore(String fieldName, Integer columnIndex) {
        if (fieldName != null) {
            if (this.includeColumnFieldNames != null && !this.includeColumnFieldNames.contains(fieldName)) {
                return true;
            }
            if (this.excludeColumnFieldNames != null && this.excludeColumnFieldNames.contains(fieldName)) {
                return true;
            }
        }
        if (columnIndex != null) {
            if (this.includeColumnIndexes != null && !this.includeColumnIndexes.contains(columnIndex)) {
                return true;
            }
            if (this.excludeColumnIndexes != null && this.excludeColumnIndexes.contains(columnIndex)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public ExcelWriteHeadProperty excelWriteHeadProperty() {
        return this.getExcelWriteHeadProperty();
    }

    @Override
    public Map<Class<? extends WriteHandler>, List<WriteHandler>> writeHandlerMap() {
        return this.getWriteHandlerMap();
    }

    @Override
    public Map<Class<? extends WriteHandler>, List<WriteHandler>> ownWriteHandlerMap() {
        return this.getOwnWriteHandlerMap();
    }

    @Override
    public boolean needHead() {
        return this.getNeedHead();
    }

    @Override
    public int relativeHeadRowIndex() {
        return this.getRelativeHeadRowIndex();
    }

    @Override
    public boolean automaticMergeHead() {
        return this.getAutomaticMergeHead();
    }

    public Boolean getNeedHead() {
        return this.needHead;
    }

    public Integer getRelativeHeadRowIndex() {
        return this.relativeHeadRowIndex;
    }

    public ExcelWriteHeadProperty getExcelWriteHeadProperty() {
        return this.excelWriteHeadProperty;
    }

    public Map<Class<? extends WriteHandler>, List<WriteHandler>> getWriteHandlerMap() {
        return this.writeHandlerMap;
    }

    public Map<Class<? extends WriteHandler>, List<WriteHandler>> getOwnWriteHandlerMap() {
        return this.ownWriteHandlerMap;
    }

    public Boolean getUseDefaultStyle() {
        return this.useDefaultStyle;
    }

    public Boolean getAutomaticMergeHead() {
        return this.automaticMergeHead;
    }

    public Collection<Integer> getExcludeColumnIndexes() {
        return this.excludeColumnIndexes;
    }

    public Collection<String> getExcludeColumnFieldNames() {
        return this.excludeColumnFieldNames;
    }

    public Collection<Integer> getIncludeColumnIndexes() {
        return this.includeColumnIndexes;
    }

    public Collection<String> getIncludeColumnFieldNames() {
        return this.includeColumnFieldNames;
    }

    public void setNeedHead(Boolean needHead) {
        this.needHead = needHead;
    }

    public void setRelativeHeadRowIndex(Integer relativeHeadRowIndex) {
        this.relativeHeadRowIndex = relativeHeadRowIndex;
    }

    public void setExcelWriteHeadProperty(ExcelWriteHeadProperty excelWriteHeadProperty) {
        this.excelWriteHeadProperty = excelWriteHeadProperty;
    }

    public void setWriteHandlerMap(Map<Class<? extends WriteHandler>, List<WriteHandler>> writeHandlerMap) {
        this.writeHandlerMap = writeHandlerMap;
    }

    public void setOwnWriteHandlerMap(Map<Class<? extends WriteHandler>, List<WriteHandler>> ownWriteHandlerMap) {
        this.ownWriteHandlerMap = ownWriteHandlerMap;
    }

    public void setUseDefaultStyle(Boolean useDefaultStyle) {
        this.useDefaultStyle = useDefaultStyle;
    }

    public void setAutomaticMergeHead(Boolean automaticMergeHead) {
        this.automaticMergeHead = automaticMergeHead;
    }

    public void setExcludeColumnIndexes(Collection<Integer> excludeColumnIndexes) {
        this.excludeColumnIndexes = excludeColumnIndexes;
    }

    public void setExcludeColumnFieldNames(Collection<String> excludeColumnFieldNames) {
        this.excludeColumnFieldNames = excludeColumnFieldNames;
    }

    public void setIncludeColumnIndexes(Collection<Integer> includeColumnIndexes) {
        this.includeColumnIndexes = includeColumnIndexes;
    }

    public void setIncludeColumnFieldNames(Collection<String> includeColumnFieldNames) {
        this.includeColumnFieldNames = includeColumnFieldNames;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractWriteHolder)) {
            return false;
        }
        AbstractWriteHolder other = (AbstractWriteHolder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$needHead = this.getNeedHead();
        Boolean other$needHead = other.getNeedHead();
        if (this$needHead == null ? other$needHead != null : !((Object)this$needHead).equals(other$needHead)) {
            return false;
        }
        Integer this$relativeHeadRowIndex = this.getRelativeHeadRowIndex();
        Integer other$relativeHeadRowIndex = other.getRelativeHeadRowIndex();
        if (this$relativeHeadRowIndex == null ? other$relativeHeadRowIndex != null : !((Object)this$relativeHeadRowIndex).equals(other$relativeHeadRowIndex)) {
            return false;
        }
        Boolean this$useDefaultStyle = this.getUseDefaultStyle();
        Boolean other$useDefaultStyle = other.getUseDefaultStyle();
        if (this$useDefaultStyle == null ? other$useDefaultStyle != null : !((Object)this$useDefaultStyle).equals(other$useDefaultStyle)) {
            return false;
        }
        Boolean this$automaticMergeHead = this.getAutomaticMergeHead();
        Boolean other$automaticMergeHead = other.getAutomaticMergeHead();
        if (this$automaticMergeHead == null ? other$automaticMergeHead != null : !((Object)this$automaticMergeHead).equals(other$automaticMergeHead)) {
            return false;
        }
        ExcelWriteHeadProperty this$excelWriteHeadProperty = this.getExcelWriteHeadProperty();
        ExcelWriteHeadProperty other$excelWriteHeadProperty = other.getExcelWriteHeadProperty();
        if (this$excelWriteHeadProperty == null ? other$excelWriteHeadProperty != null : !((Object)this$excelWriteHeadProperty).equals(other$excelWriteHeadProperty)) {
            return false;
        }
        Map<Class<? extends WriteHandler>, List<WriteHandler>> this$writeHandlerMap = this.getWriteHandlerMap();
        Map<Class<? extends WriteHandler>, List<WriteHandler>> other$writeHandlerMap = other.getWriteHandlerMap();
        if (this$writeHandlerMap == null ? other$writeHandlerMap != null : !((Object)this$writeHandlerMap).equals(other$writeHandlerMap)) {
            return false;
        }
        Map<Class<? extends WriteHandler>, List<WriteHandler>> this$ownWriteHandlerMap = this.getOwnWriteHandlerMap();
        Map<Class<? extends WriteHandler>, List<WriteHandler>> other$ownWriteHandlerMap = other.getOwnWriteHandlerMap();
        if (this$ownWriteHandlerMap == null ? other$ownWriteHandlerMap != null : !((Object)this$ownWriteHandlerMap).equals(other$ownWriteHandlerMap)) {
            return false;
        }
        Collection<Integer> this$excludeColumnIndexes = this.getExcludeColumnIndexes();
        Collection<Integer> other$excludeColumnIndexes = other.getExcludeColumnIndexes();
        if (this$excludeColumnIndexes == null ? other$excludeColumnIndexes != null : !((Object)this$excludeColumnIndexes).equals(other$excludeColumnIndexes)) {
            return false;
        }
        Collection<String> this$excludeColumnFieldNames = this.getExcludeColumnFieldNames();
        Collection<String> other$excludeColumnFieldNames = other.getExcludeColumnFieldNames();
        if (this$excludeColumnFieldNames == null ? other$excludeColumnFieldNames != null : !((Object)this$excludeColumnFieldNames).equals(other$excludeColumnFieldNames)) {
            return false;
        }
        Collection<Integer> this$includeColumnIndexes = this.getIncludeColumnIndexes();
        Collection<Integer> other$includeColumnIndexes = other.getIncludeColumnIndexes();
        if (this$includeColumnIndexes == null ? other$includeColumnIndexes != null : !((Object)this$includeColumnIndexes).equals(other$includeColumnIndexes)) {
            return false;
        }
        Collection<String> this$includeColumnFieldNames = this.getIncludeColumnFieldNames();
        Collection<String> other$includeColumnFieldNames = other.getIncludeColumnFieldNames();
        return !(this$includeColumnFieldNames == null ? other$includeColumnFieldNames != null : !((Object)this$includeColumnFieldNames).equals(other$includeColumnFieldNames));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AbstractWriteHolder;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $needHead = this.getNeedHead();
        result = result * 59 + ($needHead == null ? 43 : ((Object)$needHead).hashCode());
        Integer $relativeHeadRowIndex = this.getRelativeHeadRowIndex();
        result = result * 59 + ($relativeHeadRowIndex == null ? 43 : ((Object)$relativeHeadRowIndex).hashCode());
        Boolean $useDefaultStyle = this.getUseDefaultStyle();
        result = result * 59 + ($useDefaultStyle == null ? 43 : ((Object)$useDefaultStyle).hashCode());
        Boolean $automaticMergeHead = this.getAutomaticMergeHead();
        result = result * 59 + ($automaticMergeHead == null ? 43 : ((Object)$automaticMergeHead).hashCode());
        ExcelWriteHeadProperty $excelWriteHeadProperty = this.getExcelWriteHeadProperty();
        result = result * 59 + ($excelWriteHeadProperty == null ? 43 : ((Object)$excelWriteHeadProperty).hashCode());
        Map<Class<? extends WriteHandler>, List<WriteHandler>> $writeHandlerMap = this.getWriteHandlerMap();
        result = result * 59 + ($writeHandlerMap == null ? 43 : ((Object)$writeHandlerMap).hashCode());
        Map<Class<? extends WriteHandler>, List<WriteHandler>> $ownWriteHandlerMap = this.getOwnWriteHandlerMap();
        result = result * 59 + ($ownWriteHandlerMap == null ? 43 : ((Object)$ownWriteHandlerMap).hashCode());
        Collection<Integer> $excludeColumnIndexes = this.getExcludeColumnIndexes();
        result = result * 59 + ($excludeColumnIndexes == null ? 43 : ((Object)$excludeColumnIndexes).hashCode());
        Collection<String> $excludeColumnFieldNames = this.getExcludeColumnFieldNames();
        result = result * 59 + ($excludeColumnFieldNames == null ? 43 : ((Object)$excludeColumnFieldNames).hashCode());
        Collection<Integer> $includeColumnIndexes = this.getIncludeColumnIndexes();
        result = result * 59 + ($includeColumnIndexes == null ? 43 : ((Object)$includeColumnIndexes).hashCode());
        Collection<String> $includeColumnFieldNames = this.getIncludeColumnFieldNames();
        result = result * 59 + ($includeColumnFieldNames == null ? 43 : ((Object)$includeColumnFieldNames).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "AbstractWriteHolder(super=" + super.toString() + ", needHead=" + this.getNeedHead() + ", relativeHeadRowIndex=" + this.getRelativeHeadRowIndex() + ", excelWriteHeadProperty=" + this.getExcelWriteHeadProperty() + ", writeHandlerMap=" + this.getWriteHandlerMap() + ", ownWriteHandlerMap=" + this.getOwnWriteHandlerMap() + ", useDefaultStyle=" + this.getUseDefaultStyle() + ", automaticMergeHead=" + this.getAutomaticMergeHead() + ", excludeColumnIndexes=" + this.getExcludeColumnIndexes() + ", excludeColumnFieldNames=" + this.getExcludeColumnFieldNames() + ", includeColumnIndexes=" + this.getIncludeColumnIndexes() + ", includeColumnFieldNames=" + this.getIncludeColumnFieldNames() + ")";
    }

    public AbstractWriteHolder() {
    }
}

