package com.taobao.diamond.client.impl;

import static com.taobao.diamond.client.impl.DiamondEnv.log;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

import com.alibaba.metrics.Timer;
import com.alibaba.middleware.tls.JavaSSLSocketFactory;
import com.alibaba.middleware.tls.util.TlsUtil;
import com.taobao.diamond.common.Constants;
import com.taobao.diamond.exception.DiamondException;
import com.taobao.diamond.maintenance.DiamondMetric;
import com.taobao.diamond.md5.MD5;
import com.taobao.diamond.utils.EnvUtil;

public class HttpSimpleClient {

//    public static void main(String[] args) throws Exception {
//        HttpURLConnection conn = null;
//        try {
//            conn = (HttpURLConnection) new URL("http://jmenv.tbsite.net:8082/siteip").openConnection();
//            conn.setRequestMethod("GET");
//            conn.setConnectTimeout(3000);
//            conn.setReadTimeout(3000);
//            
//            conn.connect();
//            int respCode = conn.getResponseCode(); // �����ڲ���������
//            String resp = null;
//
//            if (HttpURLConnection.HTTP_OK == respCode) {
//                resp = IOUtils.toString(conn.getInputStream());
//            } else {
//                resp = IOUtils.toString(conn.getErrorStream());
//            }
//            System.out.println(respCode);
//            System.out.println(resp);
//        } finally {
//            if (conn != null) {
//                conn.disconnect();
//            }
//        }
//    }

    static String DIAMOND_CLIENT_VERSION = "unknown";

    static final int DIAMOND_CONNECT_TIMEOUT;

    static {
        String tmp = "1000"; //change timeout from 100 to 200
        try {
            tmp = System.getProperty("DIAMOND.CONNECT.TIMEOUT","1000"); //change timeout from 100 to 200
            DIAMOND_CONNECT_TIMEOUT = Integer.parseInt(tmp);
        } catch (NumberFormatException e) {
            final String msg = "[http-client] invalid connect timeout:" + tmp;
            log.error("settings", "DIAMOND-XXXX", msg, e);
            throw new IllegalArgumentException(msg, e);
        }
        log.info("settings","[http-client] connect timeout:{}", DIAMOND_CONNECT_TIMEOUT);
        
		try {
			InputStream in = HttpSimpleClient.class.getClassLoader()
					.getResourceAsStream("application.properties");
			Properties props = new Properties();
			props.load(in);
			String val = null;
			val = props.getProperty("version");
			if (val != null) {
				DIAMOND_CLIENT_VERSION = val;
			}
			log.info("DIAMOND_CLIENT_VERSION:{}", DIAMOND_CLIENT_VERSION);
		} catch (Exception e) {
			log.error("500", "read application.properties", e);
		}
		
    }


    static public HttpResult httpGet(String url, List<String> headers, List<String> paramValues,
            String encoding, long readTimeoutMs, boolean isSSL) throws IOException{
    	String encodedContent = encodingParams(paramValues, encoding);
        url += (null == encodedContent) ? "" : ("?" + encodedContent);
		if (Limiter.isLimit(MD5.getInstance().getMD5String(
				new StringBuilder(url).append(encodedContent).toString()))) {
			return new HttpResult(DiamondException.CLIENT_OVER_THRESHOLD,
					"More than client-side current limit threshold");
		}
		Timer.Context context = DiamondMetric.getRequestTimer().time();
        
        HttpURLConnection conn = null;
        
		try {
			if (isSSL) {
				TlsUtil.replaceHostnameVerifier();
				SSLSocketFactory ssf = JavaSSLSocketFactory.createJavaSSLSocketFactory(null, null);
				HttpsURLConnection httpsConn = (HttpsURLConnection) new URL(url).openConnection();
				httpsConn.setSSLSocketFactory(ssf);
				conn = httpsConn;
			} else {
				conn = (HttpURLConnection) new URL(url).openConnection();
			}
			conn.setRequestMethod("GET");
			conn.setConnectTimeout(DIAMOND_CONNECT_TIMEOUT > 100 ? DIAMOND_CONNECT_TIMEOUT : 100);
			conn.setReadTimeout((int) readTimeoutMs);
			List<String> newHeaders = new ArrayList<String>();
			newHeaders.add("Spas-AccessKey");
			newHeaders.add(SpasAdapter.getAk());
			if (headers != null) {
				newHeaders.addAll(headers);
			}
			List<String> signHeaders = SpasAdapter.getSignHeaders(paramValues);
			if (signHeaders != null) {
				newHeaders.addAll(signHeaders);
			}
			// json���л�֧���ֶβ���ȫƥ��
			newHeaders.add("exConfigInfo");
			newHeaders.add("true");
			setHeaders(conn, newHeaders, encoding);

			conn.connect();
			int respCode = conn.getResponseCode(); // �����ڲ���������
			String resp = null;

			if (HttpURLConnection.HTTP_OK == respCode) {
				resp = IOUtils.toString(conn.getInputStream(), encoding);
			} else {
				resp = IOUtils.toString(conn.getErrorStream(), encoding);
			}
			return new HttpResult(respCode, conn.getHeaderFields(), resp);
		} finally {
        	context.stop();
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

	/**
	 * ����GET����
	 */
	static public HttpResult httpGet(String url, List<String> headers, List<String> paramValues, String encoding,
			long readTimeoutMs) throws IOException {
		return httpGet(url, headers, paramValues, encoding, readTimeoutMs, false);
	}

    /**
     * ����POST����
     * 
     * @param url
     * @param headers
     *            ����Header������Ϊnull
     * @param paramValues
     *            ����������Ϊnull
     * @param encoding
     *            URL����ʹ�õ��ַ���
     * @param readTimeoutMs
     *            ��Ӧ��ʱ
     * @param isSSL
     *            �Ƿ�https
     * @return
     * @throws IOException
     */
    static public HttpResult httpPost(String url, List<String> headers, List<String> paramValues,
            String encoding, long readTimeoutMs, boolean isSSL) throws IOException {
		String encodedContent = encodingParams(paramValues, encoding);
		if (Limiter.isLimit(MD5.getInstance().getMD5String(
				new StringBuilder(url).append(encodedContent).toString()))) {
			return new HttpResult(DiamondException.CLIENT_OVER_THRESHOLD,
					"More than client-side current limit threshold");
		}
        HttpURLConnection conn = null;
        try {
        	if (isSSL) {
        		TlsUtil.replaceHostnameVerifier();
				SSLSocketFactory ssf = JavaSSLSocketFactory.createJavaSSLSocketFactory(null, null);
				HttpsURLConnection httpsConn = (HttpsURLConnection) new URL(url).openConnection();
				httpsConn.setSSLSocketFactory(ssf);
				conn = httpsConn;
			} else {
				conn = (HttpURLConnection) new URL(url).openConnection();
			}
            conn.setRequestMethod("POST");
            conn.setConnectTimeout(DIAMOND_CONNECT_TIMEOUT > 3000 ? DIAMOND_CONNECT_TIMEOUT : 3000);
            conn.setReadTimeout((int) readTimeoutMs);
            conn.setDoOutput(true);
            conn.setDoInput(true);
			List<String> newHeaders = new ArrayList<String>();
			newHeaders.add("Spas-AccessKey");
			newHeaders.add(SpasAdapter.getAk());
			if (headers != null) {
				newHeaders.addAll(headers);
			}
			List<String> signHeaders = SpasAdapter.getSignHeaders(paramValues);
			if (signHeaders != null) {
				newHeaders.addAll(signHeaders);
			}
			// json���л�֧���ֶβ���ȫƥ��
			newHeaders.add("exConfigInfo");
			newHeaders.add("true");
			setHeaders(conn, newHeaders, encoding);

            conn.getOutputStream().write(encodedContent.getBytes());

            int respCode = conn.getResponseCode(); // �����ڲ���������
            String resp = null;

            if (HttpURLConnection.HTTP_OK == respCode) {
                resp = IOUtils.toString(conn.getInputStream(), encoding);
            } else {
                resp = IOUtils.toString(conn.getErrorStream(), encoding);
            }
            return new HttpResult(respCode, conn.getHeaderFields(), resp);
        } finally {
            if (null != conn) {
                conn.disconnect();
            }
        }
    }
    
	/**
	 * ����POST����
	 * 
	 * @param url
	 * @param headers
	 *            ����Header������Ϊnull
	 * @param paramValues
	 *            ����������Ϊnull
	 * @param encoding
	 *            URL����ʹ�õ��ַ���
	 * @param readTimeoutMs
	 *            ��Ӧ��ʱ
	 * @return
	 * @throws IOException
	 */
	static public HttpResult httpPost(String url, List<String> headers, List<String> paramValues, String encoding,
			long readTimeoutMs) throws IOException {
		return httpPost(url, headers, paramValues, encoding, readTimeoutMs, false);
	}

    static private void setHeaders(HttpURLConnection conn, List<String> headers, String encoding) {
        if (null != headers) {
            for (Iterator<String> iter = headers.iterator(); iter.hasNext();) {
                conn.addRequestProperty(iter.next(), iter.next());
            }
        }
        conn.addRequestProperty("Client-Version", DIAMOND_CLIENT_VERSION); // TODO
        conn.addRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset="
                + encoding);

        //
        String ts = String.valueOf(System.currentTimeMillis());
        String token = MD5.getInstance().getMD5String(ts + ServerHttpAgent.appKey);

        conn.addRequestProperty(Constants.CLIENT_APPNAME_HEADER, ServerHttpAgent.appName);
        conn.addRequestProperty(Constants.CLIENT_REQUEST_TS_HEADER, ts);
        conn.addRequestProperty(Constants.CLIENT_REQUEST_TOKEN_HEADER, token);
		conn.addRequestProperty(EnvUtil.AMORY_TAG, EnvUtil.getSelfAmorayTag());
		conn.addRequestProperty(EnvUtil.VIPSERVER_TAG, EnvUtil.getSelfVipserverTag());
		conn.addRequestProperty(EnvUtil.LOCATION_TAG, EnvUtil.getSelfLocationTag());
    }

    static private String encodingParams(List<String> paramValues, String encoding)
            throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        if (null == paramValues) {
            return null;
        }
        
        for (Iterator<String> iter = paramValues.iterator(); iter.hasNext();) {
            sb.append(iter.next()).append("=");
            sb.append(URLEncoder.encode(iter.next(), encoding));
            if (iter.hasNext()) {
                sb.append("&");
            }
        }
        return sb.toString();
    }
    
    
    
    static public class HttpResult {
        final public int code;
        final public Map<String,List<String>> headers;
        final public String content;

		public HttpResult(int code, String content) {
			this.code = code;
			this.headers = null;
			this.content = content;
		}
		
		public HttpResult(int code, Map<String, List<String>> headers, String content) {
			this.code = code;
			this.headers = headers;
			this.content = content;
		}
    }
    
    public static String getDIAMOND_CLIENT_VERSION() {
		return DIAMOND_CLIENT_VERSION;
	}
}
